{ DateTime routines By Mike Wilson 6-3-1992                             }
{                                                                       }
{                                                                       }
{$A+,B+,D-,E+,F+,I+,L-,N-,O+,R-,S+,V-}
Unit Date_Tim;


Interface

Uses OPCRT, DOS,Overlay,
     FastTTT5, Strnttt5;

TYPE
   Dates = LongInt;   {change to longint for greater date ranges}

CONST
   MMDDYY   = 1;   {Date formats}
   MMDDYYYY = 2;
   MMYY     = 3;
   MMYYYY   = 4;
   DDMMYY   = 5;
   DDMMYYYY = 6;


Function DateNow : String;      { Returns the PRESENT Date in STRING format }
Function TimeNow : String;      { Returns Time in STRING format }
Function PackedDateTimeNow : LongInt;         { Returns Packed DAte/Time }
Function UnPackMyDate(MyPack : LongInt) : String; { Returns Date in String format from PACKED date/time format }
Function UnPackMyTime(MyPack : LongInt) : String; { Same as above except returns Time }

Function LZero(w : Word) : String;  { Add leading Zero and convert to String }
Function StrDate(M,D,Y : Word) : String;
Function StrTime(H,M,S,Hun : Word) : String;

         { Julian Date Routines!!! }
Function  Date_To_Julian(InDate:string;format:byte): dates;
Function  Julian_to_Date(J:dates;format:byte):string;
Function  Today_in_Julian: dates;
Function  Date_Within_Range(Min,Max,Test:dates):boolean;
Function  Valid_Date(Indate:string;format:byte): boolean;
Function  Future_Date(InDate:string;format:byte;Days:word): string;
Function  Since_Date(BeginDAte : String; EndDate : String; Format : Byte) : DATES;
Function  DateNowMail : String;   { Used for Mail stuff }
Function  Unformat_date(InDate:string): string;

Function GetFileTime(var f : File) : longint; { Returns packedDateTime of the files }
                                          { creation date/time }

Implementation

Const
    LastYearNextCentuary = 78;




Function LZero(w : Word) : String;
Var
  S : String;
Begin
  Str(w:0,s);
  if Length(s) = 1 then
    S := '0' + S;
  LZero := s;
End;

Function StrDate(M,D,Y : Word) : String;
Const
 DateHear : array [0..6] of String[3] =
  ('Sun','Mon','Tue','Wed','Thu','Fri', 'Sat');

 Month : array [1..12] of String[3] =
  ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug',
   'Sep','Oct','Nov','Dec');
Var
 Year : String[2];
Begin
  Year := Copy(LZero(y),3,2);
  StrDate := LZero(D)+' '+Month[M]+' '+Year;
End;

Function StrTime(H,M,S,Hun : Word) : String;
Begin
 StrTime := LZero(H)+':'+LZero(M)+':'+LZero(S);
End;

Function DateNow : String;      { Returns the PRESENT Date in STRING format }

var
    DoW : Word;
    DT : DateTime;

Begin
  GetDate(DT.Year,DT.Month,DT.Day,Dow);
  DateNow := StrDate(DT.Month,DT.Day,DT.Year);
End;

Function DateNowMail : String;   { Used for Mail stuff }
var
    DoW : Word;
    DT : DateTime;
Begin
  GetDate(DT.Year,DT.Month,DT.Day,Dow);
  DateNowMail := LZero(DT.Month)+LZero(DT.Day)+LZero(DT.Year);
End;

Function TimeNow : String;      { Returns Time in STRING format }
Var
 Hun : Word;
 DT : DateTime;

Begin
 GetTime(DT.Hour, DT.Min,DT.Sec,Hun);
 TimeNow := StrTime(DT.Hour,DT.Min,DT.Sec,Hun);
End;

Function PackedDateTimeNow : LongInt;         { Returns Packed DAte/Time }
Var
  Extra : Word;
  MyPack : LongInt;
  dt : DateTime;
Begin
  GetTime(DT.Hour,DT.Min,DT.Sec,Extra);
  GetDate(DT.Year,DT.Month,DT.Day,Extra);
  PackTime(DT,MyPack);
  PackedDateTimeNow := MyPack;
End;

Function UnPackMyDate(MyPack : LongInt) : String; { Returns Date in String format from PACKED date/time format }
Var
 DT : DateTime;
Begin
 UnPackTime(MyPack,DT);
 UnPackMyDate := StrDate(DT.Month,DT.Day,DT.Year);
End;

Function UnPackMyTime(MyPack : LongInt) : String; { Same as above except returns Time }
Var
 DT : DateTime;
Begin
 UnPackTime(MyPack,DT);
 UnPackMyTime := StrTime(DT.Hour,DT.Min,DT.Sec,0);
End;


{+++++++++++++++++++++++++++++++++++++++++++++}
{                                             }
{ J U L I A N   D A T E    R O U T I N E S    }
{                                             }
{+++++++++++++++++++++++++++++++++++++++++++++}

(*
 Note that the Julian date logic applied in these routines is that day 1 is
 January 1, 1900. All subsequent dates are represented by the number of
 days elapsed since day 1. The INTERFACE section includes a declaration of
 type DATES - this is set equal to type word, but it could be changed to
 type longint to provide a much greater date range. 

 Throughout these procedures and functions a date "format" must be passed. The
 format codes are:

                  1  MM/DD/YY
                  2  MM/DD/YYYY
                  3  MM/YY
                  4  MM/YYYY
                  5  DD/MM/YY {International format}
                  6  DD/MM/YYYY   {   "    }

 When passing dates in string form the "separators" are not significant. For
 example, the following strings are all treated alike:

                     120188
                     12/01/88
                     12-01-88
                     12-01/88
                     12----01----88
 Only the numerical digits are significant, the alphas are ignored.

*)
  Function Nth_Number(InStr:string;Nth:byte) : char;
  {Returns the nth number in an alphanumeric string}
  var
     Counter : byte;
     B, Len : byte;
  begin
      Counter := 0;
      B := 0;
      Len := Length(InStr);
      Repeat
           Inc(B);
           If InStr[B] in ['0'..'9'] then
              Inc(Counter);
      Until (Counter = Nth) or (B >= Len);
      If (Counter >= Len) and ( (InStr[Len] in ['0'..'9']) = false) then
         Nth_Number := #0
      else
         Nth_Number := InStr[B];
  end; {of func Nth_Number}

 Function Day(DStr:string;Format:byte): word;
 {INTERNAL}
 var
    DayStr: string;
 begin
     Case Format of
     MMDDYY,
     MMDDYYYY :  DayStr := Nth_Number(DStr,3)+Nth_Number(DStr,4);
     DDMMYY,
     DDMMYYYY :  DayStr := Nth_Number(DStr,1)+Nth_Number(DStr,2);
     else     DayStr := '01';
     end;
     Day := Str_To_Int(DayStr);
 end; {of func Day}

 Function Month(DStr:string;Format:byte): word;
 {INTERNAL}
 var
    MonStr: string;
 begin
     Case Format of
     MMDDYY,
     MMDDYYYY,
     MMYY,
     MMYYYY    :  MonStr := Nth_Number(DStr,1)+Nth_Number(DStr,2);
     DDMMYY,
     DDMMYYYY  :  MonStr := Nth_Number(DStr,3)+Nth_Number(DStr,4);
     end;
     Month := Str_To_Int(MonStr);
 end; {of func Month}

 Function Year(DStr:string;Format:byte): word;
 {INTERNAL}
 var
    YrStr   : string;
    TmpYr   : word;
 begin
     Case Format of
     MMDDYY,
     DDMMYY   :  YrStr := Nth_Number(DStr,5)+Nth_Number(DStr,6);
     MMDDYYYY,
     DDMMYYYY :  YrStr := Nth_Number(DStr,5)+Nth_Number(DStr,6)+
                     Nth_Number(DStr,7)+Nth_Number(DStr,8);
     MMYY     :  YrStr := Nth_Number(DStr,3)+Nth_Number(DStr,4);
     MMYYYY   :  YrStr := Nth_Number(DStr,3)+Nth_Number(DStr,4)+
                     Nth_Number(DStr,5)+Nth_Number(DStr,6);
     end;
     TmpYr := Str_To_Int(YrStr);
     If TmpYr < LastYearNextCentuary then
        TmpYr := 2000 + TmpYr
     else
        If Tmpyr < 1000 then
           TmpYr := 1900 + TmpYr;
     Year := TmpYr;
 end; {of func Year}

 Function DMY_to_String(D,M,Y:word;format:byte): string;
 {INTERNAL}
 const
     PadChar = '/';
 var
    DD,MM,YY : string[4];
 begin
     DD := Int_to_Str(D);
     If D < 10 then
        DD := '0'+DD;
     MM := Int_to_Str(M);
     If M < 10 then
        MM := '0'+MM;
     If Format in [MMDDYY,MMYY,DDMMYY] then
     begin
         If Y > 99 then
            If Y > 2000 then
               Y := Y - 2000
            else
               If Y > 1900 then
                  Y := Y - 1900
               else
                  Y := Y Mod 100;
     end
     else
     begin
         If Y < 1900 then
            If Y < LastYearNextCentuary then
               Y := Y + 2000
            else
               Y := Y + 1900;
     end;
     YY := Int_to_Str(Y);
     If Y < 10 then
        YY := '0'+YY;
     Case Format of
     MMDDYY,
     MMDDYYYY: DMY_to_String := MM+PadChar+DD+Padchar+YY;
     MMYY,
     MMYYYY  : DMY_to_String := MM+Padchar+YY;
     DDMMYY,
     DDMMYYYY: DMY_to_String := DD+PadChar+MM+Padchar+YY;
     end; {case}
 end; {of func DMY_to_String}

 Function Date_To_Julian(InDate:string;format:byte): dates;
 {Does not check the date is valid. Passed a date string and
  returns a julian date}
 var
    D,M,Y :  word;
    Temp : dates;
 begin
     D := Day(Indate,format);
     M := Month(Indate,format);
     Y := Year(Indate,format);
     If  (Y=1900)
     and (M <= 2) then
     begin
         If M = 1 then
            Temp := pred(D)
         else
            Temp := D+30;
     end
     else
     begin
         If M > 2 then
            M := M - 3
         else
         begin
             M := M + 9;
             dec(Y);
         end;
         Y := Y - 1900;
         Temp := (1461*longint(Y) div 4) +
                 (153*M+2) div 5 +
                 D + 58;
     end;
     Date_to_Julian := Temp;
 end; {of func Date_To_Julian}

 Function Julian_to_Date(J:dates;format:byte):string;
 {}
 var
    D,M,Y : word;
    Remainder,Factored : longint;
 begin
     If J = 0 then
     begin
         Case Format of
         DDMMYY,MMDDYY :   Julian_to_date := '  /  /  ';
         DDMMYYYY,MMDDYYYY:Julian_to_date := '  /  /    ';
         MMYYYY:           Julian_to_Date := '  /    ';
         else              Julian_to_date := '  /  ';
         end;
         exit;
     end;
     If J <= 58 then
     begin
         Y := 1900;
         If J <= 30 then
         begin
             M := 1;
             D := succ(J);
         end
         else
         begin
             M := 2;
             D := J - 30;
         end;
     end
     else
     begin
         Factored := 4*LongInt(J) - 233;
         Y := Factored div 1461;
         Remainder := (Factored mod 1461 div 4 * 5) + 2;
         M := Remainder div 153;
         D := succ((Remainder mod 153) div 5);
         Y := Y + 1900;
         If M < 10 then
            M := M + 3
         else
         begin
             M := M - 9;
             Inc(Y);
         end;
     end;
     Julian_to_date := DMY_to_String(D,M,Y,format);
 end; {of proc Julian_to_Date}

 Function Date_Within_Range(Min,Max,Test:dates):boolean;
 {}
 begin
     Date_Within_Range := ((Test >= Min) and (Test <= Max));
 end; {of func Date_Within_Range}

 Function Valid_Date(Indate:string;format:byte): boolean;
 {}
 var
   D,M,Y : word;
   OK : Boolean;
 begin
     OK := true;  {positive thinking!}
     If format in [MMYY,MMYYYY] then
        D := 1
     else
        D := Day(Indate,format);
     M := Month(Indate,format);
     Y := Year(Indate,format);
     If (D < 1)
     or (D > 31)
     or (M < 1)
     or (M > 12)
     or ((Y > 99) and (Y < 1900))
     or (Y > 2078)
     then 
        OK := False
     else
        Case M of
        4,6,9,11:         OK :=   (D <= 30);
        2:                OK :=   (D <= 28)
                               or (
                                        (D = 29) 
                                    and (Y <> 1900) 
                                    and (Y <> 0)
                                    and (Y mod 4 = 0)
                                  )
        end; {case}
     Valid_Date := OK;
 end; {of func Valid_Date}

 Function Today_in_Julian: dates;
 {}
 var
 Y,
 M,
 D,
 DayOfWeek : word;
 Year   : string;
 Day    : string;
 begin
     GetDate(Y,M,D,DayofWeek);
     Today_in_Julian := Date_to_Julian(DMY_to_String(D,M,Y,1),1);
 end; {of func Today_in_Julian}


 Function Future_Date(InDate:string;format:byte;Days:word): string;
 {}
 var J : dates;
 begin
     Future_date := Julian_to_date(Date_to_Julian(InDate,Format)+Days,Format);
 end; {of func Future_Date}

Function Since_Date(BeginDAte : String; EndDate : String; Format : Byte) : DATES;
Begin
 Since_Date :=(Date_To_Julian(EndDate,Format)) - (Date_To_Julian(BeginDate,Format));
End;


 Function Unformat_date(InDate:string): string;
 {strips all non numeric characters}
 var I : Integer;

           Function digit(C:char): boolean;
           {}
           begin
               Digit := C in ['0'..'9'];
           end; {of func digit}

 begin
     I := 1;
     Repeat
          If (digit(Indate[I]) = false) and (length(Indate) > 0) then
             Delete(Indate,I,1)
          else
             I := succ(I);
     Until (I > length(Indate)) or (Indate = '');
     Unformat_Date := Indate;
 end; {of func Unformatted_date}

Function GetFileTime(var f : File) : longint;
Var
 Tmp : longint;
Begin
 GetFTime(f,Tmp);
 GetFileTime := Tmp;
End;


End.            { END OF UNIT }
