TYPE
  aastr    =string[160];
  aacstring=string[20];            { Access Condition String }
  aacrq    ='@'..'Z';              { AR flags }


  afidorec=                          { FIDONET.DAT : FidoNet information }
  record
    azone:integer;                   { FidoNet zone number }
    anet:integer;                    { FidoNet net number }
    anode:integer;                   { FidoNet node number }
    apoint:integer;                  { FidoNet point number }
    aorigin:string[50];              { origin line }
    atext_color:byte;                { color of standard text }
    aquote_color:byte;               { color of quoted text }
    atear_color:byte;                { color of tear line }
    aorigin_color:byte;              { color of origin line }
    askludge:boolean;                { strip kludge lines? }
    asseenby:boolean;                { strip SEEN-BY lines? }
    asorigin:boolean;                { strip origin line? }
    ascenter:boolean;                { strip TG centering codes? }
    asbox:boolean;                   { strip TG box codes? }
    amcenter:boolean;                { center boxed/centered lines? }
    aaddtear:boolean;                { add tear/origin lines? }
    aechopath:string[40];            { default EchoMail path }
    agrouppath:string[40];           { default GroupMail path }
    ares:array[1..1896] of byte;     { RESERVED }
  end;

(* Message base Structure for Shadow BBS Copyright by Mike Wilson    *)
(* AllRights reserved; 1991                                          *)
(*      SEEKHERE                                                     *)

TYPE

  aAnonTypes    =(aUseAlias,aUserSelect,aDearAbby,aForceAlias,aRealNameOnly,
                 aAliasReserv1,aAliasReserve2);
  aMsgBaseTypes =(aPrivateBase,aPublicBase,aPubPrivBase,
                 aEchoBase,aNetBase,aMsgHidden,aMsgUnHidden);


    aMsgBoardsRecord = Record               { MSGBRDS.DAT            }
       aName          : String[50];         { MEssage Board Name     }
       aFileName      : String[8];          { Message Board FileName }
       aPath          : String[80];         { PathTo MessageBoard    }
       aPassword,
       aTagName       : String[25];
       aNetWork       : aFidoRec;            { NetWork/FidoNEt configs}
       aMsgBaseType   : Set of aMsgBaseTypes;{ Message Base types...  }
       aAnonType      : Set of aAnonTypes;   { Anonymous Types        }
       aAcs           : aAcstring;           { Access string          }
       aKillRecieved  : Boolean;            { Kill Recieved Messages?}
       aOldMail       : Integer;            { Kill mail after XX days}
       aMaxMessages,                        { Max Messages to have   }
       aFirstMsg,                           { First Msg Number       }
       aLastMsg,                            { Last Msg Number        }
       aTotalMsgs    : LongInt;             { Total Messages !       }
End;


