{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
Unit common4;

Interface

Uses
  Dos,OPCrt,Overlay;

Function AutoAnsi:boolean;      { Is the remote ansi capable? }
function lenn(s:string):integer;
function lennmci(s:string):integer;
procedure loaduboard(i:integer);
procedure tc(n:integer);
function mso:boolean;
function fso:boolean;
function cso:boolean;
function so:boolean;
Function AddSlash(S: String) : String;
function fbaseac(b:byte):boolean;
procedure changefileboard(b:integer);
function freek(d:integer):longint;
function exdrv(s:string):byte;
function nma:integer;
function okansi:boolean;
function okavatar:boolean;
function nsl:real;
procedure checkhangup;
function sysop1:boolean;
function sysop:boolean;
function nam:string;              { Cap thisuser + this users # }
function StripCH(Ch : Char; Str : String) : String;
function leapyear(yr:integer):boolean;
Function Caps(s:string):string;  { Cap first charaters... }
procedure scc;    {* make local textcolor( = curco *}
procedure ynq(s:string);
function smci(c:char):string;
function substone(src,old,new:string):string;
function checkeventday(i:integer; t:real):boolean;
function checkpreeventtime(i:integer; t:real):boolean;
function checkeventtime(i:integer; t:real):boolean;
function checkevents(t:real):integer;
procedure doeventstuff;
function aonoff(b:boolean; s1,s2:string):string;
function onoff(b:boolean):string;
function syn(b:boolean):string;
procedure pyn(b:boolean);
function yn:boolean;
function pynq(s:string):boolean;
function centre(s:string):string;
Function cstrl(li:longint):string;
function cstrr(rl:real; base:integer):string;
procedure lcmds(len,c:byte; c1,c2:string);
Function MakeLength(Len : Byte; Str : String) : String;
procedure handlempcode(var ccc:char);
Procedure ShowVersion;
function time:string;
function date:string;
function dat:string;
function stripcolor(o:string):string;
function tch(s:string):string;
procedure cl(c:integer);
function exist(fn:string):boolean;
procedure outtrap(c:char);
function stripspaceend(Str: string) : string;
procedure sde; { restore curco colors (DOS and tc) loc. after local }
procedure sdc; { restore curco colors (DOS and tc) loc/rem after loc/rem }
function PadL(Str : String;Len : Byte) : string;
function PadR(Str : String;Len : Byte) : string;


Implementation

Uses OpString,Common,TmpCom,Msg1,MModem;

function PadL(Str : String;Len : Byte) : string;
Begin
PadL := LeftPad(Str,Len);
End;

function PadR(Str : String;Len : Byte) : string;
Begin
 PadR:= Pad(Str,Len);
End;



Function AutoAnsi:boolean;

{
  Send "DSR" = Esc[6n to get remote Cursor Position
  Get  "CPR" = Esc[L;CR  where L = Line C = Column
}

Var
 C : Char;
 AnsiAuto : Boolean;
 AutoAnsiSeq : String[5];

Begin
 If (Not LocalIOOnly) then
 Begin
  AutoAnsiSeq := #27+'[6n';
  AnsiAuto := False;
  OutModemString000(AutoAnsiSeq,FALSE);
  delay(500);

 if (not Com_Rx_Empty) then       { if Comport Not Empty then GO! }
   begin
      getkey(c);
    Case C of
   #27,']',';': Begin
                  repeat
                   getkey(c);
                  until (Com_Rx_Empty) or (Hangup);
                 AnsiAuto := TRUE;
                End;
    End; { CASE }
   End;
    AutoAnsi := AnsiAuto;
 End else
  AutoAnsi := TRUE; { LOCAL IO }
End;

function StripSpaceEnd(Str: string) : string;
 const GoodChars =[#33..#126];

 Var i: integer;
Begin
  I := Length(Str);
 while Not (Str[i] in Goodchars) do
 Begin
   Delete(Str,i,1);
   Dec(i);
 End;
  StripSpaceEnd := Str;
End;


function lenn(s:string):integer;
var i,len:integer;
begin
  len:=length(s); i:=1;
  while (i<=length(s)) do
  begin
    if (s[i] in [#3,'^']) then
      if (i<length(s)) then
       begin dec(len,2); inc(i); end;
    inc(i);
  end;
  lenn:=len;
end;

function lennmci(s:string):integer;
var i,len:integer;
    lastco,lastmci:boolean;
begin
  len:=length(s);
  lastco:=FALSE; lastmci:=FALSE;
  for i:=1 to length(s) do
    if (not lastco) and (not lastmci) then
      case s[i] of
        #3,'^':if (not lastco) and (i<>length(s)) then lastco:=TRUE;
        '@':if (not lastmci) and (i<>length(s)) then lastmci:=TRUE;
      end
    else
    begin
      if (lastco) then
        if s[i] in [#0..#9,'0'..'9'] then
        begin
          dec(len,2);
          lastco:=FALSE;
        end;
      if (lastmci) then
      begin
        dec(len,2);
        inc(len,lennmci(smci(s[i])));
        lastmci:=FALSE;
      end;
    end;
  lennmci:=len;
end;

procedure loaduboard(i:integer);
var ulfo:boolean;
begin
  if (readuboard<>i) then begin
    ulfo:=(filerec(ulf).mode<>fmclosed);
    if (not ulfo) then reset(ulf);
    if ((i>=0) and (i<=filesize(ulf)-1)) then begin
      seek(ulf,i);
      read(ulf,memuboard);
    end else
      memuboard:=tempuboard;
    readuboard:=i;
    if (not ulfo) then close(ulf);
  end;
end;

procedure tc(n:integer);
begin
  textcolor(n);
end;

function mso:boolean;
var i:byte;
    b:boolean;
begin
  b:=FALSE;
  {
  for i:=1 to 5 do
    if (board=thisuser.boardsysop[i]) then b:=TRUE;
  }
  mso:=((cso) or (aacs(systat.msop)) or (b));
end;

function fso:boolean;
begin
  fso:=((cso) or (aacs(systat.fsop)));
end;

function cso:boolean;
begin
  cso:=((so) or (aacs(systat.csop)));
end;

function so:boolean;
begin
  so:=(aacs(systat.sop));
end;

function fbaseac(b:byte):boolean;
begin
  fbaseac:=FALSE;
  if ((b<0) or (b>maxulb)) then exit;
  loaduboard(b);
  fbaseac:=aacs(memuboard.acs);
end;


procedure changefileboard(b:integer);
var s:string[20];
    go:boolean;
begin
  go:=FALSE;
  if (b>=0) and (b<=maxulb) then
    if (fbaseac(b)) then { fbaseac loads memuboard itself ... }
      if (memuboard.password='') then go:=TRUE
      else begin
        nl; sprint('File base '+cstr(ccuboards[1][b])+': '+
                   #3#5+memuboard.name);
        prt('Password: '); mpl(20); input(s,20);
        if (s=memuboard.password) then go:=TRUE else print('Wrong.');
      end;
  if (go) then begin fileboard:=b; thisuser.lastfil:=fileboard; end;
end;

function freek(d:integer):longint;
var lng:longint;
begin
  lng:=diskfree(d);
  freek:=lng div 1024;
end;

function exdrv(s:string):byte;
begin
  s:=fexpand(s);
  exdrv:=ord(s[1])-64;
end;

function nma:integer;
begin
  nma:=thisuser.tltoday;
end;

function okansi:boolean;
begin
  okansi:=((ansi in thisuser.ac) or (avatar in thisuser.ac));
end;

function okavatar:boolean;
begin
  okavatar:=((avatar in thisuser.ac) and (not mtcolors));
end;

function nsl:real;
var ddt,dt:datetimerec;
    beenon:real;
begin
  if ((useron) or (not inwfcmenu)) then begin
    getdatetime(dt);
    timediff(ddt,timeon,dt);
    beenon:=dt2r(ddt);
    nsl:=((nma*60.0+extratime+freetime)-(beenon+choptime));
  end else
    nsl:=3600.0
end;

procedure checkhangup;
begin
  if (not com_carrier) then
    if ((outcom) and (not hangup)) then begin
      hangup:=TRUE; hungup:=TRUE;
    end;
end;

function sysop1:boolean;
var a:byte absolute $0000:$0417;
begin
  if (a and 16)=0 then sysop1:=TRUE else sysop1:=FALSE;
end;

function sysop:boolean;
var s:boolean;
begin
  s:=sysop1;
  if (not intime(timer,systat.lowtime,systat.hitime)) then s:=FALSE;
  if (rchat in thisuser.ac) then s:=FALSE;
  sysop:=s;
end;


function StripCH(Ch : Char; Str : String) : String;
Var
 Temp : String;
 I : Integer;
Begin
  Temp := '';
  for I := 1 to Length(Str) do
   if (Str[i] <> Ch)
      then Temp := Temp + Str[i];
 StripCh := Temp;
end;


procedure scc;    {* make local textcolor( = curco *}
var f:integer;
begin
  if (okansi) then begin
    f:=curco and 7;
    if (curco and 8)<>0 then inc(f,8);
    if (curco and 128)<>0 then inc(f,16);
    tc(f);
    textbackground((curco shr 4) and 7);
  end;
end;


procedure ynq(s:string);
begin
  cl(5); sprompt(s); cl(3);
end;

function smci(c:char):string;
var s,dum:string;
    i:integer;
begin
  dum:=nam;
  case UpCaseMac(c) of
      (* These are MCI's for Sprompt and other things...              *)
      (* -------------------- MSGBASE AND FILEBASE MCI's -------------*)
      'A': s:=Cstr(ccboards[1][Board]); { Msgboard NUMBER in memory }
      'B': begin
                LoadMsgBoard(Board);
                S:= Brd.Name;
          end;
      'C':s:=cstr(ccuboards[1][fileboard]); { Condensed Fileboard number in memory }
      'D':begin
           loaduboard(fileboard);
           s:=#3#5+memuboard.name;   { MCI for file board name }
           if (fbnoratio in memuboard.fbstat) then s:=s+#3#5+' [NR]';
        end;
      'Y' : Begin
                LoadMsgBoard(Board);
                S:= cstr(Brd.FirstMsg+1);
            End;
      'U' : Begin                    { Message user is ON }
                S:= Cstr(MsgOn);
            End;
      'W' : begin                    { MsgBAse Total Messages }
                LoadMsgBoard(Board);
                S := Cstr(Brd.TotalMsgs-1);
            End;

        (* %%%%%%%%%%%%%%%%%%% USER MCI COMMANDS %%%%%%%%%%%%%%% *)
                         {*  User REAL NAME }
    'F':s:=copy(thisuser.realname,1,pos(' ',thisuser.realname)-1);
    'H':s:=copy(dum,1,pos('#',dum)-2);
    'L':begin            {*Users First Name*}
          dum:=caps(thisuser.realname);
          i:=length(dum);
          while ((dum[i]<>' ') and (i>1)) do
          begin
            s:=copy(dum,i,(length(dum)-i)+1);
            dec(i);
          end;
        end;
    'N':s:=dum;    {* Users full real name ALLCAPS *}
    'P':s:=cstr(thisuser.filepoints); {* Users file points *}
    'R':s:=thisuser.realname;         {* User real name Not capped *}
    'T':s:=tlef;                      {* Users time left *}
    'X':begin                         {*Supposed to be max lines in text *}
          if (cso) then i:=systat.csmaxlines else i:=systat.maxlines;
          s:=cstr(i);
        end;

        { <<<<<<<<<<<<<<<<<<<<<< MISC MCI COMMANDS >>>>>>>>>>>>>>>>>> }
    'G':s:=^G;           {*  BEEP remote }
    'K':begin            {*  Free disk space }
          loaduboard(fileboard);
          s:=cstrl(freek(exdrv(memuboard.ulpath)));
        end;
    'M':s:=^M^J;                      {* Send CR *}
    'V':s:=cmdlist;                   {* Commands avalible from this menu *}
    'Z':s:=chatr;                     {* Chat reason *}
              { SEEKHERE }
  else
        s:='@'+c;
  end;
  smci:=s;
end;

function substone(src,old,new:string):string;
var p:integer;
begin
  if (old<>'') then
  begin
    p:=pos(old,allcaps(src));
    if (p>0) then
    begin
      insert(new,src,p+length(old));
      delete(src,p,length(old));
    end;
  end;
  substone:=src;
end;

function checkeventday(i:integer; t:real):boolean;
var s:string;
    year,month,day,dayofweek:word;
    e:integer;
begin
  checkeventday:=FALSE;
  with events[i]^ do begin
    getdate(year,month,day,dayofweek);
    e:=0;
    if (timer+t>=24.0*60.0*60.0) then begin
      inc(dayofweek); e:=1;
      if (dayofweek>6) then dayofweek:=0;
    end;
    if (monthly) then begin
      if (value(copy(date,4,2))+e=execdays) then
        checkeventday:=TRUE;
    end else begin
      if ((1 shl (6-dayofweek)) and execdays<>0) then
        checkeventday:=TRUE;
    end;
  end;
end;

function checkpreeventtime(i:integer; t:real):boolean;
begin
  with events[i]^ do
    if (busytime=0) then
      checkpreeventtime:=FALSE
    else
      checkpreeventtime:=intime(timer+t,exectime-busytime,exectime);
end;

function checkeventtime(i:integer; t:real):boolean;
begin
  with events[i]^ do
    if (duration=0) then
      checkeventtime:=FALSE
    else
      checkeventtime:=intime(timer+t,exectime,exectime+duration);
end;

function checkevents(t:real):integer;
var i:integer;
begin
  for i:=0 to numevents do
    with events[i]^ do
      if (active) then
        if (checkeventday(i,t)) then begin
          checkevents:=i;
          if (checkpreeventtime(i,t)) or (checkeventtime(i,t)) then begin
            if (etype in ['D','E','P']) then exit;
            if ((etype='A') and (not aacs(execdata)) and (useron)) then exit;
          end;
        end;
  checkevents:=0;
end;

procedure doeventstuff;
var s:string;
    e,savpap:integer;
    aaa:boolean;
begin
  case telluserevent of
    0:begin
        oltime:=timer;
        e:=checkevents(systat.eventwarningtime);
        if (e<>0) then begin
          telluserevent:=1;
          nl;
          sysoplog('[> '+date+' '+time+' - Displayed "REVENT'+cstr(e)+'" in preparation for event #'+cstr(e));
          savpap:=pap;
          aaa:=allowabort; allowabort:=FALSE;
          printf('revent'+cstr(e));
          allowabort:=aaa;
          if (nofile) then begin
            nl; nl;
            sprint(#3#8+^G'Warning: '+#3#5+'System event approaching.'^G);
            sprint(#3#5+^G'System will be shut down in '+
                    copy(ctim(systat.eventwarningtime),4,5)+' minutes.'^G);
            nl; nl;
          end;
          pap:=savpap;
        end else
          if (checkevents(0)=0) then telluserevent:=0;
      end;
    1:begin
        oltime:=timer;
        e:=checkevents(0);
        if (e<>0) then begin
          telluserevent:=2;
          sysoplog('[> '+date+' '+time+' - Logged user off in preparation for '+
                   'event #'+cstr(e));
          nl; nl; sprint(#3#8+^G'Shutting down for system events'^G); nl; nl;
          hangup:=TRUE;
        end;
      end;
  end;
end;

function aonoff(b:boolean; s1,s2:string):string;
begin
  if (b) then aonoff:=s1 else aonoff:=s2;
end;

function onoff(b:boolean):string;
begin
  if (b) then onoff:='On ' else onoff:='Off';
end;

function syn(b:boolean):string;
begin
  if (b) then syn:='Yes' else syn:='No ';
end;
  
procedure pyn(b:boolean);
begin
  print(syn(b));
end;


function yn:boolean;
var c:char;
begin
  if (not hangup) then begin
    cl(3);
    repeat
      getkey(c);
      c:=UpCaseMac(c);
    until (c in ['Y','N',^M,^N]) or (hangup);
    if (dyny) and (c<>'N') then c:='Y';
    if (c='Y') then begin
      print('Yes');
      yn:=TRUE;
    end else begin
      print('No');
      yn:=FALSE;
    end;
    if (hangup) then yn:=FALSE;
  end;
  dyny:=FALSE;
end;

function pynq(s:string):boolean;
begin
  ynq(s);
  pynq:=yn;
end;

function centre(s:string):string;
var i,j:integer;
begin
 Centre:=  Center(S,ThisUser.LineLen);
end;

Function cstrl(li:longint):string;
Var c:string;
begin
  Cstrl := Long2Str(Li);
end;

function cstrr(rl:real; base:integer):string;
var i:integer;
    s:string;
    r1,r2:real;
begin
  if (rl<=0.0) then cstrr:='0'
  else begin
    r1:=ln(rl)/ln(1.0*base);
    r2:=exp(ln(1.0*base)*(trunc(r1)));
    s:='';
    while (r2>0.999) do begin
      i:=trunc(rl/r2);
      s:=s+copy('0123456789ABCDEF',i+1,1);
      rl:=rl-i*r2;
      r2:=r2/(1.0*base);
    end;
    cstrr:=s;
  end;
end;

function nam:string;              { Cap thisuser + this users # }
begin
  nam:=caps(thisuser.name)+' #'+cstr(usernum);
end;


function leapyear(yr:integer):boolean;
begin
  leapyear:=(yr mod 4=0) and ((yr mod 100<>0) or (yr mod 400=0));
end;

Function Caps(s:string):string;  { Cap first charaters... }
 var i:integer;
 begin
  for i:=1 to length(s) do
    if (s[i] in ['A'..'Z']) then s[i]:=chr(ord(s[i])+32);
  for i:=1 to length(s) do
    if (not (s[i] in ['A'..'Z','a'..'z'])) then
      if (s[i+1] in ['a'..'z']) then s[i+1]:=UpCaseMac(s[i+1]);
  s[1]:=UpCaseMac(s[1]);
  caps:=s;
end;

Procedure ShowVersion;
Begin
    cls;
    nl;
    sprint(#3#0+centre(verline(1)));
    sprint(#3#7+centre(verline(2)));
    sprint(#3#5+centre('Fossil Driver '+Fossil_Description(Systat.ComPort)));

  If (LicenseInfo<>'') then
    Begin
      nl;
      sprint(#3#5+'This Copy of '+#3#0+SoftwareName+#3#5+' is licensed to:');
      nl;
      sprompt('                '+#3#4+licenseinfo);  { Added a space there for looks... }
      nl;
      nl;
      nl;
      pausescr;
   End;
End;

Function MakeLength(Len : Byte; Str : String) : String;

Begin
 if Length(Str)<Len then
    While Length(Str)<Len do
          Str := Str +' ';
 MakeLength := Str;
End;

procedure lcmds(len,c:byte; c1,c2:string);
var s:string;
begin
  s:=copy(c1,2,lenn(c1)-1);
  if (c2<>'') then s:=mln(s,len-1);
  sprompt(#3#1+'('+#3+chr(c)+c1[1]+#3#1+')'+s);
  if (c2<>'') then
  sprompt(#3#1+'('+#3+chr(c)+c2[1]+#3#1+')'+copy(c2,2,lenn(c2)-1));
  nl;
end;

procedure handlempcode(var ccc:char);
var tf:file of tfilerec;
    temptfilebase:tfilerec;
    s:string;
    i,j:integer;
    mc:array[1..6] of char;
    bfo,ulfo:boolean;
begin
  if (not mpcoder) then exit;
  ccc:=#0;
  for i:=1 to 6 do mc[i]:=chr(mpcode[i]);
  case chr(mpcode[1]) of
    'r':begin
          if (mc[2]+mc[3]='mt') then mtcolors:=(mc[4]='1');
        end;
    '*':begin
          if (mc[2]+mc[3]='li') then
            case mc[4] of

(*
              'b':begin
                    pr('');
                    bfo:=(filerec(bf).mode<>fmclosed);
                    if (not bfo) then reset(bf);
                    i:=1;
                    with tempboard do
                      while (not eof(bf)) do begin
                        read(bf,tempboard);
                        s:=aonoff(aacs(acs),' ','*')+mn(i,3)+':'+
                           mln(stripcolor(name),40)+':'+acs+'/'+password;
                        pr1(s+^M^J);
                        inc(i);
                      end;
                    pr('');
                    if (not bfo) then close(bf);
                  end;

*)

              'f':begin
                    pr('');
                    ulfo:=(filerec(ulf).mode<>fmclosed);
                    if (not ulfo) then reset(ulf);
                    i:=1;
                    with tempuboard do
                      while (not eof(ulf)) do begin
                        read(ulf,tempuboard);
                        s:=aonoff(aacs(acs),' ','*')+mn(i,3)+':'+
                           mln(stripcolor(name),40)+':'+acs+'/'+password;
                        pr1(s+^M^J);
                        inc(i);
                      end;
                    pr('');
                    if (not ulfo) then close(ulf);
                  end;
              'r':SendFileP(start_dir+'\err.log');
              't':begin
                    pr('');
                    assign(tf,systat.gfilepath+'gfiles.dat');
                    {$I-} reset(tf); {$I+}
                    i:=1;
                    read(tf,temptfilebase); j:=temptfilebase.gdaten;
                    with temptfilebase do
                      while ((not eof(tf)) and (i<j)) do begin
                        read(tf,temptfilebase);
                        s:=aonoff(aacs(acs),' ','*')+mn(i,3)+':'+
                           mln(filen,12)+':'+mln(stripcolor(title),40)+':'+
                           acs+'/'+gdate;
                        pr1(s+^M^J);
                        inc(i);
                      end;
                    pr('');
                    close(tf);
                  end;
            end;
        end;
  end;
  mpcoder:=FALSE;
end;

function stripcolor(o:string):string;
var s:string;
    i:integer;
    lc:boolean;
begin
  s:=''; lc:=FALSE;
  for i:=1 to length(o) do
    if (lc) then lc:=FALSE
      else if ((o[i]=#3) or (o[i]='^')) then lc:=TRUE else s:=s+o[i];
  stripcolor:=s;
end;


function tch(s:string):string;
begin
  if (length(s)>2) then s:=copy(s,length(s)-1,2) else
    if (length(s)=1) then s:='0'+s;
  tch:=s;
end;

function date:string;
var r:registers;
    y,m,d:string[3];
    yy,mm,dd,dow:word;
begin
  getdate(yy,mm,dd,dow);
  str(yy-1900,y); str(mm,m); str(dd,d);
  date:=tch(m)+'/'+tch(d)+'/'+tch(y);
end;

function dat:string;
const mon:array [1..12] of string[3] =
          ('Jan','Feb','Mar','Apr','May','Jun',
           'Jul','Aug','Sep','Oct','Nov','Dec');
var ap,x,y:string; i:integer;
    year,month,day,dayofweek,hour,minute,second,sec100:word;
begin
  getdate(year,month,day,dayofweek);
  gettime(hour,minute,second,sec100);

  if (hour<12) then ap:='am'
  else begin
    ap:='pm';
    if (hour>12) then dec(hour,12);
  end;
  if (hour=0) then hour:=12;

  dat:=cstr(hour)+':'+tch(cstr(minute))+' '+ap+'  '+
       copy('SunMonTueWedThuFriSat',dayofweek*3+1,3)+' '+
       mon[month]+' '+cstr(day)+', '+cstr(year);
(*  5:43 pm  Fri Jul 28, 1989  *)
end;

function time:string;
var h,m,s:string[3];
    hh,mm,ss,ss100:word;
begin
  gettime(hh,mm,ss,ss100);
  str(hh,h); str(mm,m); str(ss,s);
  time:=tch(h)+':'+tch(m)+':'+tch(s);
end;

procedure sde; { restore curco colors (DOS and tc) loc. after local }
var c:byte;
    b:boolean;
begin
  if (okansi) then begin
    c:=curco; curco:=255-curco;
    b:=outcom; outcom:=FALSE;
    setc(c);
    outcom:=b;
  end;
end;

procedure sdc; { restore curco colors (DOS and tc) loc/rem after loc/rem }
var c:byte;
begin
  if (okansi) then begin
    c:=curco; curco:=255-curco;
    setc(c);
  end;
end;

procedure outtrap(c:char);
begin
  if (c<>^G) then write(trapfile,c);
end;

procedure cl(c:integer);
begin
  if (c in [0..9]) then
    if (okansi) then
      setc(thisuser.cols[(color in thisuser.ac)][c]);
end;

function exist(fn:string):boolean;
var srec:searchrec;
begin
  findfirst(sqoutsp(fn),anyfile,srec);
  exist:=(doserror=0);
end;

Function AddSlash(S: String) : String;
Begin
 if (copy(s,length(s),1)<>'\') then
    s:=s+'\';
  AddSlash := S;
End;

End.                     { END OF UNIT }
