{ Lib 1 }

{ OCT 97 - Release Notes                                         }
{ Function library                                               }

Unit Lib;

Interface

Uses Crt, Dos, Display, Fossil, Data, CDrop, Stats, ErrorLog, page, Colours,
     Wins, WaitTix;

procedure CurSw(Switch : Boolean);
Procedure TCol(Col1 : Integer);
Procedure BCol(Col2 : Integer);
Procedure Center(X : Integer; Buffer : String);
procedure Printfile(FileName : String);
procedure Print(Buffer : String);
procedure LocalPrint(Buffer : String);
function ReadKB(Flag : Integer): string;
function ReadKeys(Code : Boolean): Integer;  { Reads Local Keyboard }
procedure ClearKBuffer;
procedure LineFeed;
procedure ClearDisplay(DisplayUserStats : Boolean);
procedure SetX(Col : String);
procedure SetY(Col : String);
procedure ResetTime;
function MinutesPast : Word;
function TimeLeft : word;
function GetSec : Word;
procedure HoldPage;

Implementation

Var
   Fin   : Word;
   Sec,
   Start,
   U,I    : Integer;

(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure Help;
var
  Key : char;
begin
  U := WhereX;
  I := WhereY;
  If StatsBox = 4 then StatsBox := 1
    Else inc(StatsBox);
  UserStats;
  GotoXY(U,I);
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure CurSw(Switch : Boolean);
begin
  if Switch then
   begin
     regs.ah := $01;
     regs.ch := $03;
     regs.cl := $01;
   end
  else
   begin
     regs.ah := $01;
     regs.ch := $01;
     regs.cl := $20;
   end;
 Intr($10, regs);
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
Procedure TCol(Col1 : Integer);
begin
  TextColor(Col1);
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
Procedure BCol(Col2 : Integer);
begin
  TextBackground(Col2);
end;
(* ------------------------------------------------------------------------ *)
(* Scroll BBS Screen Up One Line                                            *)
(* ------------------------------------------------------------------------ *)
procedure ScrollUp;
begin
   Regs.AH := $06;
   Regs.AL := $01; { Lines To Scroll }
   Regs.BH := $00; { Colour Attribute For New Line / Black }
   if SOnOff then   { Status Bar On / Off }
     begin
       Regs.CH := $02; { Top Row  / 1 }
     end
   Else
     begin
       Regs.CH := $00;
     end;
   Regs.CL := $00; { Left Column / 0 }
   Regs.DH := 25; { Bottom Row / 25 }
   Regs.DL := $50; { Right Column / 80 }
   Intr($10, Regs);
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure ControlScreen(Flag : Byte);
Var
  X, Y : Integer;
begin
  Y := WhereY; { Store Current Cursor Posistions }
  X := WhereX;
  Case Flag of
    0 : begin { Increment Screen Up One }
          ScrollUp;
        end;
    1 : begin
          UserStats;
          BBSLines  := 0;
          LineCount :=0;
        end;
  end; { Case End }
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure HoldPage;
Var
  Step : Integer;
begin
  LineCount := 0; { Reset Line Counter }
(*  If not Local then
    begin
      SendFChar(10);
    end;
  *)
  Print('[PAUSED] Press Any Key To Continue');
  Response := ReadKB(1);
  for Step := 0 to 34 do
    begin
      Print(Chr($08));
      Print(Chr($20));
      Print(Chr($08));
    end;
  Print(Chr(32));
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
Procedure Center(X : Integer; Buffer : String);
Var
  A, B : Integer;
begin
  A := 81 - Length(Buffer);
  B := Trunc(A / 2);
  GotoXY(B,X);
  Write(Buffer);
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure Printfile(FileName : String);
Var
  GetLine  : Char;
  PFile    : Text;
  TextGrab,
  Outs     : String;
begin
  LineCount :=0;
  TextGrab  := '';
  Assign(PFile, FileName);
  {$I-} Reset(PFile); {$I+}
  If IOResult <> 0 then
    begin
      LogError('Unable To Open ' + FileName);
    end
  Else
    begin
      While not eof(PFile) do
       begin
         Read(PFile, GetLine);
         TextGrab := TextGrab + GetLine;
         If (Ord(GetLine) = 10) and (LineCount = 0)
             or (BBSLines = CurrentLine) then
              begin
                GetLine := Chr(0);
                If BBSLines = CurrentLine then
                  Dec(BBSLines);
              end
          Else
           begin { If Hold Page Has Just Been Used Then Do not LineFeed }
             If Local then
               begin
                 if (GetLine >= Chr(224)) and (GetLine <= Chr(239)) then
                   begin  { Sauron Colour Codes }
                     Colour(Ord(GetLine));
                   end
                 Else
                   begin
                     Disp(Getline); { Display Local Only }
                   end;
               end
              Else
               begin
                 If not FCarrier then
                   begin
                     NoCarrier;
                   end;
                 if (GetLine >= Chr(224)) and (GetLine <= Chr(239)) then
                   begin  { Sauron Colour Codes }
                     Colour(Ord(GetLine));
                   end
                 Else
                   begin
                     SendFChar(Ord(Getline)); { Send To Modem }
                     Disp(Getline);
                   end;
                end;
              If Ord(GetLine) = 13 then
                begin
                  Inc(LineCount);
                  Inc(BBSLines);
                end;
              If BBSLines = CurrentLine then ControlScreen(0);
              If LineCount = 24 then HoldPage;
              If Length(TextGrab) > 4 Then TextGrab := '';
              If (TextGrab = #27 + '[2J') or (TextGrab = #12) then
                begin
                  ControlScreen(1);
                  TextGrab := '';
                end;
          end;
       end;
      Close(PFile);
    end;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure Idle(Sets : Boolean);
Var
    H,M,S,Hund  : word;
begin             GetTime(H,M,S,Hund);
  If Sets then
    begin
      Start := 0;
      Fin   := 0;
      Fin   := 60 * BBSCfg.IdleTime;
      Sec := S;
    end
  Else
    begin
      if Sec <> S then
        begin
          Inc(Start);
          Sec := S;
        end;
      If Start >= Fin then
        begin
          LineFeed;
          LineFeed;
          PrintFile('IDLE.TXT');
          Wait(100);
          LogError('User Was Idle To Long');
          NoCarrier;
        end;
    end;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure Print(buffer : String);
Var
  Stringlen, Y,
  Step   : Integer;
begin
  Y := WhereY;
  If Local Then
     begin
       Stringlen := 0;
       StringLen := Length(Buffer);
       For Step  := 1 to Stringlen do
          begin
            If (Buffer[Step] = Chr(10)) and (Y = 25) then
              begin
                ControlScreen(0)
              end
            Else
              begin
                { Sauron Colour Codes }
                if (Buffer[Step] >= Chr(224)) and ((Buffer[Step]) <= Chr(239)) then
                  begin
                    Colour(Ord(Buffer[Step]));
                  end
                Else
                  begin
                    Disp(Buffer[Step]);
                  end;
              end;
         end;
     end
  Else
     begin
       Stringlen := 0;
       StringLen := Length(Buffer);
       For Step  := 1 to Stringlen do
          begin
            If not FCarrier then NoCarrier;
            If (Buffer[Step] = Chr(10)) and (Y = 25) then
              begin
                ControlScreen(0);
                SendFChar(Ord(Buffer[Step]));
              end
            Else
              begin
                { Sauron Colour Codes }
                if (Buffer[Step] >= Chr(224)) and ((Buffer[Step]) <= Chr(239)) then
                  begin
                    Colour(Ord(Buffer[Step]));
                  end
                Else
                  begin
                    SendFChar(Ord(Buffer[Step]));
                    Disp(Buffer[Step]);
                  end;
              end;
          end;
      end;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure LocalPrint(Buffer : String);
begin
  If Local = False then
    begin
      Local := True;
      Print(Buffer);
      Local := False;
    end
  Else
    begin
      Print(Buffer);
    end;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure ClearKBuffer;
begin
  Regs.Ah := $0C;
  Intr($21, Regs);
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
function ReadKeys(Code : Boolean): integer;
begin
  Regs.Ah := $01;
  Intr($16, Regs);
  if Code then
    ReadKeys := Regs.Al  { Get ASCII Code From Keyboard Buffer }
  Else
    ReadKeys := Regs.Ah; { Get Keyboard Scan Code From Buffer }
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
function ReadKB(Flag : Integer): string;
Var
  Buffer   : String;
  KeyIn    : Integer;
  Key      : Integer;
begin
  Buffer := '';
  Key    := 0;
  Idle(True);
  Repeat
    Idle(False);
    If Local Then
      begin
        If Keypressed then
          begin
            KeyIn :=Ord(ReadKey);
            case Chr(KeyIn) of
                 #0 : begin
                        Case ReadKey of
                    {F1}  #59 : begin  { Help / Local Only }
                                  If Not NewUser then Help;
                                end;
                    {F2}  #60 : begin
                                  Chats;
                                  KeyIn := 13;
                                end;
                    {F3}  #61 : begin
                                  LineFeed;
                                  LineFeed;
                                  PrintFile('FORCE.TXT');
                                  LogError('User Forced Of System');
                                  NoCarrier;
                                end;
                    {F4}  #62 : begin
                                end;
                    {F5}  #63 : begin
                                  If SOnOff then
                                    begin
                                      U := WhereX;
                                      I := WhereY + 2;
                                      SOnOff := False;
                                      Window(1,1,80,25);
                                      GotoXY(1,1);
                                      textbackground(Black);
                                      ClrEol;
                                      GotoXY(1,2);
                                      ClrEol;
                                      GotoXY(U,I);
                                    end
                                  Else
                                    begin
                                      U := WhereX;
                                      I := WhereY - 2;
                                      SOnOff := True;
                                      UserStats;
                                      GotoXY(U,I);
                                    end;
                                end;
                         end; { Case End }
                      end;
                #17 :  begin              { Exit To Dos / Local Only }
                         CloseDataFiles;
                         Halt(1);
                       end;
            end; { Case End }
         end
       Else
         begin
           KeyIn := 0;
         end;
      end
      Else
        begin
          KeyIn := 0;
          If not FCarrier then
            begin
              NoCarrier;
            end
          Else
            If Keypressed then
              begin
                KeyIn := Ord(ReadKey);
                Case Chr(KeyIn) of
                  #0 : begin
                         Case ReadKey of
                    {F1}  #59 : begin  { Help / Local Only }
                                  If Not NewUser Then Help;
                                end;
                    {F2}   #60 :begin
                                  Chats;
                                  KeyIn := 13;
                                end;
                    {F3}  #61 : begin
                                  LineFeed;
                                  LineFeed;
                                  PrintFile('FORCE.TXT');
                                  LogError('User Forced Of System');
                                  NoCarrier;
                                end;
                    {F4}  #62 : begin
                                end;
                    {F5}  #63 : begin
                                  If SOnOff then
                                    begin
                                      U := WhereX;
                                      I := WhereY + 2;
                                      SOnOff := False;
                                      Window(1,1,80,25);
                                      GotoXY(1,1);
                                      textbackground(Black);
                                      ClrEol;
                                      GotoXY(1,2);
                                      ClrEol;
                                      GotoXY(U,I);
                                    end
                                  Else
                                    begin
                                      U := WhereX;
                                      I := WhereY - 2;
                                      SOnOff := True;
                                      UserStats;
                                      GotoXY(U,I);
                                    end;
                                end;
                         end; { Case End }
                       end;
                end; { Case End }
              end
            Else
             begin
               If PeakFChar <> 0 Then  { Checks Port For Key Press }
                 begin
                   KeyIn := ReadFChar;
                 end;
             end;
          end;
        Case KeyIn of
        32..125 : begin
                     Inc(Key);
                     If Echo then
                       If Not PassEcho then
                         Print(Chr(KeyIn))
                       Else Print('*');
                     Insert(Chr(KeyIn), Buffer, Key); { Do not Store CR }
                     Idle(True);
                   end;
                8 : begin
                     If Key > 0 then
                       begin
                         If Echo then
                           begin
                              Print(Chr(KeyIn));
                              Print(Chr($20));
                              Print(Chr(KeyIn));
                           end;
                         Delete(Buffer, Key, 1);
                         Dec(Key);
                         Idle(True);
                      end;
                   end;
       end; { Case End }
      Until (KeyIn = 13) or (Key = Flag);
      If Not NoUpper then
        begin
          For Loop := 1 to Key do
            begin  { Convert To Upper Case }
              Buffer[Loop] := UpCase(Buffer[Loop]);
            end;
        end;
      ReadKB := Buffer;
      If InputReady then PurgeInput;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure LineFeed;
Var
  X, Y : Integer;
begin
  Y := WhereY;
{  If Y = 25 Then ControlScreen(0); }
  Print(Chr(13));
  Print(Chr(10));
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure ClearDisplay(DisplayUserStats : Boolean);
begin
  BBSLines := 0;
  If UserInfo.UserCls = True then
    begin
      if Local then ClrScr;
      if UserInfo.UserAnsi = 1 then
        begin
          Print(#27 + '[2J');
        end
      Else
        begin
          Print(Chr($0C));
        end;
   end
 else
   LineFeed;
 if DisplayUserStats then
  begin
    if not NewUser then UserStats
  end
 Else
  begin
    FirstStats;
  end;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure ResetTime;
Var
  H,M,S,Hund,
  Mins  : Word;
begin
  GetTime(H,M,S,Hund);
  StartTimes := M;
  Minutes := 0;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
function MinutesPast: word;
Var
  H,M,S,Hund,
  Mins  : Word;
begin
  GetTime(H,M,S,Hund);
  If M <> StartTimes then
    begin
      Inc(Minutes);
      StartTimes := M;
    end;
  MinutesPast := Minutes;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;

function TimeLeft : Word;
begin
  SessionLength := MinutesPast;
  If (UserNumber > 0) and (UserInfo.UserLevel > 0) then
    begin
      If SessionLength <= SessionTime - LastOnTime then
        begin
          TimeLeft := SessionTime - SessionLength;
        end
      Else
        begin
          LineFeed;
          LineFeed;
          Print(' ---- Sorry You Ran Out Of Time ---- ');
          LineFeed;
          Wait(100);
          Timeleft := 0;
        end
    end;
end;

function GetSec : word;
Var h,m,S,hu : Word;
begin
  GetTime(h,m,s,hu);
  GetSec := s;
end;

{ Cursor Control }
procedure SetX(Col : string);
Var
  Y, X : byte;
begin
  if UserInfo.UserAnsi = 1 then { ANSI }
    begin
      Col := '[' + Col + 'C';
      Print(#13 + Col);
    end
  Else
    begin
      If UserInfo.UserAnsi = 2 then  { AVATAR }
        begin
          Y := WhereY;
          Val(Col, X, Code);
          Print(#22 + #8 + Chr(Y) + Chr(X));
        end
      Else
        begin
          { Sauron }
        end;
    end;
end;

procedure SetY(Col : string);
Var
  Y, X : integer;
begin
  if UserInfo.UserAnsi = 1 then { ANSI }
    begin
      Val(Col, Y, X);
      Dec(Y);
      Str(Y, Col);
      Print(#27 + '[0;0H' + #27 + '[' + Col + 'B');
    end
  Else
    begin
      If UserInfo.UserAnsi = 2 then  { AVATAR }
        begin
          Y := WhereX;
          Val(Col, X, Code);
          Print(#22 + #8 + Chr(X) + Chr(Y));
        end
      Else
        begin
          { Sauron }
        end;
    end;
end;

end.