{ AVATAR INTERPRETER }

Program Avatar;

Uses Crt, Dos;

Const
    def_attr = 3;
    lastline = 25;
    lastrow  = 80;
var
   Buffer : array[1..2048] of char;  { 2K Buffer }

   BufferSize,
   Num       : integer;
   Cur_attr : integer;

   Regs     : registers;
   Ins      : file of char;

procedure GetBuffer;
Var
  Chars : Char;
begin
  Num        := 1;
  BufferSize := 0;
  Cur_Attr  := 3;
  Assign(Ins,'FILE.AVT');
  {$I-} Reset(Ins); {$I+}
  If IOResult <> 0 then
    begin
      Halt(0);
    end
  Else
    begin
      while not Eof(Ins) do
        begin
          read(Ins, Chars);
          Inc(BufferSize);
          Buffer[BufferSize] := Chars;
        end;
      Close(Ins);
    end;
end;

function MgetChar : Char;
begin
  If Num < BufferSize then
    begin
      MGetChar := Buffer[Num];
      Inc(Num);
    end
  Else
    begin
      Halt(0);
    end;
end;


Var
  c,i,j,
  Code   : Integer;
  TCol,
  BCol   : Byte;
Begin
   GetBuffer;
   repeat
   Code := Ord(mgetchar);            (* Read a char from the modem *)
   Case Code of
       12 : begin { Clear Screen & Reset Attributes }
              Textattr := def_attr;  { ^L }
              ClrScr;
            end;
       25 : begin { See FSC-0025.TXT For Description }
              C := Ord(mgetchar);                 { ^Y }
              J := Ord(mgetchar);
              for I := 1 to J do
                begin
                  Write(Chr(C));        { print in color }
                end;
            end;
       22 : begin
              Code := Ord(mgetchar);              { ^V }
              case Code of
                    1 : begin { Set the color attribute to <attr> }
                          cur_attr := Ord(MGetChar) and $7f;
                          textattr := Cur_Attr;
                         end;
                     2 : begin  { Turn Blink On }
                           cur_attr := cur_attr + 128;
                           Textattr := cur_attr;
                         end;
                     3 : begin { Move Cursor One Line Up }
                           I := WhereY;
                           if I  > 1 then  { Move Only If Cusror Is > 1 }
                             begin
                               GotoXY(whereX,I - 1);
                             end
                           Else
                             begin
                               { Ignore }
                             end;
                          end;
                      4 : begin { Move Cursor One Line Down }
                            I := WhereY;
                            if I < lastline then
                              begin
                                GotoXY(WhereX, I + 1);
                              end
                            Else
                              begin
                                { Ignore }
                              end;
                           end;
                       5 : begin { Move Cursor One Column To The Left }
                             I := WhereX;
                             if I  > 1 then
                               begin
                                 GotoXY(I - 1,WhereY);
                               end
                             Else
                               begin
                                 { Ignore }
                               end;
                           end;
                       6 : begin { Move Cursor One Column To The Right }
                             I := WhereX;
                             if I < lastrow then
                               begin
                                 GotoXY(I + 1,WhereY);
                               end
                             Else
                               begin
                                 { Ignore }
                               end;
                             end;
                         7 : begin { Clear Rest Of Line In Current Window }
                               ClrEol;
                              end;
                         8 : begin { Move Cursor to <ROW> <COL> }
                               I := Ord(mgetchar);
                               GotoXY(Ord(mgetchar),I);
                             end;
                        end; { Case End }
            end;
     Else
       begin
         Write(Chr(Code));
       end;
  end; { Case End }
  until num = 99999;
end.

