program verbconv;

uses crt,dos;

type
  oldverbrec     = Record         { [VERBOSE.DAT] - Verbose Descriptions    }
    descr : array[1..4] of string[50]; { The Verbose Description            }
  end;
  newverbrec  = Record            { [VERBOSE.DAT] - Verbose Descriptions    }
    descr : array[1..10] of string[80]; { The Verbose Description           }
  end;

Procedure ConvertVerbose;
Var ov:oldverbrec;
    tv:newverbrec;
    ovf:file of oldverbrec;
    tvf:file of newverbrec;
    i:byte;

Begin
  assign(ovf,'verbose.dat');
  {$I-} reset(ovf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading VERBOSE.DAT.');
    textcolor(15);
    HALT(1);
  end;
  assign(tvf,'verbose.new');
  rewrite(tvf);
  textcolor(14); write('Converting VERBOSE.DAT......'); textcolor(15);
  while not eof(ovf) do begin
    read(ovf,ov);
    with tv do begin
      for i:=1 to 4 do
        descr[i]:=ov.descr[i];
      for i:=5 to 10 do
        descr[i]:='';
    end;
    write(tvf,tv);
  end;
  close(tvf);
  close(ovf);
  writeln('Done!');
end;

Begin
  ConvertVerbose;
End.
