program userconv;

uses crt,dos;

type
  UserNameStr = String[30];       { FILL ME IN                               }
  Astr        = String[160];      { ASTR String Type Definition              }
  acstring    = String[20];       { Access Condition String Type [ACS]       }
  acrq        = '@'..'Z';         { AR Flags                                 }
  FlagSet     = Set of '@'..'Z';  { AR Flags [Ryan's - FILL ME IN]           }

  uflags      =                   { User Access Condition Flags              }
   (rlogon,                       { L - Restricted to one call a day         }
    rchat,                        { C - Can't page the SysOp                 }
    rvalidate,                    { V - Posts marked unvalidated             }
    rbackspace,                   { B - Can't do ^B/^N/etc in messages       }
    ramsg,                        { A - Can't change the AutoMessage         }
    rpostan,                      { * - Can't post anonymously               }
    rpost,                        { P - Can't post at all                    }
    remail,                       { E - Can't send any e-mail                }
    rvoting,                      { K - Can't vote                           }
    rmsg,                         { M - Force e-mail deletion                }
    spcsr,                        {                                          }
    onekey,                       { onekey input mode                        }
    avatar,                       { user has AVATAR                          }
    pause,                        { pause                                    }
    novice,                       { user is at novice help level             }
    ansi,                         { user has ANSI                            }
    color,                        { user has color                           }
    alert,                        { alert SysOp when user logs on            }
    smw,                          { short-message waiting for user           }
    nomail,                       { user mail-box is closed                  }
    fnodlratio,                   { 1 - No UL/DL ratio                       }
    fnopostratio,                 { 2 - No post/call ratio                   }
    fnofilepts,                   { 3 - No file points checking              }
    fnodeletion);                 { 4 - Protection from deletion             }
  clrs        = array[FALSE..TRUE,0..9] of byte; { color records             }
  secrange    = array[0..255] of integer;        { security tables           }
  dlnscan     = set of 0..96;     { FILL ME IN                               }

  olduserrec     = record            { [USER.LST] - Main User Account Records   }
    name,                               { User Name [Handle]                 }
    realname    : string[36];           { User Real Name                     }
    pw          : string[20];           { User Password                      }
    ph          : string[12];           { User Phone Number                  }
    bday,                               { User BirthDate                     }
    firston,                            { FirstOn Date                       }
    laston      : string[8];            { LastOn Date                        }

    accountnote,                        { User Note - Public User Note       }
    computer    : string[30];           { Computer Type                      }
    note        : string[39];           { User Note - Private SysOp Note     }

    lockedout,                          { Is This User Locked Out?           }
    deleted     : boolean;              { Is This User Deleted?              }
    lockedfile  : string[8];            { Lockout Message To Display         }

    ac          : set of uflags;        { User Access Flags                  }
    ar          : flagset;              { Access Restriction Flags           }

    zzqscan,                            { Last-Read Message Pointers         }
    xqxxx       : array[1..64] of word; { FILL ME IN                         }
    zzqscn      : array[1..64] of boolean; { Scan Message Board Flags        }
    zzdlnscn    : dlnscan;              { Scan File Area Flags               }

    vote,                               { User Voting Data                   }
    nuv         : array[1..20] of byte; { User New User Voting Data          }

    useautosigs : boolean;              { Use Auto-Signatures Or Not         }

    sex         : char;                 { User Sex                           }

    ttimeon,                            { Total Mins Spent On-Line           }
    uk,                                 { Uploaded Kbytes                    }
    dk          : longint;              { Downloaded Kbytes                  }

    uploads,                            { Number of Uploads                  }
    downloads,                          { Number of Downloads                }
    loggedon,                           { Number of Calls                    }
    tltoday,                            { Time [Minutes] Remaining Today     }
    msgpost,                            { Number of Public Posts             }
    emailsent,                          { Number of E-Mail Messages Sent     }
    filepoints  : integer;              { Number of File Points              }

    linelen,                            { User Line Length [Num. Columns]    }
    pagelen,                            { User Page Length [Num. Rows   ]    }
    ontoday,                            { Number of Calls Today              }
    illegal,                            { Number of Illegal Logon Attempts   }
    sl,                                 { User Security Level                }
    dsl         : byte;                 { User Download Security Level       }

    cols        : clrs;                 { User Colors                        }

    lastmsg,                            { Last Message Area                  }
    lastfil     : byte;                 { Last File Area                     }
    timebank    : integer;              { Number of Minutes in Time Bank     }
                                        { Note: Time Bank will be replaced
                                          and the new one will be auxiliary. }

    trapactivity,                       { Trap This Users Activity?          }
    trapseperate: boolean;              { If Trapping, To Seperate File?     }

    timebankadd : integer;              { Time Added To Bank Today SEE ABOVE }
    mpointer    : longint;              { Pointer To Entry in MACRO.LST      }
    chatauto,                           { Automatically Log Chat Mode?       }
    chatseperate,                       { Log To A Seperate Chat Trap File?  }
    slogseperate,                       { Seperate SysOp Log For This User?  }
    clsmsg      : boolean;              { Clear Screen Before Each Message?  }

    avatarcoloradjust:boolean;          { Use The AVATAR Color Adjustment?   }

    headernumber: integer;              { Which Header Do You Wish To Use    }
    hidename    : boolean;              { FILL ME IN                         }

    FListCfg    : array[1..11] of byte; { File List Configurations           }
    DidConfig   : byte;                 { Has This User Configured Yet?      }
    res         : array[1..3] of byte;  { RESERVED DATA SPACE                }

    MsgConf,                            { FILL ME IN                         }
    FilConf     : FlagSet;              { FILL ME IN                         }

    IncomingMail,                       { FILL ME IN                         }
    OutGoingMail,                       { FILL ME IN                         }
    AreaListNumber:Integer;             { FILL ME IN                         }

    wallread,                           { The Wall: Scan Pointer             }
    newsread  : integer;                { AstuteNews: Scan Pointer           }
    haspickit : boolean;                { Do You Have A Ticket?              }
    pickit    : array[1..6] of integer; { The Actual Ticket                  }
  end;

  newuserrec     = record            { [USER.LST] - Main User Account Records   }
    name,                               { User Name [Handle]                 }
    realname    : string[36];           { User Real Name                     }
    pw          : string[20];           { User Password                      }
    ph          : string[12];           { User Phone Number                  }
    bday,                               { User BirthDate                     }
    firston,                            { FirstOn Date                       }
    laston      : string[8];            { LastOn Date                        }

    accountnote,                        { User Note - Public User Note       }
    computer    : string[30];           { Computer Type                      }
    note        : string[39];           { User Note - Private SysOp Note     }

    lockedout,                          { Is This User Locked Out?           }
    deleted     : boolean;              { Is This User Deleted?              }
    lockedfile  : string[8];            { Lockout Message To Display         }

    ac          : set of uflags;        { User Access Flags                  }
    ar          : flagset;              { Access Restriction Flags           }

    vote,                               { User Voting Data                   }
    nuv         : array[1..20] of byte; { User New User Voting Data          }

    useautosigs : boolean;              { Use Auto-Signatures Or Not         }

    sex         : char;                 { User Sex                           }

    ttimeon,                            { Total Mins Spent On-Line           }
    uk,                                 { Uploaded Kbytes                    }
    dk          : longint;              { Downloaded Kbytes                  }

    uploads,                            { Number of Uploads                  }
    downloads,                          { Number of Downloads                }
    loggedon,                           { Number of Calls                    }
    tltoday,                            { Time [Minutes] Remaining Today     }
    msgpost,                            { Number of Public Posts             }
    emailsent,                          { Number of E-Mail Messages Sent     }
    filepoints  : integer;              { Number of File Points              }

    linelen,                            { User Line Length [Num. Columns]    }
    pagelen,                            { User Page Length [Num. Rows   ]    }
    ontoday,                            { Number of Calls Today              }
    illegal,                            { Number of Illegal Logon Attempts   }
    sl,                                 { User Security Level                }
    dsl         : byte;                 { User Download Security Level       }

    cols        : clrs;                 { User Colors                        }

    lastmsg,                            { Last Message Area                  }
    lastfil     : byte;                 { Last File Area                     }
    timebank    : integer;              { Number of Minutes in Time Bank     }
                                        { Note: Time Bank will be replaced
                                          and the new one will be auxiliary. }

    trapactivity,                       { Trap This Users Activity?          }
    trapseperate: boolean;              { If Trapping, To Seperate File?     }

    timebankadd : integer;              { Time Added To Bank Today SEE ABOVE }
    mpointer    : longint;              { Pointer To Entry in MACRO.LST      }
    chatauto,                           { Automatically Log Chat Mode?       }
    chatseperate,                       { Log To A Seperate Chat Trap File?  }
    slogseperate,                       { Seperate SysOp Log For This User?  }
    clsmsg      : boolean;              { Clear Screen Before Each Message?  }

    avatarcoloradjust:boolean;          { Use The AVATAR Color Adjustment?   }

    headernumber: integer;              { Which Header Do You Wish To Use    }
    hidename    : boolean;              { FILL ME IN                         }

    FListCfg    : array[1..11] of byte; { File List Configurations           }
    DidConfig   : byte;                 { Has This User Configured Yet?      }
    res         : array[1..3] of byte;  { RESERVED DATA SPACE                }

    MsgConf,                            { Last Message   Conf                }
    FilConf     : FlagSet;              { FILL ME IN                         }

    IncomingMail,                       { FILL ME IN                         }
    OutGoingMail,                       { FILL ME IN                         }
    AreaListNumber:Integer;             { FILL ME IN                         }

    wallread,                           { The Wall: Scan Pointer             }
    newsread  : integer;                { AstuteNews: Scan Pointer           }
    haspickit : boolean;                { Do You Have A Ticket?              }
    pickit    : array[1..6] of integer; { The Actual Ticket                  }
  end;

Procedure ConvertUsers;
Var ou:olduserrec;
    tu:newuserrec;
    ouf:file of olduserrec;
    tuf:file of newuserrec;
    i:byte;

Begin
  assign(ouf,'user.lst');
  {$I-} reset(ouf); {$I+}
  if ioresult<>0 then begin
    textcolor(LightRed+Blink);
    Writeln('Error Reading USER.LST.');
    textcolor(15);
    HALT(1);
  end;
  assign(tuf,'user.new');
  rewrite(tuf);
  textcolor(14); write('Converting USER.LST......'); textcolor(15);
  while not eof(ouf) do begin
    read(ouf,ou);
    with tu do begin
      name:=ou.name;                    { User Name [Handle]                 }
      realname:=ou.realname;            { User Real Name                     }
      pw:=ou.pw;                        { User Password                      }
      ph:=ou.ph;                        { User Phone Number                  }
      bday:=ou.bday;                    { User BirthDate                     }
      firston:=ou.firston;              { FirstOn Date                       }
      laston:=ou.laston;                { LastOn Date                        }
      accountnote:=ou.accountnote;      { User Note - Public User Note       }
      computer:=ou.computer;            { Computer Type                      }
      note:=ou.note;                    { User Note - Private SysOp Note     }
      lockedout:=ou.lockedout;          { Is This User Locked Out?           }
      deleted:=ou.deleted;              { Is This User Deleted?              }
      lockedfile:=ou.lockedfile;        { Lockout Message To Display         }
      ac:=ou.ac;                        { User Access Flags                  }
      ar:=ou.ar;                        { Access Restriction Flags           }
      for i:=1 to 20 do begin
        vote[i]:=ou.vote[i];
        nuv[i]:=ou.nuv[i];
      end;
      useautosigs:=ou.useautosigs;      { Use Auto-Signatures Or Not         }
      sex:=ou.sex;                      { User Sex                           }
      ttimeon:=ou.ttimeon;              { Total Mins Spent On-Line           }
      uk:=ou.uk;                        { Uploaded Kbytes                    }
      dk:=ou.dk;                        { Downloaded Kbytes                  }
      uploads:=ou.uploads;              { Number of Uploads                  }
      downloads:=ou.downloads;          { Number of Downloads                }
      loggedon:=ou.loggedon;            { Number of Calls                    }
      tltoday:=ou.tltoday;              { Time [Minutes] Remaining Today     }
      msgpost:=ou.msgpost;              { Number of Public Posts             }
      emailsent:=ou.emailsent;          { Number of E-Mail Messages Sent     }
      filepoints:=ou.filepoints;        { Number of File Points              }
      linelen:=ou.linelen;              { User Line Length [Num. Columns]    }
      pagelen:=ou.pagelen;              { User Page Length [Num. Rows   ]    }
      ontoday:=ou.ontoday;              { Number of Calls Today              }
      illegal:=ou.illegal;              { Number of Illegal Logon Attempts   }
      sl:=ou.sl;                        { User Security Level                }
      dsl:=ou.dsl;                      { User Download Security Level       }
      cols:=ou.cols;                    { User Colors                        }
      lastmsg:=ou.lastmsg;              { Last Message Area                  }
      lastfil:=ou.lastfil;              { Last File Area                     }
      timebank:=ou.timebank;            { Number of Minutes in Time Bank     }
                                        { Note: Time Bank will be replaced
                                          and the new one will be auxiliary. }
      trapactivity:=ou.trapactivity;    { Trap This Users Activity?          }
      trapseperate:=ou.trapseperate;    { If Trapping, To Seperate File?     }
      timebankadd:=ou.timebankadd;      { Time Added To Bank Today SEE ABOVE }
      mpointer:=ou.mpointer;            { Pointer To Entry in MACRO.LST      }
      chatauto:=ou.chatauto;            { Automatically Log Chat Mode?       }
      chatseperate:=ou.chatseperate;    { Log To A Seperate Chat Trap File?  }
      slogseperate:=ou.slogseperate;    { Seperate SysOp Log For This User?  }
      clsmsg:=ou.clsmsg;                { Clear Screen Before Each Message?  }
      avatarcoloradjust:=ou.avatarcoloradjust; { Use The AVATAR Color Adjustment?   }
      headernumber:=ou.headernumber;    { Which Header Do You Wish To Use    }
      hidename:=ou.hidename;            { FILL ME IN                         }
      for i:=1 to 11 do flistcfg[i]:=ou.flistcfg[i];
      DidConfig:=ou.didconfig;          { Has This User Configured Yet?      }
      for i:=1 to 3 do res[i]:=ou.res[i]; { RESERVED DATA SPACE                }
      MsgConf:=ou.msgconf;              { Last Message   Conf                }
      FilConf:=ou.filconf;              { FILL ME IN                         }
      IncomingMail:=ou.incomingmail;    { FILL ME IN                         }
      OutGoingMail:=ou.outgoingmail;    { FILL ME IN                         }
      AreaListNumber:=ou.arealistnumber;{ FILL ME IN                         }
      wallread:=ou.wallread;            { The Wall: Scan Pointer             }
      newsread:=ou.newsread;            { AstuteNews: Scan Pointer           }
      haspickit:=ou.haspickit;          { Do You Have A Ticket?              }
      for i:=1 to 6 do pickit[i]:=ou.pickit[i]; { The Actual Ticket                  }
    end;
    write(tuf,tu);
  end;
  close(tuf);
  close(ouf);
  writeln('Done!');
end;

begin
  convertusers;
end.
