{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : TPANSI.PAS                                                    
  Description: ANSI Driver                                                   
  Version    : v1.5000                                                       
                                                                             
                                                                           
 Ľ}
{$R-,S+,G+,I+,F-,V-,B-,N-,L+ }
{$M 65520,0,655360 }

unit tpansi;


interface

uses crt,dos,scrlbk;

const
  ansion:boolean=TRUE;

procedure ansioutput(c:char);
procedure restorescreen(box :pointer; x,y,xx,yy :byte);
procedure savescren(box :pointer; x,y,xx,yy :byte);
function altkeydown:boolean;

implementation

type

       stype        =  string;     { you may want to svae memory and }
                                   { declare stype as string[80] , as it}
                                   { is mostly used for displaying one
                                   { line to the string, beware of pascal }
                                   { strict type checking }

       cardtype     =  (none,mda,cga,egamono,egacolour,vgamono,
                        vgacolour,mcgamono,mcgacolour);
var
       TPFError                 :byte;     { global error monitor }
       video_buff               :word;     { address of video buffer  }
       snow_check               :boolean;  { snow check for CGA   }
       video_page               :byte;     { default video page  }
       startline                :byte;     { cursor start scanline}
       stopline                 :byte;     { cursor start scanline}

{$F+}
{$L FASTOUT.OBJ}
procedure getxy(var x,y:integer);     external;
procedure setxy(x,y:integer);         external;
procedure putc(c:char);               external;
procedure scroll;                     external;
procedure reverse;                    external;
procedure conceal;                    external;
procedure restorescreen;              external;
procedure savescren;                  external;
function  altkeydown:boolean;         external;
{$F-}

procedure carriagereturn;
var x,y:integer;
begin
  getxy(x,y);
  if (x>lo(windmin)) then setxy(lo(windmin),y);
end;

procedure linefeed;
var x,y:integer;
begin
  getxy(x,y);
  if (y<hi(windmax)) then setxy(x,succ(y)) else scroll;
end;

procedure bell;
begin
  sound(440);
  delay(100);
  nosound;
end;

procedure backspace;
var x,y:integer;
begin
  getxy(x,y);
  if (x>lo(windmin)) then setxy(pred(x),y) else
    if (y>hi(windmin)) then setxy(lo(windmax),pred(y));
{*  putc(' ');*} {* messing up message ANSI B.S.!!!!! *}
end;

procedure character(c:char);
var x,y:integer;
begin
  getxy(x,y); putc(c);
  if (x<lo(windmax)) then setxy(succ(x),y) else
    if (y<hi(windmax)) then setxy(lo(windmin),succ(y))
  else begin
    scroll;
    setxy(lo(windmin),y);
  end;
end;

function getnumber(var s:string):integer;
var t:string;
    l:longint;
    e,n:integer;
begin
  {$I-}
  if (length(s)=0) then getnumber:=0
  else begin
    n:=pos(';',s);
    if (n = 0) then begin
      t:=s;
      s:=''
    end else begin
      t:=copy(s,1,n-1);
      delete(s,1,n)
    end;
    val(t,l,e);
    if (ioresult<>0) or (e<>0) then n:=0 else n:=integer(l);
    getnumber:=n;
  end;
  {$I+}
end;

procedure ansiup(var s:string);
var x,y,n:integer;
begin
  getxy(x,y);
  n:=getnumber(s);
  if (n<1) then n:=1;
  y:=y-lo(n);
  if (y<hi(windmin)) then y:=hi(windmin) else
    if (y>hi(windmax)) then y:=hi(windmax);
  setxy(x,y);
end;

procedure ansidn(var s:string);
var x,y,n:integer;
begin
  getxy(x,y);
  n:=getnumber(s);
  if (n<1) then n:=1;
  y:=y+lo(n);
  if (y>hi(windmax)) then y:=hi(windmax) else
    if (y<hi(windmin)) then y:=hi(windmin);
  setxy(x,y);
end;

procedure ansilt(var s:string);
var x,y,n:integer;
begin
  getxy(x,y);
  n:=getnumber(s);
  if (n<1) then n:=1;
  x:=x-lo(n);
  if (x<lo(windmin)) then x:=lo(windmin) else
    if (x>lo(windmax)) then x:=lo(windmax);
  setxy(x,y);
end;

procedure ansirt(var s:string);
var x,y,n:integer;
begin
  getxy(x,y);
  n:=getnumber(s);
  if (n<1) then n:=1;
  x:=x+lo(n);
  if (x>lo(windmax)) then x:=lo(windmax) else
    if (x<lo(windmin)) then x:=lo(windmin);
  setxy(x,y);
end;

procedure ansito(var s:string);
var i,n:integer;
begin
  n:=getnumber(s);
  i:=getnumber(s);
  if (n<1) then n:=1;
  if (i<1) then i:=1;
  gotoxy(i,n);
end;

procedure ansixy(save:boolean);
const
  x:word=0;
  y:word=0;
begin
  if (save) then begin
    x:=wherex;
    y:=wherey;
  end else
    if ((x>0) and (y>0)) then gotoxy(x,y);
end;

procedure ansicl;
begin
  clreol;
end;

procedure ansics(var s:string);
begin
  if (getnumber(s)=2) then clrscr;
end;

procedure ansico(var s:string);
var n:integer;

  procedure ftc(f:byte);
  begin
    textattr:=(textattr and 248) or f;
  end;

  procedure btc(b:byte);
  begin
    textattr:=(textattr and 143) or (b shl 4);
  end;

begin
  if (length(s)=0) then normvideo;
  while (length(s)>0) do begin
    n:=getnumber(s);
    if (n<0) then n:=0;
                                    { : B : b   b   b : f   f   f   f : }
    case lo(n) of
      0:textattr:=7;                { normal video }
      1:textattr:=textattr or 8;    { turn on f1   }
      2:textattr:=textattr and 247; { knock off f1 }
      5:textattr:=textattr or 128;  { turn on B    }
      6:textattr:=textattr or 128;  { turn on B    }
      7:reverse;
      8:conceal;
      30:ftc(black);
      31:ftc(red);
      32:ftc(green);
      33:ftc(brown);
      34:ftc(blue);
      35:ftc(magenta);
      36:ftc(cyan);
      37:ftc(lightgray);
      40:btc(black);
      41:btc(red);
      42:btc(green);
      43:btc(brown);
      44:btc(blue);
      45:btc(magenta);
      46:btc(cyan);
      47:btc(lightgray)
    end;
  end;
end;

procedure ansioutput(c:char);
const isansi:boolean=FALSE;
      ansis:string='';
      lastc:char=#0;
begin
  if (isansi) and (ansion) then begin
    if (c in ['H','F','A'..'D','s','u','J','K','m']) then begin
      case c of
        'H','F':ansito(ansis);
        'A':ansiup(ansis);
        'B':ansidn(ansis);
        'C':ansirt(ansis);
        'D':ansilt(ansis);
        's':ansixy(TRUE);
        'u':ansixy(FALSE);
        'J':ansics(ansis);
        'K':ansicl;
        'm':ansico(ansis);
      end;
      isansi:=FALSE;
    end else
      if (c in ['0'..'9',';']) and (length(ansis)<255) then
        ansis:=ansis+c
      else isansi:=FALSE;
  end else begin
    if (c<' ') then
      case c of
        #7 : bell;
        #8 : backspace;
        #10: linefeed;
        #12: clrscr;
        #13: carriagereturn;
        #27: if (lastc=c) then character(^[);
      else character(c);
      end
      else
      if (lastc<>^[) then character(c)
      else
        if (c='[') and (ansion) then begin
          isansi:=TRUE;
          ansis:='';
        end else begin
          character(^[);
          character(c);
        end;
  end;
  lastc:=c;
end;

procedure showstr(var b:textbuf; p,l:word);
var n:word;
begin
  for n:=p to (p+l) do character(b[n]);
end;

procedure setsnow;
begin
  inline($3e/$a0/>directvideo/{          mov       al,DirectVideo  }
         $3c/$01/             {          cmp       al,1            }
         $74/$07/             {          jz        DIRECT          }
         $b8/$00/$0f/         {          mov       ax,$0F00        }
         $cd/$10/             {          int            $10        }
         $eb/$08/             {          jmp       CHKMODE         }
         $31/$c0/             { DIRECT:  xor       ax,ax           }
         $8e/$c0/             {          mov       es,ax           }
         $26/$a0/$49/$04/     {          mov       al,[ES: $0449]  }
         $3c/$07/             { CHKMODE: cmp       al,7            }
         $74/$0c/             {          je        SETFAST         }
         $b4/$12/             {          mov       ah,$12          }
         $bb/$10/$ff/         {          mov       bx,$FF10        }
         $cd/$10/             {          int       $10             }
         $80/$ef/$ff/         {          sub       bh,$FF          }
         $74/$04/             {          jz        NOTFAST         }
         $31/$c0/             { SETFAST: xor       ax,ax           }
         $eb/$02/             {          jmp       SETIT           }
         $b0/$01/             { NOTFAST: mov       al,$01          }
         $3e/$a2/>checksnow); { SETIT:   mov       CheckSnow,al    }
end;

function whatcard : cardtype;
var
  code  :byte;
  regs : registers;

begin
  regs.ah := $1A;             { attempt to call vga identify card function }
  regs.al := $00;             { must clear al to 0 ...                     }
  intr($10,regs);
  if regs.al = $1A then       { so that if $1a comes back in al...         }
    begin                     { we know a ps/2 video bios is out there.    }
      case regs.bl of         { code comes back in bl.                     }
        $00 : whatcard := none;
        $01 : whatcard := mda;
        $02 : whatcard := cga;
        $04 : whatcard := egacolour;
        $05 : whatcard := egamono;
        $07 : whatcard := vgamono;
        $08 : whatcard := vgacolour;
        $0a,$0c : whatcard := mcgacolour;
        $0b : whatcard := mcgamono;
        else whatcard := cga
      end { case }
    end
  else
                                  { if it's not ps/2 we have to check for  }
     begin                        { the presence of an ega bios:           }
      regs.ah := $12;             { select alternate function service      }
      regs.bx := $10;             { bl=$10 means return ega information    }
      intr($10,regs);             { do it                                  }
      if regs.bx <> $10 then      { bx unchanged means ega is not there... }
        begin
          regs.ah := $12;         { once we know alt function exists...    }
          regs.bl := $10;         { ...we call it again to see if it's...  }
          intr($10,regs);         { ...ega colour or ega monochrome.       }
          if (regs.bh = 0) then whatcard := egacolour
            else whatcard := egamono
        end
      else
                                  { now we know its a cga or mda  bastard !}
        begin
          intr($11,regs);         { $11 = equipment determination service  }
          code := (regs.al and $30) shr 4;
          case code of
            1 : whatcard := cga;
            2 : whatcard := cga;
            3 : whatcard := mda
            else whatcard := none
          end { case }
        end
    end;
end;

{ ------------------------------------------------------------------------- }
{                          unit initialization                              }
{ ------------------------------------------------------------------------- }

begin
  case whatcard of
    cga,
    mcgacolour,
    egacolour,
    vgacolour :  video_buff := $b800;
    mda,
    mcgamono,
    egamono,
    vgamono  :   video_buff := $b000;
  end;  { case }
  snow_check   := false; { set to true fro snow prone monitors }
  video_page   := 0;     { default video page, 0-7 for EGA/VGA }
  startline    := 11;  { normal cursor }
  stopline     := 12;  { normal cursor }
end.
