{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : SYSOP8.PAS                                                    
  Description: Message Base Editor                                           
  Version    : v0.1500                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop8;

interface

uses
  crt, dos, overlay, common, file0, sysop1;

const sepr9=#3#9+':'+#3#5;

procedure boardedit;

implementation

procedure boardedit;
const ltype:integer=1;
var f1:file;
    s:string;
    i1,i2,ii,iii,iv,xx:integer;
    c:char;
    abort,next,dude:boolean;

  function newindexno:longint;
  var brd:boardrec;
      i,j:integer;
  begin
    reset(bf);
    j:=-1;
    for i:=1 to filesize(bf) do begin
      read(bf,brd);
      if (brd.permindx>j) then j:=brd.permindx;
    end;
    inc(j);
    newindexno:=j;
  end;

  procedure bed(x:integer);
  var i,j:integer;
  begin
    if ((x>0) and (x<=numboards)) then begin
      i:=x-1;
      if (i>=0) and (i<=filesize(bf)-2) then
        for j:=i to filesize(bf)-2 do begin
          seek(bf,j+1); read(bf,memboard);
          seek(bf,j); write(bf,memboard);
        end;
      seek(bf,filesize(bf)-1); truncate(bf);

      dec(numboards);
      dec(maxboard);
    end;
  end;

  procedure bei(x:integer);
  var i,j:integer;
  begin
    i:=x-1;
    if ((i>=0) and (i<=filesize(bf)) and (numboards<maxboards)) then begin
      for j:=filesize(bf)-1 downto i do begin
        seek(bf,j); read(bf,memboard);
        write(bf,memboard); { ...to next record }
      end;
      with memboard do begin
        name:='<< Not used >>';
        filename:='NEWBOARD';
        lastmsgid:=0;
        mbtype:=0;
        msgpath:='';
        acs:='s30';
        postacs:='s30';
        maxmsgs:=50;
        anonymous:=atno;
        password:='';
        permindx:=newindexno;
        zone:=0;
        net:=0;
        node:=0;
        point:=0;
        if (Network.origin<>'') then origin:=Network.origin
          else origin:=copy(stripcolor(systat.bbsname),1,50);
        text_color:=1;
        quote_color:=3;
        tear_color:=2;
        origin_color:=3;
        mbstat:=[mbskludge]+[mbsseenby]+[mbscenter]+[mbsbox]+[mbmcenter]+[mbaddtear];
        confnum:=1;    {Default Message Bases To Conference 1}
        msgstatus:=1;  {Default Message Bases To Public}
        confnum:=1;
      end;
      seek(bf,i); write(bf,memboard);
      inc(numboards);
      inc(maxboard);
    end;
  end;

  procedure bep(x,y:integer);
  var tempboard:boardrec;
      i,j,k:integer;
  begin
(*
            y   x
          012345678901234567890
   (k) 1> xxxxxxOxxx...........
   (j) 2> xxOxxxxxxx...........

            x   y
          012345678901234567890
   (k) 1> xxOxxxxxxx...........
   (j) 2> xxxxxxOxxx...........

           y  x         x  y
          0123456      0123456
          XxxxOXX      XOxxxXX
          X.xxxXX      Xxxx.XX
          XOxxxXX      XxxxOXX
          0312456      0231456

*)

    k:=y; if (y>x) then dec(y);
    dec(x); dec(y);
    seek(bf,x); read(bf,tempboard);
    i:=x; if (x>y) then j:=-1 else j:=1;
    while (i<>y) do begin
      if (i+j<filesize(bf)) then begin
        seek(bf,i+j); read(bf,memboard);
        seek(bf,i); write(bf,memboard);
      end;
      inc(i,j);
    end;
    seek(bf,y); write(bf,tempboard);
    inc(x); inc(y); {y:=k;}

  end;

  function flagstate(mb:boardrec):string;
  var s:string;
  begin
    s:='';
    with mb do begin
      if (mbrealname in mbstat) then s:=s+'R' else s:=s+'-';
      if (mbunhidden in mbstat) then s:=s+'U' else s:=s+'-';
      if (mbfilter in mbstat) then s:=s+'A' else s:=s+'-';
    end;
    flagstate:=s;
  end;

  function fidoflags(mb:boardrec):string;
  var s:string[9];
  begin
    s:='';
    with mb do begin
      if (mbskludge in mbstat) then s:=s+'K' else s:=s+'-';
      if (mbsseenby in mbstat) then s:=s+'S' else s:=s+'-';
      if (mbsorigin in mbstat) then s:=s+'O' else s:=s+'-';
      s:=s+'/';
      if (mbscenter in mbstat) then s:=s+'C' else s:=s+'-';
      if (mbsbox in mbstat) then s:=s+'B' else s:=s+'-';
      if (mbmcenter in mbstat) then s:=s+'M' else s:=s+'-';
      if (mbaddtear in mbstat) then s:=s+'T' else s:=s+'-';
      If AddAccNote then s:=s+'A' Else s:=s+'-';
    end;
    fidoflags:=s;
  end;

  procedure incolor(msg:string; var i:byte);
  begin
    sprompt('^5^1Enter New '+msg+' Color ^9[^20^9-^29^9]: ^1');
    mpl(1);
    input(s,1);
    if ((s<>'') and (s[1] in ['0'..'9'])) then i:=ord(s[1])-48;
  end;

  function getaddr(zone,net,node,point:integer):string;
  begin
   getaddr:=cstr(zone)+':'+cstr(net)+'/'+cstr(node)+'.'+cstr(point);
  end;

  procedure getbrdspec(var s:string);
  begin
    with memboard do
(*      if (mbmsgpath in mbstat) then
        s:=fexpand(msgpath+filename+'.MTX')
      else*)
      s:=fexpand(systat.msgpath+filename+'.MTX');
  end;

  procedure bem;
  var f:file;
      dirinfo:searchrec;
      anontemp:anontyp;
      s,s1,s2,s3,tmp:string;
      i,i1,i2,ii,xloaded,gi:integer;
      c,c1:char;
      b:byte;
      changed,err:boolean;
  begin
    sprompt('^5^1Begin Editing At Which ^9[^21^9-^2'+cstr(numboards)+'^9]: ^1'); inu(ii);
    c:=' '; xloaded:=-1;
    if ((ii>0) and (ii<=numboards)) then begin
      while (c<>'Q') and (not hangup) do begin
        if (xloaded<>ii) then begin
          seek(bf,ii-1); read(bf,memboard);
          xloaded:=ii; changed:=FALSE;
        end;
        with memboard do
          repeat
            if (c<>'?') then begin
              cls; nl;
              writetop('Message Base #'+cstr(ii)+' Of '+cstr(numboards));
              writebox2('');
              writebox2('[^21^9]^1 Name        : ^5'+name);
              writebox2('[^22^9]^1 FileName    : ^5'+filename);
              tmp:='[^23^9]^1 Base Type   : ^5';
              case mbtype of
                0:tmp:=tmp+'Local';
                1:tmp:=tmp+'EchoMail';
              end;
              tmp:=tmp+'   ^1Message Path: ^5';
              if (mbtype=0) then tmp:=tmp+'Unused' else tmp:=tmp+msgpath;
              writebox2(tmp);
              writebox2('[^24^9]^1 ACS Req.    : ^5"'+acs+'"');
              writebox2('[^25^9]^1 Post/MCI ACS: ^5"'+postacs+'" ^9/^5 "'+mciacs+'"');
              writebox2('[^26^9]^1 Max Mess    : ^5'+cstrl(maxmsgs));
              tmp:='[^27^9]^1 Anonymous   : ^5';
              case anonymous of
              atyes:tmp:=tmp+'Yes';
               atno:tmp:=tmp+'No';
           atforced:tmp:=tmp+'Forced';
         atdearabby:tmp:=tmp+'Dear Abby';
          atanyname:tmp:=tmp+'Any Name';
              end;
              writebox2(tmp);
              writebox2('[^28^9]^1 Password    : ^5"'+password+'"');
              tmp:='[^29^9]^1 Address     : ^5';
              if (mbtype=0) then tmp:=tmp+'Unused'
                else tmp:=tmp+getaddr(zone,net,node,point);
              writebox2(tmp);
{              writebox2('[^20^9]^1 Conference #: ^5'+cstr(confnum)); }
              writebox2('[^2L^9]^1 Lines/Msg   : ^5'+cstr(maxfselines));
              tmp:='[^2C^9]^1 Colors      : ^5';
              if (mbtype=0) then tmp:=tmp+'Unused' else
                tmp:=tmp+'Text='+cstr(text_color)+
                  ', Quote='+cstr(quote_color)+
                  ', Tear='+cstr(tear_color)+
                  ', Origin='+cstr(origin_color);
              writebox2(tmp);
              tmp:='[^2M^9]^1 Mail Flags  : ^5';
              if (mbtype=0) then tmp:=tmp+'Unused' else tmp:=tmp+fidoflags(memboard);
              writebox2(tmp);
              tmp:='[^2O^9]^1 Origin Line : ^5';
              if (mbtype=0) then tmp:=tmp+'Unused' else tmp:=tmp+'"'+origin+'"';
              writebox2(tmp);
              writebox2('    ^1Flags       : ^5'+flagstate(memboard));
              writebox2('    ^1P-Index     : ^5'+cstrl(permindx));
              tmp:='[^2P^9]^1 Priv/Public : ^5';
              Case MsgStatus of
                0:tmp:=tmp+'Private';
                1:tmp:=tmp+'Public';
                Else tmp:=tmp+'Unknown';
              End;
              writebox2(tmp);
              writebox2('[^2Q^9]^1 Quit');
              writebox2('');
            end;
            writebottom;
            nl; prt('^5^1Edit Menu ^9[^2?^9/^2Help^9]:^5 ');
            onek(c,^M'?[]FJLQ123456789CMOPRUA'); nl;
            case c of
              '1':begin
                    prt('^5^1New Name: ');
                    cl(5); inputwnwc(name,40,changed);
                  end;
              '2':begin
                    getbrdspec(s1);
                    prt('^5^1New Filename: '); mpl(8); input(s,8); s:=sqoutsp(s);
                    if (pos('.',s)>0) then filename:=copy(s,1,pos('.',s)-1);
                    if (s<>'') then begin
                      if (s<>filename) then changed:=TRUE;
                      filename:=s;
                      getbrdspec(s2);
                      if ((exist(s1)) and (not exist(s2))) then begin
                        nl;
                        sprint('^2Old BRD/MIX filenames: ^7"'+copy(s1,1,pos('.',s1)-1)+'.*"');
                        sprint('^2New BRD/MIX filenames: ^7"'+copy(s2,1,pos('.',s2)-1)+'.*"');
                        nl;
                        if pynq('Rename Old Filenames To New FileNames') then begin
                          s3:=s1;
                          err:=FALSE;
                          assign(f,s1);
                          {$I-} rename(f,s2); {$I+}
                          if (ioresult<>0) then begin
                            sprint('^5^7Error Renaming *.MTX Filename.');
                            err:=TRUE;
                          end;
                          s1:=copy(s3,1,pos('.',s3)-1)+'.SCN';
                          s2:=copy(s2,1,pos('.',s2)-1)+'.SCN';
                          assign(f,s1);
                          {$I-} rename(f,s2);  {$I+}
                          if (IOResult<>0) then begin
                            sprint('^5^7Error Renaming *.SCN Filename.');
                            err:=true;
                          end;
                          s1:=copy(s3,1,pos('.',s3)-1)+'.IDX';
                          s2:=copy(s2,1,pos('.',s2)-1)+'.IDX';
                          assign(f,s1);
                          {$I-} rename(f,s2); {$I+}
                          if (ioresult<>0) then begin
                            sprint('^5^7Error Renaming *.IDX Filename.');
                            err:=TRUE;
                          end;
                          if err then pausescr;
                        end;
                      end;
                    end;
                  end;
              '3':begin
                    changed:=TRUE;
                    prt('^5^1Base Type ^9[^2L^9/^2Local^9, ^2E^9/^2EchoMail^9]: ^1');
                    onek(c,'LE'^M);
                    case c of
                      'L':mbtype:=0;
                      'E':mbtype:=1;
                    end;
                    if (mbtype<>0) then begin
                      nl; sprompt('^5Current Message Path: ^6');
                      if (msgpath<>'') then print(msgpath) else sprint('^7*NONE*');
                      nl; sprint('^5Press <CR> To Use Default Path ^2"'+Network.EchoMailPath+FileName+'\"');
                      nl; sprint('^5Enter new message path:');
                      prt(':'); mpl(40); input(s,40); s:=sqoutsp(s);
                      if (s='') then s:=Network.EchoMailPath+FileName;
                      while (copy(s,length(s)-1,2)='\\') do s:=copy(s,1,length(s)-1);
                      if (copy(s,length(s),1)<>'\') then s:=s+'\';
                      msgpath:=s;

{                      if ((s='') and (msgpath='')) then msgpath:=systat.msgpath+filename+'\';}
                      if (not existdir(msgpath)) then begin
                        nl; sprint('^3"'+msgpath+'"^2 does not exist.');
                        if (pynq('Create Message Directory Now')) then begin
                          {$I-} mkdir(bslash(FALSE,msgpath)); {$I+}
                          if (ioresult<>0) then begin
                            sprint('^7Errors Creating Directory.');
                            pausescr;
                          end;
                        end;
                      end else begin
                        nl; sprint('^2"'+msgpath+'" ^7Already Exists!'); nl;
                        sprint('^5Make SURE that this path is the one you REALLY want');
                        sprint('^5to use, or messages may be inadvertantly mixed!');
                        nl; pausescr;
                      end;
                    end;
                  end;
              '4':begin
                    prt('^5^1New ACS: '); mpl(20);
                    inputwn(acs,20,changed);
                  end;
              '5':begin
                    prt('^5^1New Post ACS: '); mpl(20);
                    inputwn(postacs,20,changed);
                    prt('^5^1New MCI ACS: '); mpl(20);
                    inputwn(mciacs,20,changed);
                  end;
              '6':begin
                    prt('^5^1Max Messages: '); mpl(5); inu(i);
                    if (not badini) then begin
                      if (i<>maxmsgs) then changed:=TRUE;
                      maxmsgs:=i;
                    end;
                    if (maxmsgs<10) then maxmsgs:=10;
                    if (maxmsgs>30000) then maxmsgs:=30000;
                  end;
              '7':begin
                    writetop('Anonymous Types');
                    writebox2('');
                    writebox2('[^2Y^9]^1 Yes ^9- ^1Anonymous Allowed Selectively');
                    writebox2('[^2N^9]^1 No ^9- ^1Anonymous Not Allowed');
                    writebox2('[^2F^9]^1 Forced ^9- ^1Must Be Anonymous');
                    writebox2('[^2D^9]^1 Dear Abby^9 - ^1Dear Abby Type Base');
                    writebox2('[^2A^9]^1 Any Name ^9į ^1Use Any Name');
                    writebox2(''); writebottom;
                    nl;
                    prt('^5^1New Anon. Type ^9[^2YNFDA^9]: ^1');
                    onek(c,'QYNFDA'^M);
                    if (pos(c,'YNFDA')<>0) then begin
                      case c of
                        'Y':anontemp:=atyes;
                        'N':anontemp:=atno;
                        'F':anontemp:=atforced;
                        'D':anontemp:=atdearabby;
                        'A':anontemp:=atanyname;
                      end;
                      if (anontemp<>anonymous) then changed:=TRUE;
                      anonymous:=anontemp;
                    end;
                  end;
              '8':begin
                    prt('^5^1New PW: ');
                    mpl(20); inputwn1(password,20,'u',changed);
                  end;
              '9':if (mbtype<>0) then begin
                      prt('^5^1Enter New Zone Number  : '); inu(i);
                      if (not badini) then zone:=i;
                      prt('^5^1Enter New Net Number   : '); inu(i);
                      if (not badini) then net:=i;
                      prt('^5^1Enter New Node Number  : '); inu(i);
                      if (not badini) then node:=i;
                      prt('^5^1Enter New Point Number : '); inu(i);
                      if (not badini) then point:=i;
                    changed:=TRUE;
                  end;
{              '0': begin
                     if systat.confactive then begin
                       prt('^5^1New Conference #: ');
                       inu(XX);
                       confnum:=XX;
                       changed:=TRUE;
                     end else sprint('^7Conferencing Not Active!');
                   end; }
              'L':begin
                    nl;
                    prt('^5^1New Max Lines Per Message ^9[^250^9-^2819^9]: ^1');
                    inu(gi);
                    if (gi <= 819) and (gi >= 50) then maxfselines:=gi;
                    changed:=TRUE;
                  end;
              'C':if (mbtype<>0) then begin
                    incolor('Standard Text',text_color);
                    incolor('Quoted Text',quote_color);
                    incolor('Tear Line',tear_color);
                    incolor('Origin Line',origin_color);
                    changed:=TRUE;
                  end;
              'M':begin
                    if (mbtype<>0) then repeat
                      prt('^5^1Flags ^9[^2'+fidoflags(memboard)+'^9, ^2?^9/^2Help^9, ^2Q^9/^2Quit^9]: ^1');
                      onek(c1,'KASOCBMT?Q'^M);
                      case c1 of
                        ^M,'Q': ;
                        '?':begin
                              nl;
                              sprint('        ^5^9͸');
                              sprint('        ^5^9 ^2Base Flag Options ^9');
                              sprint('        ^5^9;');
                              sprint('        ^5^9  ^5'); nl;
                              sprint('^9[^2K^9]^1 Kludge Line Strip   ^9[^2B^9]^1 Box Code Strip');
                              sprint('^9[^2S^9]^1 SEEN-BY Line Strip  ^9[^2M^9]^1 Make Lines Centered');
                              sprint('^9[^2O^9]^1 Origin Line Strip   ^9[^2T^9]^1 Tear/Origin Line Add');
                              sprint('^9[^2C^9]^1 Center Code Strip   ^9[^2A^9]^1 Add Account Note Kludge');
                              sprint('^9[^2Q^9]^1 Quit');
                              nl;
                            end;
                        'A':AddAccNote:=Not AddAccNote;
                        'K':if (mbskludge in mbstat) then
                              mbstat:=mbstat-[mbskludge]
                              else mbstat:=mbstat+[mbskludge];
                        'S':if (mbsseenby in mbstat) then
                              mbstat:=mbstat-[mbsseenby]
                              else mbstat:=mbstat+[mbsseenby];
                        'O':if (mbsorigin in mbstat) then
                              mbstat:=mbstat-[mbsorigin]
                              else mbstat:=mbstat+[mbsorigin];
                        'C':if (mbscenter in mbstat) then
                              mbstat:=mbstat-[mbscenter]
                              else mbstat:=mbstat+[mbscenter];
                        'B':if (mbsbox in mbstat) then
                              mbstat:=mbstat-[mbsbox]
                              else mbstat:=mbstat+[mbsbox];
                        'M':if (mbmcenter in mbstat) then
                              mbstat:=mbstat-[mbmcenter]
                              else mbstat:=mbstat+[mbmcenter];
                        'T':if (mbaddtear in mbstat) then
                              mbstat:=mbstat-[mbaddtear]
                              else mbstat:=mbstat+[mbaddtear];
                      end;
                    until ((c1 in [^M,'Q']) or (hangup));
                    if (mbtype<>0) then changed:=TRUE;
                  end;
              'O':if (mbtype<>0) then begin
                    sprint('^5^1Enter New Origin Line -');
                    prt(':'); mpl(50); inputwn1(origin,50,'',changed);
                  end;
              'P':begin
                   changed:=TRUE;
                   Inc(MsgStatus);
                   If MsgStatus > 1 Then MsgStatus := 0;
                  end;
              'R':begin
                    changed:=TRUE;
                    if (mbrealname in mbstat) then mbstat:=mbstat-[mbrealname]
                      else mbstat:=mbstat+[mbrealname];
                  end;
              'U':begin
                    changed:=TRUE;
                    if (mbunhidden in mbstat) then mbstat:=mbstat-[mbunhidden]
                      else mbstat:=mbstat+[mbunhidden];
                  end;
              'A':begin
                    changed:=TRUE;
                    if (mbfilter in mbstat) then mbstat:=mbstat-[mbfilter]
                      else mbstat:=mbstat+[mbfilter];
                  end;
              '[':if (ii>1) then dec(ii) else c:=' ';
              ']':if (ii<numboards) then inc(ii) else c:=' ';
              'F':if (ii<>1) then ii:=1 else c:=' ';
              'J':begin
                    prt('^5^1Jump To Entry: ');
                    input(s,3);
                    if (value(s)>=1) and (value(s)<=numboards) then ii:=value(s) else c:=' ';
                  end;
              'L':if (ii<>numboards) then ii:=numboards else c:=' ';
              '?':begin
                    nl;
                    sprint('        ^5^9͸');
                    sprint('        ^5^9 ^2BaseEdit Commands ^9');
                    sprint('        ^5^9;');
                    sprint('        ^5^9  ^5'); nl;
                    sprint('^9[^2#^9]^1 Modify Item         ^9[^2CR^9]^1 ReDisplay Screen');
                    sprint('^9[^2[^9]^1 Back One Entry      ^9[^2]^9]^1 Forward One Entry');
                    sprint('^9[^2F^9]^1 First Entry In List ^9[^2L^9]^1 Last Entry In List');
                    sprint('^9[^2J^9]^1 Jump To Entry       ^9[^2Q^9]^1 Quit And Save');
                    nl;
                    sprint('        ^5^9͸');
                    sprint('        ^5^9 ^2Toggling Options ^9');
                    sprint('        ^5^9;');
                    sprint('        ^5^9  ^5'); nl;
                    sprint('^9[^2R^9]^1 Real Names          ^9[^2A^9]^1 Filter ANSi/8-Bit ASCII');
                    sprint('^9[^2U^9]^1 UnHidden/Hidden');
                  end;
            end;
          until (pos(c,'Q[]FJL')<>0) or (hangup);
        if (changed) then begin
          seek(bf,xloaded-1); write(bf,memboard);
          changed:=FALSE;
        end;
      end;
    end;
  end;

  procedure bepi;
  var i,j:integer;
  begin
    prt('^5^1Move Which Message Base ^9[^21^9-^2'+cstr(numboards)+'^9]: ^1'); inu(i);
    if ((not badini) and (i>=1) and (i<=numboards)) then begin
      prt('^5^1Move Before Which Message Base ^9[^21^9-^2'+cstr(numboards+1)+'^9]: ^1');
      inu(j);
      if ((not badini) and (j>=1) and (j<=numboards+1) and
          (j<>i) and (j<>i+1)) then begin
        nl;
        bep(i,j);
      end;
    end;
  end;

  function anont(a:anontyp):string;
  begin
    case a of
      atyes     :anont:='Y';
      atno      :anont:='N';
      atforced  :anont:='F';
      atdearabby:anont:='DA';
      atanyname :anont:='AN';
    end;
  end;

begin
  c:=#0;
  reset(bf);
  repeat
    if (c<>'?') then begin
      cls; abort:=FALSE; next:=FALSE;
      s:=#3#5+'###'+sepr9+'Base Name                    '+sepr9;
      case ltype of
        1:begin
            printacr(s+'Flag'+sepr9+'ACS       '+sepr9+'Post ACS  '+
              sepr9+'MCI ACS   '+sepr9+'MaxM'+sepr9+'An',abort,next);
            s:=':::::';
          end;
        2:begin
            printacr(s+'Filename'+sepr9+'Password',abort,next);
            s:=':';
          end;
        3:begin
            printacr(s+'Flags   '+sepr9+'Colors '+sepr9+'Message Path',abort,next);
            s:='::';
          end;
        4:begin
            printacr(s+'Address    '+sepr9+'Origin Line',abort,next);
            s:=':';
          end;
      end;
      printacr(#3#9+'::'+s,abort,next);
(*
###:Base Name                    :Flag:ACS       :Post ACS  :MCI ACS   :MaxM:An
:::::::

###:Base Name                    :FileName:Password
:::

###:Base Name                    :Flags   :Colors :Message Path
::::

###:Base Name                    :Address    :Origin Line
:::
*)

      ii:=1;
      if numboards=0 then dude:=eof(bf) else dude:=false;
      while (not dude) and (not abort) and (not hangup) do begin
        seek(bf,ii-1); read(bf,memboard);
        s:=#3#5+mn(ii,3)+' '+#3#1+mln(stripcolor(memboard.name),29)+' '+#3#2;
        with memboard do begin
          case ltype of
            1:s:=s+copy('LEG',mbtype+1,1)+flagstate(memboard)+' '+#3#7+
                mln(acs,10)+' '+mln(postacs,10)+' '+mln(mciacs,10)+' '+#3#0+
                mn(maxmsgs,4)+' '+anont(anonymous);
            2:s:=s+mln(filename,8)+' '+#3#7+password;
            3:if (mbtype=0) then s:=s+'<< Not Used >>' else
                s:=s+fidoflags(memboard)+' '+#3#7+cstr(text_color)+','+
                cstr(quote_color)+','+cstr(tear_color)+','+cstr(origin_color)+
                ' '+#3#0+mln(msgpath,28);
            4:if (mbtype=0) then s:=s+'<< Not Used >>' else
                s:=s+mln(getaddr(zone,net,node,point),11)+' '+#3#7+mln(origin,33);
          end;
          printacr(s,abort,next);
          inc(ii);
        end;
        dude:=eof(bf);
      end;
      numboards:=ii-1;
      maxboard:=ii-1;
      readboard:=-1; loadboard(1);
    end;
    nl;
    prt('^5^1Message Base Editor ^9[^2?^9/^2Help^9]: ^1');
    onek(c,'QDIEPT?'^M);
    case c of
      '?':begin
            nl;
            sprint('        ^5^9͸');
            sprint('        ^5^9 ^2BaseEdit Commands ^9');
            sprint('        ^5^9;');
            sprint('        ^5^9  ^5'); nl;
            sprint('^9[^2T^9]^1 Toggle Display Mode ^9[^2CR^9]^1 ReDisplay Screen');
            sprint('^9[^2D^9]^1 Delete A Base       ^9[^2I^9]^1 Insert A Base');
            sprint('^9[^2E^9]^1 Edit A Base         ^9[^2P^9]^1 Position A Base');
            sprint('^9[^2Q^9]^1 Quit');
            nl;
          end;
      'D':begin
            prt('^5^1Board Number To Delete ^9[^21^9-^2'+cstr(numboards)+'^9]: ^1'); inu(ii);
            prt('^5^1Delete How Many Boards ^9[^21^9-^2'+cstr(numboards-ii+1)+'^9]: ^1'); inu(iii);
            if not ((iii>0) and (iii <= (numboards-ii+1))) then iii:=1;
            for iv:=1 to iii do
              if ((not badini) and (ii>=1) and (ii<=numboards)) then begin
                readboard:=-1; loadboard(ii);
                s:=systat.msgpath+memboard.filename;
                nl; sprint('^0Message Base: ^5'+memboard.name);
                if pynq('Delete This') then begin
                  sysoplog('* Deleted message base: '+memboard.name);
                  bed(ii);
                  if (pynq('Delete Message Files')) then begin
                    nl;
                    sprint('Deleting: '+s+'.MTX');
                    {$I-} assign(f1,s+'.MTX'); reset(f1); close(f1); {$I+}
                    if (ioresult=0) then erase(f1);
                    sprint('Deleting: '+s+'.IDX');
                    {$I-} assign(f1,s+'.IDX'); reset(f1); close(f1); {$I+}
                    if (ioresult=0) then erase(f1);
                    sprint('Deleting: '+s+'.SCN');
                    {$I-} assign(f1,s+'.SCN'); reset(f1); close(f1); {$I+}
                    if (IOResult=0) then erase(f1);
                    pausescr;
                  end;
                end;
              end;
          end;
      'I':begin
            prt('^5^1Board Number To Insert Before ^9[^21^9-^2'+cstr(numboards+1)+'^9]: ^1'); inu(ii);
            prt('^5^1Insert How Many Boards ^9[^21^9-^2'+cstr(maxboards-numboards)+'^9]: ^1'); inu(iii);
            if not ((iii>0) and (iii<=(maxboards-numboards))) then iii:=1;
            for iv:=1 to iii do
              if ((not badini) and (ii>0) and (ii<=numboards+1) and
                  (numboards<maxboards)) then begin
                sysoplog('* Inserted new message base');
                bei(ii);
              end;
          end;
      'E':bem;
      'P':bepi;
      'T':ltype:=ltype mod 4+1;  { toggle between 1, 2, 3 & 4 }
    end;
  until ((c='Q') or (hangup));
  close(bf);

  if ((board<1) or (board>numboards)) then board:=1;
  readboard:=-1; loadboard(board);
end;

end.

