{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : SYSOP6.PAS                                                    
  Description: Event Editor                                                  
  Version    : v0.1500                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop6;

interface

procedure eventedit;

implementation

uses
  crt, dos, overlay,
  common,
  sysop1;

function etim(time:integer):string;
var hr,min,rem:integer; hrs,mins:string;
begin
  hr:=time div 60; min:=time mod 60; rem:=hr*60+min;
  if (hr<10) then hrs:='0'+cstr(hr) else hrs:=cstr(hr);
  if (min<10) then mins:='0'+cstr(min) else mins:=cstr(min);
  if rem=time then etim:=hrs+':'+mins else etim:='??:??'
end;

procedure eventedit;
const sepr9=#3#5+#3#9+':'+#3#5;
var evf:file of eventrec;
    i1,i2,ii:integer;
    c:char;
    abort,next:boolean;
    s:astr;

  function onoff(b:boolean):astr;
  begin
    if b then onoff:='On ' else onoff:='Off';
  end;

  function dactiv(l:boolean; days:byte; b:boolean):astr;
  const dayss:string[7]='SMTWTFS';
  var s:astr;
      i:integer;
  begin
    if b then begin
      s:=cstr(days);
      if l then s:=s+' (monthly)' else s:=s+' mthly';
    end else begin
      s:='';
      for i:=6 downto 0 do
        if (days and (1 shl i)<>0) then
          s:=s+dayss[7-i] else s:=s+'-';
    end;
    if not l then s:=mln(s,7);
    dactiv:=s;
  end;

  function schedt(l:boolean; c:char):astr;
  begin
    case c of
      'A':if (l) then schedt:='ACS users' else schedt:='ACS';
      'C':if (l) then schedt:='Chat event' else schedt:='Cht';
      'D':if (l) then schedt:='DOS shell' else schedt:='DOS';
      'E':if (l) then schedt:='External' else schedt:='Ext';
      'P':if (l) then schedt:='Pack bases' else schedt:='Pak';
    end;
  end;

  procedure eed(i:integer);
  var x:integer;
  begin
    if (i>=1) and (i<=numevents) then begin
      dec(numevents);
      for x:=i to numevents do events[x]^:=events[x+1]^;
      rewrite(evf);
      for x:=1 to numevents do write(evf,events[x]^);
      close(evf);
      dispose(events[numevents+1]);   (* DISPOSE OF DYNAMIC MEMORY! *)
    end;
  end;

  procedure eei(i:integer);
  var x:integer;
  begin
    if (i>=1) and (i<=(numevents+1)) and (numevents<maxevents) then begin
      inc(numevents);
      new(events[numevents]);         (* DEFINE DYNAMIC MEMORY! *)
      for x:=numevents downto i do events[x]^:=events[x-1]^;
      with events[i]^ do begin
        active:=FALSE;
        description:='A NEW Revelation Event';
        etype:='D';
        execdata:='event.bat';
        busytime:=5;
        exectime:=0;
        busyduring:=TRUE;
        duration:=1;
        execdays:=0;
        monthly:=FALSE;
      end;
      rewrite(evf);
      for x:=1 to numevents do write(evf,events[x]^);
      close(evf);
    end;
  end;

  procedure eem;
  var ii,i,j:integer;
      c:char;
      s:astr;
      bb:byte;
      changed:boolean;
  begin
    prt('^5^1Begin Editing At Which Event ^9[^21^9-^2'+cstr(numevents)+'^9]: ^1'); inu(ii);
    c:=' ';
    if (ii>=1) and (ii<=numevents) then begin
      while (c<>'Q') and (not hangup) do begin
        with events[ii]^ do
          repeat
            if (c<>'?') then begin
              cls;
              writetop2('Event #'+cstr(ii)+' Of '+cstr(numevents));
              writebox2('');
              writebox2('[^2!^9] ^1Active     :^2 '+syn(active));
              writebox2('[^21^9] ^1Description:^2 '+description);
              writebox2('[^22^9] ^1Sched. Type:^2 '+schedt(TRUE,etype));
              writebox2('[^23^9] ^1Event Data :^2 '+execdata);
              writebox2('[^24^9] ^1Busy Time  :^2 '+
                    aonoff((busytime<>0),cstr(busytime)+' minutes','None.'));
{              writebox2('[^25^9] ^1Exec. Time :^2 '+copy(ctim(exectime),4,5));}
              writebox2('[^25^9] ^1Exec. Time :^2 '+etim(exectime));
              writebox2('[^26^9] ^1Busy During:^2 '+syn(busyduring));
              writebox2('[^27^9] ^1Duration   :^2 '+cstr(duration));
              writebox2('[^28^9] ^1Days Active:^2 '+dactiv(TRUE,execdays,monthly));
              writebox2('');
              writebottom2;
            end;
            nl;
            prt('^5^1Edit Menu ^9[^2?^9/^2Help^9]: ^1');
            onek(c,'Q!12345678[]FJL?'^M);
            nl;
            case c of
              '!':active:=not active;
              '1':begin
                    prt('^5^1New Description: ');
                    mpl(30); inputwn(description,30,changed);
                  end;
              '2':begin
                    prt('^5^1New Schedule Type ^9[^2A^9,^2C^9,^2D^9,^2E^9,^2P^9]: ^1');
                    onek(c,'QACDEP'^M);
                    if (pos(c,'ACDEP')<>0) then etype:=c;
                  end;
              '3':begin
                    sprint('^1ACS: ^3ACS string');
                    sprint('^1Cht: ^3"0" if off, "1" if on');
                    sprint('^1DOS: ^3Dos commandline');
                    sprint('^1Ext: ^3Errorlevel to exit BBS with');
                    sprint('^1Pak: ^3Pack The Message Bases');
                    nl;
                    prt('^5^1New Event Data: ');
                    mpl(20); inputwn(execdata,20,changed);
{*****
                    if s=' ' then
                      if pynq('Set To Null String') then
                        execdata:=''
                    else if s<>'' then execdata:=s;
 *****}
                  end;
              '4':begin
                    prt('^5^1New Busy Time ^9[^20^9/^2None^9]: ^1');
                    inu(i);
                    if not badini then busytime:=i;
                  end;
              '5':begin
                    sprint('^5All Entries In 24 Hour Time.  ^1Hour ^9[^20^9-^223^9] ^5/ ^1Minute ^9[^20^9-^259^9]');
                    nl;
                    sprompt('^5New Event Time');
                    prt('  ^5Hour   : '); mpl(5); inu(i);
                    if not badini then begin
                      if (i<0) or (i>23) then i:=0;
                      prt('                 Minute : '); mpl(5); inu(j);
                      if not badini then begin
                        if (j<0) or (j>59) then j:=0;
                        exectime:=i*60+j;
                      end;
                    end;
                  end;
              '6':busyduring:=not busyduring;
              '7':begin
                    prt('^5^1New Duration: '); mpl(5); inu(i);
                    if not badini then duration:=i;
                  end;
              '8':begin
                    if monthly then c:='M' else c:='W';
                    prt('^5^1Active ^9[^2W^9/^2Weekly^9, ^2M^9/^2Monthly^9][^2'+c+'^9]: ^1');
                    onek(c,'QWM'^M);
                    if c in ['M','W'] then monthly:=(c='M');
                    if c='M' then execdays:=1;
                    if monthly then begin
                      nl;
                      prt('^5^1What Day Of The Month ^9[^21^9-^231^9][^2'+cstr(execdays)+'^9]: ^1');
                      mpl(3); ini(bb);
                      if not badini then
                        if bb in [1..31] then execdays:=bb;
                    end else begin
                      nl;
                      sprint('^5Current: '+dactiv(TRUE,execdays,FALSE));
                      nl;
                      sprint('^1Modify by entering an "X" under days active.');
                      prt('^5^9[^1SMTWTFS^9]');
                      nl; prt(':'); mpl(7); input(s,7);
                      if s<>'' then begin
                        bb:=0;
                        for i:=1 to length(s) do
                          if s[i]='X' then
                            inc(bb,1 shl (7-i));
                        execdays:=bb;
                      end;
                    end;
                  end;
              '[':if (ii>1) then dec(ii) else c:=' ';
              ']':if (ii<numevents) then inc(ii) else c:=' ';
              'F':if (ii<>1) then ii:=1 else c:=' ';
              'J':begin
                    prt('^5^1Jump To Entry: ');
                    input(s,3);
                    if (value(s)>=1) and (value(s)<=numevents) then ii:=value(s) else c:=' ';
                  end;
              'L':if (ii<>numevents) then ii:=numevents else c:=' ';
              '?':ee_help;
            end;
          until ((c in ['Q','[',']','F','J','L']) or (hangup));
      end;
      reset(evf);
      for ii:=1 to numevents do write(evf,events[ii]^);
      close(evf);
    end;
  end;

  procedure eep;
  var i,j,k:integer;
  begin
    prt('^5^1Move Which Event ^9[^21^9-^2'+cstr(numevents)+'^9]: ^1'); inu(i);
    if ((not badini) and (i>=1) and (i<=numevents)) then begin
      prt('^5^1Move Before Which Event ^9[^21^9-^2'+cstr(numevents+1)+'^9]: ^1'); inu(j);
      if ((not badini) and (j>=1) and (j<=numevents+1) and
          (j<>i) and (j<>i+1)) then begin
        eei(j);
        if (j>i) then k:=i else k:=i+1;
        events[j]^:=events[k]^;
        if (j>i) then eed(i) else eed(i+1);
      end;
    end;
  end;

begin
  assign(evf,systat.SystemPath+'events.dat');
  c:=#0;
  repeat
    if c<>'?' then begin
      cls; abort:=FALSE;
      printacr(#3#5+' ##'+sepr9+'Description                   '+
               sepr9+'Typ'+sepr9+'Bsy'+sepr9+'Time '+sepr9+'Len'+sepr9+'Days   '+
               sepr9+'ExecData',abort,next);
      printacr(#3#9+' :::::::',abort,next);
      ii:=1;
      while (ii<=numevents) and (not abort) do
        with events[ii]^ do begin
          if (active) then s:=#3#8+'+' else s:=#3#8+'-';
          s:=s+#3#5+mn(ii,2)+' '+#3#1+mln(description,30)+' '+
              schedt(FALSE,etype)+' '+
{             #3#2+mn(busytime,3)+' '+copy(ctim(exectime),4,5)+' '+}
              #3#2+mn(busytime,3)+' '+etim(exectime)+' '+
              mn(duration,3)+' '+dactiv(FALSE,execdays,monthly)+' '+
              #3#7+mln(execdata,9);
          printacr(s,abort,next);
          inc(ii);
        end;
    end;
    nl;
    prt('^5^1Event Editor ^9[^2?^9/^2Help^9]: ^1');
    onek(c,'QDIEP?'^M);
    case c of
      '?':begin
            nl;
            sprint('        ^5^9͸');
            sprint('        ^5^9 ^2Editing Commands ^9');
            sprint('        ^5^9;');
            sprint('        ^5^9  '); nl;
            sprint('^5^9[^2D^9]^1 Delete Event        ^9[^2I^9]^1 Insert Event');
            sprint('^9[^2E^9]^1 Edit An Event       ^9[^2P^9]^1 Position Event');
            sprint('^9[^2CR^9]^1 ReDisplay Screen   ^9[^2Q^9]^1 Quit');
            nl;
          end;
      'D':begin
            prt('^5^1Event To Delete ^9[^21^9-^2'+cstr(numevents)+'^9]: ^1'); inu(ii);
            if (ii>=1) and (ii<=numevents) then begin
              nl; sprint('Event: '+#3#4+events[ii]^.description);
              if pynq('Delete This') then begin
                sysoplog('* Deleted event: '+events[ii]^.description);
                eed(ii);
              end;
            end;
          end;
      'I':begin
            prt('^5^1Event To Insert Before ^9[^21^9-^2'+cstr(numevents+1)+'^9]: ^1'); inu(ii);
            if (ii>=1) and (ii<=numevents+1) then begin
              sysoplog('* Inserted new event');
              eei(ii);
            end;
          end;
      'E':eem;
      'P':eep;
    end;
  until (c='Q') or (hangup);
end;

end.
