{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : SYSOP10.PAS                                                   
  Description: Voting Question Editor / Voting Results Output                
  Version    : v0.1500                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop10;

interface

uses
  crt, dos, overlay,
  common;

procedure initvotes;
procedure voteprint;

implementation

procedure initvotes;
var vdata:file of vdatar;
    cv,tv,ii:integer;
    s,i1,i2:astr;
    vd:vdatar;
    t1,tf,abort,next:boolean;
    u1:userrec;
begin
  assign(vdata,systat.systempath+'voting.dat');
  {$I-} reset(vdata); {$I+}
  if ioresult<>0 then begin
    rewrite(vdata);
    vd.question:='<< No Question >>'; vd.numa:=0;
    for cv:=0 to numvoteqs-1 do write(vdata,vd);
  end;
  repeat
    cls;
    abort:=FALSE; next:=FALSE;
    writetop('Voting Questions');
    for cv:=1 to numvoteqs do begin
      seek(vdata,cv-1); read(vdata,vd);
      writebox2('[^2'+mn(cv,2)+'^9]^1 '+vd.question);
{     printacr(#3#0+mn(cv,2)+sepr2+vd.question,abort,next); }
    end;
    writebottom; nl;
    abort:=FALSE; next:=FALSE;
    prt('^5^1Voting Editor ^9[^21^9-^220^9, ^2Q^9/^2Quit^9]: ^1'); input(s,2);
    ii:=value(s); t1:=FALSE;
    if ((ii>=1) and (ii<=numvoteqs)) then begin
      cv:=1; t1:=TRUE;
      sprint('^5Enter New Question. <CR>=No Change');
      prt(':');
      inputwc(vd.question,79);
      if (vd.question<>'') then begin
        vd.answ[0].ans:='No Comment';
        vd.answ[0].numres:=0;
        nl; print('Enter A Blank Line For The Last Choice - 9 Answers Max, 40 Chars/Answer.');
        tf:=FALSE;
        repeat
          prt('^5^9[^2'+cstr(cv)+'^9] į ^5');
          inputwc(vd.answ[cv].ans,40); vd.answ[cv].numres:=0;
          if (vd.answ[cv].ans='') then begin
            tf:=TRUE;
            if (cv=1) then vd.question:='<< No Question >>';
          end
          else inc(cv);
        until (cv>=numvoteas+1) or (tf) or (hangup);

        vd.numa:=cv-1;
        seek(vdata,ii-1); write(vdata,vd);
        reset(userf);
        for cv:=1 to filesize(userf)-1 do begin
          seek(userf,cv); read(userf,u1);
          u1.vote[ii]:=0;
          seek(userf,cv); write(userf,u1);
        end;
        close(userf);
        thisuser.vote[ii]:=0;
      end;
    end;
  until (not t1) or (hangup);
  close(vdata);
end;

Procedure VotePrint;
Var vdata:file of vdatar;
    vd:vdatar;
    user:userrec;
    t:text;
    vn,i1,i2:integer;
    s1,s2:astr;
Begin
  Assign(t,Systat.TextPath+'VOTES.TXT');
  Rewrite(t);
  Writeln(t);
  Writeln(t,'Votes as of '+dat);
  Print('Beginning output to file "VOTES.TXT"');
  i1:=1;

  reset(UserF);
  Assign(vdata,Systat.SystemPath+'VOTING.DAT');
  Reset(vdata);

  For vn:=1 to numvoteqs do begin
    seek(vdata,vn-1); read(vdata,vd);
    if (vd.numa<>0) then begin
      writeln(t); writeln(t,vd.question);
      print(vd.question);
      for i1:=1 to vd.numa do begin
        writeln(t,'   '+vd.answ[i1].ans);
        for i2:=1 to filesize(UserF)-1 do begin
          seek(UserF,i2); read(UserF,user);
          if (Not user.Deleted) and (user.vote[vn]=i1) then
            writeln(t,'      '+caps(user.name)+' #'+cstr(i2));
        end;
      end;
    end;
  end;

  Close(UserF);
  Close(t);
  Close(vdata);
  Print('Output complete.');
End;


(*
procedure initvotes;
var vdata:file of vdatar;
    cv,tv,ii:integer;
    s,i1,i2:astr;
    vd:vdatar;
    t1,tf,abort,next:boolean;
    u1:userrec;
begin
  assign(vdata,systat.SystemPath+'voting.dat');
  {$I-} reset(vdata); {$I+}
  if ioresult<>0 then begin
    rewrite(vdata);
    vd.question:='<< No Question >>'; vd.numa:=0;
    for cv:=0 to numvoteqs-1 do write(vdata,vd);
  end;
  repeat
    cls;
    abort:=FALSE; next:=FALSE;
    for cv:=1 to numvoteqs do begin
      seek(vdata,cv-1); read(vdata,vd);
      printacr(#3#0+mn(cv,2)+sepr2+vd.question,abort,next);
    end;
    abort:=FALSE; next:=FALSE;
    prt('Vote editor - modify which? : '); input(s,2);
    ii:=value(s); t1:=FALSE;
    if ((ii>=1) and (ii<=numvoteqs)) then begin
      cv:=1; t1:=TRUE;
      print('Enter new question: (79 characters max)');
      print('<CR>=No change.');
      prt(':');
      inputwc(vd.question,79);
      if (vd.question<>'') then begin
        vd.answ[0].ans:='No Comment';
        vd.answ[0].numres:=0;
        nl; print('Enter blank line for last answer; max 9 answers, 40 chars/answer.');
        tf:=FALSE;
        repeat
          sprompt(#3#4+cstr(cv)+#3#7+':'+#3#3);
          inputwc(vd.answ[cv].ans,40); vd.answ[cv].numres:=0;
          if (vd.answ[cv].ans='') then begin
            tf:=TRUE;
            if (cv=1) then vd.question:='<< No Question >>';
          end
          else inc(cv);
        until (cv>=numvoteas+1) or (tf) or (hangup);

        vd.numa:=cv-1;
        seek(vdata,ii-1); write(vdata,vd);
        reset(UserF);
        for cv:=1 to filesize(UserF)-1 do begin
          seek(UserF,cv); read(UserF,u1);
          u1.vote[ii]:=0;
          seek(UserF,cv); write(UserF,u1);
        end;
        close(UserF);
        thisuser.vote[ii]:=0;
      end;
    end;
  until (not t1) or (hangup);
  close(vdata);
end;

*)

End.
