{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : QWK.PAS                                                       
  Description: Offline Mail Reader Interface                                 
  Version    : v0.1100                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B-,E+,F+,I+,L-,N-,O+,R-,S+,V-}

Unit Qwk;

Interface

Uses Crt, Dos, Overlay, Common,
     BasicConvert,
     TimeJunk,
     Msg0, Msg1,
     ExecBat,
     File0,  {Function ExistDir}
     File1,  {Proc Idl}
     File2,  {Proc CopyFile}
     File8,  {Proc Receive1}
     Archive;  {Proc PurgeDir}

Var
 MsgIdx    : MsgIndexRec;

Procedure ResetPointers;
Procedure ImportQwkPacket(QwkFileName:String);
Procedure MakeQwkPacket(QwkFileName:String);

Implementation

Procedure ResetPointers;
Var
 SaveMsgBoard, BoardCount, i:Integer;
Begin

 If pynq(#3#5'Reset NewScan Pointers') then begin

  SaveMsgBoard:=Board;
  BoardCount:=1;
  Repeat
   If (checkzscanm(mconfpk^[boardcount])) then begin
    If Board<>mconfpk^[boardcount] then ChangeBoard(mconfpk^[boardcount]);
     If Board=mconfpk^[boardcount] then begin
       InitMsgFiles(MemBoard.FileName);
       If (HiMsg<>-1) then begin
         Reset(MsgIdxF, SizeOf(MsgIndexRec));
         Seek(MsgIdxF, HiMsg);
         BlockRead(MsgIdxF, MsgIdx, 1);
         Close(MsgIdxF);
         ZScanm.HiRead := MsgIdx.MsgPostDateTime;
         savezscanm;
       End;
     End;
   End;
   Inc(BoardCount);
  Until (BoardCount>numboards);

  Board:=SaveMsgBoard;
  ChangeBoard(Board);
 End;
End;

Procedure ImportQwkPacket(QwkFileName:String);
Type
 Read128Rec=Array[1..128] of Char;

Var
 SavePause, Ok, NoSpace,
 WriteIt, dok, kabort, addbatch:boolean;
 SourceDir, WorkDir, ReplyArchiveName:String;
 ArcNum, SaveMsgBoard:Byte;
 Read128:Read128Rec;
 ReplyFile:File of Read128Rec;

 BlockCount:LongInt;

 MsgHFlag:String[1];
 MsgHConference:String[7]; {* MsgHNumber in MESSAGES.DAT *}
 MsgHDate:String[8];
 MsgHTime:String[5];
 MsgHTo, MsgHFrom, MsgHSubject:String[25];
 MsgHPassword:String[12];
 MsgHRefNumber:String[8];
 MsgHBlocks:String[6];
 MsgHStatus:String[1];
 MsgHConf:String[1];

 MsgNum,
 RecordCount:LongInt;

 i,j,k:Integer;
 BFo:Boolean;
 MsgBoard:Integer;
 t:Text;
 s:String;
 c:Char;
 UserCount : Integer;
 User : UserRec;

  function getaddr(zone,net,node,point:integer):string;
  Var
    TempStr:string;
  begin
    TempStr:=cstr(zone)+':'+cstr(net)+'/'+cstr(node);
    If (point<>0) then TempStr:=TempStr+'.'+cstr(point);
    GetAddr:=TempStr;
  end;

  function getorigin:string;
  var s:astr;
  begin
    if (memboard.origin<>'') then s:=memboard.origin
      else if (Network.origin<>'') then s:=Network.origin
        else s:=copy(stripcolor(systat.bbsname),1,50);
    while (copy(s,length(s),1)=' ') do
      s:=copy(s,1,length(s)-1);
    getorigin:=s;
  end;

 Function ExtractFrom128(Start,Total:Byte):String;
 Var es:String;
 Begin
  es:='';
  For Start:=Start to Start+Total do es:=es+Read128[Start];
  ExtractFrom128:=es;
 End;

Begin
 QwkFileName:=AllCaps(QwkFileName);
 If Value(QwkFileName)>0 then begin
  ArcNum:=Value(QwkFileName);
  Delete(QwkFileName,1,Length(cstr(Value(QwkFileName))));
  Delete(QwkFileName,1,Pos(';',QwkFileName));
 End
 Else ArcNum:=1;

 SavePause:=Pause in ThisUser.AC;
 ThisUser.AC:=ThisUser.AC-[Pause];

 SaveMsgBoard:=Board;
 SysOpLog('Uploaded .REP Offline Mail Packet');
 WorkDir:=WorkPath+'QWK\';
 If Not ExistDir(WorkDir) then
 {$I-} MkDir(BSlash(FALSE,WorkDir)); {$I+}
 If IOResult<>0 then begin
  sprint(#3#5'Error Accessing Temporary QWK Directory.');
  Exit;
 End;
 PurgeDir(WorkDir);

 dok:=true;    kabort:=true;    addbatch:=false;
 If ConnectSpd='KB' then begin
  prt('Location of '+QwkFileName+'.REP: ');
  mpl(40);   Input(SourceDir,40);
  SourceDir:=BSlash(TRUE,SourceDir);
  ReplyArchiveName:=SourceDir+QwkFileName+'.REP';
 End
 Else begin
  ReplyArchiveName:=WorkDir+QwkFileName+'.REP';
  sprint(#3#3'Ready to receive upload of '+QwkFileName+'.REP');
  Receive1(ReplyArchiveName,TRUE,false,dok,kabort,addbatch);
 End;

 If Exist(ReplyArchiveName) then begin
  {* Add Search for Archive Header Type *}
  shel1;
  execbatch(ok,TRUE,'REVTMP'+cstr(NodeNumber)+'.BAT','tgtest1.$$$',WorkDir,
            arcmci(Systat.ArchivePath+systat.filearcinfo[ArcNum].unarcline,ReplyArchiveName,'*.*'),
            systat.filearcinfo[ArcNum].succlevel);
  shel2;
  If (not ok) then begin
   sysoplog('Archive "'+ReplyArchiveName+'": Errors during de-compression');
  End Else begin
   Assign(ReplyFile,WorkDir+QwkFileName+'.MSG');
   {$I-} Reset(ReplyFile); {$I+}
   If (IOResult=0) then begin
    NL;
    Read(ReplyFile,Read128);  {* Read Packet Header - Unused in .REP*}
    While Not Eof(ReplyFile) do begin
     Read(ReplyFile,Read128);   {* Read Message Header *}

     MsgHFlag:=ExtractFrom128(1,1);
     MsgHConference:=ExtractFrom128(2,7);
     MsgHDate:=ExtractFrom128(9,8);
     MsgHTime:=ExtractFrom128(17,5);
     MsgHTo:=ExtractFrom128(22,25);
     MsgHFrom:=ExtractFrom128(47,25);
     MsgHSubject:=ExtractFrom128(72,25);
     MsgHPassword:=ExtractFrom128(97,12);
     MsgHRefNumber:=ExtractFrom128(109,8);
     MsgHBlocks:=ExtractFrom128(117,6);
     MsgHStatus:=ExtractFrom128(123,1);
     MsgHConf:=ExtractFrom128(124,1);


{    If MsgHFlag='-' then begin} {* Normal Public Unread *}

     If Copy(AllCaps(StripExtraSpaces(MsgHSubject)),1,3) = 'ADD' Then Begin
      MsgBoard := Value(MsgHConference);
      If Board <> MsgBoard then ChangeBoard(MsgBoard);
      If Board = MsgBoard Then Begin
       zscanm.zscan:=true;
       savezscanm;
       SysOpLog('+ Added '+MemBoard.Name+' #'+cstr(MsgBoard)+#3#3' to New/QWK Scan.');
       sprint(#3#3'Added '+MemBoard.Name+' #'+cstr(MsgBoard)+#3#3' to New/QWK Scan.');
      End;
     End
     Else If Copy(StripExtraSpaces(AllCaps(MsgHSubject)),1,4) = 'DROP' Then Begin
      MsgBoard := Value(MsgHConference);
      If Board <> MsgBoard then ChangeBoard(MsgBoard);
      If Board = MsgBoard Then Begin
       ZScanm.ZScan := false;
       SaveZScanm;
       SysOpLog('+ Dropped '+MemBoard.Name+' #'+cstr(MsgBoard)+#3#3' from New/QWK Scan.');
       sprint(#3#3'Dropped '+MemBoard.Name+' #'+cstr(MsgBoard)+#3#3' from New/QWK Scan.');
      End;
     End
     Else If Copy(StripExtraSpaces(AllCaps(MsgHSubject)),1,5) = 'RESET' Then Begin
      MsgBoard := Value(MsgHConference);
      If Board <> MsgBoard then ChangeBoard(MsgBoard);
      If Board = MsgBoard Then Begin
       MsgNum := Value(Copy(StripExtraSpaces(MsgHSubject),6,255)) - 1;
       If MsgNum > HiMsg Then MsgNum := HiMsg;
       If MsgNum < 0 Then MsgNum := HiMsg + MsgNum;
       If MsgNum < 0 Then MsgNum := 0;
       InitMsgFiles(MemBoard.FileName);
       Reset(MsgIdxF, SizeOf(MsgIndexRec));
       Seek(MsgIdxF, MsgNum);
       BlockRead(MsgIdxF, MsgIdx, 1);
       Close(MsgIdxF);
       ZScanm.HiRead:= MsgIdx.MsgPostDateTime;
       SaveZScanm;
       SysOpLog('+ Reset Hi-Msg Pointer On '+MemBoard.Name+' #'+cstr(MsgBoard)+' to '+cstr(MsgNum + 1)+'.');
       sprint(#3#3'Hi-Msg Pointer On '+MemBoard.Name+' #'+cstr(MsgBoard)+#3#3' reset to '+cstr(MsgNum + 1)+'.');
      End;
     End
     Else Begin
      MsgBoard := Value(MsgHConference);
      If Board <> MsgBoard then ChangeBoard(MsgBoard);
      If Board = MsgBoard Then Begin
       If MemBoard.MsgStatus = 0 Then Begin
        Reset(UserF);
        UserCount := 0;
        Repeat
         Inc(UserCount);
         Seek(UserF, UserCount);
         Read(UserF, User);
         If MsgNameMatch(StripExtraSpaces(MsgHTo), User.Name, User.RealName) Then Begin
          WriteIt := TRUE;

          {* Resets to EXACT capitilization as in User Entry *}
          If AllCaps(MsgIdx.ToInfo.UserName) = AllCaps(User.Name) Then MsgIdx.ToInfo.UserName := User.Name
          Else If AllCaps(MsgIdx.ToInfo.UserName) = AllCaps(User.RealName) Then MsgIdx.ToInfo.UserName := User.RealName;
         End;
        Until (UserCount = FileSize(UserF)-1) Or WriteIt;
        Close(UserF);
       End
       Else WriteIt:=TRUE;
      End
      Else WriteIt:=FALSE;

      If WriteIt then begin

       ClearMsgIdx(MsgIdx);
       With MsgIdx Do Begin
        Title := StripExtraSpaces(MsgHSubject);
        If (MBRealName IN MemBoard.MBStat) then FromInfo.UserName := ThisUser.RealName
        Else FromInfo.UserName := ThisUser.Name;
        FromInfo.UserNote := ThisUser.AccountNote;
        ToInfo.UserName := Caps(StripExtraSpaces(MsgHTo));

        ReplyTo := Value(MsgHRefNumber);

        GetPackDateTime(@MsgDateTime);
        GetPackDateTime(@MsgPostDateTime);

        {* If Public Only? *}
        If (RValidate In ThisUser.AC) Then SetAttr(MsgAttr, UnValidated, TRUE);

       End;

       Assign(t,'MSGTMP');
       Rewrite(t);
      End;

      {* Read in Message, Output to Message Board *}
      BlockCount:=1;
      While (BlockCount <= Value(MsgHBlocks) - 1) And Not Eof(ReplyFile) do begin
       Read(ReplyFile, Read128);
       If WriteIt then begin
        s := Read128;

        If (MBFilter IN MemBoard.MBStat) And (Length(s) > 0) then begin
         s:=StripColor(s);
         For j:=1 to Length(s) do begin
          c:=s[j];
          If (c in [#0..#1,#3..#31,#127..#255]) then c:='*';
          s[j]:=c;
         End;
        End;

        For i := 1 to Length(s) Do
         If s[i] = #227 Then WriteLn(t)
         Else Write(t, s[i]);

       End;
       Inc(BlockCount);
      End;

      If WriteIt then begin
       If { (pub) } (MemBoard.MBType IN [1,2]) and (MBAddTear IN MemBoard.MBStat) then With MemBoard do begin
        WriteLn(t);
        s:=#3+chr(tear_color)+'--- '+softwarename+' Systems QWK Mail';
        writeln(t,s);
        s:=#3+chr(origin_color)+' * Origin: '+getorigin+' (';
        s:=s+getaddr(zone,net,node,point);
        s:=s+')';
        writeln(t,s);
       End;

       Close(t);

       DumpMsg(MsgIdx, 'MSGTMP', MemBoard.FileName);

       bfo:=(filerec(bf).mode<>fmclosed);
       If Not BFo then reset(bf);
       Seek(bf,board-1);
       Write(bf,memboard);
       If Not BFo then Close(bf);

       SysOpLog('+ "'+MsgIdx.Title+'" posted on '+#3#5+memboard.name);
       SysOpLog('    To: "'+MsgIdx.ToInfo.UserName+'"');
       TopScr;

       sprint(#3#3'Message "'#3#4+MsgIdx.Title+#3#3'" posted on '+MemBoard.Name);

       Inc(ThisUser.MsgPost);
       Inc(PToday);
       Inc(Systat.TodayZLog.PubPost);
      End;
     End;

    End;

    Close(ReplyFile);
    Erase(ReplyFile);

   End;
  End;
 End
 Else sprint(#3#5'File not found.');

 If SavePause then ThisUser.AC:=ThisUser.AC+[Pause]; lil:=0;  {* Avoids Screen Pause *}
 Board := SaveMsgBoard;
 ChangeBoard(Board);
End;

Procedure MakeQwkPacket(QwkFileName:String);
Type
 NdxRecord = Record
  MsgPointer:LongInt;
  Conference:Byte;
 End;

 Function Pad128(InStr:String):String;
 Begin
  While Length(InStr) < 128 do InStr := InStr+' ';
  Pad128 := InStr;
 End;

 Function Pad0(InStr:String):String;
 Begin
  While Length(InStr)<3 do InStr:='0'+InStr;
  Pad0:=InStr;
 End;

Var
 TextFile:Text;
 ArcNum:Byte;
 Abort, Next, SavePause, Ok, NoSpace:Boolean;
 ErrorCode,BoardTotal:Integer;

 BoardCount, SaveMsgBoard:Byte;
 TempCtlFile, ControlFile, MessageFile:Text;
 Ndx:NdxRecord;
 NdxF:File of NdxRecord;

 DestDir, ReadStr:String;
 NdxFName, WorkDir:String;

 PacketHeader, MessageHeader:String[128];

 BlockCount:LongInt;

 Procedure AddPacket(MsgNum : LongInt);
 Var
  TotLen : LongInt;
  WorkBlocks, TempMsgBlocks, MsgBlocks, MsgHTotalBlocks : LongInt;

  MsgHFlag:String[1];
  MsgHNumber:String[7];

  MsgHDate:String[8];
  MsgHTime:String[5];
  MsgHTo, MsgHFrom, MsgHSubject:String[25];
  MsgHPassword:String[12];
  MsgHRefNumber:String[8];
  MsgHBlocks:String[6];


  Procedure UnpackDateTime(pdtpp:packdatetimepp);
  Var
   pdt:packdatetime;
   dt:ldatetimerec;

   Function StrDT(i:Integer):String;
   Var
    OutStr:string;
   Begin
    Str(i,OutStr);
    If (i<10) then OutStr:='0'+OutStr;
    StrDT:=OutStr;
   End;

  Begin
   pdt:=pdtpp^;
   pdt2dt(pdt,dt);
   With dt do begin
     MsgHDate:=StrDT(Month)+'-'+StrDT(Day)+'-'+StrDT(Year);
     MsgHTime:=StrDT(Hour)+':'+StrDT(Min);
   End;
  End;

 Begin
  Reset(MsgIdxF, SizeOf(MsgIndexRec));
  Seek(MsgIdxF, MsgNum);
  BlockRead(MsgIdxF, MsgIdx, 1);
  Close(MsgIdxF);

  Reset(MsgTxtF, 1);

  MsgBlocks:=0; TotLen:=0;  WorkBlocks:=0;
  Seek(MsgTxtF, MsgIdx.MsgPtr);
  Repeat
   BlockReadStr(MsgTxtF, ReadStr);
   Inc(TotLen, Length(ReadStr) + 2);
   ReadStr:=StripColor(ReadStr);
   WorkBlocks:=WorkBlocks+Length(ReadStr)+1;
   If WorkBlocks>=128 then
    Repeat
     Inc(MsgBlocks);
     Dec(WorkBlocks,128);
    Until WorkBlocks<128;
  Until (TotLen >= MsgIdx.MsgLength);

  If WorkBlocks > 0 then Inc(MsgBlocks);
  MsgHTotalBlocks := 1 + (MsgBlocks);
  MsgHFlag := '-'; {* Public Unread *}
  MsgHNumber := Justify_L(cstr(MsgNum+1),7);

  With MsgIdx Do Begin
   UnpackDateTime(@MsgDateTime);
   If Not ((MsgHDate[3]='-') and (MsgHDate[6]='-') and (Length(MsgHDate)=8)) then MsgHDate:='00-00-00';
   If Not ((MsgHTime[3]=':') and (Length(MsgHTime)=5)) then MsgHTime:='00:00';

   MsgHTo := AllCaps(Justify_L(Copy(ToInfo.UserName,1,25),25)); {*}
   MsgHFrom := AllCaps(Justify_L(Copy(FromInfo.UserName,1,25),25)); {*}
   MsgHSubject := AllCaps(Justify_L(Copy(Title,1,25),25));
   MsgHPassword := Justify_L('',12);

{   If ReplyTo = 0 then MsgHRefNumber := Justify_L('',8)}

   MsgHRefNumber := Justify_L(cstr(ReplyTo + 1),8); {* Reply To? *}
   MsgHBlocks := Justify_L(cstr(MsgHTotalBlocks),6);
   MessageHeader := MsgHFlag+MsgHNumber+MsgHDate+MsgHTime+MsgHTo+MsgHFrom+
                    MsgHSubject+MsgHPassword+MsgHRefNumber+MsgHBlocks+
                    #225+Chr(Board);

   MessageHeader:=MessageHeader+(ExtraSpace(MessageHeader,128));
   Write(MessageFile,MessageHeader);

   TotLen:=0; WorkBlocks:=0;
   Seek(MsgTxtF, MsgIdx.MsgPtr);
   Repeat
    BlockReadStr(MsgTxtF, ReadStr);
    Inc(TotLen, Length(ReadStr) + 2);
    ReadStr := StripColor(ReadStr);
    Write(MessageFile,ReadStr + #227);
    WorkBlocks:=WorkBlocks+Length(ReadStr)+1;
    If WorkBlocks>128 then
     Repeat
      Dec(WorkBlocks,128);
     Until WorkBlocks<128;
   Until (TotLen >= MsgLength);
   If WorkBlocks < 128 then For TotLen := 1 to 128 - WorkBlocks do Write(MessageFile, ' ');

   Ndx.MsgPointer:=Long2BasicReal(BlockCount);

   Ndx.Conference:=Board;
   Write(NdxF,Ndx);

   BlockCount:=BlockCount+MsgHTotalBlocks;
  End;

  Close(MsgTxtF);
 End;

  Procedure ScanMessages(BoardNum:Integer);
  Var
    TotNew, MsgNum:Word;
    b:Byte;
    SaveMConf,
    WaitingOnly : Boolean;

  Begin
    If Board<>BoardNum then ChangeBoard(BoardNum);
    If Board=BoardNum then begin
      WaitingOnly := MemBoard.MsgStatus = 0;
      InitMsgFiles(MemBoard.FileName);

      If (HiMsg<>-1) then begin
        MsgNum := 0;
        Reset(MsgIdxF, SizeOf(MsgIndexRec));
        BlockRead(MsgIdxF, MsgIdx, 1);
        While (MsgNum < HiMsg) And Not (IsNewMsg(MsgIdx) And ((Not WaitingOnly) Or ToUser(MsgIdx))) Do Begin
          Inc(MsgNum);
          BlockRead(MsgIdxF, MsgIdx, 1);
        End;
        Close(MsgIdxF);

        sprompt(#3#2+Justify_L(StripColor(MemBoard.Name)+' #'+cstr(realmbase(Board)),45));
        sprompt(#3#9'  ');

        TotNew := HiMsg - MsgNum;
        SetGraph(TotNew);
  
        If ((MsgNum <= HiMsg) and (IsNewMsg(MsgIdx))) then begin
          Assign(NdxF,WorkDir+Pad0(cstr(Board))+'.NDX');
          Rewrite(NdxF);

          For MsgNum := MsgNum To HiMsg do begin
            AddPacket(MsgNum);
            IncrementGraph;
          End;
          Close(NdxF);
        End Else IncrementGraph;
        FillGraph;
        cl(3);
        For b:=1 to 29 do sprompt(^H' '^H);
        sprompt(cstr(TotNew)+' New Message');
        If TotNew <> 1 then sprint('s') Else NL;

        wkey(Abort, Next);
      End;
    End;

    If MBaseAC(BoardNum) Then Begin
      Inc(BoardTotal);
      WriteLn(TempCtlFile, BoardNum);
      WriteLn(TempCtlFile, StripColor(MemBoard.Name));
    End;
  End;


Begin
 QwkFileName:=AllCaps(QwkFileName);
 If Value(QwkFileName)>0 then begin
  ArcNum:=Value(QwkFileName);
  Delete(QwkFileName,1,Length(cstr(Value(QwkFileName))));
  Delete(QwkFileName,1,Pos(';',QwkFileName));
 End
 Else ArcNum:=1;
 PacketHeader:=Pad128('Produced by '+SoftwareName+' BBS '+Ver);

 SavePause:=Pause in ThisUser.AC;
 ThisUser.AC:=ThisUser.AC-[Pause];

 NL;

 sprint(#3#3'Generating QWK Packet - Press <Space> to Abort');
 NL;
 sprint(#3#1'Scanning Board                                '#3#9''#3#1' Progress                       ');
 sprint(#3#9'');


 SaveMsgBoard:=Board;
 SysOpLog('Generated .QWK Offline Mail Packet');
 WorkDir:=WorkPath+'QWK\';
 If Not ExistDir(WorkDir) then
 {$I-} MkDir(BSlash(FALSE,WorkDir)); {$I+}
 If IOResult<>0 then begin
  sprint(#3#7'Error accessing temporary QWK directory.');
  Exit;
 End;
 NodeUpDate('Generating QWK Offline Mail Packet');
 PurgeDir(WorkDir);

 Assign(MessageFile,WorkDir+'MESSAGES.DAT');
 Rewrite(MessageFile);
 Write(MessageFile,PacketHeader);

 Assign(TempCtlFile,WorkDir+'CONTROL.$$$');
 Rewrite(TempCtlFile);

 Assign(ControlFile,WorkDir+'CONTROL.DAT');
 Rewrite(ControlFile);
 WriteLn(ControlFile,Systat.BBSName);
 WriteLn(ControlFile,'Unknown, Universe');
 WriteLn(ControlFile,Systat.BBSPhone);
 WriteLn(ControlFile,Systat.SysOpName,',Sysop');
 WriteLn(ControlFile,'0',',',QwkFileName);  {* 0 = Serial Number *}
 WriteLn(ControlFile,Date,',',Time);
 WriteLn(ControlFile,ThisUser.Name);
 WriteLn(ControlFile);
 WriteLn(ControlFile,'0');
 WriteLn(ControlFile,'0');

 BlockCount:=2;
 BoardTotal:=-1;
 BoardCount:=1;
 Abort:=FALSE;  Next:=FALSE;
 Repeat
  If (checkzscanm(mconfpk^[boardcount])) then ScanMessages(mconfpk^[boardcount]);
  Inc(BoardCount);
 Until (BoardCount > numboards) or (Abort);
 NL;

 WriteLn(ControlFile, BoardTotal);
 Close(TempCtlFile);
 {$I-} Reset(TempCtlFile); {$I+}
 If (IOResult=0) then begin
  While Not Eof(TempCtlFile) do begin
   ReadLn(TempCtlFile,ReadStr);
   WriteLn(ControlFile,ReadStr);
  End;
  Close(TempCtlFile);
  Erase(TempCtlFile);
 End;

 WriteLn(ControlFile, 'WELCOME.TXT');
 WriteLn(ControlFile, 'BULLET.TXT');
 WriteLn(ControlFile, 'GOODBYE.TXT');

 Close(ControlFile);
 Close(MessageFile);

 Assign(TextFile,WorkDir+'DOOR.ID');
 Rewrite(TextFile);
 WriteLn(TextFile,'DOOR = '+SoftwareName);
 WriteLn(TextFile,'VERSION = '+Ver);
 WriteLn(TextFile,'SYSTEM = '+SoftwareName+' BBS '+Ver);
 WriteLn(TextFile,'CONTROLNAME = '+QwkFileName);
 WriteLn(TextFile,'CONTROLTYPE = ADD');
 WriteLn(TextFile,'CONTROLTYPE = DROP');
 WriteLn(TextFile,'CONTROLTYPE = RESET');
 Close(TextFile);

 CopyFile(Ok,NoSpace,FALSE,Systat.TextPath+'WELCOME.QWK',WorkDir+'WELCOME.TXT');
 CopyFile(Ok,NoSpace,FALSE,Systat.TextPath+'BULLET.QWK',WorkDir+'BULLET.TXT');
 CopyFile(Ok,NoSpace,FALSE,Systat.TextPath+'GOODBYE.QWK',WorkDir+'GOODBYE.TXT');
 NodeUpDate('Available for Page');

 If pynq('Archive And Download Mail Packet') then begin
  sprint(#3#3'Creating Archive '+QwkFileName+'.QWK');
  Delay(1000);
  ArcComp(Ok,ArcNum,WorkDir+QwkFileName+'.QWK',WorkDir+'*.*');
  WriteLn;
  If ConnectSpd='KB' then begin
   If pynq('Move Mail Packet') then begin
    prt('Destination Directory: ');
    mpl(40);   Input(DestDir,40);
    If ExistDir(BSlash(FALSE,DestDir)) then CopyFile(Ok,NoSpace,FALSE,WorkDir+QwkFileName+'.QWK'
       ,BSlash(TRUE,DestDir)+QwkFileName+'.QWK');
   End;
  End
  Else idl(WorkDir+QwkFileName+'.QWK');
 End;
 shel2;          { TEST MODIFICATION }
 NL;

 Board:=SaveMsgBoard;
 ChangeBoard(Board);

 If SavePause then ThisUser.AC:=ThisUser.AC+[Pause]; lil:=0;  {* Avoids Screen Pause *}
End;

End.
