{
                                Paragon
                                
  MSGCONV.PAS - Paragon v1.00 - v1.06 to v1.10+ Message Conversion.
 }
{$A+,B-,E+,F+,I+,L-,N-,O+,R-,S+,V-}

Program MsgConv;
Uses Crt, Dos, LowLevel;

{$I STRUCTUR}

Type

  msgindexstatr=
   (miexist,                      { does message actually exist? }
    miencrypted,                  { is it encrypted? }
    miunvalidated,                { is message unvalidated? }
    mipermanent,                  { is the message permanent? }
    miallowmci,                   { DID owner have access to MCI? }
    mithreads,                    { is message referenced? (threaded) }
    mimassmail,                   { is it private, mass mail? }
    miscanned);                   { is message scanned for FidoNet? }

  Oldmsgindexrec=                         { *.MIX : Message index records }
  record
    messagenum:word;                   { message number, tonum in EMAIL.MIX }
    hdrptr:longint;                    { pointer to message header }
    msgid:longint;                     { message ID (sequential) }
    isreplytoid:longint;               { ID of replied message }
    msgdate:cpackdatetime;             { message date/time (packed) }
    msgdowk:byte;                      { message day-of-week (0=Sun ...) }
    msgindexstat:set of msgindexstatr; { status flags }
    isreplyto:word;                    { reply this message is to (-1=None) }
    numreplys:word;                    { number of replies to THIS message }
  end;

  fromtoinfo=                  { from/to information for mheaderrec }
  record
    Anon:byte;                 { anonymous type }
    UserNum:word;              { user number }
    AccountNote:string[42];             { given name for this case }
    FormerlyReal_NowUnused:string[36];           { user real name }
    UserName:string[36];          { user alias }
  end;

  mheaderrec=                  { *.BRD : Message header records }
  record
    signature:longint;         { header signature - $FFFFFFFF }
    msgptr:longint;            { pointer to message text }
    msglength:longint;         { length of message text }
    fromi:fromtoinfo;          { from information }
    toi:fromtoinfo;            { to information }
    title:string[60];          { title of message }
    origindate:string[19];     { Echo/Group original msg date }
  end;

Var BoardF:File of BoardRec;
    Board:BoardRec;
    Sys:SystatRec;
    SysF:File of SystatRec;

    ReadStr: String;

    BoardCount:Integer;

    MixF: File;
    Mix: OldMsgIndexRec;
    BrdF: File;

    TotLen,
    HiMsg: LongInt;

    MsgIdxF: File Of MsgIndexRec;
    MsgIdx: MsgIndexRec;
    MsgTxtF: File;
    MHead : MHeaderRec;




  Function UpperCase(ConvStr:string):string;
  Var
   Count:integer;
  Begin
   For Count:=1 to Length(ConvStr) do ConvStr[Count]:=UpCase(ConvStr[Count]);
   UpperCase:=ConvStr;
  End;

  Procedure BlockReadStr(Var F:File; Var S:String);
  Begin
   BlockRead(F,S[0],1);    { Filler Character }
   If Ord(S[0])=$FF Then
   Begin
    BlockRead(F,S[0],1);
    BlockRead(F,S[1],Ord(S[0]));
   End;
  End;

  Procedure BlockWriteStr(Var F:File; S:String);
  Var bb : Byte;
  Begin
   bb := $FF;
   BlockWrite(F, bb, 1);
   BlockWrite(F, s[0], 1);
   BlockWrite(F, s[1], Ord(s[0]));
  End;

  Procedure OpenFiles;
  Begin
   If GetEnv('PARAGON')<>'' Then Assign(SysF,GetEnv('PARAGON')+'\PARAGON.DAT')
   Else Assign(SysF,'PARAGON.DAT');
   {$I-} Reset(SysF); {$I+}
   If (IOResult)<>0 then begin
    WriteLn(' PARAGON.DAT file not found',12);
    Halt;
   End
   Else
   Begin
    Read(SysF,Sys);
    Close(SysF);

    Assign(BoardF,Sys.SystemPath+'BOARDS.DAT');
    {$I-} Reset(BoardF); {$I+}
    If (IOResult)<>0 then begin
     WriteLn(' BOARDS.DAT file not found',12);
     Halt;
    End;

   End;
  End;

Procedure InitMsgFiles(FName:String);
Begin
 FName := UpperCase(FName);

 Assign(MsgIdxF, Sys.MsgPath + FName + '.IDX');
 {$I-} Reset(MsgIdxF); {$I+}
 If IOResult <> 0 Then Rewrite(MsgIdxF);
 Close(MsgIdxF);

 Assign(MsgTxtF, Sys.MsgPath + FName + '.MTX');
 {$I-} Reset(MsgTxtF,1); {$I+}
 If IOResult <> 0 Then Rewrite(MsgTxtF, 1);
 Close(MsgTxtF);

End;

Procedure ClearMsgIdx(Var MsgIdx:MsgIndexRec);
Var b : Byte;
Begin
  With MsgIdx Do Begin
   MsgPtr := 0;
   MsgLength := 0;
   MsgAttr := 0;
   FidoAttr := 0;
   Cost := 0;
   Anon := 0;
   ReplyTo := 0;
   NextReply := 0;
   TimesRead := 0;

   For b := 1 To 6 Do MsgPostDateTime[b]:=0;
   For b := 1 To 6 Do MsgDateTime[b]:=0;

   FromInfo.Zone := 0;
   FromInfo.Net := 0;
   FromInfo.Node := 0;
   FromInfo.Point := 0;
   FromInfo.UserName := '';
   FromInfo.UserNote := '';

   ToInfo.Zone := 0;
   ToInfo.Net := 0;
   ToInfo.Node := 0;
   ToInfo.Point := 0;
   ToInfo.UserName := '';

   Title := '';
   For b := 1 To SizeOf(MsgIndexRec_FutureExpansion) Do MsgIndexRec_FutureExpansion[b]:=0;
  End;
End;

Procedure SetAttr(Var ModifyAttr:Word; Position:Word; On:Boolean);
Var b : Word;
Begin
 b := $01 Shl Position;
 If On Then ModifyAttr := ModifyAttr Or b
 Else Begin
  b := b XOr $FF;
  ModifyAttr := ModifyAttr And b;
 End;
End;


procedure findhimsg;
var
    lng:longint;
    numread:word;
begin
  himsg:=(filesize(mixf)-1) div 100;
  himsg:=himsg*100-1;
  seek(mixf,himsg+1);
  repeat
    lng:=himsg;
    blockread(mixf,mix,1,numread);
    if ((numread=1) and (mix.hdrptr<>-1)) then inc(himsg);
  until (lng=himsg);
end;

function cstr(i:longint):string;
var c:string[16];
begin
  str(i,c);
  cstr:=c;
end;

 Procedure Convert(BoardFileName: String);
 Var SaveX, i:Integer;
 Begin
  InitMsgFiles(BoardFileName);

  Assign(MixF, Sys.MsgPath+BoardFileName+'.MIX');
  {$I-} Reset(MixF, SizeOf(OldMsgIndexRec)); {$I+}
  If IOResult <> 0 Then Exit;

  Assign(BrdF, Sys.MsgPath+BoardFileName+'.BRD');
  {$I-} Reset(BrdF, 1); {$I+}
  If IOResult <> 0 Then Exit;

  FindHiMsg;

  Reset(MsgTxtF, 1);
  Reset(MsgIdxF);

  For HiMsg := 0 to HiMsg Do Begin
   SaveX := WhereX;
   Write(cstr(HiMsg)+'        ');
   GotoXY(SaveX,WhereY);
   Seek(MixF, HiMsg);
   BlockRead(MixF, Mix, 1);
   Seek(BrdF, Mix.HdrPtr);
   BlockRead(BrdF, MHead, SizeOf(MHeaderRec));
   Seek(BrdF, MHead.MsgPtr);

   ClearMsgIdx(MsgIdx);

   With MsgIdx Do Begin
    Title := MHead.Title;
    FromInfo.UserName := MHead.Fromi.UserName;
    ToInfo.UserName := MHead.Toi.UserName;
    MsgPtr := FileSize(MsgTxtF);
    GetPackDateTime(@MsgPostDateTime);
    MsgDateTime := Mix.MsgDate;
    SetAttr(MsgAttr, Scanned, TRUE);
   End;

   Seek(MsgTxtF, MsgIdx.MsgPtr);

   TotLen := 0;
   Repeat
    BlockReadStr(BrdF, ReadStr);

    For i:=0 to 9 do
     While Pos(#3+cstr(i), ReadStr) > 0 do Begin
      Insert(#3+chr(i), ReadStr, Pos(#3+cstr(i),ReadStr));
      Delete(ReadStr,Pos(#3+cstr(i), ReadStr),2);
     End;

    BlockWriteStr(MsgTxtF, ReadStr);
    Inc(TotLen, Length(ReadStr) + 2)
   Until TotLen >= MHead.MsgLength;

   MsgIdx.MsgLength := TotLen;
   Seek(MsgIdxF, FileSize(MsgIdxF));
   Write(MsgIdxF, MsgIdx);
  End;

   Close(MsgIdxF);
  Close(MsgTxtF);
  Close(MixF);
  Close(BrdF);
 End;

Function StripColor(InStr:String):String;
Var b:Byte;
Begin
 For b:=1 to Length(InStr) do begin
  If ((InStr[b]=#3) And (InStr[b+1] In [#0..#9]))
   Or ((InStr[b]='^') And (InStr[b+1] In ['0'..'9']))
    Then Delete(InStr,b,2);

  If ((InStr[b]='|') And (InStr[b+1] In ['0'..'9']) And (InStr[b+2] In ['0'..'9']))
   Then Delete(InStr,b,3);
 End;
 StripColor:=InStr;
End;

Var
 InKey: Char;

Begin
 WriteLn('Paragon v1.00 - v1.06 to v1.10+ Message Conversion.  Press ^C to Halt.');
 OpenFiles;
 BoardCount:=1;
 InKey := #0;

 While (BoardCount-1<=FileSize(BoardF)-1) And (InKey <> ^C) do begin
  Seek(BoardF,BoardCount-1);
  Read(BoardF,Board);
  Write('Converting '+StripColor(Board.Name)+' - ');
  Convert(Board.FileName);
  WriteLn;
  Inc(BoardCount);
  While KeyPressed Do If ReadKey=^C Then InKey := ^C;
 End;
 If InKey=^C Then WriteLn('^C');

 WriteLn;
 Close(BoardF);
 WriteLn('Conversion finished.  Backup and kill the .BRD/.MIX files.');
End.