{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : MISC1.PAS                                                     
  Description: Lists/Voting/Time Bank                                        
  Version    : v0.2000                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit misc1;

Interface

uses
  crt, dos, overlay,
  common;


Procedure ListLastCallers(CallerFile:String);
Procedure ListAvailableNodes(NodeFile:String);
Procedure TypeTextFile(OptionStr:astr;totype:integer);
Procedure ToggleFlags(ToggleStr:astr; Var Flags:FlagSet);
procedure reqchat(Why:astr; ToUser:UserNameStr);
procedure TimeBank(s:astr);
function ctp(t,b:longint):astr;
procedure vote;

Implementation

Uses File0, Msg1;

Procedure ListLastCallers(CallerFile:String);
Var
 BackDays,CallCount,Tmp:Integer;
 Abort,Next,FoundFile:Boolean;
 InF:Text;
 Temp,Work:String;
Begin
 BackDays:=99;
 If (Value(CallerFile)>0) or (Copy(CallerFile,1,1)='0') then begin
  BackDays:=Value(CallerFile);
  Delete(CallerFile,1,Length(cstr(BackDays)));
  If Pos(';',CallerFile)<>0 then Delete(CallerFile,Pos(';',CallerFile),1);
 End
 Else begin
  Prt(#3#1'List Recent Callers How Many Days Back '#3#9'['#3#2'0'#3#9']: ');
  mpl(2);
  Input(Temp,2);
  BackDays:=Value(Temp);
 End;
 CallerFile:=GetTextFileName(CallerFile);
 If CallerFile='' then FoundFile:=FALSE
 Else FoundFile:=TRUE;

 Abort:=FALSE;
 Next:=FALSE;

 If Not FoundFile then begin
  printacr('',abort,next);
  printacr(#3#9'Ŀ',abort,next);
  printacr(#3#9' '#3#5'User Name                     '#3#9' '#3#1'Baud Rate           '#3#9' '#3#2
  +'Date     '#3#9' '#3#7'Time  '#3#9' '#3#7'N# '#3#9'',abort,next);
  printacr(#3#9'Ĵ',abort,next);
 End
 Else begin
  Assign(InF,CallerFile);
  Reset(InF);
  ReadLn(InF,Temp);
  If Temp<>'' then Printacr(Temp,abort,next);
  ReadLn(InF,Temp);
  If Temp<>'' then Printacr(Temp,abort,next);
  ReadLn(InF,Temp);
  If Temp<>'' then Printacr(Temp,abort,next);
  ReadLn(InF,Temp);
  If Temp<>'' then Printacr(Temp,abort,next);
  ReadLn(InF,Temp);
 End;
 Assign(LastCallF,Systat.SystemPath+'LASTCALL.DAT');
 {$I-} Reset(LastCallF); {$I+}
 If (IOResult<>0) then Rewrite(LastCallF);
 CallCount:=0;
 While (Not Abort) and (CallCount<=FileSize(LastCallF)-1) do begin
  Seek(LastCallF,CallCount);
  Read(LastCallF,LastCall);
  tmp:=lastcall.nodeid; if tmp=255 then tmp:=0;
  If LastCall.DaysOld<=BackDays then begin
   If Not FoundFile then
    PrintAcr(#3#9' '#3#5+LastCall.UserName+Ins(30,LastCall.UserName)+#3#9' '#3#1+LastCall.BaudRate+Ins(20,LastCall.BaudRate)
     +#3#9' '#3#2+LastCall.Date+#3#9'  '#3#7+LastCall.TimeOn+#3#9'   '#3#7+cstr(LastCall.NodeID)+#3#9' ',abort,next)
   Else begin
    Work:=Temp;

    ReplaceCode('LU',LastCall.UserName,30,Work);
    ReplaceCode('LB',LastCall.BaudRate,20,Work);
    ReplaceCode('LD',LastCall.Date,8,Work);
    ReplaceCode('LT',LastCall.TimeOn,5,Work);
{   ReplaceCode('LN',cstr(LastCall.NodeID),1,Work);}
    ReplaceCode('LN',cstr(tmp),1,work);

    PrintAcr(Work,Abort,Next);
   End;
  End;
  Inc(CallCount);
 End;
 Close(LastCallF);

 If Not FoundFile then begin
  printacr(#3#9'',abort,next);
  printacr('',abort,next);
 End
 Else While (Not Eof(InF)) and (Not Abort) do begin
  ReadLn(InF,Temp);
  printacr(Temp,abort,next);
 End;
 If FoundFile then Close(InF);
End;

Procedure ListAvailableNodes(NodeFile:String);
Var
 LineFil:Integer;
 Abort,Next,FoundFile:Boolean;
 InF:Text;
 Temp,Work:String;
Begin
 NodeFile:=GetTextFileName(NodeFile);
 If NodeFile='' then FoundFile:=FALSE
 Else FoundFile:=TRUE;

 Abort:=FALSE;
 Next:=FALSE;

 If Not FoundFile then begin
  printacr('',abort,next);
  printacr(#3#2'Ŀ',abort,next);
  printacr(#3#2' '#3#3'User Name                     '#3#2' '#3#3'Status                                 '
   +#3#2' '#3#3'N# '#3#2'',abort,next);
  printacr(#3#2'Ĵ',abort,next);
 End
 Else begin
  NL;
  Assign(InF,NodeFile);
  Reset(InF);
  ReadLn(InF,Temp);
  If Temp<>'' then Printacr(Temp,abort,next);
  ReadLn(InF,Temp);
  If Temp<>'' then Printacr(Temp,abort,next);
  ReadLn(InF,Temp);
  If Temp<>'' then Printacr(Temp,abort,next);
  ReadLn(InF,Temp);
  If Temp<>'' then Printacr(Temp,abort,next);
  ReadLn(InF,Temp);
 End;

 For LineFil:=1 to 9 do begin
  Assign(OnLineF,GetEnv('REV')+'\USERON.'+cstr(LineFil));
  {$I-} Reset(OnLineF); {$I+}
  If IOResult=0 then begin
   Read(OnLineF,OnLine);
   If Not FoundFile then
    sprint(#3#2' '#3#5+OnLine.Handle+Ins(30,OnLine.Handle)+#3#2' '#3#5+OnLine.Status+Ins(39,OnLine.Status)
     +#3#2'  '#3#5+cstr(LineFil)+#3#2' ')
   Else begin
    Work:=Temp;

    ReplaceCode('NN',cstr(LineFil),1,Work);
    ReplaceCode('NS',OnLine.Status,39,Work);
    ReplaceCode('NU',OnLine.Handle,30,Work);

    PrintAcr(Work,Abort,Next);
   End;
   Close(OnLineF);
  End;
 End;

 If Not FoundFile then begin
  printacr(#3#2'',abort,next);
  printacr('',abort,next);
 End
 Else While (Not Eof(InF)) and (Not Abort) do begin
  ReadLn(InF,Temp);
  printacr(Temp,abort,next);
 End;
 If FoundFile then Close(InF);
End;


Procedure TypeTextFile(OptionStr:astr;totype:integer);
Var
 DLk,Points:boolean;
 FileName:string[12];
 pl,rn:integer;
 f:ulfrec;
Begin
 OptionStr:=AllCaps(OptionStr);
 Points:=Pos('P',OptionStr)<>0;
 DLk:=Pos('K',OptionStr)<>0;

 If (MemUBoard.Res[3]=1) then begin
  if (totype <= 0) then begin
    sprompt(fstring.TypeFile);
    mpl(12);
    Input(FileName,12);
  end else filename:=cstr(totype);
  FiScan(pl);
  If (baddlpath) then exit;
  If (Value(FileName)>0) and (Length(FileName)=Length(cstr(Value(FileName))))
  then begin
   rn:=Value(FileName);
   If rn>pl then rn:=0;
  End
  Else begin
   FileName:=Align(FileName);
   RecNo(FileName,pl,rn);
  End;
  Setc(7);
  If (rn=0) then Begin NL; sprint(#3#5'File Not Found.'); End
  Else begin
   fiscan(pl);
   seek(ulff,rn); read(ulff,f);
   PrintF(MemUBoard.DLPath+f.filename);

   If (not (fbnoratio in memuboard.fbstat)) and (DLk) then begin
    Inc(ThisUser.downloads);
    ThisUser.dk:=thisuser.dk+(f.blocks div 8);
   End;

   If (not (fbnoratio in memuboard.fbstat))
     and (Points)
       and (not aacs(systat.nofilepts))
          and (not (fnofilepts in thisuser.ac))
            and (f.filepoints>0)
              then dec(thisuser.filepoints,f.filepoints);

   If (thisuser.filepoints<0) then thisuser.filepoints:=0;

   Inc(systat.todayzlog.downloads);
   Inc(systat.todayzlog.dk,(f.blocks div 8));
  End;

 End
 Else sprint(^M^J+#3#5'File Typing Is Not Allowed In This Base.')

End;


Procedure ToggleFlags(ToggleStr:astr; Var Flags:FlagSet);
Var
 Count:integer;
 ToggleChar:char;
Begin
  ToggleStr:=AllCaps(ToggleStr);
  For Count:=1 to Length(ToggleStr) do begin
    If Count<Length(ToggleStr) then begin
      Case ToggleStr[Count] of
         '/','!':Begin
                   While (ToggleStr[Count+1] in ['A'..'Z']) and (Count<Length(ToggleStr)) do begin
                     ToggleChar:=ToggleStr[Count+1];  Inc(Count);
                     If ToggleChar in Flags then Flags:=Flags-[ToggleChar]
                       Else Flags:=Flags+[ToggleChar];
                   End;
                 End;
         '+':Begin                                                {<=}
               While (ToggleStr[Count+1] in ['A'..'Z']) and (Count<Length(ToggleStr)) do begin
                 ToggleChar:=ToggleStr[Count+1];  Inc(Count);
                 Flags:=Flags+[ToggleChar];
               End;
             End;
         '-':Begin
               While (ToggleStr[Count+1] in ['A'..'Z']) and (Count<Length(ToggleStr)) do begin
                 ToggleChar:=ToggleStr[Count+1];  Inc(Count);
                 Flags:=Flags-[ToggleChar];
               End;
             End;
      End;   {Case ToggleStr[Count]}
    End;
  End;
End;



procedure reqchat(Why:Astr; ToUser:UserNameStr);
var c,ii,i:integer;
    r:char;
    chatted:boolean;
    s: astr;
begin
  If why = '' then why := '^3Why Do You Want To Chat? ';
  if ((chatt<systat.maxchat) or (cso)) then begin

    sprint(why);
    chatted:=FALSE;

    prt(':'); mpl(70); inputl(s,70);

    if (s<>'') then begin
      inc(chatt);
      if ((not sysop) or (rchat in thisuser.ac)) then
        if (length(s)<64) then
          sysoplog(#3#4+'Chat attempt: "'+#3#5+s+#3#4+'"')
        else begin
          sysoplog(#3#4+'Chat attempt:');
          sl1(#3#4+' "'+#3#5+s+#3#4+'"');
        end
      else begin
        ChatActivated:=TRUE;
        sl1(#3#4+'Chat: "'+#3#5+s+#3#4+'"');
        sprint(fstring.chatcall1);
        CommandLine('Press <SPACE> to chat or <ENTER> to SHUT UP for rest of call');
        ii:=0; c:=0;
        repeat
          inc(ii);
          if (outcom) then sendcom1(^G);
          sprompt(fstring.chatcall2);
          if (outcom) then sendcom1(^G);
          if (shutupchatcall) then delay(1500)
          else
            for i:=1 to 8 do begin
              sound(800); delay(33);
              sound(1300); delay(35);
              sound(1700); delay(37);
              sound(2100); delay(39);
              sound(3200); delay(45);
              sound(2100); delay(39);
              sound(1700); delay(37);
              sound(1300); delay(35);
              sound(800);
            end;
          nosound;
          if (keypressed) then begin
            r:=readkey;
            case r of
              #32:begin
                    commandline('');
                    chatted:=TRUE; chatt:=0;
                    pap:=0;
                    chat;
                  end;
               ^M:shutupchatcall:=TRUE;
            end;
          end;
        until ((chatted) or (ii=15) or (hangup));
        NL;
        commandline('');
      end;
      if (not chatted) then begin
        chatr:=s;
        NL;
        printf('nosysop');
        If ToUser <> '' Then
          If pynq('Send Feedback') then SendEMail(ToUser, 'Tried Chatting');
      end else
        chatr:='';
      tleft;
    end;
  end else begin
    printf('goaway');
    sysoplog('Tried chatting more than '+cstr(systat.maxchat)+' times');
    If ToUser = '' then ToUser := 'SYSOP';
    If Pynq('Send Feedback') then
      SendEMail(ToUser, 'Tried Chatting (More Than '+cstr(systat.maxchat)+' Times!)');
  end;
end;


procedure TimeBank(s:astr);
var lng,maxperday,maxever:longint;
    zz:integer;
    oc:astr;
    c:char;

  function cantdeposit:boolean;
  begin
    cantdeposit:=TRUE;
    if ((thisuser.timebankadd>=maxperday) and (maxperday<>0)) then exit;
    if ((thisuser.timebank>=maxever) and (maxever<>0)) then exit;
    cantdeposit:=FALSE;
  end;

begin
  maxperday:=value(s); maxever:=0;
  if (pos(';',s)<>0) then maxever:=value(copy(s,pos(';',s)+1,length(s)));
  if ((maxever<>0) and (thisuser.timebank>maxever)) then
    thisuser.timebank:=maxever;


  nl; nl;
  sprint('^5Time Bank v'+ver);
  nl;
  if (not cantdeposit) then
    sprint('^3A^1)dd time to your account.');
  sprint('^3G^1)oodbye, log off now.');
  sprint('^3Q^1)uit to BBS.');
  if (choptime=0.0) then
    sprint('^3W^1)ithdraw time from your account.');
  nl;
  if (choptime<>0.0) then
    sprint(#3#7+'You cannot withdraw time during this call.');
  if (cantdeposit) then begin
    if ((thisuser.timebankadd>=maxperday) and (maxperday<>0)) then
      sprint(#3#7+'You cannot add any more time to your account today.');
    if ((thisuser.timebank>=maxever) and (maxever<>0)) then
      sprint(#3#7+'You cannot add any more time to your account!');
  end;
  nl;
  sprompt(#3#5+'In your account: '+#3#3+cstr(thisuser.timebank)+
          #3#5+'   Time left online: '+#3#3+cstr(trunc(nsl) div 60));
  if (thisuser.timebankadd<>0) then
    sprompt('   ^5Deposited today: ^3'+cstr(thisuser.timebankadd));
  nl;
  sprompt(#3#5+'Account limits: '+#3#3);
  if (maxever<>0) then sprompt(cstr(maxever)+' max')
    else sprompt('No max limit');
  if (maxperday<>0) then sprompt(' / '+cstr(maxperday)+' per day');
  nl; nl;

  prt('Time Bank :');
  oc:='QG';
  if (choptime=0.0) then oc:=oc+'W';
  if (not cantdeposit) then oc:=oc+'A';
  onek(c,oc);
  case c of
    'A':begin
          prt('Add how many minutes? '); inu(zz); lng:=zz;
          nl;
          if (not badini) then
            if (lng>0) then
              if (lng>trunc(nsl) div 60) then
                sprint(#3#7+'You don''t have that much time left to deposit!')
              else
                if (lng+thisuser.timebankadd>maxperday) and (maxperday<>0) then
                  sprint(#3#7+'You can only add '+cstr(maxperday)+' minutes to your account per day!')
                else
                  if (lng+thisuser.timebank>maxever) and (maxever<>0) then
                    sprint(#3#7+'Your account deposit limit is '+cstr(maxever)+' minutes!')
                  else begin
                    inc(thisuser.timebankadd,lng);
                    inc(thisuser.timebank,lng);
                    dec(thisuser.tltoday,lng);
                    sprint('^5In your account: ^3'+cstr(thisuser.timebank)+
                           '^5   Time left online: ^3'+cstr(trunc(nsl) div 60));
                    sysoplog('TimeBank: Deposited '+cstr(lng)+' minutes.');
                  end;
              end;
          'G':hangup:=TRUE;
          'W':begin
                prt('Withdraw how many minutes? '); inu(zz); lng:=zz;
                nl;
                if (not badini) then
                  if (lng>thisuser.timebank) then
                    sprint(#3#7+'You don''t have that much time left in your account!')
                  else
                    if (lng>0) then begin
                      dec(thisuser.timebankadd,lng);
                      if (thisuser.timebankadd<0) then thisuser.timebankadd:=0;
                      dec(thisuser.timebank,lng);
                      inc(thisuser.tltoday,lng);
                      sprint('^5In your account: ^3'+cstr(thisuser.timebank)+
                             '^5   Time left online: ^3'+cstr(trunc(nsl) div 60));
                      sysoplog('TimeBank: Withdrew '+cstr(lng)+' minutes.');
                    end;
                  end;
  end;
end;

function ctp(t,b:longint):astr;
var s,s1:astr;
    n:real;
begin
  if ((t=0) or (b=0)) then begin
    ctp:='  0.0%';
    exit;
  end;
  n:=(t*100)/b;
  str(n:5:1,s);
  s:=s+'%';
  ctp:=s;
end;

function vote1x(answeringall:boolean; qnum:integer; var vd:vdatar):boolean;
var s,pva:astr;
    i,tv:integer;
    c:char;
    abort,next,changed,doneyet,b:boolean;

  procedure showvotes(stats,nocom:boolean);
  var s:astr;
      i:integer;
  begin
    cls;
    sprint(#3#5+#3#1+'Question #'+cstr(qnum)+#3#9+' į '+#3#2+vd.question);
    nl; tv:=0;
    for i:=1 to vd.numa do inc(tv,vd.answ[i].numres);
    if (tv=0) then tv:=1;
    sprint(#3#5+#3#9+'Percentage Of Users Voting: '+#3#2+ctp(tv,systat.numusers)); nl;
    abort:=FALSE; i:=1;
    if (nocom) then begin
      sprint(#3#5+#3#9+'  ['+#3#2+'0'+#3#9+'] '+#3#1+'No Comment');
      pva:='Q0';
    end else
      pva:='';
    while (i<=vd.numa) do begin
      if (not abort) then begin
        s:=#3#5+#3#9+'['+#3#2+cstr(i)+#3#9+'] '+#3#1+vd.answ[i].ans;
        if (stats) then
          s:=mln(s,41+length(cstr(i)))+#3#4+' :'+#3#0+mn(vd.answ[i].numres,3)+
             #3#4+':'+#3#0+ctp(vd.answ[i].numres,tv)+#3#4+':';
        if (i=thisuser.vote[qnum]) then s:=#3#8+'*'+s else s:=' '+s;
        printacr(' '+s,abort,next);
      end;
      pva:=pva+cstr(i);
      inc(i);
    end;
  end;

begin
  changed:=FALSE;
  if (vd.numa<>0) then begin
    doneyet:=(thisuser.vote[qnum]<>0);
    showvotes(doneyet,not systat.forcevoting);
    nl;
    sprint(#3#5+'Your Vote į '+#3#3+vd.answ[thisuser.vote[qnum]].ans);

    if (not (rvoting in thisuser.ac)) and (not hangup) then begin

      if (answeringall) then b:=TRUE else b:=pynq('Change It [Y/N]: ');
      if (b) then begin
        nl; prt('Select Your Choice [0-'+cstr(vd.numa)+']: ');
        onek(s[1],pva);
        s[0]:=#1; i:=value(s);
        if (s<>'') and (i>=0) and (i<=vd.numa) then begin
          if (thisuser.vote[qnum]<>0) then
            dec(vd.answ[thisuser.vote[qnum]].numres);
          thisuser.vote[qnum]:=i;
          if (i<>0) then inc(vd.answ[i].numres);
          changed:=TRUE;

          if (not answeringall) then showvotes(TRUE,FALSE);
        end;
      end;
    end;
  end else
    if (not answeringall) then print('Inactive Question.');
  vote1x:=changed;
end;

procedure vote;
var vdata:file of vdatar;
    vd:vdatar;
    i,j,int2,vna:integer;
    s,i1,ij:astr;
    abort,next,done,lq,waschanged:boolean;

  procedure getvote(qnum:integer);
  begin
    seek(vdata,qnum-1); read(vdata,vd);
  end;

  procedure vote1(answeringall:boolean; qnum:integer);
  begin
    getvote(qnum);
    if (vote1x(answeringall,qnum,vd)) then begin
      seek(vdata,qnum-1);
      write(vdata,vd);
      waschanged:=TRUE;
    end;
  end;

begin
  s:=''; done:=FALSE; lq:=TRUE; waschanged:=FALSE;
  assign(vdata,systat.systempath+'voting.dat');
  {$I-} reset(vdata); {$I+}
  if (ioresult<>0) then print('Sorry, No Voting Today.')
  else begin
    sysoplog(' Entered Voting Section');
    repeat
      done:=FALSE;
      ij:='Q?';
      abort:=FALSE;
      if (lq) then begin
        cls;
        lsdbars('Current Questions');
        nl;
      end;
      int2:=0;
      for i:=1 to numvoteqs do begin
        getvote(i);
        if vd.numa<>0 then begin
          inc(int2);
          if (lq) and (not abort) then begin
            if (thisuser.vote[i]=0) then i1:=#3+#8+'New' else i1:='   ';
            i1:=i1+#3#5+#3#3+' ['+#3#2+cstr(i)+#3#3+'] '+#3#1+vd.question;
            printacr(i1,abort,next);
          end;
          ij:=ij+cstr(i);
        end;
      end;
      lq:=FALSE;
      if (int2=0) then begin
        print('No Questions To Vote On Exist!');
        done:=TRUE;
      end else begin
        nl;
        prt(#3#5+#3#1+'Which Question '+#3#9+'['+#3#2+'#'+#3#9+','+#3#2+'L'+#3#9+'/'+#3#2+'List'+#3#9+','+#3#2+'A'+#3#9+
          '/'+#3#2+'Answer All'+#3#9+','+#3#2+'Q'+#3#9+'/'+#3#2+'Quit'+#3#9+']: '+#3#1);
        input(s,2);
        i:=value(s);
        if (s='A') then begin
          j:=0;
          i:=1;
          while ((i<=numvoteqs) and (not hangup)) do begin
            getvote(i);
            if ((vd.numa<>0) and (thisuser.vote[i]=0)) then begin
              vote1(TRUE,i);
              inc(j);
            end;
            inc(i);
          end;
          if (j=0) then begin nl; sprint(#3#7+'No More Questions Need To Be Answered!'); end;
        end;
        if ((s='Q') or (s='')) then done:=TRUE;
        if ((s='L') or (s='?')) then lq:=TRUE;
        if (i>=1) and (i<=numvoteqs) then vote1(FALSE,i);
      end;
      if (systat.forcevoting) and (done) then begin
        vna:=0;
        for i:=1 to numvoteqs do begin
          seek(vdata,i-1); read(vdata,vd);
          if ((vd.numa<>0) and (thisuser.vote[i]=0)) then inc(vna);
        end;
        if (vna<>0) then begin
          nl;
          sprint(#3#5+#3#1+'Voting Is Mandatory - All Questions MUST BE Answered!');
          done:=FALSE;
        end;
      end;
    until (done) or (hangup);

    close(vdata);

    if (waschanged) then begin
      nl;
      sprint(#3#3+fstring.thanxvote);
    end;
  end;
end;
(*
function vote1x(answeringall:boolean; qnum:integer; var vd:vdatar):boolean;
var s,pva:astr;
    i,tv:integer;
    c:char;
    abort,next,changed,doneyet,b:boolean;

  procedure showvotes(stats,nocom:boolean);
  var s:astr;
      i:integer;
  begin
    cls;
    sprint('Current standings for Question #'+cstr(qnum)+' :');
    nl; sprint(#3#7+vd.question); nl;
    tv:=0;
    for i:=1 to vd.numa do inc(tv,vd.answ[i].numres);
    if (tv=0) then tv:=1;
    sprint('Users voting: '+#3#3+ctp(tv,systat.numusers)); nl;
    abort:=FALSE; i:=1;
    if (nocom) then begin
      sprint(#3#0+'  0:No Comment');
      pva:='Q0';
    end else
      pva:='';
    while (i<=vd.numa) do begin
      if (not abort) then begin
        s:=#3#5+cstr(i)+#3#7+':'+#3#3+vd.answ[i].ans;
        if (stats) then
          s:=mln(s,41+length(cstr(i)))+#3#4+' :'+#3#0+mn(vd.answ[i].numres,3)+
             #3#4+':'+#3#0+ctp(vd.answ[i].numres,tv)+#3#4+':';
        if (i=thisuser.vote[qnum]) then s:=#3#8+'*'+s else s:=' '+s;
        printacr(' '+s,abort,next);
      end;
      pva:=pva+cstr(i);
      inc(i);
    end;
  end;

begin
  changed:=FALSE;
  if (vd.numa<>0) then begin
    doneyet:=(thisuser.vote[qnum]<>0);
    showvotes(doneyet,not systat.forcevoting);
    nl;
    sprint(#3#5+'Your vote: '+#3#3+vd.answ[thisuser.vote[qnum]].ans);
    if (not (rvoting in thisuser.ac)) and (not hangup) then begin
      if (answeringall) then b:=TRUE else b:=pynq('Change It');
      if (b) then begin
        nl; prt('Which number (0-'+cstr(vd.numa)+') ? ');
        onek(s[1],pva);
        s[0]:=#1; i:=value(s);
        if (s<>'') and (i>=0) and (i<=vd.numa) then begin
          if (thisuser.vote[qnum]<>0) then
            dec(vd.answ[thisuser.vote[qnum]].numres);
          thisuser.vote[qnum]:=i;
          if (i<>0) then inc(vd.answ[i].numres);
          changed:=TRUE;

          if (not answeringall) then showvotes(TRUE,FALSE);
        end;
      end;
    end;
  end else
    if (not answeringall) then print('Inactive question.');
  vote1x:=changed;
end;

procedure vote;
var vdata:file of vdatar;
    vd:vdatar;
    i,j,int2,vna:integer;
    s,i1,ij:astr;
    abort,next,done,lq,waschanged:boolean;

  procedure getvote(qnum:integer);
  begin
    seek(vdata,qnum-1); read(vdata,vd);
  end;

  procedure vote1(answeringall:boolean; qnum:integer);
  begin
    getvote(qnum);
    if (vote1x(answeringall,qnum,vd)) then begin
      seek(vdata,qnum-1);
      write(vdata,vd);
      waschanged:=TRUE;
    end;
  end;

begin
  s:=''; done:=FALSE; lq:=TRUE; waschanged:=FALSE;
  assign(vdata,systat.SystemPath+'voting.dat');
  {$I-} reset(vdata); {$I+}
  if (ioresult<>0) then print('No voting today.')
  else begin
    sysoplog('Entered voting booths');
    repeat
      done:=FALSE;
      ij:='Q?';
      abort:=FALSE;
      if (lq) then begin
        cls;
        printacr(#3#5+'Current Questions:',abort,next);
        nl;
      end;
      int2:=0;
      for i:=1 to numvoteqs do begin
        seek(vdata,i-1); read(vdata,vd);
        if vd.numa<>0 then begin
          inc(int2);
          if (lq) and (not abort) then begin
            if (thisuser.vote[i]=0) then i1:=#3+#8+'* ' else i1:='  ';
            i1:=i1+#3#5+cstr(i)+#3#7+': '+#3#3+vd.question;
            printacr(i1,abort,next);
          end;
          ij:=ij+cstr(i);
        end;
      end;
      lq:=FALSE;
      if (int2=0) then begin
        print('No voting questions now.');
        done:=TRUE;
      end else begin
        nl;
        prt('Which question (##,L:ist,A:nswer all,Q:uit) : ');
        input(s,2);
        i:=value(s);
        if (s='A') then begin
          j:=0;
          i:=1;
          while ((i<=numvoteqs) and (not hangup)) do begin
            getvote(i);
            if ((vd.numa<>0) and (thisuser.vote[i]=0)) then begin
              vote1(TRUE,i);
              inc(j);
            end;
            inc(i);
          end;
          if (j=0) then begin nl; sprint(#3#7+'No more questions need answering!'); end;
        end;
        if ((s='Q') or (s='')) then done:=TRUE;
        if ((s='L') or (s='?')) then lq:=TRUE;
        if (i>=1) and (i<=numvoteqs) then vote1(FALSE,i);
      end;
      if (systat.forcevoting) and (done) then begin
        vna:=0;
        for i:=1 to numvoteqs do begin
          seek(vdata,i-1); read(vdata,vd);
          if ((vd.numa<>0) and (thisuser.vote[i]=0)) then inc(vna);
        end;
        if (vna<>0) then begin
          nl;
          print('Voting is mandatory - all questions must be answered.');
          done:=FALSE;
        end;
      end;
    until (done) or (hangup);

    close(vdata);

    if (waschanged) then begin
      nl;
      sprint(#3#3+fstring.thanxvote);
    end;
  end;
end;
*)
end.
