{*****************************************************************************
 *     Revelation Initialization Program - Initialize Data Files - v0.85     *
 *            For Use With Revelation 0.85 Or Less ONLY!!!                   *
 *                 Coded By: Force Ten and The Master                        *
 *****************************************************************************}

(*
DONE:

USER    .LST *
MACRO   .LST *
BOARDS  .DAT *
REVELATE.DAT *
NETWORK .DAT *
MODEM   .DAT *
UPLOADS .DAT *
ZLOG    .DAT *
EVENTS  .DAT *
LASTCALL.DAT *
VERBOSE .DAT *
VOTING  .DAT *
SHORTMSG.DAT *
RUMOR   .DAT *
CONFEREN.DAT *
NUV     .DAT *
ONELINER.DAT *
LOTTERY .DAT *

TO-DO:

PROTOCOL.DAT
STRING  .DAT
EMAIL   .MTX  w/ prewritten letter.
EMAIL   .IDX           "
GENERAL .MTX
GENERAL .IDX

DATA FILES TO BE INCLUDED PREMADE: <MAYBE>

PROTOCOL.DAT

DATA FILES NOT TO BE MADE OR INCLUDED:

ANEWS   .DAT
ANEWS   .TXT
*)

program initrev;

{$A+,B+,E+,F+,G+,I+,L+,N-,O+,R-,S+,V-}
{$M 50000,0,1024}       { Declared here suffices for all Units as well! }

uses
  crt, dos,
  myio, timejunk;

{$I struct.inc}

type
  pickitrec=record
    jackpot:longint;
    lastpick:array [1..6] of integer;
    winners:array [1..10] of string;
{Force Ten #1                      150 points     01/01/80}
    numsold:longint;
  end;

  OneRec = Record
    Line:Array[1..16] Of String;    {1-15 Are OneLiners, 16 is ALWAYS END}
  End;

const noone='Nobody!                            0 Points       ';


var
  systatf:file of systatrec;
  systat:systatrec;
  modemf:file of modemrec;
  modemr:modemrec;
  fstringf:file of fstringrec;
  fstring:fstringrec;
  uf:file of userrec;
  u:userrec;
  bf:file of boardrec;
  br:boardrec;
  uff:file of ulrec;
  ufr:ulrec;
  xp:file of protrec;
  xpr:protrec;
  zf:file of zlogrec;
  zfr:zlogrec;
  brdf:file;
  mixf:file;
  tref:file;
  lcallf:file of lastcallrec;
  lcall:lastcallrec;
  verbf:file of verbrec;
  vr:verbrec;
  vdata:file of vdatar;
  vd:vdatar;
  nuvdata:file of nvote;
  nuvd:nvote;
  smf:file of smr;
  sm:smr;
  ulff:file of ulfrec;
  ulffr:ulfrec;
  evf:file of eventrec;
  evr:eventrec;
  macrf:file of macrorec;
  macr:macrorec;
  networkrf:file of networkrec;
  networkr:networkrec;

  curdir:string;
  path:array[1..7] of string;
  found:boolean;
  dirinfo:searchrec;
  i,j,k:integer;
  c:char;

function syn(b:boolean):astr;
begin
  if (b) then syn:='Yes' else syn:='No ';
end;
  
function yn:boolean;
var c:char;
begin
    textcolor(3);
    repeat
      c:=readkey;
      c:=upcase(c);
    until (c in ['Y','N',^M,^N]);
    if (c='Y') then begin
      textcolor(9);
      write('Yes'); delay(25); textcolor(11);
      write(' Yes'); delay(25); textcolor(15);
      write('Yes '); delay(25); textcolor(14);
      write(' Yes '); delay(25); writeln;
      yn:=TRUE;
    end else begin
      textcolor(9);
      write('No'); delay(25); textcolor(11);
      write(' No'); delay(25); textcolor(15);
      write('No '); delay(25); textcolor(14);
      write(' No '); delay(25); writeln;
      yn:=FALSE;
    end;
end;

function pynq(s:string):boolean;
begin
  textcolor(4); write(s);
  textcolor(11); pynq:=yn;
end;

procedure prt(s:string);
begin
  textcolor(9); write(s);
end;

procedure star(s:string);
begin
  textcolor(9); write(' ');
  textcolor(11); cwrite(s); writeln;
end;

function freek(d:integer):longint;
var lng:longint;
begin
  lng:=diskfree(d);
  freek:=lng div 1024;
end;

function exdrv(s:astr):byte;
begin
  s:=fexpand(s);
  exdrv:=ord(s[1])-64;
end;

function leapyear(yr:integer):boolean;
begin
  leapyear:=(yr mod 4=0) and ((yr mod 100<>0) or (yr mod 400=0));
end;

function value(s:astr):longint;
var i,j:integer;
begin
  val(s,i,j);
  if (j<>0) then begin
    s:=copy(s,1,j-1);
    val(s,i,j)
  end;
  value:=i;
  if (s='') then value:=0;
end;

function days(mo,yr:integer):integer;
var d:integer;
begin
  d:=value(copy('312831303130313130313031',1+(mo-1)*2,2));
  if ((mo=2) and (leapyear(yr))) then inc(d);
  days:=d;
end;

function daycount(mo,yr:integer):integer;
var m,t:integer;
begin
  t:=0;
  for m:=1 to (mo-1) do t:=t+days(m,yr);
  daycount:=t;
end;

function daynum(dt:astr):integer;
var d,m,y,t,c:integer;
begin
  t:=0;
  m:=value(copy(dt,1,2));
  d:=value(copy(dt,4,2));
  y:=value(copy(dt,7,2))+1900;
  for c:=1985 to y-1 do
    if (leapyear(c)) then inc(t,366) else inc(t,365);
  t:=t+daycount(m,y)+(d-1);
  daynum:=t;
  if y<1985 then daynum:=0;
end;

function tch(s:astr):astr;
begin
  if (length(s)>2) then s:=copy(s,length(s)-1,2) else
    if (length(s)=1) then s:='0'+s;
  tch:=s;
end;

function time:astr;
var h,m,s:string[3];
    hh,mm,ss,ss100:word;
begin
  gettime(hh,mm,ss,ss100);
  str(hh,h); str(mm,m); str(ss,s);
  time:=tch(h)+':'+tch(m)+':'+tch(s);
end;

function date:astr;
var r:registers;
    y,m,d:string[3];
    yy,mm,dd,dow:word;
begin
  getdate(yy,mm,dd,dow);
  str(yy-1900,y); str(mm,m); str(dd,d);
  date:=tch(m)+'/'+tch(d)+'/'+tch(y);
end;

procedure ttl(s:string);
begin
  writeln;
  textcolor(9); write('[');
  textbackground(1); textcolor(15);
  write(' '+s+' ');
  textbackground(0); textcolor(9);
  write(']');
  repeat write('') until wherex=80;
  writeln;
end;

(* FIX THIS UP *)
procedure movefile(var ok,nospace:boolean; showprog:boolean;
                   srcname,destname:astr);
var buffer:array[1..16384] of byte;
    fs,dfs:longint;
    nrec,i:integer;
    src,dest:file;

  procedure dodate;
  var r:registers;
      od,ot,ha:integer;
  begin
    srcname:=srcname+#0;
    destname:=destname+#0;
    with r do begin
      ax:=$3d00; ds:=seg(srcname[1]); dx:=ofs(srcname[1]); msdos(dos.registers(r));
      ha:=ax; bx:=ha; ax:=$5700; msdos(dos.registers(r));
      od:=dx; ot:=cx; bx:=ha; ax:=$3e00; msdos(dos.registers(r));
      ax:=$3d02; ds:=seg(destname[1]); dx:=ofs(destname[1]); msdos(dos.registers(r));
      ha:=ax; bx:=ha; ax:=$5701; cx:=ot; dx:=od; msdos(dos.registers(r));
      ax:=$3e00; bx:=ha; msdos(dos.registers(r));
    end;
  end;

begin
  ok:=TRUE; nospace:=FALSE;
  assign(src,srcname);
  {$I-} reset(src,1); {$I+}
  if (ioresult<>0) then begin ok:=FALSE; exit; end;
  dfs:=freek(exdrv(destname));
  fs:=trunc(filesize(src)/1024.0)+1;
  if (fs>=dfs) then begin
    close(src);
    nospace:=TRUE; ok:=FALSE;
    exit;
  end else begin
    assign(dest,destname);
    {$I-} rewrite(dest,1); {$I+}
    if (ioresult<>0) then begin ok:=FALSE; exit; end;
    repeat
      blockread(src,buffer,16384,nrec);
      blockwrite(dest,buffer,nrec);
    until (nrec<16384);
    close(dest); close(src);
    dodate;
    erase(src);
  end;
end;

procedure ffile(fn:string);
begin
  findfirst(fn,anyfile,dirinfo);
  found:=(doserror=0);
end;

procedure nfile;
begin
  findnext(dirinfo);
  found:=(doserror=0);
end;

procedure movefile1(srcname,destpath:string);
var ps,ns,es:string;
    ok,nospace:boolean;
begin
  ok:=TRUE; nospace:=FALSE;
  fsplit(srcname,ps,ns,es);
  star(srcname+#3#9+' -- '+#3#11+destpath);
  movefile(ok,nospace,FALSE,srcname,destpath+ns+es);
  if (not ok) then
    if (nospace) then
      star('Move failed: Insufficient space!!'^G)
    else
      star('Move failed!!'^G);
end;

procedure movefiles(srcname,destpath:string);
var ok,nospace:boolean;
begin
  ffile(srcname);
  while found do begin
    movefile1(dirinfo.name,destpath);
    nfile;
  end;
end;


function make_path(s:string):boolean;
begin
  while (copy(s,length(s),1)='\') do s:=copy(s,1,length(s)-1);
  make_path:=TRUE;
  {$I-} mkdir(fexpand(s)); {$I+}
  if (ioresult<>0) then begin
    writeln;
    star('Error creating directory "'+fexpand(s)+'"'^G^G);
    make_path:=FALSE;
  end;
end;

procedure make_paths;
var s:string;
begin
  for i:=1 to 6 do begin
    while copy(path[i],length(path[i]),1)='\' do
      path[i]:=copy(path[i],1,length(path[i])-1);
    case i of 1:s:='SYSTEM'; 2:s:='TEXT'; 3:s:='MSGS'; 4:s:='MENUS';
              5:s:='LOG'; 6:s:='WORK'; end;
    star(s+' path ("'+fexpand(path[i])+'")');
    if (not make_path(path[i])) then halt(1);
    path[i]:=path[i]+'\';
  end;
  star('Creating SYSOP and MISC file paths');
  if (not make_path('DLOADS\')) then halt(1);
  if (not make_path('DLOADS\SYSOP')) then halt(1);
  if (not make_path('DLOADS\MISC')) then halt(1);
  star('Creating TEMP 1, 2, and 3 file paths');
  if (not make_path(path[6]+'1\')) then halt(1);
  if (not make_path(path[6]+'2\')) then halt(1);
  if (not make_path(path[6]+'3\')) then halt(1);
  if (not make_path(path[6]+'QWK\')) then halt(1);
end;
(*
procedure make_mboard(s:string);
var f:file;
    mixr:msgindexrec;
    lng:longint;
    i:integer;
begin
  assign(brdf,s+'.brd');
  rewrite(brdf,1); lng:=$FC020010; blockwrite(brdf,lng,4); close(brdf);

  assign(mixf,s+'.mix');
  rewrite(mixf,sizeof(mixr));
  fillchar(mixr,sizeof(mixr),#00);
  mixr.hdrptr:=0; for i:=0 to 99 do blockwrite(mixf,mixr,1);
  close(mixf);
end;
*)
procedure make_fboard(s:string);
begin
  fillchar(ulffr,sizeof(ulffr),#00);
  ulffr.blocks:=0;
  assign(ulff,s+'.DIR');
  rewrite(ulff); write(ulff,ulffr); close(ulff);
end;

procedure make_user_lst;
const dcols:clrs=((15,7,7,15,15,15,112,7,143,7),(9,11,14,3,13,15,31,12,139,9));
begin
  FillChar(u,sizeof(u),#00);
  with u do begin
    name:='SYSOP';
    realname:='System Operator';
    pw:='SYSOP';
    ph:='000-000-0000';
    bday:='00/00/00';
    firston:=date;
    laston:=date;
    accountnote:='BBS SysOp';
    computer:='IBM Compatible';
    note:='Change These Stats To Yours.';
    lockedout:=FALSE;
    deleted:=FALSE;
    lockedfile:='';
    ac:=[onekey,pause,novice,ansi,color,
         smw,    {* short message waiting, in SHORTMSG.DAT *}
         fnodlratio,fnopostratio,fnofilepts,fnodeletion];
    ar:=[]; for c:='A' to 'Z' do ar:=ar+[c];
    for i:=1 to 20 do vote[i]:=0;
    for i:=1 to 20 do nuv[i]:=0;
    useautosigs:=FALSE;
    sex:='M';
    ttimeon:=0;
    uk:=0;
    dk:=0;
    uploads:=0;
    downloads:=0;
    loggedon:=0;
    tltoday:=600;
    msgpost:=0;
    emailsent:=0;
    filepoints:=100;
    linelen:=80;
    pagelen:=20;        {* to make room for SysOp window when on.. *}
    ontoday:=0;
    illegal:=0;
    sl:=255;
    dsl:=255;
    cols:=dcols;
    lastmsg:=1;
    lastfil:=0;
    timebank:=0;
    trapactivity:=FALSE;
    trapseperate:=FALSE;
    timebankadd:=0;
    mpointer:=-1;
    chatauto:=FALSE;
    chatseperate:=FALSE;
    slogseperate:=FALSE;
    clsmsg:=FALSE;
    avatarcoloradjust:=FALSE;
    headernumber:=0;
    hidename:=FALSE;
    for i:=1 to 11 do flistcfg[i]:=0;
    didconfig:=0;
    for i:=1 to 3 do res[i]:=0;
    incomingmail:=0;
    outgoingmail:=0;
    arealistnumber:=0;
    wallread:=0;
    newsread:=0;
    haspickit:=FALSE;
    for i:=1 to 6 do pickit[i]:=0;
  end;
  assign(uf,'user.lst');
  rewrite(uf);
  seek(uf,0); write(uf,u);      { write dummy record }
  seek(uf,1); write(uf,u);      { write user #1 }
  close(uf);
end;

procedure make_macro_lst;
var i:integer;
begin
  FillChar(macr,sizeof(macr),#00);
  with macr do
    for i:=1 to 4 do macro[i]:='';
  assign(macrf,'macro.lst');
  rewrite(macrf);
  seek(macrf,0); write(macrf,macr);
  close(macrf);
end;

procedure make_boards_dat;
begin
  assign(bf,'boards.dat');
  rewrite(bf);
  FillChar(br,sizeof(br),#00);
  with br do begin
    name:='Private E-Mail';
    filename:='PRIVATE';
    lastmsgid:=0;
    msgpath:='';
    acs:='C0';
    postacs:='vv';
    mciacs:='%';
    maxmsgs:=50;
    anonymous:=atno;
    password:='';
    mbstat:=[mbskludge,mbsseenby,mbscenter,mbsbox,mbmcenter,mbaddtear];
    permindx:=0;
    mbtype:=0;
    origin:=networkr.origin;
    text_color:=5;
    quote_color:=1;
    tear_color:=9;
    origin_color:=5;
    zone:=0; net:=0; node:=0; point:=0;
    confnum:=1;
    msgstatus:=0;
    addaccnote:=TRUE;
    maxfselines:=300;
  end;
  write(bf,br);
  FillChar(br,sizeof(br),#00);
  with br do begin
    name:='General Messages';
    filename:='GENERAL';
    lastmsgid:=0;
    msgpath:='';
    acs:='C1';
    postacs:='vv';
    mciacs:='%';
    maxmsgs:=50;
    anonymous:=atno;
    password:='';
    mbstat:=[mbskludge,mbsseenby,mbscenter,mbsbox,mbmcenter,mbaddtear];
    permindx:=0;
    mbtype:=1;
    origin:=networkr.origin;
    text_color:=5;
    quote_color:=1;
    tear_color:=9;
    origin_color:=5;
    zone:=0; net:=0; node:=0; point:=0;
    confnum:=1;
    msgstatus:=1;
    addaccnote:=TRUE;
    maxfselines:=300;
  end;
  write(bf,br); close(bf);
end;

procedure make_revelate_dat;
begin
  FillChar(systat,sizeof(systat),#00);
  with systat do begin
    systempath:=path[1];
    textpath:=path[2];
    msgpath:=path[3];
    menupath:=path[4];
    externaleditor:='';
    protocolpath:='';
    archivepath:='';

    bbsname:='Revelation BBS';
    bbsphone:='000-000-0000';
    sysopname:='System Operator';
    lowtime:=0; hitime:=0;
    dllowtime:=0; dlhitime:=0;
    shuttlelog:=FALSE;
    lock9600:=FALSE;
    systempw:='SYSOP';
    newuserpw:='';
    lockoutpw:='';
    system1pw:='MATRIX'; system2pw:=''; system3pw:='';
    system1security:=''; system2security:=''; system3security:='';
    blowtime:=0; bhitime:=0;
    bdllowtime:=0; bdlhitime:=0;
    multiline:=FALSE;
    allownewusers:=TRUE;
    swapshell:=FALSE;
    ems_overlay:=FALSE;
    eventwarningtime:=60;
    phonepw:=FALSE;
    localscreensec:=FALSE;
    localpass:=FALSE;
    usebios:=TRUE;
    cgasnow:=TRUE;
    globaltrap:=FALSE;
    autochatopen:=TRUE;
    sop:='s255';
    csop:='s250';
    msop:='s199';
    fsop:='s230';
    spw:='s250';
    seepw:='s255';
    normpubpost:='s11';
    normprivpost:='s11';
    anonpubread:='s100';
    anonprivread:='s100';
    anonpubpost:='s100';
    anonprivpost:='s100';
    seeunval:='s50';
    dlunval:='s230';
    nodlratio:='s255';
    nopostratio:='s200';
    nofilepts:='s255';
    ulvalreq:='s21';
    default_onek:=TRUE;
    default_clrmsg:=TRUE;
    default_expert:=FALSE;
    default_pause:=FALSE;
    maxprivpost:=20;
    maxpubpost:=20;
    maxchat:=3;
    maxwaiting:=15;
    csmaxwaiting:=50;
    maxlogontries:=4;
    sysopcolor:=4;
    usercolor:=3;
    minspaceforpost:=10;
    minspaceforupload:=100;
    backsysoplogs:=7;
    wfcblanktime:=0;
    linelen:=80;
    pagelen:=25;
    offhooklocallogon:=TRUE;
    forcevoting:=FALSE;
    searchdup:=FALSE;
    stripclog:=FALSE;
    timeoutbell:=2;
    timeout:=5;
    for i:=1 to 6 do
      with filearcinfo[i] do
        case i of
          1:begin
              active:=TRUE;
              ext:='ZIP';
              listline:='/1';
              arcline:='PKZIP -aex @F @I';
              unarcline:='PKUNZIP @F @I';
              testline:='PKUNZIP -t @F';
              cmtline:='PKZIP -z @F';
              succlevel:=0;
            end;
          2:begin
              active:=FALSE;
              ext:='ARC';
              listline:='/2';
              arcline:='PKPAK a @F @I';
              unarcline:='PKUNPAK @F @I';
              testline:='PKUNPAK -t @F';
              cmtline:='PKPAK x @F';
              succlevel:=0;
            end;
          3:begin
              active:=FALSE;
              ext:='PAK';
              listline:='/2';
              arcline:='PAK a @F @I';
              unarcline:='PAK e @F @I';
              testline:='PAK t @F';
              cmtline:='';
              succlevel:=-1;
            end;
          4:begin
              active:=FALSE;
              ext:='LZH';
              listline:='/4';
              arcline:='LHARC a @F @I';
              unarcline:='LHARC e @F @I';
              testline:='LHARC t @F';
              cmtline:='';
              succlevel:=0;
            end;
          5:begin
              active:=FALSE;
              ext:='ZOO';
              listline:='/3';
              arcline:='ZOO aP: @F @I';
              unarcline:='ZOO x @F @I';
              testline:='ZOO xNd @F';
              cmtline:='ZOO cA @F';
              succlevel:=0;
            end;
          6:begin
              active:=FALSE;
              ext:='DWC';
              listline:='DWC v @F';
              arcline:='DWC a @F @I';
              unarcline:='DWC x @F @I';
              testline:='DWC t @F';
              cmtline:='';
              succlevel:=0;
            end;
        end;
    filearcinfo[6].ext:='';

    uldlratio:=FALSE;
    fileptratio:=TRUE;
    fileptcomp:=3;
    fileptcompbasesize:=10;
    ulrefund:=100;
    tosysopdir:=0;
    validateallfiles:=FALSE;
    remdevice:='COM1';
    maxintemp:=500;
    minresume:=100;
    maxdbatch:=20;
    maxubatch:=20;
    newsl:=20;
    newdsl:=20;
    newar:=[];
    newac:=[rpostan,rvoting];
    newfp:=100;
    newnote:='';
    autosl:=100;
    autodsl:=100;
    autoar:=[];
    autoac:=[];
    autonote:='Validated User.';
    allstartmenu:='MAIN';
    bulletprefix:='BULLET';
    lastdate:=date;
    curwindow:=1;
    istopwindow:=TRUE;
    callernum:=0;
    numusers:=1;
    todayzlog.date:=date;
    with todayzlog do begin
      for i:=0 to 4 do userbaud[i]:=0;
      active:=0; calls:=0; newusers:=0; pubpost:=0;
      privpost:=0; fback:=0; criterr:=0;
      uploads:=0; downloads:=0;
      uk:=0; dk:=0;
    end;
    postcredits:=0;
    rebootforevent:=FALSE;
    watchdogdoor:=FALSE;
    maxusers:=9999;
    windowon:=TRUE;
    regcode:='';
    emailboard:=1;
    confactive:=TRUE;
    givegift:=FALSE;
    giftpts:=50;
    yntype:=1;
    noagree:=0;
    shuttlesys:=0;
    newuservoting:=FALSE;
    yesvotes:=4;
    novotes:=3;
    lottonight:=true;
    caneditunote:=false;
    usevalups:=0;
    for i:=1 to 186 do reservedspace[i]:=0;
  end;
  assign(systatf,'revelate.dat');
  rewrite(systatf); write(systatf,systat); close(systatf);
end;

procedure make_network_dat;
begin
  FillChar(networkr,sizeof(networkr),#00);
  with networkr do begin
    origin:=copy(systat.bbsname+' ('+systat.bbsphone+')',1,50);
    netmailpath:='';
    echomailpath:='';
    nodelistpath:='';
    nholduser:=TRUE;
    nhold:=TRUE;
    ncrash:=FALSE;
    nkill:=TRUE;
  end;
  assign(networkrf,'network.dat');
  rewrite(networkrf); write(networkrf,networkr); close(networkrf);
end;

procedure make_modem_dat;
var i,j:integer;
begin
  FillChar(modemr,sizeof(modemr),#00);
  with modemr do begin
    maxbaud:=2400;
    comport:=1;
    init:='ATH0Q0V0E0M0X1S0=0S2=43S10=40&C1';
    answer:='ATA';
    hangup:='~~~+++~~~ATH0';
    offhook:='ATH1M0';
    nocallinittime:=30;
    lockedport:=false;
    lockedbaud:=2400;
    forcerate:=FALSE;
    CONNECT_300:='CONNECT';
    CONNECT_1200:='CONNECT 1200';
    CONNECT_2400:='CONNECT 2400';
    CONNECT_4800:='CONNECT 4800';
    CONNECT_9600:='CONNECT 9600';
    CONNECT_14400:='CONNECT 14400';
    CONNECT_19200:='CONNECT 19200';
    CONNECT_38400:='CONNECT 38400';
    ERROR:='ERROR';
    BUSY:='BUSY';
    NO_CARRIER:='NO CARRIER';
    OK:='OK';
    RING:='RING';
    NO_DIALTONE:='NO DIALTONE';
    NO_ANSWER:='NO ANSWER';
    VOICE:='VOICE';
    ctschecking:=TRUE;
    dsrchecking:=TRUE;
    usexonxoff:=FALSE;
    hardwired:=FALSE;
  end;
  assign(modemf,'modem.dat');
  rewrite(modemf); write(modemf,modemr); close(modemf);
end;
(*
procedure make_string_dat;
var i:byte;
begin
  FillChar(fstring,sizeof(fstring),#00);
  with fstring do begin
    note[1]:='^1Revelation BBS Systems Logon.';
    note[2]:='Enter Your Handle Or User Number Below.';
    lprompt:='^5Logon ^9į ';
    echoc:='';
    sysopin:='^1The SysOp Is Probably Around!';
    sysopout:='^1The SysOp Is NOT Here, Or Doesn''t Want To Chat';
    engage:='@M^1The SysOp Brings You Into Chat!';
    endchat:='^1The SysOp Returns You To The BBS....@M';
    wait:='^9[^2Please Wait^9]';
    pause:='^9[^1Pause^9]';
    automsgt:='^5AutoMessage by: ';
    autom:='';

    shelldos1:='^5^9 ^1'+systat.sysopname+' Has Shelled To DOS...';
    shelldos2:='^5^9 ^1Thank You For Waiting.';
    chatcall1:='^5^1Paging ^2'+systat.sysopname+'^1 For Chat...';
    chatcall2:=' ^9>>^1<^2*^1>^9<<';
    guestline:='Enter "GUEST" As Your User Name To Be A Guest User On The System.';
    namenotfound:='^5^2That Name Is ^8NOT ^2Found In The User List.';
    bulletinline:='^5^1Enter Bulletin Selection ^9[^2##^9,^2?^9,^2Q^9/^2Quit^9]: ^1';
    thanxvote:='^7Thanks For Taking The Time To Vote!';

    nofilepts:='^8Access Denied: ^5Insufficient file points to download.';
    unbalance:='^8Access Denied: ^5Your upload/download ratio is out of balance:';
    batchadd:='File Added To Batch Queue.';
    dosprompt:='C:\BBS> ';
    for i:=1 to 5 do res[i]:='';
  end;
  assign(fstringf,'string.dat');
  rewrite(fstringf); write(fstringf,fstring); close(fstringf);
end;
*)
procedure make_uploads_dat;
begin
  assign(uff,'uploads.dat');
  rewrite(uff);
  FillChar(ufr,sizeof(ufr),#00);
  with ufr do begin
    name:='SysOp Directory';
    filename:='SYSOP';
    dlpath:=curdir+'\DLOADS\SYSOP\';
    ulpath:=dlpath;
    maxfiles:=2000;
    password:='';
    arctype:=1;
    cmttype:=1;
    fbdepth:=0;
    fbstat:=[];
    acs:='s255d255';
    ulacs:='';
    nameacs:='s255';
    permindx:=0;
    confnum:=1;
    basetype:=0;
    avpoints:=0;
    avfiles:=FALSE;
    creduler:=FALSE;
    for i:=1 to 5 do res[i]:=0;
  end;
  write(uff,ufr);
  FillChar(ufr,sizeof(ufr),#00);
  with ufr do begin
    name:='Miscellaneous';
    filename:='MISC';
    dlpath:=curdir+'\DLOADS\MISC\';
    ulpath:=dlpath;
    maxfiles:=2000;
    password:='';
    arctype:=1;
    cmttype:=1;
    fbdepth:=0;
    fbstat:=[];
    acs:='d30';
    ulacs:='';
    nameacs:='';
    permindx:=1;
    confnum:=1;
    basetype:=0;
    avpoints:=0;
    avfiles:=FALSE;
    creduler:=FALSE;
    for i:=1 to 5 do res[i]:=0;
  end;
  write(uff,ufr); close(uff);
end;

procedure make_zlog_dat;
var i:integer;
begin
  FillChar(zfr,sizeof(zfr),#00);
  zfr.date:=date;
  with zfr do begin
    for i:=0 to 4 do userbaud[i]:=0;
    active:=0; calls:=0; newusers:=0; pubpost:=0; privpost:=0;
    fback:=0; criterr:=0;
    uploads:=0; downloads:=0;
    uk:=0; dk:=0;
  end;
  assign(zf,'zlog.dat');
  rewrite(zf); write(zf,zfr);
  zfr.date:=''; write(zf,zfr);
  close(zf);
end;
(*
procedure blockwritestr(var f:file; s:string);
begin
  blockwrite(f,s[0],1);
  blockwrite(f,s[1],ord(s[0]));
end;

procedure savemhead1(var brdf:file; mhead:mheaderrec);
begin
  blockwrite(brdf,mhead,sizeof(mheaderrec));
end;

procedure create_email_brd;
var t:text;
    fb:file;
    mheader:mheaderrec;
    mixr:msgindexrec;
    s:string;
    dt:ldatetimerec;
    pdt:packdatetime;
    lng,lsize:longint;
    i:integer;
    bb:byte;
    year,month,day,dow,hour,min,sec,sec100:word;
begin
  assign(fb,'tosysop.ltr'); reset(fb,1); lsize:=filesize(fb); close(fb);
  assign(t,'tosysop.ltr'); reset(t);
  assign(brdf,'email.brd');
  rewrite(brdf,1);
  {lng:=$FC020010; blockwrite(brdf,lng,4);}
  {lng:=$DCBA0123; blockwrite(brdf,lng,4);}
  blockwrite(brdf,lsize,4);
  while (not eof(t)) do begin
    readln(t,s);
    bb:=$FF; blockwrite(brdf,bb,1);
    blockwrite(brdf,s[0],1);
    blockwrite(brdf,s[1],ord(s[0]));
  end;
  close(t);
  erase(t);
  with mixr do begin
    messagenum:=1;
    hdrptr:=filesize(brdf);
    msgindexstat:=[miexist];
    msgid:=4242;
    getdate(year,month,day,dow);
    dt.year:=year; dt.month:=month; dt.day:=day;
    gettime(hour,min,sec,sec100);
    dt.hour:=hour; dt.min:=min; dt.sec:=sec; dt.sec100:=sec100;
    dt2pdt(dt,pdt);
    for i:=1 to 6 do msgdate[i]:=pdt[i];
    msgdowk:=0;
    isreplytoid:=0;
    isreplyto:=65535;
    numreplys:=0;
  end;

  assign(mixf,'email.mix');
  rewrite(mixf,sizeof(mixr)); blockwrite(mixf,mixr,1); close(mixf);
  with mheader do begin
    signature:=$ABCD0123;
    msgptr:=4;
    msglength := lsize;
    title:='Greetings, New Revelation BBS SysOp!!';
    with fromi do begin
      anon:=0;
      usernum:=1;
      as:='The Revelation BBS Team';
      real:='The Revelation BBS Team';
      alias:='The Revelation BBS Team';
    end;
    with toi do begin
      anon:=0;
      usernum:=1;
      as:='SysOp #1';
      real:='System Operator';
      alias:='SysOp';
    end;
    origindate:='';
  end;
  savemhead1(brdf,mheader);
  close(brdf);
end;

procedure make_email_brd;
var f:file;
    mixr:msgindexrec;
    lng:longint;
    i:integer;
begin
  assign(brdf,'email.brd');
  rewrite(brdf,1); lng:=$FC020010; blockwrite(brdf,lng,4); close(brdf);

  assign(mixf,'email.mix');
  rewrite(mixf,sizeof(mixr));
  fillchar(mixr,sizeof(mixr),#00);
  mixr.hdrptr:=0; for i:=0 to 99 do blockwrite(mixf,mixr,1);
  close(mixf);
end;
*)

procedure make_events_dat;
begin
  assign(evf,'events.dat'); rewrite(evf);
  FillChar(evr,sizeof(evr),#00);
  with evr do begin
    active:=FALSE;                    (* event is NOT active *)
    description:='Nightly Events';
    etype:='D';                       (* DOS SHELL event type *)
    execdata:='night.bat';            (* call NIGHT.BAT *)
    busytime:=1;                      (* take phone offhook 1 min before *)
    exectime:=241;                    (* 241 mins past midnite -- i.e. 4:01a *)
    busyduring:=TRUE;                 (* take phone offhook during *)
    duration:=1;                      (* 1 minute long *)
    execdays:=127;                    (* every day of the week *)
    monthly:=FALSE;                   (* weekly, not monthly *)
  end;
  write(evf,evr); close(evf);
end;

procedure make_lastcall_dat;
begin
  FillChar(lcall,sizeof(lcall),#00);
  lcall.date:=date;
  with lcall do begin
    username:='The Revelation Team';
    baudrate:='38400';
    timeon:='00:00';
    timeoff:='00:00';
    totaltimeon:='0';
    daysold:=0;
    nodeid:=1;
    callernum:=0;
  end;
  assign(lcallf,'lastcall.dat');
  rewrite(lcallf); write(lcallf,lcall);
  lcall.callernum:=-1;
  for i:=1 to 9 do write(lcallf,lcall);
  close(lcallf);
end;

procedure make_verbose_dat;
begin
  FillChar(vr,sizeof(vr),#00);
  with vr do
    for i:=1 to 4 do descr[i]:='';
  assign(verbf,'verbose.dat');
  rewrite(verbf); write(verbf,vr); close(verbf);
end;

procedure make_voting_dat;
begin
  FillChar(vd,sizeof(vd),#00);
  with vd do begin
    question:='<< No Question >>';
    numa:=0;
    for i:=0 to 9 do
      with answ[i] do begin
        if (i<>0) then ans:='Selection '+chr(i+48) else ans:='No Comment';
        numres:=0;
      end;
  end;
  assign(vdata,'voting.dat');
  rewrite(vdata);
  for i:=0 to 19 do write(vdata,vd);
  close(vdata);
end;

procedure make_shortmsg_dat;
begin
  FillChar(sm,sizeof(sm),#00);
  with sm do begin
    msg:='Revelation BBS System Initialized On '+date+' At '+time+'.';
    destin:=1;
  end;
  assign(smf,'shortmsg.dat');
  rewrite(smf); write(smf,sm); close(smf);
end;

procedure make_rumor_dat;
var rum:rumorrec; rumf:file of rumorrec;
begin
  FillChar(rum,sizeof(rum),#00);
  rum.date:=date;
  with rum do begin
    title:='Revelation Init!';
    author:='The Revelation Team';
    rumor:='|01R|09e|03v|11e|15l|11a|03t|09i|01on |15- |14Pure Excellence.';
    anonymous:=false;
    accessreq:=0;
  end;
  assign(rumf,'rumor.dat');
  rewrite(rumf); write(rumf,rum); close(rumf);
end;

{ procedure make_conf_dat;
var con:conference; conf:file of conference;
begin
  FillChar(con,sizeof(con),#00);
  with con do begin
    Number:=1;
    Message:='General Messages';
    CFile:='General Files';
    ACS:='%';
    typee:=0;
  end;
  assign(conf,'conferen.dat');
  rewrite(conf); write(conf,con); close(conf);
end; }

procedure make_nuv_dat;
var cv:byte;
begin
  assign(nuvdata,'nuv.dat');
  rewrite(nuvdata);
  FillChar(nuvd,sizeof(nuvd),#00);
  nuvd.who:='<< No User >>';
  nuvd.whonum:=0;
  nuvd.numa:=0;
  nuvd.numyes:=0;
  nuvd.numno:=0;
  nuvd.descript:='';
  nuvd.fname:='';
  for cv:=0 to numvoteqs-1 do write(nuvdata,nuvd);
  close(nuvdata);
end;

procedure make_oneliner_dat;
Var OneFil:File Of OneRec; One:OneRec; I:Byte;
begin
  Assign(OneFil,'oneliner.dat');
  ReWrite(OneFil);
  FillChar(One,sizeof(One),#00);
  One.Line[1]:='Revelation - The Wave Of The Future';
  For I:=2 To 16 Do One.Line[I]:='END';
  Write(OneFil,One);
  Close(OneFil);
end;

procedure make_lottery_dat;
var pickfile:file of pickitrec; pick:pickitrec; i:byte;
begin
  assign(pickfile,'lottery.dat');
  rewrite(pickfile);
  fillchar(pick,sizeof(pick),#00);
  pick.jackpot:=0;
  for i:=1 to 6 do pick.lastpick[i]:=0;
  for i:=1 to 10 do pick.winners[i]:=noone+date;
  pick.numsold:=0;
  write(pickfile,pick);
  close(pickfile);
end;

procedure dostuff;
begin
  ttl('Creating Revelation BBS directory paths');
(*  make_paths; *)
  ttl('Creating Revelation BBS data files');
  make_revelate_dat;
  make_modem_dat;
(*  make_string_dat; *)
  make_network_dat;

  make_user_lst;
  make_macro_lst;
  make_boards_dat;

  make_uploads_dat;
  make_zlog_dat;
(*  create_email_brd; *)
  make_events_dat;
  make_lastcall_dat;
  make_verbose_dat;
  make_voting_dat;
  make_shortmsg_dat;
(*  make_mboard('email'); *)
(*  make_mboard('general'); *)
  make_fboard('sysop');
  make_fboard('misc');
  make_rumor_dat;
(*  make_conf_dat; *)
  make_nuv_dat;
  make_oneliner_dat;
  make_lottery_dat;

  ttl('Moving data files into SYSTEM directory');
  movefile1('user.lst',path[1]);
  movefile1('macro.lst',path[1]);
  movefile1('boards.dat',path[1]);
(*  movefile1('conferen.dat',path[1]); *)
  movefile1('events.dat',path[1]);
  movefile1('network.dat',path[1]);
  movefile1('lastcall.dat',path[1]);
  movefile1('lottery.dat',path[1]);
  movefile1('modem.dat',path[1]);
  movefile1('nuv.dat',path[1]);
  movefile1('oneliner.dat',path[1]);
  movefile1('protocol.dat',path[1]);
  movefile1('rumor.dat',path[1]);
  movefile1('shortmsg.dat',path[1]);
  movefile1('string.dat',path[1]);
  movefile1('uploads.dat',path[1]);
  movefile1('verbose.dat',path[1]);
  movefile1('voting.dat',path[1]);
  movefile1('zlog.dat',path[1]);
  movefiles('*.DIR',path[1]);
  movefiles('*.CTL',path[1]);

(*  ttl('Moving message files into MSGS directory');
  movefile1('email.brd',path[2]);
  movefile1('email.mix',path[2]);
  movefile1('general.brd',path[2]);
  movefile1('general.mix',path[2]); *)

  ttl('Moving ANSI text files into TEXT directory');
  movefiles('*.ANS',path[2]);
  movefiles('*.AVT',path[2]);

  ttl('Moving normal text files into TEXT directory');
  movefiles('*.MSG',path[2]);
  movefiles('*.FLT',path[2]);
  movefiles('*.INF',path[2]);
  movefiles('*.TXT',path[2]);

(*  ttl('Moving color configuration files into AFILES directory');
  movefiles('*.CFG',path[5]); *)

(*  ttl('Moving message file into MSGS\EMAIL directory');
  movefile1('a-32767.1',path[2]+'EMAIL\');*)

  ttl('Moving menu files into MENUS directory');
  movefiles('*.MNU',path[4]);
end;

begin
  infield_out_fgrd:=11;
  infield_out_bkgd:=0;
  infield_inp_fgrd:=15;
  infield_inp_bkgd:=1;
  clrscr; textbackground(1); textcolor(15);
  gotoxy(1,1); clreol; gotoxy(7,1);
  write('Revelation BBS v0.95 Initialization Utility - Revelation BBS Systems');
  gotoxy(1,2); clreol; gotoxy(12,2);
  write('(C) 1995 Sameer Khosla.  All Rights Reserved.');
  textbackground(0); textcolor(7);
  window(1,3,80,25);
  writeln;
  assign(systatf,'revelate.dat');
  {$I-} reset(systatf); {$I+}
  if ioresult=0 then begin
    textcolor(28); write('WARNING!!');
    textcolor(14); writeln('  "REVELATE.DAT" file already exists..');
    writeln('Revelation BBS has already been initialized!');
    writeln('If you proceed, ALL DATA FILES WILL BE ERASED AND INITIALIZED!!!');
    writeln;
    if not pynq('Proceed [Y/N]: ') then halt(1);
    writeln;
  end;

  getdir(0,curdir);
  path[1]:=curdir+'\SYSTEM\';
  path[2]:=curdir+'\TEXT\';
  path[3]:=curdir+'\MSGS\';
  path[4]:=curdir+'\MENUS\';
  path[5]:=curdir+'\LOG\';
  path[6]:=curdir+'\WORK\';

  textcolor(14);
  writeln;
  writeln('You will now be prompted several times for names of directorys');
  writeln('that will be used by Revelation BBS.  Each directory will be created');
  writeln('and the appropriate files will be moved there-in.');
  writeln;
  writeln('SYSTEM pathname.  This is the directory where the Revelation BBS data');
  writeln('files and miscellaneous Revelation BBS text files will be located.');
  writeln;
  prt('SYSTEM pathname: '); infielde(path[1],60); writeln; writeln;

  textcolor(14);
  writeln('TEXT pathname.  This is the directory where the Revelation BBS');
  writeln('menu help files, ANSI displays, etc. will be located.');
  writeln;
  prt('TEXT pathname: '); infielde(path[2],60); writeln; writeln;

  textcolor(14);
  writeln('MSGS pathname.  This directory should contain all the message');
  writeln('files (*.BRD, *.MIX, *.TRE) used by Revelation BBS for both private');
  writeln('and public messages.');
  writeln;
  prt('MSGS pathname: '); infielde(path[3],60); writeln; writeln;

  textcolor(14);
  writeln('MENUS pathname.  This is the directory where the Revelation BBS menu');
  writeln('files will be located.');
  writeln;
  prt('MENUS pathname: '); infielde(path[4],60); writeln; writeln;

  textcolor(14);
  writeln('WORK pathname.  Revelation BBS uses this directory to convert between');
  writeln('archive formats, receive batch uploads, and allow users to');
  writeln('decompress archives to download single files, etc.');
  writeln;
  prt('WORK pathname: '); infielde(path[6],60); writeln; writeln;

  clrscr;

 dostuff; 


  writeln;
  star('Revelation BBS installed and initialized successfully!');
  star('This program, "INITREV.EXE", can now be deleted.');
  star('Thanks for using Revelation!');
end.

