{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit file11;

interface

uses
  crt,dos,overlay,
  myio,
  common;

function cansee(f:ulfrec):boolean;
procedure fbasechange(var done:boolean; mstr:astr);
procedure createtempdir;
procedure fbasestats;

implementation

Uses Emulate, file0, file1;


function cansee(f:ulfrec):boolean;
begin
  cansee:=((not (notval in f.filestat)) or (aacs(systat.seeunval)));
end;

function isulr:boolean;
begin
  isulr:=((systat.uldlratio) and (not systat.fileptratio));
end;


procedure fbasechange(var done:boolean; mstr:astr);
var s:astr;
    i,temp:integer;
    count:byte;
begin
  if (mstr<>'') then
    case mstr[1] of
      '+':begin
            i:=realfbase(fileboard);
            if i<maxfboard then begin
              changefileboard(fconfpk^[i+1]);
              lastcommandovr:=true;
            end else sprint('Highest Accessable File Base.');
          end;
      '-':begin
            i:=realfbase(fileboard);
            if i>0 then begin
              changefileboard(fconfpk^[i-1]);
              lastcommandovr:=true;
            end else sprint('Lowest Accessable File Base.');
          end;
      'L':fbaselist;
    else  begin
            temp:=value(mstr);
            if (temp>=0) and (temp<=maxfboard) then begin
              changefileboard(fconfpk^[temp]);
              lastcommandovr:=true;
            end else sprint('Base Not Within Acceptable Range.');
          end;
  end else begin
    if (novice in thisuser.ac) then fbaselist;
    nl;
    s:='?';
    repeat
      prt('^5^1Change File Base ^9[^2?^9/^2List^9]: ^1'); input(s,3);
      if s[1] in ['0'..'9'] then begin
        i:=value(s);
        if (((i>=0) and (i<=maxfboard)) or
           ((i=0) and (copy(s,1,1)='[0'))) and
           (i<>fileboard) then
          changefileboard(fconfpk^[i]);
      end;
      if (s='?') then begin fbaselist; nl; end;
    until (s<>'?') or (hangup);
    lastcommandovr:=TRUE;
  end;
end;

procedure createtempdir;
var s:astr;
    i:integer;
begin
  nl;
  if (maxulb=maxuboards) then print('Too Many File Bases Already.')
  else begin
    print('Enter File Path For Temporary Directory');
    prt(':'); mpl(40); input(s,40);
    if (s<>'') then begin
      s:=fexpand(bslash(TRUE,s));
      fileboard:=maxulb+1;
      sysoplog('Created temporary directory #'+cstr(fileboard)+
               ' in "'+s+'"');
      with tempuboard do begin
        name:='<< Temporary >>';
        filename:='TEMPFILE';
        dlpath:=s;
        ulpath:=s;
        maxfiles:=2000;
        password:='';
        arctype:=0;
        cmttype:=1;
        fbdepth:=0;
        fbstat:=[];
        acs:='s'+cstr(thisuser.sl)+'d'+cstr(thisuser.dsl);
        ulacs:='s'+cstr(thisuser.sl)+'d'+cstr(thisuser.dsl);
        nameacs:='s'+cstr(thisuser.sl)+'d'+cstr(thisuser.dsl);
        for i:=1 to 6 do res[i]:=0;
      end;
      memuboard:=tempuboard;
    end;
  end;
end;

procedure fbasestats;
var s:astr; ft,ctr:integer; ft2:string;
    abort,next:boolean;

  procedure dd(var abort,next:boolean; s1,s2:astr; b:boolean);
  begin
    s1:=#3#5+#3#9+s1+#3#1+' ';
    if (b) then printacr(s1+s2,abort,next)
      else printacr(s1+'None.',abort,next);
  end;

begin
  abort:=FALSE; next:=FALSE;
  nl;
  loaduboard(fileboard);
  with memuboard do begin
    ft:=lenn(memuboard.name)+2;
    ft2:=#3+#5+#3+#9+''; for ctr:=1 to ft do ft2:=ft2+''; ft2:=ft2+'';
    sprint(ft2);
    prt(#3+#5+#3+#9+' '+memuboard.name+#3+#5+#3+#9' '); nl;
    ft2:=#3+#5+#3+#9+''; for ctr:=1 to ft do ft2:=ft2+''; ft2:=ft2+'';
    sprint(ft2);
    ft2:=#3+#5+#3+#9+'  '; for ctr:=1 to ft do ft2:=ft2+''; ft2:=ft2+'';
    sprint(ft2); nl;
    nl;
    dd(abort,next,'Area Password į ','"'+password+'"',(password<>''));
    dd(abort,next,'Max File Capacity į ',cstr(maxfiles),(maxfiles<>0));
    s:=systat.filearcinfo[arctype].ext;
    dd(abort,next,'Archive Format į ','"'+s+'"',(arctype<>0));
    case basetype of
      0:dd(abort,next,'Base Type į ','"Upload And Download"',true);
      1:dd(abort,next,'Base Type į ','"Upload Only"',true);
      2:dd(abort,next,'Base Type į ','"Download Only"',true);
      3:dd(abort,next,'Base Type į ','"Private Only"',true);
    end;
    if (fso) then begin
      nl;
      dd(abort,next,'Filename į ','"'+filename+'.DIR"',TRUE);
      dd(abort,next,'DL file path į ','"'+dlpath+'"',TRUE);
    end;
  end;
end;
end.
