{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : SYSOP2A.PAS                                                   
  Description: System Configuration - Modem Configuration                    
  Version    : v0.1500                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2a;

interface

uses
  crt, dos, overlay,
  cuser,
  common;

procedure pomodem;

implementation

const
  aresure='Are You Sure This Is What You Want';

function wantit:boolean;
begin
  nl; wantit:=pynq(aresure);
end;

procedure noch;
begin
  print('No change.');
end;

function showmodemstring(s:astr):astr;
var o:astr;
    i:integer;
begin
  o:='';
  for i:=1 to length(s) do
    case s[i] of
      ^@..^L,^N..^[:
         o:=o+'^'+chr(ord(s[i])+64);
      ^M:o:=o+'|';
    else
         o:=o+s[i];
    end;
  showmodemstring:=o;
end;

procedure newmodemstring(var vs:astr; what:astr; len:integer);
var i:integer;
    changed:boolean;
begin
  print('Current modem '+what+' string: "'+showmodemstring(vs)+'"');
  nl;
  print('Use: "^" preceding control codes (^@..^[)');
  print('     "|" for a carriage return');
  print('     "~" for a half-second delay');
  nl;
  print('Enter NEW modem '+what+' string:');
  prt(':');
  if (len>78) then mpl(78) else mpl(len);
	inputwn1(vs,len,'E',changed);
  if (changed) then begin
    for i:=1 to length(vs) do
      case vs[i] of
        '|':vs[i]:=^M;
        '^':if ((i<>length(vs)) and (vs[i+1] in ['@'..'['])) then begin
              vs[i]:=chr(ord(vs[i+1])-64);
              delete(vs,i+1,1);
            end;
      end;
  end else
    noch;
end;

(*
function whatflags:astr;
var s:string[64];
begin
  with modemr do begin
    if (ctschecking) then s:='CTS check ON, ' else s:='CTS check OFF, ';
    if (dsrchecking) then s:=s+'DSR check ON, ' else s:=s+'DSR check OFF, ';
    if (usexonxoff) then s:=s+'XON/XOFF ON, ' else s:=s+'XON/XOFF OFF, ';
    if (hardwired) then s:=s+'"Hard-wired" carrier' else s:=s+'Normal carrier';
  end;
  whatflags:=s;
end;
*)

procedure pomodem;
var
 s:string[80];
 i,c1,c2,cc:integer;
 c,ccc:char;
 abort,next,done,changed:boolean;

Function GetBaudRate: Longint;
Var
 InSpeed: string[5];
 OutBaud: LongInt;
Begin
 Prt('Enter New Baud: ');
 Inputmain(inspeed,5,'UE');
 outbaud:=0;
 inspeed:=stripextraspaces(inspeed);
 If InSpeed='300' Then outbaud:=300
 Else If InSpeed='1200' Then outbaud:=1200
 Else If InSpeed='2400' Then outbaud:=2400
 Else If InSpeed='4800' Then outbaud:=4800
 Else If InSpeed='9600' Then outbaud:=9600
 Else If InSpeed='14400' Then outbaud:=14400
 Else If InSpeed='19200' Then outbaud:=19200
 Else If InSpeed='38400' Then outbaud:=38400;
 If outbaud<>0 Then Getbaudrate:=outbaud;
End;

Function GetConnectCode(CodePrompt,Oldcode: String): String;
Var
 Newcode:String[20];
Begin
 nl;
 sprompt(#3#5+'Result for '#3#5+Codeprompt+#3#3' : '+#3#5);
 inputmain(newcode,20,'UE');
 if newcode='' then exit;     {iM Test}
 GetConnectCode:=newcode;
End;

Function GetResultCode(CodePrompt,Oldcode: String): String;
Var
 Newcode:String[14];
Begin
 nl;
 sprompt(#3#5+'Result for '#3#5+Codeprompt+#3#3' : '+#3#5);
 inputmain(newcode,14,'UE');
 if newcode='' then exit;     {iM Test}
 GetResultCode:=newcode;
End;

begin
  done:=FALSE;
  repeat
    with modemr do begin
      cls;
      sprint(#3#5+'Modem configuration');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr('1. Maximum baud rate    : '+cstrl(maxbaud),abort,next);
      printacr('2. COM port number      : '+cstr(comport),abort,next);
      printacr('3. Modem init string    : "'+showmodemstring(init)+'"',abort,next);
      printacr('4. Modem answer string  : "'+showmodemstring(answer)+'"',abort,next);
      printacr('5. Modem hangup string  : "'+showmodemstring(hangup)+'"',abort,next);
      printacr('6. Modem offhook string : "'+showmodemstring(offhook)+'"',abort,next);
      printacr('7. No-call init time    : '+cstr(nocallinittime),abort,next);
      printacr('8. Remote DOS Re-Direct : '+RemoteRedir,abort,next);
      printacr('9. COM Port Locked      : '+syn(lockedport),abort,next);
      If lockedport then
       printacr('0. Locked Baud Rate     : '+cstrl(lockedbaud),abort,next);

      printacr('A. Force baud rates?    : '+syn(forcerate),abort,next);
      nl;
      printacr('B. CONNECT 300    : '+CONNECT_300,abort,next);
      printacr('C. CONNECT 1200   : '+CONNECT_1200,abort,next);
      printacr('D. CONNECT 2400   : '+CONNECT_2400,abort,next);
      printacr('E. CONNECT 4800   : '+CONNECT_4800,abort,next);
      printacr('F. CONNECT 9600   : '+CONNECT_9600,abort,next);
      printacr('G. CONNECT 14400  : '+CONNECT_14400,abort,next);
      printacr('H. CONNECT 19200  : '+CONNECT_19200,abort,next);
      printacr('I. CONNECT 38400  : '+CONNECT_38400,abort,next);
(*
      printacr('J. ERROR          : '+ERROR,abort,next);
      printacr('K. BUSY           : '+BUSY,abort,next);
*)
      printacr('L. NO CARRIER     : '+NO_CARRIER,abort,next);
      printacr('M. OK             : '+OK,abort,next);
      printacr('N. RING           : '+RING,abort,next);
(*
      printacr('O. NO DIALTONE    : '+NO_DIALTONE,abort,next);
      printacr('P. NO ANSWER      : '+NO_ANSWER,abort,next);
      printacr('R. VOICE          : '+VOICE,abort,next);
*)
      printacr('Z. Modify Flags ',abort,next);

      prt('Enter selection or (Q)uit : ');
      If (not LockedPort) then
       onek(c,'Q123456789ABCDEFGHILMNZ'^M)
      Else onek(c,'Q1234567890ABCDEFGHILMNZ'^M);

      nl;
      case c of
        '1':if (incom) then begin
              sprint(#3#7+'This can only be changed locally!!^M');
              pausescr;
            end else begin
              sprompt(#3#3+'This should be your modem''s MAXIMUM BAUD RATE.');
              nl;
              sprompt(#3#3+'Supported Rates: '+#3#5+'300,1200,2400,4800,9600,14400,19200,38400');
              nl;
              sprompt(#3#3+'The current rate is: '+#3#5+cstrl(maxbaud));
              nl;
              maxbaud:=getbaudrate;
            end;
        '2':if (incom) then begin
              sprint(#3#7+'This can only be changed locally!!^M');
              pausescr;
            end else begin
              prt('Com port (1-4)? '); inu(cc);
              if (cc in [1..4]) then
                if (wantit) then begin
                  remove_port;
                  comport:=cc;
                  iport;
                end
                else noch;
            end;
        '3':newmodemstring(init,'init',80);
        '4':newmodemstring(answer,'answer',40);
        '5':newmodemstring(hangup,'hangup',40);
        '6':newmodemstring(offhook,'offhook',40);
        '7':begin
              prt('No call modem re-initialization: '); inu(c1);
              if (not badini) then nocallinittime:=c1;
            end;
        '8':begin
              sprint(#3#5+'This should be "GATE1" (or "GATE2", etc) if you have it.');
              sprint(#3#5+'OTHERWISE, it should be "COM1" (or "COM2", etc).');
              nl;
              prt('New device: '); mpl(10);
							inputwn1(RemoteRedir,10,'E',changed);
            end;
        '9':lockedport:= not lockedport;
        '0':begin
             nl;
             sprompt(#3#3+'Current Rate: '+#3#5+cstr(lockedbaud));
             sprompt(#3#3'New Rate: ');
             lockedbaud:=getbaudrate;
            end;

        'A': forcerate:=not forcerate;

        'B': CONNECT_300:=getconnectcode('CONNECT 300',CONNECT_300);
        'C': CONNECT_1200:=getconnectcode('CONNECT 1200',CONNECT_1200);
        'D': CONNECT_2400:=getconnectcode('CONNECT 2400',CONNECT_2400);
        'E': CONNECT_4800:=getconnectcode('CONNECT 4800',CONNECT_4800);
        'F': CONNECT_9600:=getconnectcode('CONNECT 9600',CONNECT_9600);
        'G': CONNECT_14400:=getconnectcode('CONNECT 14400',CONNECT_14400);
        'H': CONNECT_19200:=getconnectcode('CONNECT 19200',CONNECT_19200);
        'I': CONNECT_38400:=getconnectcode('CONNECT 38400',CONNECT_38400);

        'J': ERROR:=getresultcode('ERROR',ERROR);
        'K': BUSY:=getresultcode('BUSY',BUSY);
        'L': NO_CARRIER:=getresultcode('NO CARRIER',NO_CARRIER);
        'M': OK:=getresultcode('OK',OK);
        'N': RING:=getresultcode('RING',RING);
        'O': NO_DIALTONE:=getresultcode('NO DIALTONE',NO_DIALTONE);
        'P': NO_ANSWER:=getresultcode('NO ANSWER',NO_ANSWER);
        'R': VOICE:=getresultcode('VOICE',VOICE);

(*
        'R':begin
              prt('Which result code? '); onek(ccc,'Q123456789');
              cc:=ord(ccc)-48;
              if (cc in [1..9]) then begin
                if (cc in [1..3]) then begin
                  prt('Enter new result code: '); inu(c1);
                  if not badini then
                    if wantit then
                      case cc of
                        1:nocarrier:=c1;
                        2:nodialtone:=c1;
                        3:busy:=c1;
                      end
                    else noch;
                end else begin
                  prt('Enter case 1 result code: '); inu(c1);
                  if (not badini) then resultcode[1][cc-4]:=c1;
                  prt('Enter case 2 result code: '); inu(c2);
                  if (not badini) then resultcode[2][cc-4]:=c2;
                end;
              end;
            end;
*)
        'Z':begin
             repeat
              cls;
              print('Do NOT change these flags unless you are having problems with');
              print('your *current* setup, and you KNOW what you are doing!');
              nl;
              sprompt(#3#3+'Current Flags: '+#3#5);
              if ctschecking then sprompt('C');
              if dsrchecking then sprompt('D');
              if usexonxoff then sprompt('X');
              if hardwired then sprompt('H');
              nl;nl;
              print('(C)TS checking, (D)SR checking,');
              print('(X)ON/XOFF, (H)ard-wired carrier');
              nl;
              prt('Which flag: '); onek(c,'QCDHX'^M);
              case c of
                'C':ctschecking:=not ctschecking;
                'D':dsrchecking:=not dsrchecking;
                'H':hardwired:=not hardwired;
                'X':usexonxoff:=not usexonxoff;
              end;
             until (c='Q') or (c=#13);
              c:=#0;
            end;


        'Q':done:=TRUE;
      end;
    end;
  until ((done) or (hangup));

  Reset(ModemF);
  Seek(ModemF,0);
  Write(ModemF,modemr);
  Close(ModemF);
end;

end.
