
program revdoor;

uses dos,crt;

Type

dooruserrec = record            { [RDOOR#.SYS/ROLDI#.SYS] - Door User Recs }
  Name,                         { Users Handle                             }
  Realname  : string[36];       { Users Real Name                          }
  SL,                           { Users Sec. Level                         }
  DSL       : Byte;             { Users File Area Sec. Level               }
  TLToday   : Integer;          { Users Time Left Today                    }
  ANSI,                         { ANSI Bit For AC                          }
  COLOR     : Boolean;          { Color Bit For AC                         }
  FilePoints: Integer;          { Users File Points                        }
  accountnote: string[39];      { Users Public Account Note                }
  sex       : char;             { Users Sex                                }
  bday      : string[8];        { Users Birthday                           }
end;

var door:dooruserrec;
    doorf:file of dooruserrec;
    node:integer;

function value(s:string):longint;
var i:longint;
    j:integer;
begin
  val(s,i,j);
  if (j<>0) then begin
    s:=copy(s,1,j-1);
    val(s,i,j)
  end;
  value:=i;
  if (s='') then value:=0;
end;

function cstr(i:longint):string;
var c:string[16];
begin
  str(i,c);
  cstr:=c;
end;

{$I HEADER.INC}

procedure showhelp;
begin
  textcolor(15); writeln;
  writeln('REVDOOR Usage:'); textcolor(9);
  writeln(''); textcolor(11);
  write('REVDOOR '); textcolor(13);
  write('<Node> '); textcolor(14); write('[ID] [Real]');
  textcolor(13); write(' <SL> <DSL> <Time>'); textcolor(10);
  write(' {ANSI} {COLOR}'); textcolor(13); write(' <FPs>');
  textcolor(14); write(' [ANote] [Sex] [BDay]'); textcolor(11);
  writeln('.');
  writeln; textcolor(15);
  writeln('<> denotes numeric value, [] denotes character value, {} denotes TRUE or FALSE');
  writeln;
  textcolor(5);
  write('Press Any Key...');
  readkey;
end;


procedure processvars;
var tempstr:string;
begin
  if (paramcount<>12) then begin
    textcolor(12);
    writeln; writeln('ERROR: Invalid Number Of Parameters!'); writeln;
    showhelp;
    halt;
  end else begin
    node:=value(paramstr(1));
    door.name:=paramstr(2);
    door.realname:=paramstr(3);
    door.sl:=value(paramstr(4));
    door.dsl:=value(paramstr(5));
    door.tltoday:=value(paramstr(6));
    tempstr:=paramstr(7);
    if (tempstr[1]='T') then door.ansi:=TRUE else door.ansi:=FALSE;
    tempstr:=paramstr(8);
    if (tempstr[1]='T') then door.color:=TRUE else door.color:=FALSE;
    door.filepoints:=value(paramstr(9));
    door.accountnote:=paramstr(10);
    tempstr:=paramstr(11);
    door.sex:=tempstr[1];
    door.bday:=paramstr(12);
  end;
end;

procedure makedoor;
var tdoorf:file of dooruserrec;
begin
  assign(doorf,'RDOOR'+cstr(node)+'.SYS');
  rewrite(doorf);
  write(doorf,door);
  close(doorf);
  textcolor(11);
  writeln;
  writeln('RDOOR'+cstr(node)+'.SYS Written.');
  textcolor(15);
end;


begin
  header('REVDOOR v1.00','011995','Revelation As-A-Door Command Line->RDOOR##.SYS Processor.');
  processvars;
  makedoor;
end.

