{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : MSG2.PAS                                                      
  Description: Message System Stat Screens, Area Lists, Etc.                 
  Version    : v0.2000                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B-,E+,F+,I+,L-,N-,O+,R-,S+,V-}

Unit Msg2;

Interface

Uses Crt,
     Common,
     Msg0,
     Emulate,
     CfgLists;

procedure mbaselist;
procedure mbasechange(var done:boolean; mstr:astr);
procedure mbasestats;
procedure chbds;

Implementation

Procedure mbaselist;
var AreaFileName,s1,os:astr;
    TotMessages,b,b2,i,nd:integer;
    AreaListF:text;
    mixr:msgindexrec;
    InF:Text;


  Procedure AreaList;
  Var
    Acc,Abort,Next,FoundFile:Boolean;
    InF:Text;
    AreaFile,Temp,Work:String;
    BoardNum,BType:String[5];

    Function YesNo(InBoo:Boolean):String;
    Begin
      If InBoo then YesNo:='Yes'
      Else YesNo:='No ';
    End;

  Begin
    If ThisUser.AreaListNumber>0 then begin
      AreaFile:=Systat.TextPath+'MSG'+cstr(ThisUser.AreaListNumber);
      AreaFile:=GetTextFileName(AreaFile);
      If AreaFile='' then FoundFile:=FALSE
      Else FoundFile:=TRUE;
    End Else FoundFile:=FALSE;
    Abort:=FALSE;
    Next:=FALSE;
    if FoundFile then begin
      Assign(InF,AreaFile);
      Reset(InF);
    end;

    CfgListTOP(FoundFile,InF,1);
    if FoundFile then ReadLn(InF,Temp);

    i:=1;
    While (i<=numboards) and (not abort) do begin
      acc:=mbaseac(mconfpk^[i]); { mbaseac will load memboard }

      If ((mbunhidden in memboard.mbstat) or (acc)) then begin
        If (Not FoundFile) or (Pos('AT',Temp)<>0) then begin
          InitMsgFiles(MemBoard.FileName);
          TotMessages := HiMsg + 1;
        End;
        Case memboard.mbtype of
          0:BType:='Local';
          1:BType:='Echo ';
          2:BType:='Group';
          Else BType:='     ';
        End;

        If (acc) then BoardNum:=cstr(i) Else BoardNum:='';

        If Not FoundFile then begin
          varstr:=BoardNum+'~'+memboard.name+'~'+YesNo(checkzscanm(mconfpk^[i]))+'~';
          varstr:=varstr+BType+'~'+YesNo(mbrealname in memboard.mbstat)+'~';
          varstr:=varstr+YesNo(Not (mbfilter in memboard.mbstat))+'~'+cstr(TotMessages);
          abort:=prfmsga('MBALISTO',varstr);
        End Else begin
          Work:=Temp;
          ReplaceCode('AA',YesNo(Not (mbfilter in memboard.mbstat)),0,Work);
          ReplaceCode('AB',BType,0,Work);
          ReplaceCode('AD',memboard.name,40,Work);
          ReplaceCode('AN',BoardNum,0,Work);
          ReplaceCode('AO',Ins(3,BoardNum),0,Work);
          ReplaceCode('AR',YesNo(mbrealname in memboard.mbstat),0,Work);
          ReplaceCode('AS',YesNo(checkzscanm(mconfpk^[i])),0,Work);
          ReplaceCode('AT',cstr(TotMessages),4,Work);
          PrintAcr(Work,Abort,Next);
        End;
        Inc(nd);
      End;
      inc(i);
    End;
    CfgListBOT(FoundFile,InF,1);
    If FoundFile then Close(InF);
  End;

begin
  b:=1; nd:=0;
  AreaList;
  if (nd=0) then prfmsg('MBNOBASE','');
end;

procedure mbasechange(var done:boolean; mstr:astr);
var s:astr;
    i,temp:integer;
begin
  if mstr<>'' then
    case mstr[1] of
      '+':begin
            i:=realmbase(board);
{            if i<numboards then begin   }
              changeboard(mconfpk^[i+1]);
              lastcommandovr:=true;
{            end else sprint('Highest Accessable Message Base.');   }
          end;

      '-':begin
            i:=realmbase(board);
{            if i>1 then begin    }
              changeboard(mconfpk^[i-1]);
              lastcommandovr:=true;
{            end else sprint('Lowest Accessable Message Base.');   }
          end;
      'L':mbaselist;
      else begin
            temp:=value(mstr);
            if (temp>0) and (temp<=numboards) then begin
              changeboard(mconfpk^[temp]);
              lastcommandovr:=true;
            end else prfmsg('MBNOTINR','');
          end;
    end
  else begin
    if (novice in thisuser.ac) then mbaselist;
    s:='?';
    repeat
      prfmsg('MBCHGBAS','');
      input(s,3);
      if s[1] in ['0'..'9'] then begin
        i:=value(s);  (*PACK*)
        if (i>=1) and (i<=numboards) then
          changeboard(mconfpk^[i]);
      end;
      if s='?' then begin mbaselist; nl; end;
    until (s<>'?') or (hangup);
    lastcommandovr:=TRUE;
  end;
end;


procedure mbasestats;
var s:astr;

  function dv(s:string; b:boolean):string; (* Determine Variable *)
  begin
    if (b) then dv:=s else dv:='None.';
  end;

begin
  loadboard(board);
  with memboard do begin

    prfmsg('MBBINFH',memboard.name);

    varstr:=dv('"'+password+'"',(password<>''));
    varstr:=varstr+'~'+dv(cstr(maxmsgs),(maxmsgs<>0));
    case anonymous of
      atno      :varstr:=varstr+'~'+'None allowed';
      atyes     :varstr:=varstr+'~'+'Anonymous posts allowed';
      atforced  :varstr:=varstr+'~'+'All posts forced anonymous';
      atdearabby:varstr:=varstr+'~'+'Dear Abby base';
      atanyname :varstr:=varstr+'~'+'Any Name Goes';
    end;
    prfmsg('MBBINFB',varstr);
    if (mso) then begin
      varstr:=acs+'~'+postacs+'~'+mciacs+'~'+'"'+filename+'.BRD"';
      varstr:=varstr+'~'+dv('"'+msgpath+'"',(mbtype<>0));
      prfmsg('MBBINFS',varstr);
    end;
  end;
end;

procedure chbds;
var s,z:astr;
    i:integer;
    done:boolean;
    tempboard:integer;
begin
  if (novice in thisuser.ac) then mbaselist;
  done:=FALSE;
  repeat
    prfmsg('MBSETZP','');
    Input(s,3);
    if (s='Q') then done:=TRUE;
    if (s='?') then mbaselist;
    {$B-}
    if (length(s)>0) and (s[1] in ['0'..'9']) and (value(s)<=numboards) then
      i:=value(s);
    {$B+}
    if (mbaseac(mconfpk^[i])) then { loads memboard }
      If (i>=1) and (length(s)>0) and (s[1] in ['0'..'9']) then begin
        tempboard:=board;
        z:=memboard.name;
        if (checkzscanm(mconfpk^[i])) then begin
          prfmsg('MBBRDNOT',z);
          loadboard(mconfpk^[i]);
          zscanm.zscan:=false;
          savezscanm;
          loadboard(tempboard);
        end else begin
          prfmsg('MBBRDYES',z);
          loadboard(mconfpk^[i]);
          zscanm.zscan:=true;
          savezscanm;
          loadboard(tempboard);
        end;
      end;
  until (done) or (hangup);
  lastcommandovr:=TRUE;
end;


End.
