{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : MSG1.PAS                                                      
  Description: Messages - Post/Read                                          
  Version    : v0.2000                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B-,E+,F+,I+,L-,N-,O+,R-,S+,V-}

Unit Msg1;

Interface

Uses Crt,  Common,  TimeJunk,  Msg0,  File8,  UEdit,  Msg2;

Procedure UpdatePTR(MsgNum:LongInt; MsgIdx:MsgIndexRec;var ZscanUP:boolean);
Function ToUser(TestMsgIdx: MsgIndexRec): Boolean;
Function WhatAnon(AnonTyp:Byte; s:String) : String;
Function LoadConfigurablePrompt:String;
Procedure ViewMsg(MsgNum:LongInt; Var Abort: Boolean);
Procedure WriteMsg(ReplyToNum: LongInt; ForcedDestination, ForcedTitle: String; EMail: Boolean);
Procedure PostMsg(ForcedDestination, ForcedTitle: String);
Procedure SendEMail(ForcedDestination, ForcedTitle: String);
Procedure ReadMsgs(WaitingOnly: Boolean);
Procedure ReplyMsg(MsgNum: LongInt; Public: Boolean);
Procedure NewScanMsgs(Options: String);
Procedure MoveMsg(MsgNum: LongInt; DestBoard:integer);

Implementation
uses scrlbk;

Procedure UpdatePtr(MsgNum:LongInt; MsgIdx:MsgIndexRec;var ZscanUP:boolean);
Begin
  Reset(MsgIdxF, SizeOf(MsgIndexRec));
  Seek(MsgIdxF, MsgNum);
  BlockRead(MsgIdxF, MsgIdx, 1);
  Close(MsgIdxF);

  If IsNewMsg(MsgIdx) Then Begin
    loadboard(board);
    ZScanm.HiRead := MsgIdx.MsgPostDateTime;
    savezscanm;
    ZscanUp := TRUE;
  End;
End;

Function ToUser(TestMsgIdx: MsgIndexRec): Boolean;
Begin
  If MsgNameMatch(TestMsgIdx.ToInfo.UserName, ThisUser.Name, ThisUser.RealName)
    Then ToUser := TRUE Else ToUser := FALSE;
End;

Function WhatAnon(AnonTyp:Byte; s:String) : String;
Begin
  Case AnonTyp Of
    1,2 : s := '**Anonymous**';
    3 : s := '"Abby"';
    4 : s := '"Problemed Person"';
    Else s := s;
  End;
  WhatAnon := s;
End;

Function LoadConfigurablePrompt:String;
Var
 InF:Text;
 FoundFile:Boolean;
 HeaderFile:String;

Begin
  If ThisUser.HeaderNumber>0 then begin
    HeaderFile:=Systat.TextPath+'HEAD'+cstr(ThisUser.HeaderNumber);
    HeaderFile:=GetTextFileName(HeaderFile);
    If HeaderFile='' then FoundFile:=FALSE Else FoundFile:=TRUE;
  End Else FoundFile:=FALSE;
  If FoundFile then begin
    Assign(InF,HeaderFile);
    Reset(InF);
    ReadLn(InF,HeaderFile);
    LoadConfigurablePrompt:=HeaderFile;
    Close(InF);
  End Else LoadConfigurablePrompt:='';
End;

Procedure ViewMsg(MsgNum:LongInt; Var Abort: Boolean); {* Pass Actual .IDX Number *}
Var
  MsgIdx      : MsgIndexRec;
  s1, s2,
  WorkStr1,
  WorkStr2,
  Work,
  ReadStr,
  HeaderFile  : String;
  Public,
  SeeAnon,
  FoundFile,
  Next        : Boolean;
  Author,
  Destination,
  Subject     : String[30];
  UserNote    : String[25];
  InF         : Text;
  BodyCount   : Integer;
  TotLen      : LongInt;
  QuotePos,
  QuoteColor,
  TxtColor,pass    : Byte;

  function readdelete:boolean;
  var tmp:boolean;
  begin
    tmp:=FALSE;
    Reset(MsgIdxF, SizeOf(MsgIndexRec));
    Seek(MsgIdxF, MsgNum);
    BlockRead(MsgIdxF, MsgIdx, 1);
    if AttrOn(MsgIdx.MsgAttr, Deleted) then begin
      if(    (mso)
      or ( MsgNameMatch(MsgIdx.FromInfo.UserName, ThisUser.name, ThisUser.RealName) )
      or ( (MemBoard.MsgStatus=0) and ToUser(MsgIdx) )
       )
      then tmp:=TRUE else tmp:=FALSE
    end else tmp:=TRUE;
    readdelete:=tmp;
  end;


Begin
  {$I-} Reset(MsgTxtF,1); {$I+}
  If IOResult <> 0 Then Exit;
  Close(MsgTxtF);

  {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
  If IOResult <> 0 Then Exit;
  Seek(MsgIdxF, MsgNum);
  BlockRead(MsgIdxF, MsgIdx, 1);
  Close(MsgIdxF);

  With MsgIdx Do Begin
    Public := TRUE;

    If not Readdelete then begin
      next:=true;
      abort:=true;
      exit;
    end;

    If Public then seeanon:=aacs(systat.anonpubread) Else seeanon:=aacs(systat.anonprivread);
    If (MsgIdx.Anon=2) then SeeAnon:=aacs(systat.csop);

    If ThisUser.HeaderNumber>0 then begin
      HeaderFile:=Systat.TextPath+'HEAD'+cstr(ThisUser.HeaderNumber);
      HeaderFile:=GetTextFileName(HeaderFile);
      If HeaderFile='' then FoundFile:=FALSE Else FoundFile:=TRUE;
    End Else FoundFile:=FALSE;

    Abort:=FALSE;
    Next:=FALSE;

    Author:=FromInfo.UserName;
    If (not seeanon) then Author:=WhatAnon(MsgIdx.Anon,Author);
    If (ToInfo.UserName='') then Destination:='All' Else Destination:=ToInfo.UserName;
    If (MsgIdx.Anon=0) then UserNote:=FromInfo.UserNote Else UserNote:='';

    Subject:=Copy(Title,1,30);
    Subject:=Subject+Ins(30,Subject);

    If Not FoundFile then
      (* do nothing *)
    Else begin
      Assign(InF,HeaderFile);
      Reset(InF);
      ReadLn(InF,ReadStr);  {* First Line=Prompt *}
      ReadLn(InF,ReadStr);
      If ReadStr<>'' then Printacr(ReadStr,abort,next);
      ReadLn(InF,ReadStr);
      If ReadStr<>'' then Printacr(ReadStr,abort,next);
    End;

    BodyCount:=1;

    If Not FoundFile Then Begin (* Do the entire "internal" header *)
      VarStr:=CStr(Msg_On+1)+'~'+CStr(Msg_Total)+'~';
      If (SeeAnon) Or (MsgIdx.Anon=0) Then VarStr:=VarStr+MsgDT(@MsgDateTime)
        Else VarStr:=VarStr+GetMsg('MBHDRUK','');
      VarStr:=VarStr+'~'+Author+' ['+UserNote+']'+'~'+Destination+'~'+Subject;
      PrfMsg('MBMSGHI',VarStr);
    End Else
    While (Not Abort) and (BodyCount<=3) do begin (* Do The HEAD*.MSG Header*)
      If Not FoundFile then
        (* Again, Do Nothing.  We Did It Already. *)
      Else begin
        ReadLn(InF,ReadStr);
        If ReadStr<>'' then begin
          Work:=ReadStr;

          ReplaceCode('HA',Author,0,Work);
          ReplaceCode('HB',Ins(30,Author),0,Work);

          If SeeAnon Or (MsgIdx.Anon=0) Then s1:=Msgdt(@MsgDateTime)
          Else s1:=getmsg('MBHDRUK','');

          ReplaceCode('HD',s1,15,Work);
          ReplaceCode('HF',Destination,0,Work);
          ReplaceCode('HG',Ins(30,Destination),0,Work);
          ReplaceCode('HN',UserNote,0,Work);
          ReplaceCode('HO',Ins(25,UserNote),0,Work);
          ReplaceCode('HR',cstr(Msg_On + 1),4,Work);
          ReplaceCode('HS',Subject,0,Work);
          ReplaceCode('HT',cstr(Msg_Total),4,Work);

          PrintAcr(Work,Abort,Next);
        End;
      End;
      Inc(BodyCount);
    End;

    If Not FoundFile then begin
      (* You Guessed It! Don't Do Squat! *)
    End
    Else While (Not Eof(InF)) and (Not Abort) do begin
      ReadLn(InF,ReadStr);
      Printacr(ReadStr,abort,next);
    End;
    If FoundFile then Close(InF);

    If Not Abort then begin
      reading_a_msg:=TRUE; read_with_mci:=FALSE;
      Abort:=FALSE; Next:=FALSE;

      QuoteColor := 5;  TxtColor := 1;
      If MemBoard.MBType In [1,2] Then Begin
        QuoteColor := MemBoard.Quote_Color;
        TxtColor := MemBoard.Text_Color;
      End;

      Reset(MsgTxtF,1);
      Seek(MsgTxtF, MsgIdx.MsgPtr);

      TotLen:=0;
      If (ReadDelete) Then
      Repeat
        BlockReadStr(MsgTxtF, ReadStr);
        Inc(TotLen, Length(ReadStr) + 2);

        QuotePos := Pos('>', StripColor(ReadStr));
        If Not (Pos(^[, ReadStr) > 0) And Not DosAnsiOn Then
          If (QuotePos > 0) And (QuotePos < 5) Then ReadStr := #3+Chr(QuoteColor) + ReadStr + #3+Chr(TxtColor);
        if (okscrollback) and not (pos(#27+'[A',readstr)=1) then addtoscroll(wherey-1);
        PrintAcr(ReadStr, Abort, Next);
        if (okscrollback) and (totlen>=msgidx.msglength) then addtoscroll(wherey-1);
      Until Abort Or (TotLen >= MsgIdx.MsgLength);

      Close(MsgTxtF);
      myscrolly:=wherey;
      read_with_mci:=FALSE;
      reading_a_msg:=FALSE;

      prfmsg('MBMSGEND','');
      If AttrOn(MsgIdx.MsgAttr, Deleted) Then prfmsg('MBMSGDEL','');

      If DosAnsiOn Then RedrawForAnsi;
    End;

  End;
End;


Procedure WriteMsg(ReplyToNum: LongInt; ForcedDestination, ForcedTitle: String; EMail: Boolean);
Var Ok         : Boolean;
    TempMsgIdx,
    MsgIdx     : MsgIndexRec;
    ValidName  : Boolean;
    i,
    UserCount  : Integer;

  Procedure Nope(s,v:String);
  Begin
   If Ok Then prfmsg(s,v);
   Ok:=FALSE;
  End;

  Procedure IncrementOther;
  Var tmpu:userrec; d:boolean;
      tmpuf:file of userrec;
  Begin
    assign(tmpuf,systat.systempath+'USER.LST');
    reset(tmpuf); d:=FALSE;
    while (not (eof (tmpuf))) and (not (d)) do begin
      read(tmpuf,tmpu);
      if ((allcaps(tmpu.name))=allcaps(msgidx.toinfo.username)) then begin
        inc(tmpu.incomingmail);
        seek(tmpuf,filepos(tmpuf)-1); write(tmpuf,tmpu);
        d:=TRUE;
      end;
   end;
   close(tmpuf);
 End;


Begin
  Ok:=TRUE;
  LoadBoard(Board);

  If Not EMail Then Begin
    if (not aacs(memboard.postacs)) then
      nope('MBNOATP','');
    if ((rpost in thisuser.ac) or (not aacs(systat.normpubpost))) then
      nope('MBNOATPA','');
    if ((ptoday>=systat.maxpubpost) and (not mso)) then
      nope('MBTOOMNY','');
  End
  Else Begin
    if ((remail in thisuser.ac) or (not (aacs(systat.normprivpost)))) then
      nope('MBNOATMA','');
    if ((etoday>=systat.maxprivpost) and (not mso)) then
      nope('MBTOOMEM','');
  End;

  If Ok Then Begin
    ClearMsgIdx(MsgIdx);

    if (MBRealName in MemBoard.MBStat) then MsgIdx.FromInfo.UserName := ThisUser.RealName
      else MsgIdx.FromInfo.UserName := ThisUser.Name;

    MsgIdx.FromInfo.UserNote := ThisUser.AccountNote;
    MsgIdx.ToInfo.UserName := ValidUser(ForcedDestination);

    If ReplyToNum <> -1 Then Begin
      {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
      If IOResult <> 0 Then Exit;
      Seek(MsgIdxF, ReplyToNum);
      BlockRead(MsgIdxF, TempMsgIdx, 1);
      Close(MsgIdxF);

      MsgIdx.ToInfo.UserName := TempMsgIdx.FromInfo.UserName;

      If MsgIdx.ToInfo.UserName = '' Then MsgIdx.ToInfo.UserName := ' ';
      MsgIdx.Title := TempMsgIdx.Title;
    End
    Else If MsgIdx.ToInfo.UserName = '' Then Begin
      ValidName := FALSE;
      If MemBoard.MsgStatus <> 0 Then prfmsg('MBCR4ALL','')
      Else prfmsg('MBCRABT','');
      Repeat
        prfmsg('MBWHOTO',''); Mpl(30);
        If MemBoard.MsgStatus <> 0 Then MsgIdx.ToInfo.UserName := 'All'
        Else MsgIdx.ToInfo.UserName := '';
        InputMain(MsgIdx.ToInfo.UserName,30,'DL');

        If MemBoard.MsgStatus = 0 Then Begin
          ForcedDestination := ValidUser(MsgIdx.ToInfo.UserName);

          If ForcedDestination <> '' Then Begin
            ValidName := TRUE;
            For i := 1 to Length(MsgIdx.ToInfo.UserName) Do sprompt(^H' '^H);
            MsgIdx.ToInfo.UserName := ForcedDestination;
            prfmsg('MBREOTO',MsgIdx.ToInfo.UserName);
          End;

          If MsgIdx.ToInfo.UserName = '' Then ValidName := TRUE; {* Abort *}
        End
        Else ValidName := TRUE;

        prfmsg('MBTOISOK','');
        If Not ValidName then prfmsg('MBTONTOK','');
      Until (Hangup) Or (ValidName);
    End;

    If MsgIdx.ToInfo.UserName <> '' Then If Not Hangup Then Begin
      GetPackDateTime(@MsgIdx.MsgDateTime);
      GetPackDateTime(@MsgIdx.MsgPostDateTime);

      If InputMsg(MsgIdx, ForcedTitle) Then Begin
        SysOpLog('+ "'+MsgIdx.Title+'" posted on '+#3#5+memboard.name);
        SysOpLog('  To: "'+MsgIdx.ToInfo.UserName+'"');

        TopScr;

        prfmsg('MBNL','');

        If (MemBoard.MsgStatus=0) Then Inc(ThisUser.EMailSent) Else Inc(ThisUser.MsgPost);
        Inc(PToday);
        Inc(Systat.TodayZLog.PubPost);
        If (MemBoard.MsgStatus=0) And (MemBoard.MBType=0) Then IncrementOther;
        InitMsgFiles(MemBoard.FileName);
      End;
    End;

  End;
End;

Procedure PostMsg(ForcedDestination, ForcedTitle: String);
Begin
  WriteMsg(-1, ForcedDestination, ForcedTitle, FALSE);
End;

Procedure SendEMail(ForcedDestination, ForcedTitle: String);
Var SavBoard : Integer;
Begin
  SavBoard:=Board;

  If Board <> Systat.EMailBoard Then ChangeBoard(Systat.EMailBoard);
  If Board = Systat.EMailBoard Then WriteMsg(-1, ForcedDestination, ForcedTitle, TRUE);

  Board := SavBoard;
  LoadBoard(Board);
End;



Procedure DoRead(Var Quit:Boolean; StartMsgNum:Word; WaitingOnly, IsNewScan: Boolean);  {* Undefined *}
Var Done          : Boolean;
    ValidCmds,
    WorkStr,
    TempString,
    CmdStr        : String;
    Cmd           : Char;

    FirstMsg,
    LastMsg,
    WorkMsgNum,
    GetMsg1,
    MsgNum        : LongInt;
    EditAuthor,
    TempConf,
    ThreadCode,
    TotLoad       : Integer;
    B,
    Compress,
    PubReply,
    AskPost,
    ContinousList,
    Abort, Ok,
    ShowMsg,
    WasOut,
    ZScanUp       : Boolean;
    MIdx,
    MsgIdx        : MsgIndexRec;
    ExtractedMsgF : Text;    {was 'T'}

{label penis;  What is this doing here?}

  Procedure CBounds;
  Begin
    WasOut:=((MsgNum<0) or (MsgNum>Msg_Total-1));
    If (Not WasOut) Then Exit;
    If (MsgNum>Msg_Total) Then MsgNum:=Msg_Total
      Else If (MsgNum<0) Then MsgNum:=0;
  End;

  Procedure ScanTitles;
  Var MIdx:MsgIndexRec;
      S,Alias:String;
      FTo,FFrom,FTit:String;
      FCtr,FZ1,FZ2,FL,FL2,FL3:Integer;
      J,NumDone:Word;
      Public,SeeAnon,Abort,Next,NDone:Boolean;

  Begin
    ZscanUP :=FALSE;
    fctr:=1; fz1:=0; fz2:=0; ndone:=TRUE; abort:=FALSE; numdone:=0; Public:=TRUE;
    If Public Then SeeAnon:=AACS(Systat.Anonpubread) Else Seeanon:=Aacs(Systat.Anonprivread);
    If (MsgIdx.Anon=2) Then SeeAnon:=Aacs(Systat.csop);
    prfmsg('MBTITSCP','');

    CBounds; If WasOut Then Exit;

    prfmsg('MBTITSCH','');

    While ((Not HangUp) And (Not Abort) And (NumDone<10) And (NDone)) Do Begin
    CBounds; If (WasOut) Then NDone:=FALSE;
      If (NDone) Then Begin
        {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
        If IOResult <> 0 Then Exit;
        Seek(MsgIdxF, MsgNum);
        BlockRead(MsgIdxF, MIdx, 1);
        Close(MsgIdxF);
        With MIdx Do Begin
          Alias:=AllCaps(ThisUser.Name);

          FFrom:=FromInfo.UserName;

          If (Not SeeAnon) Then FFrom:=WhatAnon(Anon,FFrom);
          If (ToInfo.UserName='') Then FTo:='All' Else FTo:=ToInfo.UserName;
          If (Copy(AllCaps(FromInfo.UserName),1,Length(Alias))=Alias) Then FZ1:=1;
          If (Copy(AllCaps(ToInfo.UserName),1,Length(Alias))=Alias) Then FZ2:=1;
          varstr:=cstr(msgnum+1);
        End;

        TempString:=MsgDT(@MIdx.MsgDateTime);
        If (Length(TempString) > 8) Then TempString[0]:=Chr(8)
        Else For J:=Length(TempString) To 8 Do TempString[J]:=' ';
        TempString[8]:=' ';
        varstr:=varstr+'~'+tempstring;

        If (IsNewMsg(MIdx)) Then
          varstr:=' * '+'~'+varstr
        Else If (AttrOn(MIdx.MsgAttr,UnValidated)) Then
          varstr:='NV '+'~'+varstr
        Else
          varstr:='   '+'~'+varstr;

        If ((Not (AttrOn(MIdx.MsgAttr,UnValidated))) Or (Mso)) Then Begin
          FTit:=MIdx.Title; FL3:=Length(FTit);
          If (FL3 > 20) then FTit[0]:=Chr(20)
            Else Begin
              FCtr:=1;
              While (FCtr < 21) Do Begin
                If (FCtr > FL3) Then FTit:=FTit+' ';
                Inc(FCtr);
              End;
            End;
          varstr:=varstr+'~'+ftit;
        End;

        If ((Not (AttrOn(MIdx.MsgAttr,UnValidated))) Or (Mso)) Then Begin
          FL:=Length(FFrom);
          If (FL > 15) Then FFrom[0]:=Chr(15)
          Else Begin
            FCtr:=1;
            While (FCtr < 16) Do Begin
              If (FCtr > FL) Then FFrom:=FFrom+' ';
              Inc(FCtr);
            End;
          End;
          If (FZ1=1) Then Begin
            varstr:=varstr+'~'+getmsg('MBYOUCLR','')+FFrom; FZ1:=0;
          End Else
            varstr:=varstr+'~'+FFrom;
        End;

        If ((Not (AttrOn(MIdx.MsgAttr,UnValidated))) Or (Mso)) Then Begin
          FL2:=Length(FTo);
          If (FL2 > 15) Then FTo[0]:=Chr(15)
          Else Begin
            FCtr:=1;
            While (FCtr < 16) Do Begin
              If (FCtr > FL2) Then FTo:=FTo+' ';
              Inc(FCtr);
            End;
          End;
          If (FZ2=1) Then Begin
            varstr:=varstr+'~'+getmsg('MBYOUCLR','')+FTo; FZ2:=0;
          End Else
            varstr:=varstr+'~'+FTo;
        End;

{        PrintAcr(S,Abort,Next); }
        prfmsg('MBTITSCO',varstr);

        WKey(Abort,Next);
        Inc(NumDone);
        Inc(MsgNum); Inc(Msg_On);
      End;
    End;
    Dec(MsgNum); Dec(Msg_On);
    UpdatePTR(MsgNum,MsgIdx,ZscanUP);
    prfmsg('MBTITSCB','');
  End;

  Function Threading(Forward:Boolean;TTit:String):Integer;
  Var MIdx:MsgIndexRec;
      MTit:String;
      TempReturn,MNum:Integer;
      Abort,Next,NDone:Boolean;

    Procedure CBound;
    Begin
      WasOut:=((MNum<0) or (MNum>Msg_Total-1));
      If (Not WasOut) Then Exit;
      If (MNum>Msg_Total) Then MNum:=Msg_Total
        Else If (MNum<0) Then MNum:=0;
    End;

    Function Match:Boolean;
    Var Temp:String;
        LthM,LthT,C:Integer;

    Begin
      Match:=FALSE; Temp:='';

      LthM:=Length(MTit); LthT:=Length(Ttit);  (* Set Lengths *)
      Mtit:=allcaps(Mtit); TTit:=allcaps(Ttit); (* Set To Caps *)

      Temp:=MTit;
      If Length(Temp) > 1 Then
        Temp[0]:=Chr(2); (* Remove any RE:'s from the string *)
      If (Temp='RE') then
        delete(Mtit,1,4);

      Temp:=TTit;
      If Length(Temp) > 1 Then
        Temp[0]:=Chr(2); (* Remove any RE:'s from the string *)
      If (Temp='RE') then
        delete(Ttit,1,4);

      If (MTit=TTit) then Match:=TRUE;
    End;


  Begin
    ndone:=TRUE; abort:=FALSE; TempReturn:=-1; MNum:=Msg_On;
    If Forward then Inc(MNum) else Dec(MNum);

    CBound; If WasOut Then Exit;

    While ((Not HangUp) And (Not Abort) And (NDone)) Do Begin
      CBound;
      If (WasOut) Then NDone:=FALSE;
      If (NDone) Then Begin
        {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
        If IOResult <> 0 Then Exit;
        Seek(MsgIdxF, MNum);
        BlockRead(MsgIdxF, MIdx, 1);
        Close(MsgIdxF);

        MTit:=MIdx.Title;
        If Match then begin TempReturn:=MNum; NDone:=FALSE; end;

        WKey(Abort,Next);
        If Forward Then Inc(MNum) Else Dec(MNum);
      End;
    End;
    Threading:=TempReturn;
  End;

  procedure scaninput(var s:string; allowed:string);
  var os:string;
      i:integer;
      c:char;
      gotcmd:boolean;
  begin
    gotcmd:=FALSE; s:='';
    repeat
      getkey(c); c:=upcase(c);
      os:=s;
      if ((pos(c,allowed)<>0) and (s='')) then begin gotcmd:=TRUE; s:=c; end
      else
      if (pos(c,'0123456789')<>0) then begin
        if (length(s)<5) then s:=s+c;
      end
      else
        if ((s<>'') and (c=^H)) then s:=copy(s,1,length(s)-1)
      else
        if (c=^X) then begin
          for i:=1 to length(s) do prompt(^H' '^H);
          s:=''; os:='';
        end
      else
      if (c=#13) then gotcmd:=TRUE;

      if (length(s)<length(os)) then prompt(^H' '^H);
      if (length(s)>length(os)) then prompt(copy(s,length(s),1));
    until ((gotcmd) or (hangup));
    nl; (*?*)
  end;

{UpDatePtr cut here}

  Procedure ToggleAttr(Attribute: Word; OnStr, OffStr: String);

  Begin
    Reset(MsgIdxF, SizeOf(MsgIndexRec));
    Seek(MsgIdxF, MsgNum);
    BlockRead(MsgIdxF, MsgIdx, 1);

    If Not AttrOn(MsgIdx.MsgAttr, Attribute) Then Begin
      SetAttr(MsgIdx.MsgAttr, Attribute, TRUE);
      prfmsg('MBTOGON',OnStr);
      {If message is deleted it is UNCONDITIONALLY set to Scanned.}
      if (Attribute=Deleted) and (memboard.mbtype=1) then begin
        SetAttr(Msgidx.MsgAttr, Scanned, TRUE);
        prfmsg('MBTOGNS','');
      end;
    End
    Else Begin
      SetAttr(MsgIdx.MsgAttr, Attribute, FALSE);
      prfmsg('MBTOGOFF',OffStr);
    End;

    Seek(MsgIdxF, MsgNum);
    BlockWrite(MsgIdxF, MsgIdx, 1);
    Close(MsgIdxF);
  End;


  Procedure CheckBounds;

    Procedure LastMessage;
    Begin
      WorkMsgNum := MsgNum;
      Dec(WorkMsgNum);
      Seek(MsgIdxF, WorkMsgNum);
      BlockRead(MsgIdxF, MsgIdx, 1);

      While Not ToUser(MsgIdx) And (WorkMsgNum > 0) Do Begin
        Dec(WorkMsgNum);
        Seek(MsgIdxF, WorkMsgNum);
        BlockRead(MsgIdxF, MsgIdx, 1);
      End;

      If ToUser(MsgIdx) Then Begin
        MsgNum := WorkMsgNum;
        If Compress Then Dec(Msg_On) Else Msg_On := MsgNum;
      End;
    End;

    Procedure NextMessage;
    Begin
      WorkMsgNum := MsgNum;
      Inc(WorkMsgNum);
      Seek(MsgIdxF, WorkMsgNum);
      BlockRead(MsgIdxF, MsgIdx, 1);

      While Not ToUser(MsgIdx) And (WorkMsgNum < HiMsg) Do Begin
        Inc(WorkMsgNum);
        Seek(MsgIdxF, WorkMsgNum);
        BlockRead(MsgIdxF, MsgIdx, 1);
      End;

      If ToUser(MsgIdx) And (MsgNum <> WorkMsgNum) Then Begin
        MsgNum := WorkMsgNum;
        If Compress Then Inc(Msg_On) Else Msg_On := MsgNum;
      End
      Else Begin
        If Not ContinousList Then Done := TRUE
        Else ContinousList := FALSE;
      End;
    End;

  Begin
    ShowMsg := FALSE;

    If Not WaitingOnly Then Begin
      If GetMsg1 <> 0 Then Begin
        If (GetMsg1 = -3) Then Dec(MsgNum)
        Else If (GetMsg1 = -1) Then Inc(MsgNum)
        Else If (GetMsg1 > 0) Then MsgNum := GetMsg1 - 1;

        Msg_On := MsgNum;
        ShowMsg := TRUE;

        If ((MsgNum < 0) Or (MsgNum > HiMsg)) Then Begin
          Done := TRUE;    {957}
          ContinousList := FALSE;
        End;

      End;
    End

    Else Begin
      Reset(MsgIdxF, SizeOf(MsgIndexRec));

      If GetMsg1 <> 0 Then Begin

        If (GetMsg1 = -3) And (MsgNum > 0) Then LastMessage
        Else If (GetMsg1 = -1) And (MsgNum < HiMsg) Then NextMessage
        Else If (GetMsg1 > 0) And (GetMsg1 <= Msg_Total) Then Begin
          If (GetMsg1 <= LastMsg + 1) And (GetMsg1 > Msg_On + 1) Then
            Repeat
              NextMessage;
            Until Done Or (Msg_On + 1 >= GetMsg1)
          Else If (GetMsg1 >= FirstMsg + 1) And (GetMsg1 < Msg_On + 1) Then
            Repeat
              LastMessage;
            Until Done Or (Msg_On + 1 <= GetMsg1)
          Else If (GetMsg1 > LastMsg + 1) Then NextMessage
          Else If (GetMsg1 < LastMsg + 1) Then LastMessage;
        End

        Else If (MsgNum > HiMsg) Or ((GetMsg1 = -1) And (MsgNum = HiMsg)) Then Begin
          If Not ContinousList Then Done := TRUE
          Else ContinousList := FALSE;
        End;

        ShowMsg := TRUE;
      End;

      Close(MsgIdxF);
    End;

    GetMsg1 := 0;
  End;

  Procedure ScanFirstLast;
  Begin
    If WaitingOnly Then Begin
      Reset(MsgIdxF, SizeOf(MsgIndexRec));
      Seek(MsgIdxF, MsgNum);
      BlockRead(MsgIdxF, MsgIdx, 1);
      While Not ToUser(MsgIdx) And (MsgNum < HiMsg) Do Begin
        BlockRead(MsgIdxF, MsgIdx, 1);
        Inc(MsgNum);
      End;

      If Not Compress Then Begin
        Msg_On := MsgNum;
        FirstMsg := MsgNum;
      End
      Else FirstMsg := 0;

      If Not ToUser(MsgIdx) Then Begin
        Done := TRUE; AskPost := FALSE;
        prfmsg('MBNOWAIT','');
      End
      Else Begin
        LastMsg := MsgNum;
        WorkMsgNum := HiMsg;
        While (WorkMsgNum > MsgNum) And (LastMsg = MsgNum) Do Begin
          Seek(MsgIdxF, WorkMsgNum);
          BlockRead(MsgIdxF, MsgIdx, 1);
          If ToUser(MsgIdx) Then LastMsg := WorkMsgNum;
          Dec(WorkMsgNum);
        End;
      End;

      Close(MsgIdxF);
    End

    Else Begin
      FirstMsg := Msg_On;
      LastMsg := Msg_Total;
    End;
  End;

  Procedure MsgTotal;
  Begin
    If Compress And WaitingOnly Then Msg_Total := GetMsgTotal(ThisUser.Name, ThisUser.RealName)
    Else Msg_Total := HiMsg + 1;
  End;

Begin
  Done := FALSE; Quit := FALSE; Abort := FALSE;
  ContinousList := FALSE; AskPost := TRUE;
  ZScanUp := FALSE;
  Compress := MemBoard.MsgStatus = 0;

  If (MemBoard.MsgStatus = 0) And (Not MSo Or IsNewScan) Then WaitingOnly := TRUE;

  MsgNum := StartMsgNum;

  If Compress And WaitingOnly Then Begin
    Msg_On := 0;
    Reset(MsgIdxF, SizeOf(MsgIndexRec));
    For WorkMsgNum := MsgNum -1 DownTo 0 Do Begin
      Seek(MsgIdxF, WorkMsgNum);
      BlockRead(MsgIdxF, MsgIdx, 1);
      If ToUser(MsgIdx) Then Inc(Msg_On);
    End;
    Close(MsgIdxF);
  End
  Else Msg_On := MsgNum;

  MsgTotal;
  ScanFirstLast;

  GetMsg1 := -2;

  While Not Done And Not Hangup Do Begin
    CheckBounds;

    If Not Done Then Begin
      If ShowMsg Then Begin
        If ThisUser.ClsMsg And Not ContinousList Then Cls;
        ViewMsg(MsgNum, Abort);
        UpdatePtr(MsgNum,MsgIdx,ZscanUP);
      End;

      If ContinousList And Not Abort Then
        If MsgNum = HiMsg Then Abort := TRUE;

      If Not ContinousList Or Abort Then Begin
        If ContinousList Then Begin
        ContinousList := FALSE;
        prfmsg('MBCMLOFF','');
      End;

      (* NOTE: ENTIRE MESSAGE READ MENU SHOULD BE A .MNU FILE! *)

      prfmsg('MBSCANPT',''); (* CONFIG. PROMPT GOES HERE *)
      ValidCmds := '-=ACDEHNPQRTZ?\{}';
      if mso then validcmds:=validcmds+'XM';
      if mso and (memboard.mbtype in [1,2]) then validcmds := validcmds + 'SK';
      if mso and (memboard.msgstatus <> 0) then validcmds := validcmds + '!V';
      ScanInput(CmdStr, ValidCmds);
    End
    Else CmdStr := '';

    If CmdStr = '' Then CmdStr := '=';
    GetMsg1 := Value(CmdStr);
    If (GetMsg1 = 0) Then Cmd := CmdStr[1]
    Else Cmd := #0;

    Case Cmd Of   {9513 -- remed out to allow before newscan readings..}
      '-':If {(MsgNum = FirstMsg) Or} (MsgNum = 0) Or (Msg_On = 0) Then
            prfmsg('MBATFM','')
          Else GetMsg1 := -3;
      '=':GetMsg1 := -1;
      'A':GetMsg1 := -2; {* Ignore & Re-Display *}
      'C':if (MsgNum+1 < LastMsg) then Begin
            ContinousList := TRUE; Abort := FALSE;
            GetMsg1 := -1;
            prfmsg('MBCMLON','');
          End else prfmsg('MBNOM2L','');
      'D':Begin
            Reset(MsgIdxF, SizeOf(MsgIndexRec));
            Seek(MsgIdxF, MsgNum);
            BlockRead(MsgIdxF, MsgIdx, 1);
            Close(MsgIdxF);
            If WaitingOnly Or Mso Or MsgNameMatch(MsgIdx.FromInfo.UserName, ThisUser.Name, ThisUser.RealName) Then Begin
              If Not AttrOn(MsgIdx.MsgAttr, Permanent) Then
                ToggleAttr(Deleted, getmsg('MBMSGDL',''), getmsg('MBMSGUDL',''))
              Else prfmsg('MBMISP','');
            End
            Else prfmsg('MBINSACC','');
          End;
      'E':if cso then begin
            Reset(MsgIdxF, SizeOf(MsgIndexRec));
            Seek(MsgIdxF, MsgNum);
            BlockRead(MsgIdxF, MsgIdx, 1);
            Close(MsgIdxF);
            Search4user(MsgIdx.FromInfo.UserName, EditAuthor);
            EditUsers(EditAuthor);      { User Editor w/ Current Poster }
          End;
      'H':Begin
            Reset(MsgIdxF, SizeOf(MsgIndexRec));
            Seek(MsgIdxF, MsgNum);
            BlockRead(MsgIdxF, MsgIdx, 1);
            Close(MsgIdxF);
            loadboard(board);
            zscanm.hiread:=Msgidx.MsgPostDateTime;
            SaveZScanm;
            prfmsg('MBHIPTRS',cstr(Msg_On + 1));
          End;
      'M':if mso then MoveMsg(MsgNum, -1) else prfmsg('MBINSACC','');
      'N':Begin
            Done := TRUE;
            AskPost := FALSE;
          End;
      'P':Begin
            PostMsg('', '');
            prfmsg('MBAFTPOS','');
            MsgTotal;
          End;
      'Q':Begin
            Quit := TRUE;
            Done := TRUE;
          End;
      'R':Begin
            prfmsg('MBB4POS','');
            PubReply := TRUE;
            ReplyMsg(MsgNum, PubReply);
            prfmsg('MBAFTPOS','');
            MsgTotal;
          End;
      'T':if memboard.msgstatus<>0 then ScanTitles else
          prfmsg('MBNOEMT','');
      '{':Begin
            If (Msg_On=0) Then
              prfmsg('MBNOSIND','')
            else begin
              Reset(MsgIdxF, SizeOf(MsgIndexRec));
              Seek(MsgIdxF, MsgNum);
              BlockRead(MsgIdxF, MsgIdx, 1);
              Close(MsgIdxF);
              ThreadCode:=-1; ThreadCode:=Threading(FALSE,MsgIdx.Title);
              If ThreadCode>-1 then begin
                Msg_On:=ThreadCode; MsgNum:=ThreadCode;
                GetMsg1:=-2;
              end else prfmsg('MB1STMSG','');
            end;
          end;
      '}':Begin
            If (Msg_On=Msg_Total-1) Then
              prfmsg('MBNOSIND','')
            else begin
              Reset(MsgIdxF, SizeOf(MsgIndexRec));
              Seek(MsgIdxF, MsgNum);
              BlockRead(MsgIdxF, MsgIdx, 1);
              Close(MsgIdxF);
              ThreadCode:=-1; ThreadCode:=Threading(TRUE,MsgIdx.Title);
              If ThreadCode>-1 then begin
                Msg_On:=ThreadCode; MsgNum:=ThreadCode;
                GetMsg1:=-2;
              end else prfmsg('MBLSTMSG','');
            end;
          end;
      'X':if (mso) then begin
            prfmsg('MBWHATFN','');
            input(tempstring,40);
            if (tempstring='') then Tempstring:=systat.textpath+'MSGEXT.TXT';
            if pynq(getmsg('MBWMTF','')) then begin
              b:=pynq(getmsg('MBSCCFF',''));
              {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
              If IOResult <> 0 Then Exit;
              Seek(MsgIdxF, MsgNum);
              BlockRead(MsgIdxF, MsgIdx, 1);
              Close(MsgIdxF);

              Reset(MsgTxtF,1);
              Seek(MsgTxtF, MsgIdx.MsgPtr);

              assign(ExtractedMsgF,tempstring);
              rewrite(ExtractedMsgF);
              totload:=0;

              repeat
                tempstring:='';
                BlockReadStr(MsgTxtF,tempstring);
                inc(totload,length(tempstring)+2);
                if ((b) and (pos(#3,tempstring)<>0)) then tempstring:=stripcolor(tempstring);
                writeln(ExtractedMsgF,TempString);
              until (totload>=MsgIdx.msglength);
              close(MsgTxtF);
              close(ExtractedMsgF);

              prfmsg('MBDONEXF','');
            end;
          end else prfmsg('MBINSACC','');
      '\':begin
            prfmsg('MBDLINF','');
            b:=pynq(getmsg('MBSCCFM',''));

            {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
            If IOResult <> 0 Then Exit;
            Seek(MsgIdxF, MsgNum);
            BlockRead(MsgIdxF, MsgIdx, 1);
            Close(MsgIdxF);

            Reset(MsgTxtF,1);
            Seek(MsgTxtF, MsgIdx.MsgPtr);

            assign(ExtractedMsgF,systat.textpath+'DLTEMP.MSG');
            rewrite(ExtractedMsgF);
            totload:=0;
            repeat
              BlockReadStr(MsgTxtF,TempString);
              inc(totload,length(TempString)+2);
              if ((b) and (pos(#3,TempString)<>0)) then TempString:=stripcolor(TempString);
              writeln(ExtractedMsgF,TempString);
            until (totload>=MsgIdx.msglength);
            close(MsgTxtF);
            close(ExtractedMsgF);
            prfmsg('MBDLRDY','');
            send1(systat.textpath+'DLTEMP.MSG',ok,abort);
            erase(ExtractedMsgF);
            prfmsg('MBDLDUN','');
          end;
      'Z':If checkzscanm(Board) Then Begin
            loadboard(board);
            zscanm.zscan:=false;
            savezscanm;
            prfmsg('MBMBNOTS',stripcolor(memboard.name));
          End Else Begin
            loadboard(board);
            zscanm.zscan:=true;
            savezscanm;
            prfmsg('MBMBWILS',stripcolor(memboard.name));
          End;
      '!':ToggleAttr(Permanent, getmsg('MBMSGPS',''),getmsg('MBMSGNPS',''));
      'S':ToggleAttr(Scanned, getmsg('MBMSGSS',''), getmsg('MBMSGNSS',''));
      'V':ToggleAttr(UnValidated, getmsg('MBMSGUVS',''), getmsg('MBMSGVS',''));
      'K':ToggleAttr(DelSent, getmsg('MBMSGWDS',''), getmsg('MBMSGWSS',''));
      '?':Begin
            prfmsg('MBMSGSHP','');
            if mso and (memboard.msgstatus <> 0) then
              prfmsg('MBMSGSH1','');
            if mso then
              prfmsg('MBMSGSH2','');
            if mso and (memboard.mbtype in [1,2]) then
              prfmsg('MBMSGSH3','');
              {^2[^3F^2] ^4Modify Fido Attributes}
            if cso then prfmsg('MBMSGSH4','');
            prfmsg('MBMSGSHB','');
          End;
    End;

    {IF EMAIL, PRIVATE, TO THIS USER, MOVING TO ANOTHER MSG, NOT DEL'd... }
    if (memboard.msgstatus=0) and (GetMsg1<>-2) or (Done) then begin
      dyny:=True;
      {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
      If IOResult <> 0 Then Exit;
      Seek(MsgIdxF, MsgNum);
      BlockRead(MsgIdxF, MsgIdx, 1);
      Close(MsgIdxF);
      if ( (not AttrOn(MsgIdx.MsgAttr, Deleted)) and ToUser(MsgIdx) )
       then if pynq(getmsg('MBDELMSQ','')) then ToggleAttr(Deleted,getmsg('MBMSGDL',''),getmsg('MBMSGUDL',''));
      dyny:=False;
    end;
  End; (*? what is this to*)

  End; {* While Do Loop *}

  If AskPost And (Not Quit) And (aacs(MemBoard.PostACS))
      And ((Not (rpost in thisuser.ac)) and (ptoday<systat.maxpubpost)) Then Begin
    prfmsg('MBPREPQ','');
    If Pynq(getmsg('MBPOMBQ',Memboard.Name)) Then PostMsg('', '');
  End;
  If (Memboard.MsgStatus=0) And (MemBoard.MbType=0) Then Thisuser.IncomingMail:=Msg_Total;
End;


Procedure ReadMsgs(WaitingOnly: Boolean);
Var Quit : Boolean;
Begin
  LoadBoard(Board);
  if (memboard.msgstatus=0) and (connectspd<>'KB') then waitingonly:=TRUE;
  InitMsgFiles(MemBoard.FileName);
  If HiMsg <> -1 Then DoRead(Quit, 0, WaitingOnly, FALSE)
    Else prfmsg('MBNOMSGO',memboard.name);
End;


Procedure ReplyMsg(MsgNum: LongInt; Public: Boolean);
Var QuoteF  : Text;
    MsgIdx  : MsgIndexRec;
    TotLen  : LongInt;
    ReadStr : String;

Begin
  Assign(QuoteF, 'MSGTMP');
  Rewrite(QuoteF);

  {$I-} Reset(MsgTxtF,1); {$I+}
  If IOResult <> 0 Then Exit;
  Close(MsgTxtF);

  {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
  If IOResult <> 0 Then Exit;
  Seek(MsgIdxF, MsgNum);
  BlockRead(MsgIdxF, MsgIdx, 1);
  Close(MsgIdxF);

  Reset(MsgTxtF,1);
  Seek(MsgTxtF, MsgIdx.MsgPtr);
  TotLen:=0;
  Repeat
    BlockReadStr(MsgTxtF, ReadStr);
    Inc(TotLen, Length(ReadStr) + 2);
    WriteLn(QuoteF, '> '+StripColor(ReadStr));
  Until TotLen >= MsgIdx.MsgLength;

  Close(MsgTxtF);
  Close(QuoteF);

  WriteMsg(MsgNum, '', '', FALSE);
  prfmsg('MBNL',''); (*?*)
End;


Procedure NewScanMsgs(Options:String);
Var SavBoard    : Integer;
    Next,
    Quit        : Boolean;
    MsgNum      : LongInt;
    MsgIdx      : MsgIndexRec;
    WaitingOnly : Boolean;

  Procedure NewScanBoard(BoardNumber: Integer);
  Begin
    If Not Quit Then Begin
      If Board <> BoardNumber Then ChangeBoard(BoardNumber);
      If Board = BoardNumber Then Begin
        WaitingOnly := MemBoard.MsgStatus = 0;
        lil := 0;
        BlockAbort:=TRUE; PrintF('NEWSCANM');

        InitMsgFiles(MemBoard.FileName);

        If HiMsg > -1 Then Begin
          MsgNum := 0;

          Reset(MsgIdxF, SizeOf(MsgIndexRec));
          BlockRead(MsgIdxF, MsgIdx, 1);

          While (MsgNum < HiMsg) And Not (IsNewMsg(MsgIdx) And ((Not WaitingOnly) Or ToUser(MsgIdx))) Do Begin
            Inc(MsgNum);
            BlockRead(MsgIdxF, MsgIdx, 1);
          End;

          Close(MsgIdxF);

          If (MsgNum <= HiMsg) And (IsNewMsg(MsgIdx) And ((Not WaitingOnly) Or ToUser(MsgIdx)))
            Then DoRead(Quit, MsgNum, FALSE, TRUE);

        End;
      End;
      WKey(Quit, Next);
    End;
  End;

  Procedure NewScanAllBoards;
  Var b:longint;
  Begin
    NodeUpDate(getmsg('NDNEWSAB',''));
    SysOpLog('NewScan of All Message Boards in Current Conference');
    quit:=false;
    b:=1;
    while (b<=numboards) and (not quit) and (not hangup) do begin
      If checkzscanm(mconfpk^[b]) Then NewScanBoard(mconfpk^[b]);
      inc(b);
    end;
    NodeUpDate(getmsg('NDAVL4PG',''));
  End;

Begin
  SavBoard := Board;
  Options := AllCaps(Options);
  Quit := FALSE; Next := FALSE;
  If Options = 'C' Then NewScanBoard(board)
  Else If Options = 'G' Then NewScanAllBoards
  Else If Value(Options) > 0 Then NewScanBoard(Value(Options))
  Else Begin
    If Pynq(getmsg('MBNEWSAA','')) Then NewScanAllBoards Else NewScanBoard(Board);
  End;

  Board := SavBoard;
  LoadBoard(Board);
End;

Procedure MoveMsg(MsgNum:LongInt; DestBoard: integer);   {* Pass Actual .IDX Number *}

{
	MsgNum : -1 = Prompt User for Message Number
		 -2 = Last Message in block
		 xx = forced number
}

var s           : string;
    i           : integer;
    MsgIdx      : MsgIndexRec;
    ReadStr     : String;
    BodyCount   : Integer;
    TotLen      : LongInt;
    TempMsgTxtF : Text;
    TempMsgTxt  : String;   {NAME of above file}
    origboard   : integer;

begin
  if (mso) then begin

  {Save old board # for Deletion Purposes later}
  origBoard:=Board;

  {Input Destination Board Number}
  if DestBoard=-1 then begin
    prfmsg('MBMOVINF','');
    s:='?';
    repeat
      prfmsg('MBMOVPMT','');
      input(s,3);
      if s[1] in ['0'..'9'] then begin
        i:=value(s);  (*PACK*)
        if (i>=1) and (i<=numboards) then
          DestBoard:=mconfpk^[i];
      end;
      if s='?' then begin mbaselist; {nl;} end;
    until (s<>'?') or (hangup) or (s='Q');
  end;  { input for destboard NUMBER }

  {Read msg's INDEX into MsgIdx variable}

  {$I-} Reset(MsgIdxF, SizeOf(MsgIndexRec)); {$I+}
  If IOResult <> 0 Then Exit;
  if MsgNum <> -2 Then Seek(MsgIdxF, MsgNum)
    else Seek(MsgIdxF,FileSize(MsgIdxF)-1);
  BlockRead(MsgIdxF, MsgIdx, 1);
  Close(MsgIdxF);

  {Open Text file, move to current Text}

  {$I-} Reset(MsgTxtF,1); {$I+}
  If IOResult <> 0 Then Exit;
  Seek(MsgTxtF, MsgIdx.MsgPtr);
  TotLen:=0;

  { Open Temporary Text File }

  TempMsgTxt := WorkPath+'3\REVTMP01.MSG';
  Assign(TempMsgTxtF, TempMsgTxt);
  Rewrite(TempMsgTxtF);

  { Read Text Info --> Output to T-File }

  Repeat
    BlockReadStr(MsgTxtF, ReadStr);
    Inc(TotLen, Length(ReadStr) + 2);
    WriteLn(TempMsgTxtF, ReadStr);
  Until (TotLen >= MsgIdx.MsgLength);

  Close(MsgTxtF);
  Close(TempMsgTxtF);

  { Dump Text File and Index --> New Base }

  DumpMsg(MsgIdx, TempMsgTxt, MemBoard.FileName);


  { Delete old message }

  loadboard(origboard);
  Reset(MsgIdxF, SizeOf(MsgIndexRec));
  Seek(MsgIdxF, MsgNum);
  BlockRead(MsgIdxF, MsgIdx, 1);
  If Mso Or MsgNameMatch(MsgIdx.FromInfo.UserName, ThisUser.Name, ThisUser.RealName) Then Begin
   If Not AttrOn(MsgIdx.MsgAttr, Permanent) Then SetAttr(MsgIdx.MsgAttr, Deleted, TRUE)
     Else prfmsg('MBMISP','');
  End
  Else prfmsg('MBINSACC','');
  Close(MsgIdxF);

  { pack old base? }

 end else prfmsg('MBNOA2MM','');
end;  {end subroutine}

End.
