{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : MISC1.PAS                                                     
  Description: Lists/Voting/Time Bank                                        
  Version    : v0.2000                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit misc1;

Interface

uses
  crt, dos, overlay,
  common, common1;


Procedure ListLastCallers(CallerFile:String);
Procedure ListAvailableNodes(NodeFile:String);
Procedure TypeTextFile(OptionStr:astr;totype:integer);
Procedure ToggleFlags(ToggleStr:astr; Var Flags:FlagSet);
procedure reqchat(Why:astr; ToUser:UserNameStr);
procedure TimeBank(s:astr);
function ctp(t,b:longint):astr;
procedure vote;

Implementation

Uses File0, Msg1, CfgLists;

Procedure ListLastCallers(CallerFile:String);
Var
 BackDays,CallCount,Tmp:Integer;
 Abort,Next,FoundFile:Boolean;
 InF:Text;
 Temp,Work:String;
Begin
 BackDays:=99;
 If (Value(CallerFile)>0) or (Copy(CallerFile,1,1)='0') then begin
  BackDays:=Value(CallerFile);
  Delete(CallerFile,1,Length(cstr(BackDays)));
  If Pos(';',CallerFile)<>0 then Delete(CallerFile,Pos(';',CallerFile),1);
 End
 Else begin
  prfmsg('MSCLRCPT','');
  mpl(2);
  Input(Temp,2);
  BackDays:=Value(Temp);
 End;
 CallerFile:=GetTextFileName(CallerFile);
 If CallerFile='' then FoundFile:=FALSE
 Else FoundFile:=TRUE;

 Abort:=FALSE;
 Next:=FALSE;

 if FoundFile then begin
  Assign(InF,CallerFile);
  Reset(InF);
 End;

 CfgListTOP(FoundFile,InF,4);
 if FoundFile then ReadLn(InF,Temp);

 Assign(LastCallF,Systat.SystemPath+'LASTCALL.DAT');
 {$I-} Reset(LastCallF); {$I+}
 If (IOResult<>0) then Rewrite(LastCallF);
 CallCount:=0;
 While (Not Abort) and (CallCount<=FileSize(LastCallF)-1) do begin
  Seek(LastCallF,CallCount);
  Read(LastCallF,LastCall);
  tmp:=lastcall.nodeid; if tmp=255 then tmp:=0;
  If LastCall.DaysOld<=BackDays then begin
   If Not FoundFile then begin
     varstr:=lastcall.username+'~'+lastcall.baudrate+'~'+lastcall.date+'~'+lastcall.timeon+'~'+cstr(lastcall.nodeid);
     prfmsg('MSCLRCOT',varstr);
   End Else begin
    Work:=Temp;

    ReplaceCode('LU',LastCall.UserName,30,Work);
    ReplaceCode('LB',LastCall.BaudRate,20,Work);
    ReplaceCode('LD',LastCall.Date,8,Work);
    ReplaceCode('LT',LastCall.TimeOn,5,Work);
{   ReplaceCode('LN',cstr(LastCall.NodeID),1,Work);}
    ReplaceCode('LN',cstr(tmp),1,work);

    PrintAcr(Work,Abort,Next);
   End;
  End;
  Inc(CallCount);
 End;
 Close(LastCallF);

 CfgListBOT(FoundFile,InF,4);

 If FoundFile then Close(InF);
End;

Procedure ListAvailableNodes(NodeFile:String);
Var
 LineFil:Integer;
 Abort,Next,FoundFile:Boolean;
 InF:Text;
 Temp,Work:String;
Begin
 NodeFile:=GetTextFileName(NodeFile);
 If NodeFile='' then FoundFile:=FALSE
 Else FoundFile:=TRUE;

 Abort:=FALSE;
 Next:=FALSE;

 if FoundFile then begin
   Assign(InF,NodeFile);
   Reset(InF);
 end;

 CfgListTOP(FoundFile,InF,5);
 if FoundFile then Readln(InF,Temp);

 For LineFil:=1 to 9 do begin
  Assign(OnLineF,GetEnv('REV')+'\USERON.'+cstr(LineFil));
  {$I-} Reset(OnLineF); {$I+}
  If IOResult=0 then begin
   Read(OnLineF,OnLine);
   If Not FoundFile then begin
     varstr:=online.handle+'~'+online.status+'~'+cstr(linefil);
     prfmsg('MSCNLOUT',varstr);
   End Else begin
    Work:=Temp;

    ReplaceCode('NN',cstr(LineFil),1,Work);
    ReplaceCode('NS',OnLine.Status,39,Work);
    ReplaceCode('NU',OnLine.Handle,30,Work);

    PrintAcr(Work,Abort,Next);
   End;
   Close(OnLineF);
  End;
 End;

 CfgListBOT(FoundFile,InF,5);

 If FoundFile then Close(InF);
End;


Procedure TypeTextFile(OptionStr:astr;totype:integer);
Var
 DLk,Points:boolean;
 FileName:string[12];
 pl,rn:integer;
 f:ulfrec;
Begin
 OptionStr:=AllCaps(OptionStr);
 Points:=Pos('P',OptionStr)<>0;
 DLk:=Pos('K',OptionStr)<>0;

 If (MemUBoard.Res[3]=1) then begin
  if (totype <= 0) then begin
    prfmsg('MSCFILET','');
    mpl(12);
    Input(FileName,12);
  end else filename:=cstr(totype);
  FiScan(pl);
  If (baddlpath) then exit;
  If (Value(FileName)>0) and (Length(FileName)=Length(cstr(Value(FileName))))
  then begin
   rn:=Value(FileName);
   If rn>pl then rn:=0;
  End
  Else begin
   FileName:=Align(FileName);
   RecNo(FileName,pl,rn);
  End;
  Setc(7);
  If (rn=0) then prfmsg('MSCFNF','')
  Else begin
   fiscan(pl);
   seek(ulff,rn); read(ulff,f);
   PrintF(MemUBoard.DLPath+f.filename);

   If (not (fbnoratio in memuboard.fbstat)) and (DLk) then begin
    Inc(ThisUser.downloads);
    ThisUser.dk:=thisuser.dk+(f.blocks div 8);
   End;

   If (not (fbnoratio in memuboard.fbstat))
     and (Points)
       and (not aacs(systat.nofilepts))
          and (not (fnofilepts in thisuser.ac))
            and (f.filepoints>0)
              then dec(thisuser.filepoints,f.filepoints);

   If (thisuser.filepoints<0) then thisuser.filepoints:=0;

   Inc(systat.todayzlog.downloads);
   Inc(systat.todayzlog.dk,(f.blocks div 8));
  End;

 End
 Else prfmsg('MSCFTNA','')

End;


Procedure ToggleFlags(ToggleStr:astr; Var Flags:FlagSet);
Var
 Count:integer;
 ToggleChar:char;
Begin
  ToggleStr:=AllCaps(ToggleStr);
  For Count:=1 to Length(ToggleStr) do begin
    If Count<Length(ToggleStr) then begin
      Case ToggleStr[Count] of
         '/','!':Begin
                   While (ToggleStr[Count+1] in ['A'..'Z']) and (Count<Length(ToggleStr)) do begin
                     ToggleChar:=ToggleStr[Count+1];  Inc(Count);
                     If ToggleChar in Flags then Flags:=Flags-[ToggleChar]
                       Else Flags:=Flags+[ToggleChar];
                   End;
                 End;
         '+':Begin                                                {<=}
               While (ToggleStr[Count+1] in ['A'..'Z']) and (Count<Length(ToggleStr)) do begin
                 ToggleChar:=ToggleStr[Count+1];  Inc(Count);
                 Flags:=Flags+[ToggleChar];
               End;
             End;
         '-':Begin
               While (ToggleStr[Count+1] in ['A'..'Z']) and (Count<Length(ToggleStr)) do begin
                 ToggleChar:=ToggleStr[Count+1];  Inc(Count);
                 Flags:=Flags-[ToggleChar];
               End;
             End;
      End;   {Case ToggleStr[Count]}
    End;
  End;
End;



procedure reqchat(Why:Astr; ToUser:UserNameStr);
var c,ii,i:integer;
    r:char;
    chatted:boolean;
    s: astr;
begin
  If (why='') then why:=getmsg('MSCWHYDF','');
  if ((chatt<systat.maxchat) or (cso)) then begin

    sprint(why);
    chatted:=FALSE;

    prfmsg('MSCCHATP',''); mpl(70); inputl(s,70);

    if (s<>'') then begin
      inc(chatt);
      if ((not sysop) or (rchat in thisuser.ac)) then
        if (length(s)<64) then
          sysoplog(#3#4+'Chat attempt: "'+#3#5+s+#3#4+'"')
        else begin
          sysoplog(#3#4+'Chat attempt:');
          sl1(#3#4+' "'+#3#5+s+#3#4+'"');
        end
      else begin
        ChatActivated:=TRUE;
        sl1(#3#4+'Chat: "'+#3#5+s+#3#4+'"');
        prfmsg('MSCCALL1','');
        CommandLine('[F10] to Chat  [C+F10] for Vertical  [A+F10] for Horizontal  [ENTER] Shut Up');
{        CommandLine('Press <SPACE> to chat or <ENTER> to SHUT UP for rest of call');  }
        ii:=0; c:=0;
        repeat
          inc(ii);
          if (outcom) then sendcom1(^G);
          prfmsg('MSCCALL2','');
          if (outcom) then sendcom1(^G);
          if (shutupchatcall) then delay(1500)
          else
            for i:=1 to 8 do begin
              sound(800); delay(33);
              sound(1300); delay(35);
              sound(1700); delay(37);
              sound(2100); delay(39);
              sound(3200); delay(45);
              sound(2100); delay(39);
              sound(1700); delay(37);
              sound(1300); delay(35);
              sound(800);
            end;
          nosound;
          if (keypressed) then begin
            r:=readkey;
            case r of
              #68:begin   {F10}
                    commandline('');
                    chatted:=TRUE; chatt:=0;
                    pap:=0;
                    chat;
                  end;
              #103:begin  {CTRL-F10}
                     commandline('');
                     chatted:=TRUE; chatt:=0;
                     pap:=0;
                     SplitChat(2,1,2,41,20,37,False);
                   end;
              #113:begin  {ALT-F10}
                     commandline('');
                     chatted:=true; chatt:=0;
                     pap:=0;
                     SplitChat(2,1,13,1,10,79,True);
                   end;
              ^M:shutupchatcall:=TRUE;
            end;
          end;
        until ((chatted) or (ii=15) or (hangup));
        prfmsg('MSCCALL3','');
      end;
      if (not chatted) then begin
        chatr:=s;
        {NL;}
        printf('nosysop');
        If ToUser <> '' Then
          If pynq(getmsg('MSCSENDF','')) then SendEMail(ToUser, getmsg('MSCTRYCH',''));
      end else
        chatr:='';
      tleft;
    end;
  end else begin
    printf('goaway');
    sysoplog('Tried chatting more than '+cstr(systat.maxchat)+' times');
    If ToUser = '' then ToUser := 'SYSOP';
    If Pynq(getmsg('MSCSENDF','')) then
      SendEMail(ToUser, getmsg('MSCTRYLT',cstr(systat.maxchat)));
  end;
end;


procedure TimeBank(s:astr);
var lng,maxperday,maxever:longint;
    zz:integer;
    oc:astr;
    c:char;

  function cantdeposit:boolean;
  begin
    cantdeposit:=TRUE;
    if ((thisuser.timebankadd>=maxperday) and (maxperday<>0)) then exit;
    if ((thisuser.timebank>=maxever) and (maxever<>0)) then exit;
    cantdeposit:=FALSE;
  end;

begin
  maxperday:=value(s); maxever:=0;
  if (pos(';',s)<>0) then maxever:=value(copy(s,pos(';',s)+1,length(s)));
  if ((maxever<>0) and (thisuser.timebank>maxever)) then
    thisuser.timebank:=maxever;


  prfmsg('MSCTBHDR',ver+verstatus);
  if (not cantdeposit) then
    prfmsg('MSCTBM1','');
  prfmsg('MSCTBM2','');
  if (choptime=0.0) then
    prfmsg('MSCTBM3','');
  prfmsg('MSCTBM4','');
  if (choptime<>0.0) then
    prfmsg('MSCTBE1','');
  if (cantdeposit) then begin
    if ((thisuser.timebankadd>=maxperday) and (maxperday<>0)) then
      prfmsg('MSCTBE2','');
    if ((thisuser.timebank>=maxever) and (maxever<>0)) then
      prfmsg('MSCTBE3','');
  end;
  varstr:=cstr(thisuser.timebank)+'~'+cstr(trunc(nsl) div 60);
  if (thisuser.timebankadd<>0) then prfmsg('MSCTBS1',varstr+'~'+cstr(thisuser.timebankadd))
  else prfmsg('MSCTBS2',varstr);

  if (maxever<>0) then varstr:=cstr(maxever)+' Max' else varstr:=getmsg('MSCTBSNM','');
  if (maxperday<>0) then prfmsg('MSCTBS3',varstr+'~'+cstr(maxperday))
  else prfmsg('MSCTBS4',varstr);

  prfmsg('MSCTBPMT','');
  oc:='QG';
  if (choptime=0.0) then oc:=oc+'W';
  if (not cantdeposit) then oc:=oc+'A';
  onek(c,oc);
  case c of
    'A':begin
          prfmsg('MSCTBAHM','');
          inu(zz); lng:=zz;
          prfmsg('MSCTBAHZ','');
          if (not badini) then
            if (lng>0) then
              if (lng>trunc(nsl) div 60) then
                prfmsg('MSCTBAE1','')
              else
                if (lng+thisuser.timebankadd>maxperday) and (maxperday<>0) then
                  prfmsg('MSCTBAE2',cstr(maxperday))
                else
                  if (lng+thisuser.timebank>maxever) and (maxever<>0) then
                    prfmsg('MSCTBAE3',cstr(maxever))
                  else begin
                    inc(thisuser.timebankadd,lng);
                    inc(thisuser.timebank,lng);
                    dec(thisuser.tltoday,lng);
                    varstr:=cstr(thisuser.timebank)+'~'+cstr(trunc(nsl) div 60);
                    prfmsg('MSCTBAOK',varstr);
                    sysoplog('TimeBank: Deposited '+cstr(lng)+' minutes.');
                  end;
              end;
          'G':hangup:=TRUE;
          'W':begin
                prfmsg('MSCTBWHM','');
                inu(zz); lng:=zz;
                prfmsg('MSCTBWHZ','');
                if (not badini) then
                  if (lng>thisuser.timebank) then
                    prfmsg('MSCTBWE1','')
                  else
                    if (lng>0) then begin
                      dec(thisuser.timebankadd,lng);
                      if (thisuser.timebankadd<0) then thisuser.timebankadd:=0;
                      dec(thisuser.timebank,lng);
                      inc(thisuser.tltoday,lng);
                      varstr:=cstr(thisuser.timebank)+'~'+cstr(trunc(nsl) div 60);
                      prfmsg('MSCTBWOK',varstr);
                      sysoplog('TimeBank: Withdrew '+cstr(lng)+' minutes.');
                    end;
                  end;
  end;
end;

function ctp(t,b:longint):astr;
var s,s1:astr;
    n:real;
begin
  if ((t=0) or (b=0)) then begin
    ctp:='  0.0%';
    exit;
  end;
  n:=(t*100)/b;
  str(n:5:1,s);
  s:=s+'%';
  ctp:=s;
end;

function vote1x(answeringall:boolean; qnum:integer; var vd:vdatar):boolean;
var s,pva:astr;
    i,tv:integer;
    c:char;
    abort,next,changed,doneyet,b:boolean;

  procedure showvotes(stats,nocom:boolean);
  var s:astr;
      i:integer;
  begin
    prfmsg('MSCVQHDR',cstr(qnum)+'~'+vd.question);
    tv:=0;
    for i:=1 to vd.numa do inc(tv,vd.answ[i].numres);
    if (tv=0) then tv:=1;
    prfmsg('MSCVPCT',ctp(tv,systat.numusers));
    abort:=FALSE; i:=1;
    if (nocom) then begin
      prfmsg('MSCVNOC','');
      pva:='Q0';
    end else
      pva:='';
    while (i<=vd.numa) do begin
      if (not abort) then begin
        if (i=thisuser.vote[qnum]) then varstr:='*' else varstr:=' ';
        varstr:=varstr+'~'+cstr(i)+'~'+vd.answ[i].ans;
        if (stats) then begin
          varstr:=varstr+'~'+mn(vd.answ[i].numres,3)+'~'+ctp(vd.answ[i].numres,tv);
          prfmsg('MSCVQL1',varstr);
        end else prfmsg('MSCVQL2',varstr);
      end;
      pva:=pva+cstr(i);
      inc(i);
    end;
  end;

begin
  changed:=FALSE;
  if (vd.numa<>0) then begin
    doneyet:=(thisuser.vote[qnum]<>0);
    showvotes(doneyet,not systat.forcevoting);
    prfmsg('MSCURVOT',vd.answ[thisuser.vote[qnum]].ans);

    if (not (rvoting in thisuser.ac)) and (not hangup) then begin

      if (answeringall) then b:=TRUE else b:=pynq(getmsg('MSCCHGVQ',''));
      if (b) then begin
        prfmsg('MSCVSELC',cstr(vd.numa));
        onek(s[1],pva);
        s[0]:=#1; i:=value(s);
        if (s<>'') and (i>=0) and (i<=vd.numa) then begin
          if (thisuser.vote[qnum]<>0) then
            dec(vd.answ[thisuser.vote[qnum]].numres);
          thisuser.vote[qnum]:=i;
          if (i<>0) then inc(vd.answ[i].numres);
          changed:=TRUE;

          if (not answeringall) then showvotes(TRUE,FALSE);
        end;
      end;
    end;
  end else
    if (not answeringall) then prfmsg('MSCINAVQ','');
  vote1x:=changed;
end;

procedure vote;
var vdata:file of vdatar;
    vd:vdatar;
    i,j,int2,vna:integer;
    s,i1,ij:astr;
    abort,next,done,lq,waschanged:boolean;

  procedure getvote(qnum:integer);
  begin
    seek(vdata,qnum-1); read(vdata,vd);
  end;

  procedure vote1(answeringall:boolean; qnum:integer);
  begin
    getvote(qnum);
    if (vote1x(answeringall,qnum,vd)) then begin
      seek(vdata,qnum-1);
      write(vdata,vd);
      waschanged:=TRUE;
    end;
  end;

begin
  s:=''; done:=FALSE; lq:=TRUE; waschanged:=FALSE;
  assign(vdata,systat.systempath+'voting.dat');
  {$I-} reset(vdata); {$I+}
  if (ioresult<>0) then prfmsg('MSCSNOVT','')
  else begin
    sysoplog(' Entered Voting Section');
    repeat
      done:=FALSE;
      ij:='Q?';
      abort:=FALSE;
      if (lq) then prfmsg('MSCLISTQ','');
      int2:=0;
      for i:=1 to numvoteqs do begin
        getvote(i);
        if vd.numa<>0 then begin
          inc(int2);
          if (lq) and (not abort) then begin
            if (thisuser.vote[i]=0) then varstr:='New' else varstr:='   ';
            varstr:=varstr+'~'+cstr(i)+'~'+vd.question;
            prfmsg('MSCQUEST',varstr);
          end;
          ij:=ij+cstr(i);
        end;
      end;
      lq:=FALSE;
      if (int2=0) then begin
        prfmsg('MSCNOQE','');
        done:=TRUE;
      end else begin
        prfmsg('MSCWHQPT','');
        input(s,2);
        i:=value(s);
        if (s='A') then begin
          j:=0;
          i:=1;
          while ((i<=numvoteqs) and (not hangup)) do begin
            getvote(i);
            if ((vd.numa<>0) and (thisuser.vote[i]=0)) then begin
              vote1(TRUE,i);
              inc(j);
            end;
            inc(i);
          end;
          if (j=0) then prfmsg('MSCNOMOR','');
        end;
        if ((s='Q') or (s='')) then done:=TRUE;
        if ((s='L') or (s='?')) then lq:=TRUE;
        if (i>=1) and (i<=numvoteqs) then vote1(FALSE,i);
      end;
      if (systat.forcevoting) and (done) then begin
        vna:=0;
        for i:=1 to numvoteqs do begin
          seek(vdata,i-1); read(vdata,vd);
          if ((vd.numa<>0) and (thisuser.vote[i]=0)) then inc(vna);
        end;
        if (vna<>0) then begin
          prfmsg('MSCVIMND','');
          done:=FALSE;
        end;
      end;
    until (done) or (hangup);

    close(vdata);

    if (waschanged) then prfmsg('MSCTHXVT','');
  end;
end;

end.
