{$M 8000,0,0}
Program Compile;

Uses Dos,Crt;

 Function yn(DisplayStr:String; DefaultNo:Boolean):Boolean;
 Var
  InKey:char;
 Begin
  yn:=FALSE;
  Write(DisplayStr);
  InKey:=#0;
  Repeat
   If (Keypressed) then InKey:=UpCase(ReadKey);
  Until (InKey='N') or (InKey='Y') or (InKey=^M);

  If (DefaultNo) and (InKey=^M) then InKey:='N';
  If (Not DefaultNo) and (InKey=^M) then InKey:='Y';

  If (InKey='Y') then begin
   WriteLn('Yes');
   yn:=TRUE;
  End
  Else WriteLn('No');
 End;

 Function NoSpaces(InStr:String):String;
 Begin
  While Pos(' ',InStr)<>0 Do Delete(InStr,Pos(' ',InStr),1);
  NoSpaces:=InStr;
 End;

 Function Justify_LR(InStr:String):String;
 Begin
  While(InStr[1]=' ') do Delete(InStr,1,1);
  While(InStr[Length(InStr)]=' ') do Delete(InStr,Length(InStr),1);
  Justify_LR:=InStr;
 End;

function value(s:string):longint;
var i:longint;
    j:integer;
begin
  val(s,i,j);
  if (j<>0) then begin
    s:=copy(s,1,j-1);
    val(s,i,j)
  end;
  value:=i;
  if (s='') then value:=0;
end;

Var
 i:Integer;
 TempStr:String;

 OutF,RegFile, ConfigFile:Text;
 RegData, CommandLine:String;

 DestinationDir, ShortNumber:String;

 Version, SerialNumber, RegisteredSysOp, RegisteredBBS:String;
 RegisteredNodes:String[1];

 AutoCompile,LogIt,ArchiveIt:Boolean;

 Manual:Boolean;

 Param:String[2];

Begin
  Param:=ParamStr(1);
  Manual:=TRUE;
  Case Param[1] of
   '-','/':If UpCase(Param[2])='A' then Manual:=FALSE;
  End;
  Assign(ConfigFile,'COMPILE.CFG');
  Reset(ConfigFile);
  ReadLn(ConfigFile,CommandLine);
  ReadLn(ConfigFile,DestinationDir);
  ReadLn(ConfigFile,Version);
  WriteLn;
  WriteLn('Revelation BBS Upgrade Compilation and Archive Utility');

  WriteLn;
  If yn('Log to UPGRADE.LST? [No]: ',TRUE) then begin
   LogIt:=TRUE;
   Assign(OutF,DestinationDir+'\UPGRADE.LST');
   WriteLn;
   {$I-} Reset(OutF); {$I+}
   If (IOResult=0) then begin
    If yn('Append UPGRADE.LST? [No]: ',TRUE) then Append(OutF)
    Else Rewrite(OutF);
   End
   Else ReWrite(OutF);
   WriteLn(OutF);
  End
  Else LogIt:=FALSE;

  WriteLn;

  Repeat
   ReadLn(ConfigFile,RegData);
   RegData:=Justify_LR(RegData);
   If Pos(';',RegData)<>0 then RegData:=Copy(RegData,1,Pos(';',RegData)-1);
   If NoSpaces(RegData)<>'' then begin
    AutoCompile:=FALSE;
    If (RegData[1]='*')  then begin
     Delete(RegData,1,1);
     If (Not Manual) then AutoCompile:=TRUE;
    End;
    If RegData[1]='!' then begin
     ArchiveIt:=FALSE;
     Delete(RegData,1,1);
    End
    Else ArchiveIt:=TRUE;
    SerialNumber:=NoSpaces(Copy(RegData,1,Pos(',',RegData)-1));
    Delete(RegData,1,Pos(',',RegData));

    RegisteredSysOp:=Justify_LR(Copy(RegData,1,Pos(',',RegData)-1));
    Delete(RegData,1,Pos(',',RegData));

    If Pos(',',RegData)>0 then RegisteredBBS:=Copy(RegData,1,Pos(',',RegData)-1)
    Else RegisteredBBS:=RegData;
    RegisteredBBS:=Justify_LR(RegisteredBBS);
    Delete(RegData,1,Pos(',',RegData));

    RegisteredNodes:=NoSpaces(RegData);
    If Value(RegisteredNodes)<1 then RegisteredNodes:='1';

    If (AutoCompile) or
     (Manual and yn('Build '+RegisteredBBS+' ('+RegisteredSysOp+') ('+RegisteredNodes+') [No]: ',TRUE)) then begin
{    WriteLn('Building '+RegisteredBBS+' ('+RegisteredSysOp+')');}
     If LogIt then begin
      Write(OutF,'SysOp: ',RegisteredSysOp,'  BBS: ',RegisteredBBS,'  S/N: ',SerialNumber);
      WriteLn(OutF);
     End;

     Assign(RegFile,'REVELATE.REG');
     ReWrite(RegFile);
     WriteLn(RegFile,'Procedure Register;');
     WriteLn(RegFile,'Begin');
     WriteLn(RegFile,'  SerialNumber:='+SerialNumber+';');
     WriteLn(RegFile);
     WriteLn(RegFile,'  RegisteredNodes:='+RegisteredNodes+';');
     WriteLn(RegFile);
     WriteLn(RegFile,'  For i:=1 to ',Length(RegisteredSysOp),' do');
     WriteLn(RegFile,'   Case i of');

     For i:=1 to Length(RegisteredSysOp) do begin
      Write(RegFile,'    ',i,':RegisteredSysOp[i]:='''+RegisteredSysOp[i]+'''');
      If RegisteredSysOp[i]=#39 then Write(RegFile,'''');
      WriteLn(RegFile,';');
     End;

     WriteLn(RegFile,'   End;');
     WriteLn(RegFile,'  RegisteredSysOp[0]:=Chr(i);');
     WriteLn(RegFile);

     WriteLn(RegFile,'  For i:=1 to ',Length(RegisteredBBS),' do');
     WriteLn(RegFile,'   Case i of');

     For i:=1 to Length(RegisteredBBS) do begin
      Write(RegFile,'    ',i,':RegisteredBBS[i]:='''+RegisteredBBS[i]+'''');
      If RegisteredBBS[i]=#39 then Write(RegFile,'''');
      WriteLn(RegFile,';');
     End;

     WriteLn(RegFile,'   End;');
     WriteLn(RegFile,'  RegisteredBBS[0]:=Chr(i);');
     WriteLn(RegFile);
     WriteLn(RegFile,'End;');

     Close(RegFile);

     ShortNumber:=Copy(SerialNumber,Length(SerialNumber)-3+1,3);
     TempStr:=CommandLine;
     Insert(DestinationDir+'\'+ShortNumber+'-'+Version,TempStr,Pos('FN',TempStr));
     Delete(TempStr,Pos('FN',TempStr),3);

     SwapVectors;
     Exec(GetEnv('COMSPEC'),'/C PC.BAT');
     SwapVectors;
     SwapVectors;
     Exec(GetEnv('COMSPEC'),'/C PKLITE -e REVELATE');
     SwapVectors;

     If ArchiveIt then begin
      SwapVectors;
      Exec(GetEnv('COMSPEC'),+'/C DEL '+DestinationDir+'\'+ShortNumber+'-*.*');
      Exec(GetEnv('COMSPEC'),+'/C '+TempStr);
      SwapVectors;
     End;

     WriteLn;
    End;
   End;
  Until Eof(ConfigFile);
  Close(ConfigFile);
  If LogIt then Close(OutF);
End.
