{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : STRUCT.INC                                                    
  Description: Official Record Structures and Global Types/Constants         
  Version    : n/a [Revelation v0.96]                                        
                                                                             
                                                                           
 Ľ}

CONST

{SystemMaximums}

  maxboards=1024;                { Maximum Message Bases [From 1 to #]      }
  maxuboards=1024;               { Maximum File Areas [From 0 to #]         }
  maxprotocols=120;               { Maximum Protocols [From 0 to #]          }
  maxevents=10;                   { Maximum Events [From 0 to #] 0=Nightly   }
  maxarcs=8;                      { Maximum Archive Types [From 1 to #]      }
  maxubatchfiles=20;              { Maximum Batch Upload Files [From 1 to #] }
  numvoteqs=20;                   { Maximum Voting Questions [From 1 To #]   }
  numvoteas=9;                    { Maximum Voting Answers [From 1 to #]     }
  maxmenucmds=100;                { Maximum Menu Commands [From 1 to #]      }

{MessageAttributes}

  Deleted     = $00;
  UnValidated = $01;
  Permanent   = $02;
  Scanned     = $03;

  Direct      = $08;
  Immediate   = $09;
  DelSent     = $10;  { If Echo/Net Mail - Set Deleted Attribute After Sent  }

{StandardFidoAttributes}

  Private              = $00;
  Crash                = $01;
  Recd                 = $02;
  Sent                 = $03;
  FileAttached         = $04;
  InTransit            = $05;
  Orphan               = $06;
  KillSent             = $07;
  Local                = $08;
  HoldForPickup        = $09;
  Unused               = $10;
  FileRequest          = $11;
  ReturnReceiptRequest = $12;
  IsReturnReceipt      = $13;
  AuditRequest         = $14;
  FileUpdateReq        = $15;


{[ Defined Types ]}

TYPE

  UserNameStr = String[30];       { FILL ME IN                               }
  Astr        = String[160];      { ASTR String Type Definition              }
  acstring    = String[20];       { Access Condition String Type [ACS]       }
  acrq        = '@'..'Z';         { AR Flags                                 }
  FlagSet     = Set of '@'..'Z';  { AR Flags [Paragon Conferences]           }

  uflags      =                   { User Access Condition Flags              }
   (rlogon,                       { L - Restricted to one call a day         }
    rchat,                        { C - Can't page the SysOp                 }
    rvalidate,                    { V - Posts marked unvalidated             }
    rbackspace,                   { B - Can't do ^B/^N/etc in messages       }
    ramsg,                        { A - Can't change the AutoMessage         }
    rpostan,                      { * - Can't post anonymously               }
    rpost,                        { P - Can't post at all                    }
    remail,                       { E - Can't send any e-mail                }
    rvoting,                      { K - Can't vote                           }
    rmsg,                         { M - Force e-mail deletion                }
    spcsr,                        {                                          }
    onekey,                       { onekey input mode                        }
    avatar,                       { user has AVATAR                          }
    pause,                        { pause                                    }
    novice,                       { user is at novice help level             }
    ansi,                         { user has ANSI                            }
    color,                        { user has color                           }
    alert,                        { alert SysOp when user logs on            }
    smw,                          { short-message waiting for user           }
    nomail,                       { user mail-box is closed                  }
    fnodlratio,                   { 1 - No UL/DL ratio                       }
    fnopostratio,                 { 2 - No post/call ratio                   }
    fnofilepts,                   { 3 - No file points checking              }
    fnodeletion);                 { 4 - Protection from deletion             }

  anontyp     =                   { Message Section Anonymous Types          }
   (atno,                         { No anonymous posts allowed               }
    atyes,                        { Anonymous posts are allowed              }
    atforced,                     { ALL posts are forced anonymous           }
    atdearabby,                   { "Dear Abby" message base                 }
    atanyname);                   { User's can post as ANY name they want    }

  clrs        = array[FALSE..TRUE,0..9] of byte; { color records             }
  secrange    = array[0..255] of integer;        { security tables           }

  cpackdatetime = array[1..6] of byte; { Last Read Date Structure For Message Base Scan Pointers }

  tbflags     =
   (tbunhidden,                   { Whether *VISIBLE* to users w/o access    }
    tbnetlink,                    { Whether Net-Linked to other BBSs         }
    tbisdir);                     { If a text-file base directory            }

  mbflags     =
   (mbunhidden,                   { Whether *VISIBLE* To Users w/o Access    }
    mbrealname,                   { Whether Real Names Are Forced            }
    mbisdir,                      { If A Message Base Directory              }
    mbmsgpath,                    { If *.BRD File Stored In MSGPATH          }
    mbfilter,                     { Whether To Filter ANSI/8-Bit ASCII       }

    {* For Importing *}
    mbskludge,                    { Strip ^A Kludge Lines                    }
    mbsseenby,                    { Strip SEEN-BY Lines                      }

    mbsorigin,                    { Strip Origin Lines                       }
    mbscenter,                    { Strip Centering Codes                    }
    mbsbox,                       { Strip Box Codes                          }
    mbmcenter,                    { Center Boxed/Centered Lines              }
    mbaddtear,                    { Add Tear/Origin Lines                    }
    mbtopstar);                   { Whether Top Star For GroupMail Base      }

  fbflags     =
   (fbnoratio,                    { If <No Ratio> Active                     }
    fbunhidden,                   { Whether *VISIBLE* To Users w/o Access    }
    fbdirdlpath,                  { If *.DIR File Stored In DLPATH           }
    fbisdir,                      { If A File Base Directory                 }
    fbusegifspecs,                { Whether To Use GifSpecs                  }
    fbnetlink);                   { Whether Net-Linked To Other BBSs         }

  filstat     =
   (notval,                       { If File Is NOT Validated                 }
    isrequest,                    { If File Is REQUEST                       }
    resumelater);                 { If File Is RESUME-LATER                  }

  mnuflags    =
   (clrscrbefore,                 { C: Clear Screen Before Menu Display      }
    dontcenter,                   { D: Don't Center The Menu Titles!         }
    nomenuprompt,                 { N: No Menu Prompt Whatsoever?            }
    forcepause,                   { P: Force A Pause Before Menu Display?    }
    autotime);                    { T: Is Time Displayed Automatically?      }

  cmdflags    =
   (hidden,                       { H: Is Command ALWAYS Hidden?             }
    unhidden);                    { U: Is Command ALWAYS Visible?            }

  xbflags     =
   (xbactive,                     { Is The Protocol Active?                  }
    xbisbatch,                    { Is This A Batch Protocol?                }
    xbisresume,                   { Is This A Resume Protocol?               }
    xbxferokcode);                { Transfer OK Code                         }

  cfilterrec  = array[0..255] of byte; { Color Filter Records                }


{[ Record Structs ]}

  rumorrec    = record            { [RUMORS.LST] - Rumor System Records      }
    Title     : string[20];       { Title Of The Rumor                       }
    Author    : string[36];       { Author [USER] Of The Rumor               }
    Date      : string[8];        { Date The Rumor Was Posted                }
    Rumor     : string[75];       { The Rumor Text Itself!                   }
    Anonymous : boolean;          { Is The Rumor Posted Anonymously?         }
    AccessReq : byte;             { Access Required For Others To Read It    }
  end;


  userrec     = record            { [USER.LST] - Main User Account Records   }
    name,                               { User Name [Handle]                 }
    realname    : string[36];           { User Real Name                     }
    pw          : string[20];           { User Password                      }
    ph          : string[12];           { User Phone Number                  }
    bday,                               { User BirthDate                     }
    firston,                            { FirstOn Date                       }
    laston      : string[8];            { LastOn Date                        }

    accountnote,                        { User Note - Public User Note       }
    computer    : string[30];           { Computer Type                      }
    note        : string[39];           { User Note - Private SysOp Note     }

    lockedout,                          { Is This User Locked Out?           }
    deleted     : boolean;              { Is This User Deleted?              }
    lockedfile  : string[8];            { Lockout Message To Display         }

    ac          : set of uflags;        { User Access Flags                  }
    ar          : flagset;              { Access Restriction Flags           }

    vote,                               { User Voting Data                   }
    nuv         : array[1..20] of byte; { User New User Voting Data          }

    useautosigs : boolean;              { Use Auto-Signatures Or Not         }

    sex         : char;                 { User Sex                           }

    ttimeon,                            { Total Mins Spent On-Line           }
    uk,                                 { Uploaded Kbytes                    }
    dk          : longint;              { Downloaded Kbytes                  }

    uploads,                            { Number of Uploads                  }
    downloads,                          { Number of Downloads                }
    loggedon,                           { Number of Calls                    }
    tltoday,                            { Time [Minutes] Remaining Today     }
    msgpost,                            { Number of Public Posts             }
    emailsent,                          { Number of E-Mail Messages Sent     }
    filepoints  : integer;              { Number of File Points              }

    linelen,                            { User Line Length [Num. Columns]    }
    pagelen,                            { User Page Length [Num. Rows   ]    }
    ontoday,                            { Number of Calls Today              }
    illegal,                            { Number of Illegal Logon Attempts   }
    sl,                                 { User Security Level                }
    dsl         : byte;                 { User Download Security Level       }

    cols        : clrs;                 { User Colors                        }

    lastmsg,                            { Last Message Area                  }
    lastfil     : byte;                 { Last File Area                     }
    timebank    : integer;              { Number of Minutes in Time Bank     }
                                        { Note: Time Bank will be replaced
                                          and the new one will be auxiliary. }

    trapactivity,                       { Trap This Users Activity?          }
    trapseperate: boolean;              { If Trapping, To Seperate File?     }

    timebankadd : integer;              { Time Added To Bank Today SEE ABOVE }
    mpointer    : longint;              { Pointer To Entry in MACRO.LST      }
    chatauto,                           { Automatically Log Chat Mode?       }
    chatseperate,                       { Log To A Seperate Chat Trap File?  }
    slogseperate,                       { Seperate SysOp Log For This User?  }
    clsmsg      : boolean;              { Clear Screen Before Each Message?  }

    avatarcoloradjust:boolean;          { Use The AVATAR Color Adjustment?   }

    headernumber: integer;              { Which Header Do You Wish To Use    }
    hidename    : boolean;              { FILL ME IN                         }

    FListCfg    : array[1..11] of byte; { File List Configurations           }
    DidConfig   : byte;                 { Has This User Configured Yet?      }
    res         : array[1..3] of byte;  { RESERVED DATA SPACE                }

    MsgConf,                            { FILL ME IN                         }
    FilConf     : FlagSet;              { FILL ME IN                         }

    IncomingMail,                       { FILL ME IN                         }
    OutGoingMail,                       { FILL ME IN                         }
    AreaListNumber:Integer;             { Configurable Area List Number      }

    wallread,                           { The Wall: Scan Pointer             }
    newsread  : integer;                { AstuteNews: Scan Pointer           }
    haspickit : boolean;                { Do You Have A Ticket?              }
    pickit    : array[1..6] of integer; { The Actual Ticket                  }
  end;


  OnLineRec   = Record            { [ONLINE.DAT] - MultiNode Users OnLine    }
   Handle    : String[30];        { Users Handle Of This Node                }
   Status    : String[40];        { Users Status On The System               }
   AllowPage : Boolean;           { Is This User Able To Be Paged?           }
  End;

  mbasescan = Record              { <BOARDFNAME>.SCN File Structure, 1..MAXUSERS }
    zscan : boolean;              { Should This Base Be NewScanned }
    hiread: cpackdatetime;        { Date Of Last Message Read By This User In This Base }
  end;

  fbasescan = Record              { <FBOARDFNAME>.SCN File Structure, 1..MAXUSERS }
    zscan : boolean;              { Should This Base Be NewScanned }
  end;

  FromInfoRec = Record            { Message From Header Record               }
   Zone,                          { Zone Number  [ZZ:---/---.--]             }
   Net,                           { Net Number   [--:NNN/---.--]             }
   Node,                          { Node Number  [--:---/NNN.--]             }
   Point    : Word;               { Point Number [--:---/---.PP]             }
   UserName : String[30];         { User Name [Handle]                       }
   UserNote : String[25];         { User's Public UserNote                   }
  End;


  ToInfoRec   = Record            { Message To Header Record                 }
   Zone,                          { Zone Number  [ZZ:---/---.--]             }
   Net,                           { Net Number   [--:NNN/---.--]             }
   Node,                          { Node Number  [--:---/NNN.--]             }
   Point    : Word;               { Point Number [--:---/---.PP]             }
   UserName : String[30];         { User Name [Handle]                       }
  End;


  MsgIndexRec = Record            { [*.IDX] Index Records                    }
   MsgPtr,                        { Pointer To Message Text                  }
   MsgLength   : LongInt;         { Length Of Message Text                   }
   MsgAttr,                       { Message Attributes                       }
   FidoAttr,                      { Standard FidoNet Attribute Set           }
   Cost        : Word;            { NetMail Cost - If Any...                 }
   Anon        : Byte;            { Anonymous                                }
   ReplyTo,                       { Reply-To                                 }
   NextReply,                     { Next Reply                               }
   TimesRead   : Word;            { Number of Times Read                     }

   MsgPostDateTime,               { NewScan Date/Time Stamp                  }
   MsgDateTime : CPackDateTime;   { Date/Time Stamp of Message               }

   FromInfo    : FromInfoRec;     { From User Address/Name/User Note         }
   ToInfo      : ToInfoRec;       { To User Address/Name                     }
   Title       : String[72];      { Message Title                            }

   MsgIndexRec_FutureExpansion : Array[1..38] of Byte; { RESERVED            }
  End;


{Format

  Each message board has a .IDX file specific to it, which stores the
  information for the messages in that board.  Messages are stored starting
  at record 0, with record 0 being treated as message 1, record 1 being
  message 2, etc.  The IDX entry contains the variable "MsgPtr" to point to
  the start of the message in the .MTX file, with the "MsgLength" variable
  determining how long the message is (in bytes).

                                                    -Refractor
}


  zlogrec     = Record            { [ZLOG.DAT] - System Log Records         }
    date      : string[8];        { Date Of The Records Day                 }
    userbaud  : array[0..4] of integer; { User Baud Calls                   }
    active,                       { Minutes The BBS Was Active              }
    calls,                        { Number Of Calls                         }
    newusers,                     { Number Of New Users                     }
    pubpost,                      { Number Of Public Posts                  }
    privpost,                     { Number Of E-Mail Posts                  }
    fback,                        { Number Of Feedbacks Sent                }
    criterr,                      { Number Of Critical [Runtime] Errors     }
    uploads,                      { Number Of Uploads                       }
    downloads : integer;          { Number Of Downloads                     }
    uk,                           { Kbytes Uploaded                         }
    dk        : longint;          { Kbytes Downloaded                       }
  end;


  filearcinforec = Record         { Archive Configuration Records           }
    active    : boolean;          { Whether This Archive Format Is Active   }
    ext       : string[3];        { 3-Character File Extention Type         }
    listline,                     { Archive VIEW Commandline                }
    arcline,                      { Compression Commandline                 }
    unarcline,                    { De-Compression Commandline              }
    testline,                     { Integrity Test Commandline [''=None]    }
    cmtline   : string[25];       { Comment Commandline [''=None]           }
    succlevel : integer;          { Success ERRORLEVEL, -1=Ignore Results   }
  end;


  modemrec    = Record            { [MODEM.DAT] - Modem Configuration       }
    maxbaud        : word;        { Maximum Baud Rate Supported             }
    comport        : byte;        { Communications [COM] Port Number        }

    init           : string[80];  { Initialization String                   }
    answer         : string[40];  { Answer String                           }
    hangup         : string[40];  { Hangup String                           }
    offhook        : string[40];  { Phone Off-Hook String                   }


    nocallinittime : integer;     { ReInit Modem After # Mins Of InActivity }
    lockedport     : boolean;     { Is The Port Locked                      }
    lockedbaud     : longint;     { Locked Baud Rate                        }
(*
    arq9600rate    : word;        { Baud Rate To Use With 9600 ARQ Result   }
*)
    forcerate      : boolean;     { Whether To Force Baud Rate Or Not       }

    CONNECT_300,
    CONNECT_1200,
    CONNECT_2400,
    CONNECT_4800,
    CONNECT_9600,
    CONNECT_14400,
    CONNECT_19200,
    CONNECT_38400  : string[20];  { CONNECT Result Strings                  }

    ERROR,
    BUSY,
    NO_CARRIER,
    OK,
    RING,
    NO_DIALTONE,
    NO_ANSWER,
    VOICE          : string[14];  { Other Modem Result Strings              }

    ctschecking,
    dsrchecking,
    usexonxoff,
    hardwired      : boolean;     { Certain Options For The Modem           }
    RemoteRedir    : string[10];
    MReservedSpace : array[1..50] of byte;

  end;

  SystatRec   = Record            { [REVELATE.DAT] - System Status Record   }
    systempath,                       { Data Files Path                     }
    textpath,                         { ANSi/Message Files Path             }
    msgpath,                          { Path To .MTX and .IDX Files         }
    menupath,                         { Path To .MNU Menu Files             }
    externaleditor,                   { Path To An External FSE             }
    protocolpath,                     { Path To The Protocols               }
    archivepath : string[60];         { Path To The Archivers               }
    sysopname,                        { Handle/Name Of The SysOp            }
    bbsname     : string[30];         { BBS System Name                     }
    bbsphone    : string[12];         { BBS Phone Number                    }

    lowtime,                          { SysOp Available Begin Time (Mins)   }
    hitime,                           { SysOp Available End Time (Mins)     }
    dllowtime,                        { Normal Downloading Hours Begin      }
    dlhitime : integer;               { Normal Downloading Hours End        }
    shuttlelog,                       { Is The Shuttle System Active?       }
    lock9600 : boolean;               { Lock Out Under 9600 Baud Users?     }

    SystemPW,                         { SysOp Password                      }
    NewUserPW,                        { NewUser Password (Null=None)        }
    LockOutPW,                        { Under 9600 Lockout Password         }
    System1PW,                        { System 1 Shuttle Password           }
    System2PW,                        { System 2 Shuttle Password           }
    System3PW,                        { System 3 Shuttle Password           }
    System1Security,                  { System 1 Security                   }
    System2Security,                  { System 2 Security                   }
    System3Security : String[20];     { System 3 Security                   }

    blowtime,                         { Under 9600 Baud Calling Hours Begin }
    bhitime,                          { Under 9600 Baud Calling Hours End   }
    bdllowtime,                       { Under 9600 Baud D/Ling Hours Begin  }
    bdlhitime : integer;              { Under 9600 Baud D/Ling Hours End    }

    MultiLine,                        { Is This System MultiUser?           }
    AllowNewUsers,                    { Allow New Users To SignUp?          }
    SwapShell,                        { Use Swap Shell?                     }
    EMS_Overlay        : boolean;     { Use EMS For OverLay?                }
    EventWarningTime   : integer;     { Event Warning/Leeway Time           }
    AutoSysOpFastLogon : boolean;     { Automatically Use Fast Logon?       }

    phonepw,                          { Use Phone Number PassCode In Logon? }
    localscreensec,                   { Is Local Screen-Security ON?        }
    localpass,                        { Whether To Hide PW's Locally Or Not }
    usebios,                          { Use ROM BIOS For Local Video Output }
    cgasnow,                          { Suppress Snow On CGA Systems        }
    globaltrap,                       { Trap ALL USER'S Activity?           }
    autochatopen       : boolean;     { Does Chat Buffer Auto-Open?         }


    sop,                              { SysOp                               }
    csop,                             { Co-SysOp                            }
    msop,                             { Message SysOp                       }
    fsop,                             { File SysOp                          }
    spw,                              { SysOp PW at logon                   }
    seepw,                            { See SysOp PWs remotely              }
    normpubpost,                      { Make normal public posts            }
    normprivpost,                     { Send normal e-mail                  }
    anonpubread,                      { See who posted public anon          }
    anonprivread,                     { See who sent anon e-mail            }
    anonpubpost,                      { Make anon posts                     }
    anonprivpost,                     { Send anon e-mail                    }
    seeunval,                         { See unvalidated files               }
    dlunval,                          { DL unvalidated files                }
    nodlratio,                        { No UL/DL ratio                      }
    nopostratio,                      { No post/call ratio                  }
    nofilepts,                        { No file points checking             }
    ulvalreq : acstring;              { Uploads require validation by SysOp }

    Default_Onek,
    Default_ClrMsg,
    Default_Expert,
    Default_Pause : boolean;

    maxprivpost,                      { Max e-mail can send per call        }
    maxpubpost,                       { Max posts per call                  }
    maxchat,                          { Max chat-pages per call             }
    maxwaiting,                       { Max mail in mail-box                }
    csmaxwaiting,                     { Max mail in mail-box for Co-SysOp + }
    maxlogontries,                    { Tries allowed for PW's at logon     }
    sysopcolor,                       { SysOp color in chat mode            }
    usercolor         : byte;         { User color in chat mode             }
    minspaceforpost,                  { Minimum K drive space left to post  }
    minspaceforupload : integer;      { Minimum K drive space left to upload}
    backsysoplogs,                    { Days to keep SYSOP##.LOG            }
    wfcblanktime      : byte;         { Minutes After To Blank WFC Menu     }

    linelen,                          { Default video line length           }
    pagelen : byte;                   { Default video page length           }


    offhooklocallogon,                { Take phone off-hook for local logons}
    forcevoting,                      { Is manditory logon voting active?   }
    searchdup,                        { Search for dup. filenames when UL?  }
    stripclog : boolean;              { Strip colors from SysOp log output? }

    timeoutbell,                      { Minutes before time-out bell        }
    timeout : integer;                { Minutes before timeout (logoff)     }

    filearcinfo    : array[1..maxarcs] of filearcinforec; { Archive Specs   }
    filearccomment : array[1..3] of string[80]; { BBS Comments For Archives }

    uldlratio,                        { Are UL/DL ratios active?            }
    fileptratio      : boolean;       { Is auto file-pt compensation active?}
    fileptcomp,                       { File point compensation ratio       }
    fileptcompbasesize,               { File point "base compensation size" }
    ulrefund,                         { Percent time refund for ULs         }
    tosysopdir       : byte;          { "To SysOp" file base                }
    validateallfiles : boolean;       { Validate ALL FILES automatically?   }
    reserved         : string[10];    { NOT USED ANYMORE.  USES MODEMR Recd }
    maxintemp,                        { Max K allowed in TEMP\3\            }
    minresume        : integer;       { Min K to allow resume-later         }
    maxdbatch,                        { Max files in DL batch queue         }
    maxubatch        : byte;          { Max files in UL batch queue         }

    newsl,                            { Newuser SL                          }
    newdsl   : byte;                  { Newuser DSL                         }
    newar    : FlagSet;               { Newuser AR                          }
    newac    : set of uflags;         { Newuser AC                          }
    newfp    : integer;               { Newuser File Points                 }
    newnote  : string[30];            { NewUser Public User Note            }
    autosl,                           { Auto-Validation SL                  }
    autodsl  : byte;                  { Auto-Validation DSL                 }
    autoar   : FlagSet;               { Auto-Validation AR                  }
    autoac   : set of uflags;         { Auto-Validation AC                  }
    autonote : string[30];            { Auto-Validation Public User Note    }

    allstartmenu,                     { Logon menu to start ALL users on    }
    bulletprefix : string[8];         { Default bulletins filename prefix   }

    lastdate    : string[8];          { Last system date                    }
    curwindow   : byte;               { Type of SysOp window currently used }
    istopwindow : boolean;            { Is SysOp window on top of screen?   }
    callernum   : longint;            { Total number of callers             }
    numusers    : integer;            { Number of users                     }

    todayzlog   : zlogrec;            { TODAY's ZLOG record                 }

    postcredits    : integer;         { File points/upload credit for posts }
    rebootforevent : boolean;         { Reboot before events?               }
    watchdogdoor   : boolean;         { WatchDog active in doors?           }

    maxusers : integer;               { Maximum Users BBS Can Store         }

    windowon : boolean;               { SysOp Window On?                    }
    regcode  : string[10];            { Registration Code                   }

    emailboard : word;                { Private Mail Board Number           }

    confactive,                       { Conferences Active Or Not?          }
    givegift : boolean;               { Give Gifts On Special Days?         }
    giftpts  : byte;                  { Actual Gift Of Points               }

    yntype,                           { Y/N Prompt Type 1-Rev 2-TG27 3-Forum}
    noagree,                          { Disagree w/ Disclaimer 0-Hang 1-Msg }
    shuttlesys : byte;                { Shuttle Use 0-choice 1-rnd 3-6-type }

    newuservoting : boolean;          { Is New User Voting Active?          }
    yesvotes,                         { Yes Votes For Validation            }
    novotes       : byte;             { No Votes For Deletion               }

    lottonight : boolean;             { Run Nightly Lotto Event?            }
    UseFILE_ID_DIZ:boolean;           { Use FILE_ID.DIZ in Verbose          }

    usevalups:byte;                   { Use Validation Uploads?             }
    scrollbacksize:byte;              { Size of Scroll Back Buffer (1-256)(0-OFF) }
    newusermsgto:word;                { New User Message Is Sent To User #: }
    UNoteEditSL: acstring;            { Axs to Edit own User Note [20]      }
    UsersDecideDIZ:boolean;           { Users decide if UL Diz's are used   }
    NewUserMsgBoard:word;             { New User Msgs redirected to board#  }
    reservedspace : array[1..159] of byte; { RESERVED                       }
  end;


  smr         = Record            { [SHORTMSG.DAT] - One-Line Messages      }
    msg    : astr;                { The Actual Message Notice               }
    destin : integer;             { Destination User Number                 }
  end;


  vdatar      = Record            { [VOTING.DAT] - Voting Records           }
    question : string[79];        { Voting Question                         }
    numa     : integer;           { Number Of Users Who Have Answered       }
    answ     : array[0..numvoteas] of
    record
      ans    : string[40];        { Answer Description                      }
      numres : integer;           { Number Of Users Who Picked This Answer  }
    end;
  end;

  nvote = record                  { [NUV.DAT] - New User Voting Records     }
     who:string[40];              { Name Of The User To Vote On             }
     whonum,                      { Number Of User In User List             }
     numa,                        { Number Of Users Who Have Answered       }
     numyes,                      { Number Of Yes Votes                     }
     numno:integer;               { Number Of No Votes                      }
     descript,                    { Validation Upload Description           }
     fname:astr;                  { Validation Upload FileName              }
  end;
 
  boardrec    = Record            { [BOARDS.DAT] - Message Base Records     }
    name      : string[40];       { Message Base Description                }
    filename  : string[8];        { BRD/MIX Data Filename                   }
    lastmsgid : longint;          { Last Message ID Number                  }
    msgpath   : string[40];       { Messages Pathname                       }
    acs,                          { Access Requirement                      }
    postacs,                      { Post Access Requirement                 }
    mciacs    : acstring;         { MCI Usage Requirement                   }
    maxmsgs   : word;             { Max Message Count                       }
    anonymous : anontyp;          { Anonymous Type                          }
    password  : string[20];       { Base Password                           }
    mbstat    : set of mbflags;   { Message Base Status Vars                }
    permindx  : longint;          { Permanent Index #                       }
    mbtype    : integer;          { Base Type [0=Local/1=Echo]              }
    origin    : string[50];       { Origin Line                             }
    text_color,                   { Color of Standard Text                  }
    quote_color,                  { Color of Quoted Text                    }
    tear_color,                   { Color of Tear Line                      }
    origin_color:byte;            { Color of Origin Line                    }
    zone,                         { Alternate Address                       }
    net,                          { (Zone:Net/Node.Point)                   }
    node,
    point       : integer;
    confnum     : byte;           { Conference Number                       }
    msgstatus   : byte;           { 0=private 1=public                      }
    addaccnote  : boolean;
    maxfselines : integer;        { Maximum Lines To Dynamically Allocate   }
  end;


  ulrec       = Record            { [UPLOADS.DAT] - File Base Records       }
    name     : string[40];        { Area Description                        }
    filename : string[12];        { Filename + ".DIR"                       }
    dlpath   : string[40];        { Download Path                           }
    ulpath   : string[40];        { Upload Path                             }
    maxfiles : integer;           { Max Files Allowed                       }
    password : string[20];        { Password Required                       }
    arctype,                      { Wanted Archive Type [1..Max,0=Inactive] }
    cmttype  : byte;              { Wanted Comment Type [1..3,0=Inactive]   }
    fbdepth  : integer;           { File Base Dir Depth                     }
    fbstat   : set of fbflags;    { File Base Status Vars                   }
    acs,                          { Access Requirements                     }
    ulacs,                        { Upload Requirements                     }
    nameacs  : acstring;          { See-Names Requirements                  }
    permindx : longint;           { Permanent Index #                       }
    confnum,                      { Conference Number                       }
    basetype,                     { Base Type 0-Normal 1-UL 2-DL 3-PVT      }
    avpoints : byte;              { File Points For Auto-Validating         }
    avfiles  : boolean;           { Auto-Validate Files In This Base?       }
    creduler : boolean;           { Give Uploader File Point Credit For DL? }
    res      : array[1..5] of byte; { RESERVED Space 2 and 3 used           }
  end;


  ulfrec      = Record            { [*.DIR] - File Records                  }
    filename    : string[12];     { FileName                                }
    description : string[60];     { File Description                        }
    filepoints,                   { File Points                             }
    fileto,                       { File To Whom? (0=All, #=User)           }
    nacc        : integer;        { Number Of DLs                           }
    ft          : byte;           { File Type (USELESS?!)                   }
    blocks,                       { Number Of 128 Byte Blocks               }
    owner       : integer;        { Uploader Of File                        }
    stowner     : string[36];     { Uploader's Name                         }
    date        : string[8];      { Date Uploaded                           }
    daten       : integer;        { Numeric Date Uploaded                   }
    vpointer    : longint;        { Pointer To Verbose Description, -1=None }
    filestat    : set of filstat; { File Status                             }
    disknums    : array[1..2] of byte; { Disk Numbers                       }

    FileInfo    : String[6];      { File Information                        }
    CrackGroup  : String[8];      { Cracking Group                          }

    reservedpassword : string[10]; { Reserved Strings and Bytes             }
    reservedstring   : string[10];
    reserved         : array[1..4] of byte;
  end;


  verbrec     = Record            { [VERBOSE.DAT] - Verbose Descriptions    }
    descr : array[1..10] of string[80]; { The Verbose Description            }
  end;


  lastcallrec = Record            { [LASTCALL.DAT] - Last Callers Record    }
    username    : string[30];     { Caller's Handle/User Name               }
    baudrate    : string[20];     { Caller's Baud Rate                      }
    date        : string[8];      { Date Of The Call                        }
    timeon      : string[5];      { Time Logged On                          }
    timeoff     : string[5];      { Time Logged Off                         }
    totaltimeon : string[3];      { Total Time Used Online                  }

    daysold,                      { Days Ago                                }
    nodeid      : byte;           { Node Number Of The Call                 }
    callernum   : longint;        { Caller Number - Not Displayed Anywhere  }
  End;


  eventrec    = Record            { [EVENTS.DAT] - Event Records            }
    active      : boolean;        { Is This Event Active?                   }
    description : string[30];     { Event Description                       }
    etype       : char;           { (A)CS, (C)hat, (D)os Call, (E)xternal   }
    execdata    : string[20];     { Errorlevel If "E", Commandline if "D"   }
    busytime,                     { Off-Hook Time Before - 0=None           }
    exectime    : integer;        { Time Of Execution                       }
    busyduring  : boolean;        { Busy Phone DURING Event?                }
    duration    : integer;        { Length Of Time Event Takes              }
    execdays    : byte;           { Execution Days/Day Of Month If Monthly  }
    monthly     : boolean;        { Is This A Monthly Event?                }
    nodes       : word;           { Nodes Event is Active - MultiNode Only  }
  end;


  macrorec    = Record            { [MACROS.LST] - Macro Records            }
    macro : array[1..4] of string[240]; { Control Key Macro Definitions     }
  end;


  menurec     = Record            { [*.MNU] - Menu Records                  }
    menuname   : array[1..3] of string[100]; { Menu Titles [1 to 3]         }
    directive,                    { Help File To Be Displayed               }
    tutorial   : string[12];      { Tutorial Help File                      }
    menuprompt : string[120];     { Menu Prompt String                      }
    acs        : acstring;        { Access Requirements                     }
    password   : string[15];      { Password Required                       }
    fallback   : string[8];       { Fallback Menu                           }
    forcehelplevel,               { Forced Help Level For Menu              }
    gencols    : byte;            { Generic Menus: Number Of Columns        }
    gcol       : array[1..3] of byte; { Generic Menus: Colors               }
    inputcase,                    { Forced Upppercase Input                 }
    inputstyle,                   { Full Line Vs OneKey Input Vs User       }
    emulation  : byte;            { OS/Emulation <tm>                       }
    menuflags  : set of mnuflags; { Menu Status Variables                   }
  end;


  commandrec  = Record            { [*.MNU] - Command Records               }
    NodeStatus  : string[40];     { Node Status Update Line    958         }
    sdesc   : string[80];         { Command Description                     }
    ckeys   : string[14];         { Command-Execution Keys                  }
    acs     : acstring;           { Access Requirements                     }
    cmdkeys : string[2];          { Command Keys: Type Of Command           }
    mstring : string[80];         { MString: Command Data                   }
    commandflags : set of cmdflags; { Command Status Variables              }
  end;


  protrec     = Record            { [PROTOCOL.DAT] - Protocol Records       }
    xbstat   : set of xbflags;    { Protocol Flags                          }
    ckeys    : string[14];        { Command Keys                            }
    descr    : string[40];        { Protocol Description                    }
    acs      : acstring;          { Access String                           }
    templog,                      { Temporary Log File                      }
    uloadlog,                     { Permanent Upload Log File               }
    dloadlog : string[25];        { Permanent Download Log File             }
    ulcmd,                        { Upload Command Line                     }
    dlcmd    : string[78];        { Download Command Line                   }
    ulcode,                       { Upload Codes                            }
    dlcode   : array [1..6] of string[6]; { Download Codes                  }
    envcmd   : string[60];        { Environment Setup Cmd                   }
    dlflist  : string[25];        { Download File Lists                     }
    maxchrs,                      { Maximum Characters In Command Line      }
    logpf,                        { Position In Log File For Data           }
    logps    : integer;           { Position In Log File For Data           }
    permindx : longint;           { Permanent Index Number                  }
    BiDirect : boolean;           { Is the Protocol BiDirectional           }
    res      : array[1..10] of byte; { RESERVED Space                       }
  end;


  datetimerec = Record            { Date And Time Record                    }
    day,                          { Day Of The Year                         }
    hour,                         { Hour Of The Day                         }
    min,                          { Minute Of The Hour                      }
    sec : longint;                { Second Of The Minute                    }
  end;


  networkrec  = Record            { [NETWORK.DAT] - Network Info            }
    origin,                       { Default Origin Line                     }
    netmailpath,                  { NetMail Path                            }
    echomailpath,                 { EchoMail Path                           }
    nodelistpath : string[60];    { Nodelist Path                           }

    nholduser,                    { Hold All Non-SysOp NetMail?             }
    nhold,                        { Default NetMail To "hold"?              }
    ncrash,                       { Default NetMail To "crash"?             }
    nkill        : boolean;       { Default NetMail To "kill/sent"?         }
  end;


{}

