(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2  .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor.                          <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2;

interface

uses
  crt, dos, overlay,
  sysop2a, sysop2b, sysop2c, sysop2d, sysop2e, sysop2f, sysop2g, sysop2h,
  sysop2i, sysop2z, sysop2s, sysop21,
  common;

procedure changestuff;

implementation

const
  aresure='Are you sure this is what you want? ';

function wantit:boolean;
begin
  nl; wantit:=pynq(aresure);
end;

procedure changestuff;
var c:char;
    done,abort,next,savepause:boolean;
begin
  repeat
    done:=FALSE;
    cls;
    sprint(#3#5+'System configuration:');
    nl;
    abort:=FALSE; next:=FALSE; savepause:=FALSE;
    printacr('A. Modem Configuration',abort,next);
    printacr('B. BBS and File Path Configuration',abort,next);
    printacr('C. System Security Settings',abort,next);
    printacr('D. System Variables',abort,next);
    printacr('E. System Flagged Functions',abort,next);
    printacr('F. File Area Configuration',abort,next);
    printacr('G. New User and Auto-Validation settings',abort,next);
    printacr('H. Miscellaneous Configuration',abort,next);
    printacr('I. Network Configuration',abort,next);
    printacr('J. String Configuration',abort,next);
    printacr('K. Default Colors',abort,next);
    nl;
    printacr('1. Time Limitations',abort,next);
    printacr('2. Call Allowance/Day',abort,next);
    printacr('3. UL/DL # Files Ratio',abort,next);
    printacr('4. UL/DL K-Bytes Ratio',abort,next);
(*    printacr('5. Post/Call Ratio',abort,next);*)
    nl;
    prt('Enter Selection (A-K,1-4) [Q]uit : ');
    onek(c,'QABCDEFGHIJK12345'^M);
    case c of
      'A':pomodem;
      'B':pofile;
      'C':poslsettings;
      'D':pogenvar;
      'E':poflagfunc;
      'F':pofilesconfig;
      'G':ponewauto;
      'H':pomisc1;
      'I':pofido;
      'J':postring;
      'K':pocolors;
      '1':getsecrange('Time limitations',systat.timeallow);
      '2':getsecrange('Call allowance per day',systat.callallow);
      '3':getsecrange('UL/DL # files ratio (# files can DL per UL)',systat.dlratio);
      '4':getsecrange('UL/DL K-bytes ratio (#k can DL per 1k UL)',systat.dlkratio);
{     '5':getsecrange('Post/Call ratio (# 1/10''s of calls per public post to have AR flag)',systat.postratio);}
      'Q':done:=TRUE;
    end;
  until ((done) or (hangup));
  savesystat;
  if (savepause) then thisuser.ac:=thisuser.ac+[pause];
end;

end.
