(*****************************************************************************)
(*>                                                                         <*)
(*>  MULTI   .PAS -  Written by Mike Mitchell                               <*)
(*>                                                                         <*)
(*>  Multi Node Procedures and Functions                                    <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit multi;

interface

uses
  crt, dos, overlay,
  common, common1;

var numnodes: byte;

procedure listnodes;
procedure dni(tnode:byte);
procedure sendnodemsgs;
procedure readnodemsgs;
procedure nstatus(sst:string);
procedure multinodechat;

implementation

{ The Send and Recv NodeMsgs procedures are currently inoperable SEE BELOW }

procedure sendnodemsgs;
begin
  cls;
  listnodes;
end;

procedure readnodemsgs;
begin
  cls;
  listnodes;
end;

procedure dni(tnode:byte);  { Display Node Information File for Node #Tnode }
var nfile:file of nodeinfo;
    node:nodeinfo;
    abort,next:boolean;
    nodefil:string;
begin
  abort:=false;
  next:=false;
  nodefil:=systat.commonpath+'NODE'+cstr(tnode)+'.RAT';
  if not exist(nodefil) then exit;
  inc(numnodes);
  assign(nfile,nodefil);
  reset(nfile); seek(nfile,0); read(nfile,node); close(nfile);
  printacr(#3#3+'   '+cstr(tnode)+'    '+mln(node.name    ,22)+'  '+mln(node.realname,31)+'   '+node.baud,abort,next);
  printacr(#3#2+'Status: '+node.status,abort,next);
end;

procedure nstatus(sst:string);
var nfile:file of nodeinfo;
    node:nodeinfo;
    nodefil:string;
begin
  nodefil:=systat.commonpath+'NODE'+systat.nodeid+'.RAT';
  assign(nfile,nodefil);
  reset(nfile); seek(nfile,0); read(nfile,node);
  node.status:=sst;
  seek(nfile,0);
  write(nfile,node);
  close(nfile);
end;

procedure inlimulti(var s:string);             (* Input routine for mcht *)
var cv,cc,cp,g,i,j:integer;
    c,c1:char;
begin
  cp:=1;
  s:='';
  if (ll<>'') then begin
      prompt(ll);
    s:=ll; ll:='';
    cp:=length(s)+1;
  end;
  repeat
    getkey(c); checkhangup;
    case ord(c) of
      32..255:if (cp<79) then begin
                s[cp]:=c; pap:=cp; inc(cp);
                outkey(c);
                if (trapping) then write(trapfile,c);
              end;
      16:if okansi then begin
           getkey(c1);
           cl(ord(c1)-48);
         end;
      27:if (cp<79) then begin
           s[cp]:=c; inc(cp);
           outkey(c);
           if (trapping) then write(trapfile,c);
         end;
      8:if (cp>1) then begin
          dec(cp); pap:=cp;
          prompt(^H' '^H);
        end;
      24:begin
           for cv:=1 to cp-1 do prompt(^H' '^H);
           cp:=1;
           pap:=0;
         end;
       7:if (outcom) then sendcom1(^G);
      23:if cp>1 then
           repeat
             dec(cp); pap:=cp;
             prompt(^H' '^H);
           until (cp=1) or (s[cp]=' ');
       9:begin
           cv:=5-(cp mod 5);
           if (cp+cv<79) then
             for cc:=1 to cv do begin
               s[cp]:=' ';
               inc(cp); pap:=cp;
               prompt(' ');
             end;
         end;
  end;
  until ((c=^M) or (cp=79) or (hangup) or (not ch));
  if (not ch) then begin c:=#13; ch:=FALSE; end;
  s[0]:=chr(cp-1);
  if (c<>^M) then begin
    cv:=cp-1;
    while (cv>0) and (s[cv]<>' ') and (s[cv]<>^H) do dec(cv);
    if (cv>(cp div 2)) and (cv<>cp-1) then begin
      ll:=copy(s,cv+1,cp-cv);
      for cc:=cp-2 downto cv do prompt(^H);
      for cc:=cp-2 downto cv do prompt(' ');
      s[0]:=chr(cv-1);
    end;
  end;
  clreol;
  setc(7);
  nl;
end;


procedure multinodechat;
var chatstart,chatend,tchatted:datetimerec;
    s,callnode,xx:string;
    t1:real;
    i,savpap:integer;
    c:char;
    savecho,savprintingfile:boolean;
    nodefil:string;
    nfile:file of nodeinfo;
    node:nodeinfo;
    mcfile:file of mcrec;
    mcchat:mcrec;
    mcounter:byte;
    newmsg:boolean;
begin
  nosound;
  getdatetime(chatstart);
  dosansion:=FALSE;

  nodefil:=systat.commonpath+'NODE'+systat.nodeid+'.RAT';
  assign(nfile,nodefil);
  reset(nfile); seek(nfile,0); read(nfile,node);
  node.inchat:=true;
  node.paged:=false;
  node.status:='MULTINODE CHAT!';
  seek(nfile,0);
  write(nfile,node);
  close(nfile);

  savprintingfile:=printingfile;
  savpap:=pap; ch:=TRUE; chatcall:=FALSE; savecho:=echo; echo:=TRUE;
  if (systat.autochatopen) then chatfile(TRUE)
     else if (thisuser.chatauto) then chatfile(TRUE);
  nl; nl;
  thisuser.ac:=thisuser.ac-[alert];

  sprompt(#3#5+'Welcome to MultiNode Chat!'); nl; nl;
  sprint('^5RAT-MultiNode Chat, ^7Version '+ver+'    ');
  sprint('^9----------------------------------------');
  sprint('^4/?  ^3  Show this Help File        ');
  sprint('^4/W  ^3  List Users on other Nodes  ');
  sprint('^4/C  ^3  Clear the screen           ');
  sprint('^4/Q  ^3  Leave MultiNode Chat       ');
  sprint('^9----------------------------------------');
  nl;

  if (chatr<>'') then begin
    commandline(chatr); print(' '); chatr:='';
  end;
  repeat
    sprompt(#3#3+systat.nodeid+'^4: ^6'); inlimulti(xx);
    if (xx[1]='/') then xx:=allcaps(xx);
    if (xx='/W') then listnodes
    else if ((xx='/H') or (xx='/?')) then begin
      nl;
      sprint('^5RAT-MultiNode Chat, ^7Version '+ver+'    ');
      sprint('^9----------------------------------------');
      sprint('^4/?  ^3  Show this Help File        ');
      sprint('^4/W  ^3  List Users on other Nodes  ');
      sprint('^4/C  ^3  Clear the screen           ');
      sprint('^4/Q  ^3  Leave MultiNode Chat       ');
      sprint('^9----------------------------------------');
      nl;
    end
    else if (xx='/C') then cls
    else if (xx='/Q') then begin
      t1:=timer;
      while (abs(t1-timer)<0.6) and (empty) do;
      if (empty) then begin ch:=FALSE; print('Leaving RAT-MultiNode Chat...'); end
    end
    else if (xx='/O') then begin
       callnode:=copy(xx,4,1);
       if exist(systat.commonpath+'NODE'+callnode+'.RAT') then begin
        assign(nfile,systat.commonpath+'NODE'+callnode+'.RAT');
        reset(nfile);
        read(nfile,node);
        node.paged:=true;
        sprint(#3#7'Paged Node '+callnode+'...');
        write(nfile,node);
        close(nfile);
      end else sprint(#3#7'No User on Node #'+callnode+'!');
      end;
    if (cfo) then writeln(cf,xx);

    assign(mcfile,systat.commonpath+'NODEALL.MCT');
    if exist(systat.commonpath+'NODEALL.MCT') then newmsg:=true else newmsg:=false;
    if newmsg then reset(mcfile) else rewrite(mcfile);
    if newmsg then begin
      seek(mcfile,0);
      read(mcfile,mcchat);
      sprint('^3'+mcchat.fromnode+'^4: ^5'+mcchat.chatline);
      {}
      close(mcfile);
      end else
      begin
        seek(mcfile,0);
        mcchat.fromnode:=systat.nodeid;
        mcchat.toall:=true;
        mcchat.chatline:=xx;
        write(mcfile,mcchat);
        close(mcfile);
      end;
    assign(mcfile,systat.commonpath+'NODE'+systat.nodeid+'.MCT');
    if exist(systat.commonpath+'NODE'+systat.nodeid+'.MCT') then newmsg:=true else newmsg:=false;
    seek(mcfile,0);
    if newmsg then begin
      read(mcfile,mcchat);
      sprint('^7PVT FROM NODE ^3'+mcchat.fromnode+'^4: ^5'+mcchat.chatline);
      close(mcfile);
      erase(mcfile);
    end;
  until ((not ch) or (hangup));

  nl; sprint(#3#5+'RAT-MultiNode Chat Session Finished');

  getdatetime(chatend);
  timediff(tchatted,chatstart,chatend);

{
  freetime:=freetime+dt2r(tchatted);
}

  tleft;
  s:='Chatted for '+longtim(tchatted);
  if (cfo) then begin
    s:=s+'  -{ Recorded in CHAT';
    if (thisuser.chatseperate) then s:=s+cstr(usernum);
    s:=s+'.MSG }-';
  end;
  sysoplog(s);
  ch:=FALSE; echo:=savecho;
  if ((hangup) and (cfo)) then
  begin
    writeln(cf);
    writeln(cf,'NO CARRIER');
    writeln(cf);
    writeln(cf,'>> Carrier lost ...');
    writeln(cf);
  end;
  pap:=savpap; printingfile:=savprintingfile;
  commandline('');
  if (cfo) then chatfile(FALSE);
end;


procedure listnodes; { list users on other nodes }
var
    nfile: file of nodeinfo;
    node: nodeinfo;
    yournode: nodeinfo;
    rf: string[9];
    othernode: char;
    abort,next: boolean;
    tin: byte;

begin
  numnodes:=0;
  with systat do
  begin
    abort:=false; next:=false;
    nl;
    sprint(#3#7'---------------------------------------------------------------------------');
    sprint(verline(1));
    sprint(verline(2));
    sprint(verline(3));
    sprint(#3#7'---------------------------------------------------------------------------');
    sprint(#3#4' Node#  USER NAME               Real Name                        Baud Rate');
    sprint(#3#7'---------------------------------------------------------------------------');
    for tin:=1 to maxnodes do dni(tin);
    if numnodes=0 then
    sprint(#3#2'   0    MULTINODE FUNCTIONS HAVE BEEN DISABLED BY THE SYSOP');
    sprint(#3#7'---------------------------------------------------------------------------');
  end;
end;

end.
