Unit UserStuf;

Interface
Function  LoadUserInfo(Alias : String) : Boolean; (* False if Not Exist *)
Procedure WriteUserInfo(Alias : String);
Procedure WriteToLog(S : String;Stamp : Boolean);
Procedure Apply;
Implementation

Uses Dos,Crt,Records,GenStr,IO,Video,protcomm;

Procedure WriteUserInfo(Alias : String);
Var X : Integer;
    U : UserRec;
Begin
 Assign(UserF,Config.Data_Dir+'USER.DAT');
 {$I-} Reset(UserF); {$I+}
 If IOResult <> 0 then Rewrite(UserF);
 If Valu(Alias) in[1..filesize(userf)] then
  Begin
   Seek(UserF,Valu(Alias)-1);
   Write(UserF,User);
   Close(UserF);
   Exit;
  End;
 For X := 1 to FileSize(UserF) do
  Begin
   Seek(UserF,X-1);
   Read(UserF,U);
   If (uppercase(alias)=uppercase(U.Alias)) or (uppercase(alias) = uppercase(U.RealName)) then
    Begin
     Seek(UserF,X-1);
     Write(userF,User);
     Close(UserF);
     Exit;
    End;
  End;
 Close(UserF);
End;

Function UserExist(handle : String) : Boolean;
Begin
 Fillchar(User,Sizeof(User),#0);
 UserExist := LoadUserInfo(Handle);
 Fillchar(User,Sizeof(User),#0);
End;

Function LoadUserInfo(Alias : String) : Boolean; (* False if Not Exist *)
Var X : Word;
Begin
 Assign(UserF,Config.Data_Dir+'USER.DAT');
 {$I-} Reset(UserF); {$I+}
 If IOResult <> 0 then
  Begin
   Loaduserinfo := False;
   Exit;
  End;
 LoadUserInfo := False;
 If Valu(Alias) in[1..filesize(userf)] then
  Begin
   Seek(UserF,Valu(Alias)-1);
   Read(UserF,User);
   LoadUserInfo := True;
   Close(UserF);
   Exit;
  End;
 For X := 1 to FileSize(UserF) do
  Begin
   Seek(UserF,X-1);
   Read(UserF,User);
   If (uppercase(alias)=uppercase(User.Alias)) or (uppercase(alias) = uppercase(User.RealName)) then
    Begin
     LoadUserInfo := True;
     Close(UserF);
     Exit;
    End;
  End;
 Close(UserF);
End;

Procedure WriteToLog(S : String;Stamp : Boolean);
Var Year,Month,Day,DOW : Word;
    Hour,Minute,Second,MSec : Word;
    LogFile : Text;
    marker : Char;
Begin
 GetDate(Year,Month,Day,DOW);
 GetTime(Hour,Minute,Second,MSec);
 If Hour > 12 then
  Begin
   Dec(Hour,12);
   Marker := 'p';
  end else marker := 'a';
 Assign(LogFile,Config.Data_Dir+'SLOG_'+Strr(Config.NodeNumber)+'.'+Strr(DOW));
 {$I-} Append(LogFile); {$I+}
 If IOResult <> 0 then Rewrite(LogFile);
 If stamp then Write(LogFile,'-<'+LeadingZero(Month)+'/'+LeadingZero(Day)+'/'+Copy(LeadingZero(Year),3,2)+
                '   '+LeadingZero(Hour)+':'+LeadingZero(Minute)+marker+'>- ');
 Writeln(LogFile,S);
 Close(LogFile);
End;


Procedure Apply;
Function CheckExit : Boolean;
Begin
 MultiColor(Ap_AbortApp);
 CheckExit := AnsiYn('|15|17 Yes ','|16|07 Yes ','|15|17 No ','|16|07 No ');
End;
Var TempInput : String[50];
    X : Word;
   TmpUser : UserRec;
Label AskHandle,AskName,AskPasswd,AskBirth;
Begin
 Fillchar(User,SizeOf(User),0);
 { Get Handle }
AskHandle:
 MultiColor(Ap_EnterHandle);
 SInput(TempInput,30,True,False,False,0);
 If Length(TempInput) < 2 then
  Begin
   If CheckExit then Exit else goto AskHandle;
  End;
 MultiColor(Ap_CheckHandle);
 If UserExist(TempInput) then
  Begin
   MultiColor(Ap_HandleBad);
   Goto AskHandle;
  End;
 User.Alias := TempInput;
 { Get Real Name Name }
AskName:
 MultiColor(Ap_EnterName);SInput(TempInput,30,True,False,False,0);
 If Length(TempInput) < 2 then
  Begin
   If CheckExit then Exit else goto AskName;
  End;
 If (Pos(' ',TempInput) = 0) or (TempInput = ' ') then
  Begin
   MultiColor(Ap_NameBad);
   Goto AskName;
  End;
 User.RealName := TempInput;
 {Get Phone Number }
 MultiColor(Ap_PhoneNumber);SPhoneInput(TempInput);
 User.Phone := TempInput;
 {Get User Note }
 MultiColor(Ap_UserNote);SInput(TempInput,50,False,False,False,2);
 User.UserNote := TempInput;
 {Get Password}
AskPasswd:
 Fillchar(User.Password,SizeOf(User.Password),#0);
 MultiColor(Ap_Password);SInput(TempInput,30,False,False,True,2);
 If (TempInput = '') then Goto AskPasswd;
 User.Password := TempInput;
 MultiColor(Ap_ReenterPw);SInput(TempInput,30,False,False,True,2);
 If (TempInput <> User.Password) then
  Begin
   MultiColor(Ap_PWBad);
   Goto AskPasswd;
  End;
AskBirth:
 Fillchar(user.birthdate,Sizeof(User.Birthdate),#0);
 Multicolor(Ap_AskBirth);SInput(TempInput,8,False,False,False,8);
 If tempinput <> '' then User.Birthdate := TempInput else goto AskBirth;
 MultiColor(Ap_Xpert);User.XPerMode := AnsiYn('|15|17 Yes ','|16|07 Yes ','|15|17 No ','|16|07 No ');
 MultiColor(Ap_FSE);User.FSE := AnsiYn('|15|17 Yes ','|16|07 Yes ','|15|17 No ','|16|07 No ');
 MultiColor(Ap_Ansi);User.Ansi := AnsiYn('|15|17 Yes ','|16|07 Yes ','|15|17 No ','|16|07 No ');
 MultiColor(Ap_Filing);
 user.MainLev     := 1;
 user.FileLev     := 1;
 user.Flags       := '                          ';
 user.SysOpNote   := 'New User';
 user.AllowPage   := True;
 user.UserLog     := False;
 user.LogUser     := False;
 user.PCR         := 0;
 user.UDRatio     := 0;
 user.Credits     := 5000;
 user.Uploads     := 0;
 user.Downloads   := 0;
 user.BytesUp     := 0;
 user.BytesDown   := 0;
 user.Posts       := 0;
 user.Calls       := 0;
 user.CallsPerDay := 1000;
 user.LastCall    := 0;
 user.TimePerDay  := 0;
 user.TimeLeft    := 0;
 Assign(UserF,Config.Data_Dir+'USER.DAT');
 {$I-} Reset(UserF); {$I+}
 If IOResult <> 0 then Rewrite(UserF);
{ user.id := Filesize(UserF)+1;}
 If FileSize(UserF) = 0 then
  Begin
   Write(UserF,User);
   Close(UserF);
  End else
  Begin
   For X := 1 to Filesize(UserF) do
    Begin
     Seek(UserF,X-1);
     Read(UserF,TmpUser);
     If (TmpUser.Mainlev = 0) or (X = Filesize(UserF)) then
      Begin
{       User.ID := X;}
       Write(UserF,User);
       Close(UserF);
       Break;
      End;
    End;
   End;
 MultiColor(Ap_Note);
 {FSE}
 MultiColor(Ap_CallbackLater);
 Fillchar(User,SizeOf(User),#0);
 Fillchar(TmpUser,SizeOf(TmpUser),#0);
End;
End.
