Unit Pullbar;
Interface

Const maxbars=50;

Type PullModerec = Record
                    OnString,OffString : Array[1..maxbars] of String[40];
                    X           : Array[1..Maxbars] of 1..80;
                    Y           : Array[1..Maxbars] of 1..25;
                    Choices     : 1..Maxbars;
                    pointercmd  : Array[1..maxbars] of 1..50;
                    FirstOption : 1..Maxbars;
                   end;

Function Pullbars(Pull:pullmoderec):integer;

Implementation

uses io,protcomm;

Function Pullbars(Pull:pullmoderec):integer;
var On:1..maxbars;
    ch:char;

Procedure Write_Options;
Var dummy:1..maxbars;
Begin
 For dummy := 1 to pull.choices do
  begin
   goxy(pull.x[dummy],pull.y[dummy]);
   multicolor(pull.offstring[Dummy]);
  end;
  pull.firstoption:=on;
  goxy(pull.x[on],pull.y[on]);
  multicolor(pull.onstring[on]);
End;

procedure Update_Options(Down:boolean); {true:forward/false:backwards}
Begin
 Goxy(pull.x[on],pull.y[on]);
 multicolor(pull.offstring[on]);
 If Down then
  Begin
   If On < Pull.choices then Inc(on) else On := 1;
  End else
   Begin
    If On > 1 then Dec(On) else On := Pull.Choices;
   End;
 goxy(pull.x[on],pull.y[on]);
 multicolor(pull.onstring[on]);
End;

Function Get_Input : Byte;
Var CH : Char;
Begin
 CH := SReadKey;
 If CH = #0 then CH :=sReadkey;
 Case CH of
  'A' : Get_Input := 8;
  'B' : Get_Input := 2;
  #72 : Get_Input := 8;
  #80 : Get_Input := 2;
  #13 : Get_Input := 5;
 End;
End;

Var Key : Byte;

begin
 On := 1;
 Write_Options;
  Repeat
   Key := Get_input;
   Case Key of
    8 : update_options(False);
    2 : update_options(True)
   End;
  Until (Key = 5) or (not local and not carrier);
  Pullbars := On;
end;
end.
