{======= UTILITIES =======}

FUNCTION BigAdd(BANum1, BANum2 : INTEGER) : INTEGER;
VAR
  BATemp : REAL;
BEGIN
  BATemp := BANum1 + BANum2;
  IF BATemp > 30000 THEN 
    BATemp := 30000;
  BigAdd := TRUNC(BATemp);
END;

FUNCTION BigSub(BSNum1, BSNum2 : INTEGER) : INTEGER;
VAR
  BSTemp : REAL;
BEGIN
  BSTemp := BSNum1 - BSNum2;
  IF BSTemp < -30000 THEN 
    BSTemp := -30000;
  BigSub := TRUNC(BSTemp);
END;                       

PROCEDURE TextInverseOn;
BEGIN 
  TextColor(0); 
  TextBackGround(7); 
END;

PROCEDURE TextInverseOff;
BEGIN 
  TextColor(3); 
  TextBackGround(0); 
END;

FUNCTION Upper(InStr : Line) : Line;
VAR
  UCnt : INTEGER;
BEGIN
  FOR UCnt := 1 TO LENGTH(InStr) DO 
    InStr[UCnt] := UPCASE(InStr[UCnt]);
  Upper := InStr;
END;

// FUNCTION IntToStr(ITSInt : INTEGER) : TenType;
// VAR
//   ITSStr  : TenType;
// BEGIN
//   STR(ITSInt,ITSStr);
//   IntToStr := ITSStr;
// END;

FUNCTION Fmt(FLine : Line; FSide : LeftRight; FLen : INTEGER) : Line;
VAR
  FPad : Line;
BEGIN
  IF LENGTH(FLine) > FLen THEN 
    FLine := COPY(FLine,1,FLen);
  FPad := COPY(Blanks, 1, FLen - LENGTH(FLine));
  IF FSide = Left then
    Fmt := FLine + FPad
  ELSE 
    Fmt := FPad + FLine;
END;

FUNCTION LastPos(LPFind : Line; LPIn : Line) : INTEGER;
{ High-speed location of last occurance of a string in another string }
VAR
  LPCntr     : INTEGER;
  RevFind    : Line;
  RevFindLen : BYTE ABSOLUTE RevFind;
  RevIn      : Line;
  RevInLen   : BYTE ABSOLUTE RevIn;
BEGIN
  RevFindLen := LENGTH(LPFind);
  FOR LPCntr := 0 TO LENGTH(LPFind) - 1 do
    RevFind[RevFindLen - LPCntr] := LPFind[LPCntr + 1];
  RevInLen := LENGTH(LPIn);
  FOR LPCntr := 0 TO LENGTH(LPIn) - 1 do
    RevIn[RevInLen - LPCntr] := LPIn[LPCntr + 1];
  LPCntr := POS(RevFind,RevIn);
  IF LPCntr = 0 then
    LastPos := 0
  ELSE 
    LastPos := 2 + RevInLen - LPCntr - RevFindLen;
END;

FUNCTION InFocus(IFString : Line) : BOOLEAN;
BEGIN
  IF FocusString = '' then
   InFocus := TRUE
  ELSE begin
    IF POS(FocusString,Upper(IFString)) > 0 then
      InFocus := TRUE
    ELSE 
      InFocus := FALSE;
  END;
END;

FUNCTION SysLogAfter(SLNum : INTEGER) : INTEGER;
BEGIN
  IF SLNum = MaxSysLog then
    SysLogAfter := 1 
  ELSE 
    SysLogAfter := SLNum + 1;
END;

FUNCTION SysLogBefore(SLNum : INTEGER) : INTEGER;
BEGIN
  IF SLNum = 1 then
    SysLogBefore := MaxSysLog
  ELSE 
    SysLogBefore := SLNum - 1;
END;

{======= Date-Oriented Functions =======}

FUNCTION ShowDate(SDDate,SDMint : INTEGER) : TenType;
BEGIN 
  ShowDate := IntToStr(SDDate) + ':' + IntToStr(SDMint); 
END;

PROCEDURE GetDate;
VAR
  Day            : INTEGER;
  GDCntr         : INTEGER;
  Month          : INTEGER;
//  RecPack        : RegPack;
  SaveDate       : INTEGER;
  SaveMint       : INTEGER;
  Year           : INTEGER;
  ah,al,ch,cl,dh : BYTE;
BEGIN
(*******************************************************
  SaveDate := Date;
  SaveMint := Mint;
  {--- Get Day ---}
  WITH RecPack DO ax := $2A SHL 8;
  MSDOS(RecPack);
  WITH RecPack DO
  BEGIN
    Day := dx MOD 256;
    Month := dx SHR 8;
    Year := cx;
  END;
  Date := ((Year - 1985) * 365) + Day;
  IF Month > 1 THEN
  FOR GDCntr := 1 TO Month - 1 DO Date := Date + DaysInMonth[GDCntr];
  {--- Get Mint ---}
  ah := $2C;
  WITH RecPack DO ax := ah SHL 8 + al;
  INTR($21,RecPack);
  WITH RecPack DO
  BEGIN
    Mint := (cx SHR 8 * 60) + (cx MOD 256);
    Secs := dx SHR 8;
  END;
****************************************)
END;

FUNCTION GetHSecs : INTEGER;
// VAR
  // RecPack        : RegPack;
BEGIN
//  WITH RecPack DO ax := $2C SHL 8;
//  MSDOS(RecPack);
//  WITH RecPack DO GetHSecs := dx MOD 256;
END;

FUNCTION ElapsedTime(FromDate, FromMint, ToDate, ToMint : INTEGER) : REAL;
BEGIN
  ElapsedTime := ((ToDate - FromDate) * 1440.0) + (ToMint - FromMint);
END;

FUNCTION Before(FromDate, FromMint, ToDate, ToMint : INTEGER) : BOOLEAN;
BEGIN
  IF ElapsedTime(FromDate, FromMint, ToDate, ToMint) > 0.0 then
    Before := TRUE
  ELSE 
    Before := FALSE;
  IF FromDate = 0 THEN 
    Before := FALSE;
END;

PROCEDURE IncrementLog;
BEGIN
  NextLog := SysLogAfter(NextLog);
  WITH SysLogItem DO begin
    SLDate := 0;
    SLMint := 0;
    SLType := '?';
    SLText := '-- Pointer to Next Log Item --';
    SLRept := NextLog;
  END;
  SEEK(SysLogFile,0);
  WRITE(SysLogFile,SysLogItem);
END;

PROCEDURE SysLog(MsgType : CHAR; SLLine : Line);
VAR
  SLFind   : INTEGER;
  SLX, SLY : INTEGER;
BEGIN
  WITH SysLogItem DO begin
    SLDate := Date;
    SLMint := Mint;
    SLType := MsgType;
    SLText := SLLine;
    SLRept := SpellRepeat;
  END;
  SEEK(SysLogFile,NextLog);
  WRITE(SysLogFile,SysLogItem);
  IncrementLog;
  SLX := WHEREX; SLY := WHEREY;
  // WINDOW(1,1,80,25); GOTOXY(26,1);
  // TextInverseOn; CLREOL; WRITE(SLLine); TextInverseOff;
  // WINDOW(1,3,80,25); GOTOXY(SLX,SLY);
END;

PROCEDURE StatusLine;  { Top-line status-line for WizOp's information }
VAR
  SOX, SOY : INTEGER;
BEGIN
  //SaveTime := Mint;
  //SOX := WHEREX; SOY := WHEREY;
  //WINDOW(1,1,25,25);
  //TextInverseOn;
  //GOTOXY(1,1); CLREOL;
  //WRITE('Lev '+IntToStr(Level)+' Time ');
  //WRITE(IntToStr(Patience - TRUNC(ElapsedTime(StartDate,StartMint,Date,Mint)))+' ');
  //IF WizOp      THEN WRITE(#236) ELSE WRITE(' ');
  //IF ShutDown   THEN WRITE(#031) ELSE WRITE(' ');
  //IF Chattable  THEN WRITE(#001) ELSE WRITE(' ');
  //IF Alert      THEN WRITE(#004) ELSE WRITE(' ');
  //IF ChatAsk    THEN WRITE( '?') ELSE WRITE(' ');
  //IF Ascendable THEN WRITE(#127) ELSE WRITE(' ');
  //TextInverseOff;
  //WINDOW(1,3,80,25);
  //GOTOXY(SOX,SOY);
END;

PROCEDURE Contact(CType : CHAR); FORWARD;  { Chat-with-WizOp }

PROCEDURE DoFnKeys;  { Process Function keys from console }
VAR
  FnKey   : CHAR;
  DFKNum  : INTEGER;
BEGIN
(*****************************************************************************
  ExFnKey := TRUE;
  DELAY(100);
  IF KEYPRESSED THEN
  BEGIN
    READ(KBD,FnKey);
    CASE FnKey OF
      {------- Regular Function Keys -------}
      ';' : BEGIN { F1 }
              WRITELN; WRITELN;
              WRITELN('   Regular Function Keys                ALT Function Keys');
              WRITELN('  ͻ            ͻ');
              WRITELN('1    HELP    YOO-HOO!   2       1     --        --      2');
              WRITELN('  ͹            ͹');
              WRITELN('3  TIME -10  TIME +10   4       3     --        --      4');
              WRITELN('  ͹            ͹');
              WRITELN('5  OK  CHAT    CHAT     6       5     --        --      6');
              WRITELN('  ͹            ͹');
              WRITELN('7     --        --      8       7  SANCTIFY   BANISH    8');
              WRITELN('  ͹            ͹');
              WRITELN('9  SHUTDOWN     --     10       9   ASCENT     WIZOP   10');
              WRITELN('  ͼ            ͼ');
              WRITELN;
            END;
      '<' : BEGIN { F2 }
              Alert := NOT Alert;
              IF Alert THEN
              BEGIN
                WRITELN; WRITELN;
                WRITELN(#17#16+' Enter a list of names to wait for, like this: Fred/Mary/John');
                WRITE('> ');
                READLN(AlertName);
                AlertName := '/'+Upper(AlertName);
                WRITELN;
                WRITELN(#17#16+' Press the Yoo-Hoo key again when you wish to disable monitoring.');
                WRITELN;
              END;
            END;
      '=' : Patience := Patience - 10;  { F3 }
      '>' : Patience := Patience + 10;  { F4 }
      '?' : Chattable := NOT Chattable;  { F5 }
      '@' : IF CONTACTING THEN WRITE(#17#16+' ??? '+#17#16) ELSE Contact('I');  { F6 }
      'C' : BEGIN
              ShutDown := NOT ShutDown;  { F9 }
              IF ShutDown
              THEN SysLog('L','"No Visitors" sign put up')
              ELSE SysLog('L','"No Visitors" sign taken down');
            END;
      {------- ALT Function Keys -------}
      'n' : BEGIN  { ALT-F7 }
              WRITELN; WRITELN;
              WRITE(#17#16+' Sanctify this wizard upon disconnection?  (Y/N)  ');
              READ(KBD,FnKey);
              WRITELN; WRITELN;
              IF UPCASE(FnKey) = 'Y'
              THEN
              BEGIN
                WRITELN(#17#16+' This wizard will be sanctified!');
                MaxLev := 0;
              END
              ELSE WRITELN(#17#16+' No action taken.');
              WRITELN;
            END;
      'o' : BEGIN  { ALT-F8 }
              WRITELN; WRITELN;
              WRITE(#17#16+' Banish this wizard upon disconnection?  (Y/N)  ');
              READ(KBD,FnKey);
              WRITELN; WRITELN;
              IF UPCASE(FnKey) = 'Y'
              THEN
              BEGIN
                WRITELN(#17#16+' This wizard will be banished upon disconnection!');
                Patience := 1;
                Postings := -100;
              END
              ELSE WRITELN(#17#16+' Nothing done.');
              WRITELN;
            END;
      'p' : BEGIN  { ALT-F9 }
              IF Ascendable = FALSE
              THEN Ascendable := TRUE
              ELSE
              BEGIN
                Ascendable := FALSE;
                WRITELN(#17#16+' No ascending; the Guardian explains why:');
                WRITELN('----+----1----+----2----+----3----+----');
                READLN(NoAscendMsg);
                IF LENGTH(NoAscendMsg) = 0
                THEN NoAscendMsg := 'TSOTL has his reasons!';
              END;
            END;
      'q' : BEGIN
              WizOp := NOT WizOp;
              IF WizOp THEN
              BEGIN
                FOR DFKNum := 200 TO 800 DO
                BEGIN
                  SOUND(RANDOM(DFKNum)+1200);
                  DELAY(RANDOM(5));
                  NOSOUND;
                  DELAY(RANDOM(2));
                END;
              END;  { WizOp On }
            END;  { WizOp key }
      ELSE
      WRITELN; WRITELN; WRITELN(#17#16+' Undefined Function Key'); WRITELN;
    END;
    StatusLine;
  END;
****************************************************)
END;
