FUNCTION GotCarrier : BOOLEAN;
BEGIN
  GotCarrier := true;
END;

PROCEDURE SetBaud(BaudRate : INTEGER);
BEGIN
END;

FUNCTION GotComChar : BOOLEAN;
BEGIN
  GotComChar := Keypressed;

END;

FUNCTION TransmitReady : BOOLEAN;
BEGIN
  TransmitReady := TRUE;
END;

FUNCTION AnyKeyPressed : BOOLEAN;
begin
  IF KEYPRESSED THEN   
    AnyKeyPressed := TRUE;
END;

FUNCTION LostCarrier : BOOLEAN;
BEGIN
  LostCarrier := FALSE;
END;

FUNCTION SerialIn : CHAR;
VAR
  CHARIn    : CHAR;
  CmdChar   : CHAR;
  GotEvent  : BOOLEAN;
  TimeInner : INTEGER;
  TimeOut   : BOOLEAN;
  TimeOuter : INTEGER;
BEGIN
  {----- Loop until something other than a FnKey request -----}
  REPEAT
      IF AnyKeyPressed OR LostCarrier OR TimeOut OR SysFail  then
        GotEvent := TRUE;
  UNTIL GotEvent;
    {--- Process the event ---}
  IF LostCarrier OR SysFail THEN begin
    IF LostCarrier THEN 
      Logoff := TRUE;
  end else begin
    CharIn := ReadKey;
    Last2Char := LastChar;
    LastChar  := CHARIn;
    SerialIn  := CHARIn;
  end;
END;

PROCEDURE AwaitSend;
BEGIN
//  REPEAT UNTIL TransmitReady OR LostCarrier;
END;

PROCEDURE SerialOut(OutChar : CHAR);
VAR
  SLCntr   : INTEGER;
BEGIN
(***************
  IF GotCarrier THEN begin
  {----- Check for character during output -----}
    IF AnyKeyPressed AND (NOT Inputting) THEN begin
      CharDuringO := TRUE;
      DuringOChar := SerialIn;
    END else begin
      IF  (DuringOChar IN [^S, 'P', 'p']) THEN begin
        CharDuringO := FALSE;
        REPEAT UNTIL AnyKeyPressed OR LostCarrier;
        DuringOChar := SerialIn;
      END;  { Pausing }
    END;  { Not after FnKey }
  END;  { Char during output }
  {----- Update the console -----}
  IF OutChar <> ^Q THEN 
    WRITE(OutChar);
****************)
   write(OutChar);
END;

PROCEDURE XLF;
BEGIN
  IF NOT SuppressOut THEN begin
    SerialOut(#13);
    SerialOut(#10);
  END;

END;

PROCEDURE SendLine(OutLine : Line);
VAR
  CHARPosn  : BYTE;
  XInChar   : CHAR;
  XLen      : INTEGER;
BEGIN
  IF NOT SuppressOut THEN
  BEGIN
    XLen := LENGTH(OutLine);
    IF XLen <> 0 THEN
    BEGIN
      CHARPosn := 0;
      REPEAT
        IF AnyKeyPressed AND (Adding OR Contacting) AND Wrapping then begin
          if KeyPressed then
            XInChar := SerialIn
          else
            XInChar := #0;

          IF XInChar > #27 THEN begin
            InputLen := InputLen + 1;
            IF InputLen > 100 THEN InputLen := 100;
            InputLine[InputLen] := XInChar;
          END;
        END
        ELSE
        BEGIN
          {----- Spaced out a file transmit? -----}
          IF OutFiling AND CharDuringO AND (DuringOChar = ' ')
          THEN
          BEGIN
            XLen := CHARPosn;
            XLF;
          END
          ELSE
          BEGIN
            CHARPosn := CHARPosn + 1;
            SerialOut(OutLine[CHARPosn]);
            IF CHARPosn > 1 THEN
            BEGIN
              IF (OutLine[CHARPosn-1] = ^H) THEN
              BEGIN
                IF OutLine[CHARPosn] <> ^H
                THEN
                IF ((BaudRate > 500) OR LocalUser)
                THEN DELAY(75)
                ELSE DELAY(15);
              END;  { Imbedded backspace }
            END; { Worth checking for backspace }
          END;  { Output of file not interrupted }
        END;  { Not taking another character during wrap }
      UNTIL (CHARPosn = XLen);
    END;  { Output longer than 0 }
  END;  { Output not suppressed }
END;  { X }

PROCEDURE X(WorkLine : Line);
VAR
  BSCntr     : INTEGER;
  FoundWrap  : BOOLEAN;
  WorkLen    : INTEGER;
  WorkPtr    : INTEGER;
  WorkWidth  : INTEGER;
  XLen       : INTEGER;
BEGIN
  SendLine(WorkLine);
(*******************************************************************
  WorkWidth := Width - 1;
  {----- Step through the fragments -----}
  REPEAT
    WorkPtr := 999;
    XLen := LENGTH(WorkLine);
    IF XLen > WorkWidth THEN
    BEGIN
      {--- Find the maximum allowable ---}
      FoundWrap := FALSE;
      WorkPtr := 0;
      BSCntr  := 0;
      REPEAT
        WorkPtr := WorkPtr + 1;
        IF WorkLine[WorkPtr] = ^H THEN BSCntr := BSCntr + 2;
        IF WorkPtr - BSCntr = WorkWidth THEN FoundWrap := TRUE;
      UNTIL (FoundWrap) or ((WorkPtr+1) >= length(WorkLine));
      {--- Step backwards to a wrap point ---}
      FoundWrap := FALSE;
      WorkPtr := WorkPtr + 1;
      REPEAT
        WorkPtr := WorkPtr - 1;
        IF POS(WorkLine[WorkPtr],' .,?!:;)]%-+') > 0
        THEN FoundWrap := TRUE;
        {--- Is it a hopeless case? ---}
        IF WorkPtr + BSCntr < BreakPoint THEN
        BEGIN
          WorkPtr := WorkWidth;
          FoundWrap := TRUE;
        END;
      UNTIL FoundWrap;
    END;  { Needs wrapping }
    {--- Send line, remove sent text, do linefeed if wrapping ---}
    IF WorkPtr > XLen THEN WorkPtr := XLen;
    SendLine(COPY(WorkLine,1,WorkPtr));
    DELETE(WorkLine,1,WorkPtr);
    IF LENGTH(WorkLine) > 0 THEN XLF;  { Get ready for another piece }
  UNTIL (LENGTH(WorkLine) = 0) OR (CharDuringO AND (DuringOChar = ' '));
**************************************************************************)

END;

PROCEDURE XLn(OutLine : Line);
BEGIN   
  X(OutLine);  
  XLF;  
END;

PROCEDURE XLnI(OutLine : Line);  { Skippable Informatory Messages }
BEGIN                            { It's up to you to reset CharDuringO }
  IF NOT (CharDuringO AND (DuringOChar = ' ')) THEN XLn(OutLine);
END;  { XLnI }

PROCEDURE SlowX(SXLine : Line);
VAR
  SXCntr : INTEGER;
BEGIN
  FOR SXCntr := 1 TO LENGTH(SXLine) DO
  BEGIN
    SerialOut(SXLine[SXCntr]);
    IF GotCarrier THEN DELAY(80);
  END;
END;

PROCEDURE PySerialInit;
BEGIN
  CharDuringO := FALSE;
  Inputting := FALSE;
  TimeOutCntr := 0;
  TimeOutSecs := 10;
END;

PROCEDURE BackSpace;
BEGIN
  IF InputLen > 0 THEN
  BEGIN
    BSCntr := BSCntr + 1;
    InputLen := InputLen - 1;
    SerialOut(^H);  SerialOut(' ');  SerialOut(^H);
  END;
END;

FUNCTION GetInput : Line;
VAR
  BSCntr    : INTEGER;
  EndTime   : REAL;
  GIChar    : CHAR;
  GotInput  : BOOLEAN;
  StartTime : REAL;
  WrapCntr  : INTEGER;
  WrapPtr   : INTEGER;
BEGIN
  GotInput := FALSE;
  Inputting := TRUE;
  InputLen := 0;
  BSCntr := 0;
  IF LENGTH(CmdParm) > 0 THEN
  BEGIN
    InputLine := CmdParm;
    CmdParm := '';
    IF NOT ((Adding OR Contacting) AND Wrapping) THEN GotInput:= TRUE;
    WrapCntr := 0;
    REPEAT
      WrapCntr := WrapCntr + 1;
      X(InputLine[WrapCntr]);
    UNTIL (WrapCntr = InputLen);   { Can be extended by X function }
  END;
  IF NOT GotInput THEN
  BEGIN
    SerialOut(^Q);
    BSCntr := 0;
    GetDate;
    StartTime := Mint * 60 + Secs;
    REPEAT
      GIChar := SerialIn;
      IF Contacting THEN
      BEGIN
        IF GIChar = ^M
        THEN
        BEGIN
          SOUND(700);
          DELAY(5);
        END
        ELSE
        BEGIN
          SOUND(1000+ORD(GIChar));
          DELAY(1);
        END;
        NOSOUND;
      END;
      CASE GIChar OF
        #27 : BEGIN END;
        ^M  : GotInput := TRUE;
        ^X  : WHILE InputLen > 0 DO BackSpace;
        ^H  : BackSpace;
      ELSE
        IF GIChar = ^B THEN
        BEGIN
          GIChar := ^H;  { Allow imbedded backspaces }
          BSCntr := BSCntr + 2;  { Removes two from screen }
        END;
        IF (InputLen - BSCntr < 76) AND (InputLen < 100) THEN
        BEGIN
          InputLen := InputLen + 1;
          IF UpCaseInput THEN GIChar := UPCASE(GIChar);
          InputLine[InputLen] := GIChar;
          SerialOut(GIChar);
        END;
        IF (InputLen - BSCntr >= 76) AND Wrapping THEN
        BEGIN
          WrapPtr := InputLen + 1;
          REPEAT
            WrapPtr := WrapPtr - 1
          UNTIL (InputLine[WrapPtr] = ' ') OR (WrapPtr < 55);
          IF WrapPtr >= 55
          THEN
          BEGIN
            IF WrapPtr <> InputLen
            THEN
            BEGIN
              FOR WrapCntr := (WrapPtr + 1) TO InputLen DO X(^H);
              FOR WrapCntr := (WrapPtr + 1) TO InputLen DO X(' ');
              CmdParm := COPY(InputLine, WrapPtr + 1, InputLen - WrapPtr);
            END;
            InputLen := WrapPtr - 1;
            GotInput := TRUE;
          END;
        END;
      END; { Not BS, CR, ESC or CTL-X }
    UNTIL GotInput;
    GetDate;
    EndTime := Mint * 60 + Secs;
    IF StartTime > EndTime { i.e. midnight-wrap } THEN
    EndTime := EndTime + 86400.0;
    InputTime := EndTime - StartTime;
  END; { No CmdParm }
  Inputting := FALSE;
  GetInput := InputLine;
END;

FUNCTION GetInputLn : Line;
BEGIN
  GetInputLn := GetInput;
  X(^M+^J);
END;

FUNCTION GetInt(GIPrompt : Line) : INTEGER;
VAR
  GotInt   : BOOLEAN;
  IntChar  : CHAR;
  TestNum  : INTEGER;
  VALxxx   : INTEGER;
BEGIN
  GotInt := FALSE;
  IF (LENGTH(CmdParm) > 0)
  THEN
  BEGIN
    VAL(CmdParm,TestNum,VALRetCode);
    IF VALRetCode = 0 THEN
    BEGIN
      CmdParm := '';
      GotInt := TRUE;
    END
    ELSE
    BEGIN
      IF VALRetCode = 1
      THEN GotInt := FALSE
      ELSE
      BEGIN
        VAL(COPY(CmdParm,1,VALRetCode - 1),TestNum,VALxxx);
        GotInt := TRUE;
        DELETE(CmdParm,1,VALRetCode);
      END;
    END;
    IF GotInt THEN XLn(GIPrompt+IntToStr(TestNum));
  END;  { Had a stacked value }
  IF NOT GotInt THEN
  BEGIN
    InputLine := '';
    X(GIPrompt+^Q);
    Inputting := TRUE;
    REPEAT
      IntChar := SerialIn;
      IF IntChar IN ['0'..'9',^H,^M,^X]
      THEN
      BEGIN
        CASE IntChar OF
          #27 : BEGIN END;
          ^H  : BackSpace;
          ^M  : GotInt := TRUE;
          ^X  : While InputLen > 0 DO BackSpace;
        ELSE
          InputLen := InputLen + 1;
          IF InputLen > 5 THEN
          BEGIN
            InputLine := '32767';
            GotInt := TRUE;
          END
          ELSE InputLine[InputLen] := IntChar;
          SerialOut(IntChar);
        END;
      END;
      IF Logoff THEN
      BEGIN
        GotInt := TRUE;
        InputLine := '';
      END;
    UNTIL GotInt;
    IF LENGTH(InputLine) = 0 THEN
    BEGIN
      InputLine := '0';
      SerialOut('0');
    END;
    XLF;
    Inputting := FALSE;
    VAL(InputLine,TestNum,VALRetCode);
  END; { No valid cmdparm }
  IF TestNum < 0 THEN TestNum := 0;
  GetInt := TestNum;
END;

PROCEDURE GetTestPass;
VAR
  GTPChar : CHAR;
BEGIN
  XLF;
  X('<(*)> '+^Q);
  TestPass := '';
  Inputting := TRUE;
  REPEAT
    GTPChar := SerialIn;
    IF GTPChar <> ^M THEN
    BEGIN
      IF GTPChar = ^H
      THEN
      BEGIN
        IF LENGTH(TestPass) > 0 THEN
        BEGIN
          X(^H+' '+^H);
          TestPass := COPY(TestPass,1,LENGTH(TestPass)-1);
        END;
      END
      ELSE
      BEGIN
        TestPass := TestPass + UPCASE(GTPChar);
        X('*');
      END;
    END;
  UNTIL (GTPChar = ^M) OR (LENGTH(TestPass) = 10);
  Inputting := FALSE;
END;

{======= Modem-Control Routines =======}

FUNCTION LocalSerialIn : CHAR;
BEGIN
END;

PROCEDURE LocalSerialOut(LSOChar : CHAR);
BEGIN
END;

FUNCTION ModemResponse : ComLine;
BEGIN
END;

FUNCTION WaitForOkay : ComLine;
BEGIN
END;

PROCEDURE ModemCtrl(MCLine : ComLine);
BEGIN
end;
PROCEDURE DropReady;
begin
END;

PROCEDURE DropCarrier;
BEGIN
  XLF; XLF;
  IF GotCarrier THEN
  BEGIN
    WRITE(#17#16+' Disconnecting...');
    DropReady;
  END;
END;

PROCEDURE ResetAnswer;
BEGIN
END;

PROCEDURE ModemInit;
BEGIN
END;

PROCEDURE AwaitUser;
VAR
  AUChar    : CHAR;
  AULine    : Line;
  GotUser   : BOOLEAN;
  Response  : ComLine;
BEGIN
  WRITELN;
  // WRITELN(#17#16+' Awaiting visitor...');
  write(#17#16+'Press [RETURN]:');
  WRITELN;
  GotUser   := FALSE;
  LastChar  := ' ';
  Last2Char := ' ';
  LocalUser := FALSE;
  Response  := '';
  REPEAT
    {--- Detect console user ---}
    IF KEYPRESSED THEN begin
      AUChar := ReadKey;
      IF AUChar = #27 then
        DoFnKeys
      ELSE begin
        ModemCtrl(ModemPickUp);
        GotUser    := TRUE;
        HadCarrier := FALSE;
        LocalUser  := TRUE;
      END;
    END;
  UNTIL GotUser;
  WRITELN; WRITELN(#17#16+' Connected.');
END;
