{======= COMMAND PARSING =======}

PROCEDURE GetCommand;
BEGIN
  XLF;
  X('<('+IntToStr(Altitude)+')> ');
  CmdWasTyped := FALSE;
  IF LENGTH(CmdParm) = 0 THEN
  BEGIN
    UpCaseInput := TRUE;
    Cmd := GetInput;
    UpCaseInput := FALSE;
    IF Cmd = '?' THEN
    BEGIN
      Backspace;
      X('HELP');
      Cmd := 'HELP';
    END;
    CmdWasTyped := TRUE;
  END;
  CharDuringO := FALSE;
END;

PROCEDURE DoCommand;
VAR
  DCChar    : CHAR;
  DCLine    : Line;
  DCNum     : INTEGER;
  CmdLen    : INTEGER;
  CmdNumber : INTEGER;
  CmdOkay   : BOOLEAN;
  CompLen   : INTEGER;
  CompWord  : STRING[10];
  SpacePos  : INTEGER;
BEGIN
  GetDate;
  IF NOT CmdWasTyped THEN Cmd := CmdParm;
  CmdParm := '';
  {--- Parse parm ---}
  SpacePos := POS(' ',Cmd);
  IF SpacePos <> 0 THEN
  BEGIN
    CmdParm := Cmd;
    DELETE(CmdParm,1,SpacePos);
    Cmd := COPY(Cmd,1,SpacePos-1);
  END;
  IF NOT CmdWasTyped THEN X(Cmd);
  {--- Check for anything left ---}
  CmdLen := LENGTH(Cmd);
  IF CmdLen = 0
  THEN CmdOkay := FALSE
  ELSE CmdOkay := TRUE;
  IF CmdOkay THEN
  BEGIN
    {------- Find command and complete it -------}
    CmdOkay := FALSE;
    CmdNumber := 0;
    REPEAT
      CmdNumber := CmdNumber + 1;
      CompWord := CmdWords[CmdNumber];
      CompLen := CmdLen;
      IF LENGTH(CompWord) < CompLen THEN CompLen := LENGTH(CompWord);
      IF  (COPY(CmdWords[CmdNumber],1,CompLen) = COPY(Cmd,1,CompLen))
      AND ((CmdLevels[CmdNumber] < 401) OR WizOp)
      THEN CmdOkay := TRUE;
    UNTIL CmdOkay OR (CmdNumber = NumCmds);
    IF CmdOkay THEN
    BEGIN
      IF (LENGTH(CompWord) > CmdLen) AND (CmdParm = '')
      THEN XLn( COPY( CompWord, CmdLen+1, LENGTH(CompWord) ) )
      ELSE XLF;
    END
    ELSE
    BEGIN
      XLF; XLF;
      XLn('The Spirit Of The Land rumbles...'); XLF;
      XLn('"THAT WORD MEANS NOTHING TO ME."');  XLF;
      XLn('(Try using the HELP command)');
      CmdParm := '';
    END;
    XLF;
    {--- Test for level ---}
    IF CmdOkay THEN
    BEGIN
      IF ((CmdLevels[CmdNumber] > Level) AND (NOT WizOp)) THEN
      BEGIN
        XLn('The hills tremble as TSOTL speaks:');
        XLF;
        XLn('"THAT IS A LEVEL '+IntToStr(CmdLevels[CmdNumber])+' SPELL.');
        XLn('YOUR SORCERY LEVEL IS ONLY '+IntToStr(Level)+'."');
        CmdOkay := FALSE;
      END;  { Process too-high spells }
    END;
    {--- Subtract MP ---}
    SpellCost := CmdCosts[CmdNumber];
    IF CmdOkay AND (SpellCost <> 0) THEN
    BEGIN
      IF (NOT ((CompWord = 'CLOAK') OR (CompWord = 'ASCEND')))
      AND (AscCnt > 5) THEN AscCnt := AscCnt - 2;
      IF ((CompWord = 'CLOAK') OR (CompWord = 'ASCEND'))
      AND (Altitude       > 29)
      AND ((Altitude + 1) > Level)
      THEN SetManna(MannaPoints - Altitude)
      ELSE SetManna(MannaPoints - SpellCost);
      IF MannaPoints < 0 THEN
      BEGIN
        XLn('TSOTL thinks you are a fool.');
        XLF;
        XLn('"YOU DIDN''T HAVE ENOUGH MANNA-POINTS TO');
        XLn('DO THAT SPELL AND REMAIN CONSCIOUS."');
        CmdOkay := FALSE;
      END;
    END;
    {--- Check for goof ---}
    IF CmdOkay THEN
    BEGIN
      CmdLevel := CmdLevels[CmdNumber];
      IF (CmdLevel > 0) AND (Level < 19) THEN
      BEGIN
        IF RANDOM(1000) < ((20 - Level) + CmdLevel) THEN
        BEGIN
          XLn('The Spirit Of The Land ignores you.');
          CmdOkay := FALSE;
        END;
      END;
    END;
    {------- Execute the command -------}
    IF CmdOkay THEN
    BEGIN
      CharDuringO := FALSE;
      CASE CmdNumber OF
        01 : BEGIN  { Article }
               IF XFile(File_Article) = OpenError
               THEN XLn('No article available');
             END;
        02 : BEGIN  { Ascend }
               IF Level < (Altitude + 1)
               THEN Ascend
               ELSE
               BEGIN  { Cheap ascent if already qualified }
                 SetAltitude(Altitude + 1);
                 SetManna(MannaPoints + SpellCost - 1);
               END;
             END;
        03 : Banish('B');   { Banish }
        04 : WriteBoard('P');  { Beseech }
        05 : Bestow;
        06 : Boost;
        07 : Logoff := TRUE;  { Bye }
        08 : Change;
        09 : BEGIN  { Charge }
               Charging := TRUE;
               Ascend;
             END;
        10 : Check;
        11 : BEGIN  { Cloak }
               XLn('The protective mists rise about you...');
               XLF;
               Charging := TRUE;
               Cloaked := TRUE;
               Ascend;
             END;
        12 : BEGIN { Close }
               SysLog('L','"No Visitors" sign put up');
               Logoff := TRUE;
               ShutDown := TRUE;
             END;
        13 : Contact('N');  { I.E. Normal, not Interruption }
        14 : Correct;
        15 : BEGIN  { Defocus }
               FocusString := '';
               XLn('Defocussed.');
             END;
        16 : Demote;
        17 : SetAltitude(Altitude - 1);  { Descend }
        18 : Detect;
        19 : BEGIN  { Detune }
               TuneString := '';
               XLn('Detuned.');
             END;
        20 : Drain('D');
        21 : Seismo('F'); { Feed }
        22 : Focus;
        23 : Help;
        24 : BEGIN  { Hints }
               Explained := FALSE;
               IF XFile(File_Hints) = OpenError
               THEN XLn('No hints available.');
             END;
        25 : Hurl;
        26 : BEGIN  { Info }
               Explained := FALSE;
               IF XFile(File_Info) = OpenError
               THEN XLn('No information available.');
             END;
        27 : Inquire;
        28 : WriteBoard('S');  { Inscribe }
        29 : IF NOT ReadBoard('P') THEN XLn('No new beseeching!');  { Listen }
        30 : Manna;
        31 : BEGIN  { Nature }
               IF XFile(File_Nature) = OpenError
               THEN XLn('No information available');
             END;
        32 : BEGIN
               NonReadInfo := TRUE;
               ShowSysLog('IL');  { Observe }
             END;
        33 : OmniView;
        34 : Probe;
        35 : WriteBoard('G');  { Proclaim }
        36 : Promote;
        37 : IF NOT ReadBoard(XlateBand(Altitude))  { Read }
             THEN
             BEGIN
               XLn('Nothing new to read from the');
               XLn(PresentBoard+'.');
             END;
        38 : ShowSysLog('L');  { Recall }
        39 : Banish('R');   { Reduce }
        40 : Review;  { Review }
        41 : Roster;
        42 : BEGIN  { Rules }
               Explained := FALSE;
               IF XFile(File_Rules) = OpenError
               THEN XLn('Rules not available.');
             END;
        43 : Sanctify;
        44 : BEGIN  { Scan }
               IF LENGTH(FocusString) > 0
               THEN XLn('Focused on ... "'+FocusString+'"');
               IF LENGTH(TuneString) > 0
               THEN XLn('Tuned to ..... "'+TuneString+'"');
               IF NOT ReadBoard('*') THEN BEGIN END;
             END;
        45 : IF NOT ReadBoard('S') THEN XLn('Nothing new in the scrolls.');
        46 : WriteBoard(XlateBand(Altitude));  { Send }
        47 : SlowTime;
        48 : Specs;
        49 : Spells;
        50 : Seismo('S'); { Starve }
        51 : Drain('S');  { Steal }
        52 : StopTime;
        53 : IF XFile(File_Straight) = OpenError  { Straight }
             THEN XLn('Not available');
        54 : Suggest;
        55 : Teleport;
        56 : TimeWarp;
        57 : Tune;
      END;  { CASE }
    END; { Execute }
  END;
  {------- Clean-Up -------}
  CharDuringO := FALSE;
  SpellRepeat := 1;
END;

PROCEDURE CheckPatience;
BEGIN
  IF ElapsedTime(StartDate, StartMint, Date, Mint) > Patience
  THEN
  BEGIN
    XLF; XLn('With a thunderclap, TSOTL declares,'); XLF;
    XLn('"I TIRE OF YOUR PRESENCE, MORTAL!"');
    Logoff := TRUE;
  END;
  IF MannaPoints <= 0 THEN
  BEGIN
    XLF;  XLn('With a crash of thunder, TSOTL shouts,');  XLF;
    XLn('"YOU HAVE NO MORE MANNA, MORTAL!"'); XLF;
    XLn('You slide downhill as you');
    XLn('lose consciousness...');
    XLn(LF+'Try again, tomorrow.');
    Logoff := TRUE;
  END;
END;
