PROCEDURE GetSpellRepeat;
VAR
  GSRMax : INTEGER;
BEGIN
  MannaPoints := MannaPoints + SpellCost;   { Assume '0' repetitions for now }
  IF SpellCost = 0
  THEN GSRMax := 500
  ELSE GSRMax := MannaPoints DIV SpellCost;
  REPEAT
    X('You can afford to do this '+IntToStr(GSRMax)+' time');
    IF GSRMax <> 1 THEN X('s');
    XLn('.');
    XLF;
    SpellRepeat := GetInt('How many times?  ');
    XLF;
  UNTIL (SpellRepeat <= GSRMax);
  MannaPoints := MannaPoints - SpellCost * SpellRepeat;
END;

FUNCTION Yes : BOOLEAN;
VAR
  YChar : CHAR;
BEGIN
  XLF;  X('Do you wish to do so? (Y/N)  '+^Q);
  REPEAT YChar := UPCASE(SerialIn);  UNTIL (YChar IN ['Y','N', ^M]);
  IF YChar = ^M THEN YChar := 'N';
  SerialOut(YChar);  XLF;
  IF YChar = 'Y'  THEN Yes := TRUE  ELSE Yes := FALSE;
END;

PROCEDURE ExplainKeys;
BEGIN
  IF (Level < 5) AND (NOT Explained) THEN
  BEGIN
    XLn('Press SPACEBAR to skip print.');
    XLn('Press P to pause and restart.');
    IF Multiple THEN
    XLn('Any other key  displays menu.');
    XLF;
    DELAY(1000 - (Level * 150));
    Explained := TRUE;
  END;
END;

PROCEDURE ShowSysLog(ShowWhat : TenType);
VAR
  SSCntr : INTEGER;
  SSDate : INTEGER;
  SSDone : BOOLEAN;
  SSLoop : INTEGER;
  SSMint : INTEGER;
  SSSave : INTEGER;
  SSStep : INTEGER;
  SSTry  : INTEGER;
BEGIN
  X('Meditate on the past....');
  IF Level > 250 THEN ShowWhat := ShowWhat + 'W';
  SSDate := Date_Last;
  SSMint := Mint_Last;
  IF Date_Warp <> -1 THEN
  BEGIN
    SSDate := Date_Warp;
    SSMint := Mint_Warp;
  END;
  {----- Roughly find the spot from which to read -----}
  SSCntr := NextLog;
  SSSave := -1;
  SSStep := MaxSysLog DIV 10;
  SSTry  := 8;
  SSDone := FALSE;
  REPEAT
    FOR SSLoop := 1 TO SSStep DO SSCntr := SysLogBefore(SSCntr);
    SEEK(SysLogFile,SSCntr);
    READ(SysLogFile,SysLogItem);
    IF Before(SSDate,SSMint,SysLogItem.SLDate,SysLogItem.SLMint)
    THEN SSSave := SSCntr
    ELSE SSDone := TRUE;
    SSTry := SSTry - 1;
  UNTIL SSDone OR (SSTry = 0);
  X('.');
  {----- Zero in on spot from which to read -----}
  IF SSSave = -1
  THEN SSCntr := NextLog
  ELSE SSCntr := SSSave;
  SSDone := FALSE;
  REPEAT
    SSCntr := SysLogBefore(SSCntr);
    SEEK(SysLogFile,SSCntr);
    READ(SysLogFile,SysLogItem);
    IF Before(SSDate,SSMint,SysLogItem.SLDate,SysLogItem.SLMint)
    THEN SSSave := SSCntr
    ELSE SSDone := TRUE;
  UNTIL SSDone OR (SSCntr = NextLog);
  {----- Display -----}
  XLF; XLF;
  IF SSSave = -1
  THEN XLn('Nothing to display.')
  ELSE
  BEGIN
    {----- Print the display -----}
    SSCntr := SSSave;
    REPEAT
      SEEK(SysLogFile,SSCntr);
      READ(SysLogFile,SysLogItem);
      IF  (POS(SysLogItem.SLType,ShowWhat) > 0)
      AND (SysLogItem.SLText <> '')
      AND ((POS('ssword',SysLogItem.SLText) = 0) OR WizOp)
      AND (InFocus(SysLogItem.SLText))
      THEN
      BEGIN
        X(Fmt(IntToStr(SysLogItem.SLDate), Right, 4));
        X(':');
        X(Fmt(IntToStr(SysLogItem.SLMint), Left,  4));
        X(' ');
        X(SysLogItem.SLText);
        IF SysLogItem.SLRept > 1
        THEN XLn(' '+ IntToStr(SysLogItem.SLRept) + ' times')
        ELSE XLF;
      END;  { He is permitted to see this }
      SSCntr := SysLogAfter(SSCntr);
    UNTIL CharDuringO OR (SSCntr = NextLog);
  END;  { Had something to show }
END;

PROCEDURE CleanUp;
VAR
  CUChar : CHAR;
BEGIN
  CLOSE(UsersFile);
  CLOSE(NextMsgFile);
  CLOSE(MsgTimesFile);
  CLOSE(SysLogFile);
  CLOSE(SeismoFile);
  IF SysFail THEN
  BEGIN
    WRITE('SYSTEM FAILURE!  ');
    SOUND(1000); DELAY(1000); NOSOUND;
  END;
  // WINDOW(1,1,80,25);
END;

FUNCTION EsteemCalc : INTEGER;
VAR
  TempEst : REAL;
  TempP   : REAL;
BEGIN
  {----- Esteem 1 to 10, otherwise by 10's -----}
  TempP   := Postings;
  TempEst := TempP * 100.0 / (Level + 1);
  IF TempEst > 10 THEN
  TempEst := Postings * 10 DIV (Level + 1) * 10;
  EsteemCalc := TRUNC(TempEst);
END;

FUNCTION PatienceCalc : INTEGER;
BEGIN
  PatienceCalc := 15 + RANDOM(10) + (Level DIV 5);
END;

FUNCTION XlateBand(XLNum : INTEGER) : CHAR;
BEGIN
  IF XLNum  =   0 THEN XlateBand := '0';
  IF XLNum >=   1 THEN XlateBand := 'A';
  IF XLNum >=  30 THEN XlateBand := 'B';
  IF XLNum >= 100 THEN XlateBand := 'C';
  IF XLNum >= 300 THEN XlateBand := 'D';
END;

FUNCTION XlateBoard(XBChar : CHAR) : ComLine;
BEGIN
  CASE XBChar OF
    '0' : XlateBoard := 'Crowds at the Base Portal';
    'A' : XlateBoard := 'Disciples of the Arduous Task';
    'B' : XlateBoard := 'Brothers of Apprentice Sorcery';
    'C' : XlateBoard := 'Craftsmen of Operative Magic';
    'D' : XlateBoard := 'Pilgrims of the Final Ascent';
    'G' : XlateBoard := 'Guardian of the Base Portal';
    'P' : XlateBoard := 'Beseechers of TSOTL';
    'S' : XlateBoard := 'Scribe of the Tidings Scrolls';
    ELSE
      XlateBoard := 'Void';
  END;
END;

FUNCTION PresentBoard : ComLine;
BEGIN PresentBoard := XlateBoard(XlateBand(Altitude)); END;

PROCEDURE SetAltitude(NewAlt : INTEGER);
VAR
  OldBoard : ComLine;
  NewBoard : ComLine;
BEGIN
  OldBoard := PresentBoard;
  IF NewAlt > Level THEN NewAlt := Level;
  IF NewAlt <   0 THEN NewAlt := 0;
  IF NewAlt > 500 THEN NewAlt := 500;
  Altitude := NewAlt;
  If AscCnt > 5 THEN AscCnt := AscCnt - 5;
  NewBoard := PresentBoard;
  SaveDescTexture := DescTexture[RANDOM(MaxDescTexture)+1];
  SaveDescType    := DescType[RANDOM(MaxDescType)+1];
  SaveDescCharac  := DescCharac[RANDOM(MaxDescCharac)+1];
  IF OldBoard <> NewBoard THEN
  BEGIN
    XLn(LF+'This level of the Mountain is used by');
    XLn('the '+NewBoard+'.');
    Promo := TRUE;
  END;
END;

PROCEDURE SetManna(SMAmnt : INTEGER);
BEGIN
  MannaPoints := SMAmnt;
  IF MannaPoints < -20000 THEN MannaPoints := -20000;
  IF MannaPoints > ((Level + 1) * 50) THEN MannaPoints := ((Level + 1) * 50);
END;

FUNCTION ParmFrom(PFLine : Line) : ComLine;  { Get parm from PYCONFIG line }
VAR
  PFCntr : INTEGER;
BEGIN
  IF LENGTH(PFLine) > 39 THEN PFLine := COPY(PFLine,1,39);
  PFCntr := LENGTH(PFLine);
  IF PFLine[PFCntr] = ' ' THEN
  REPEAT
    PFCntr := PFCntr - 1;
  UNTIL (PFLine[PFCntr] <> ' ') OR (PFCntr = 1);
  PFLine := COPY(PFLine,1,PFCntr);
  ParmFrom := PFLine;
END;

FUNCTION DeBlank(DBString : Line) : Line;
VAR
  DBCntr : INTEGER;
BEGIN
  DeBlank := '';
  DBCntr := 0;
  REPEAT DBCntr := DBCntr + 1;
  UNTIL (DBCntr > LENGTH(DBString)) OR (DBString[DBCntr] <> ' ');
  IF DBCntr <= LENGTH(DBString) THEN
  BEGIN
    DELETE(DBString,1,DBCntr - 1);
    DBCntr := LENGTH(DBString) + 1;
    REPEAT DBCntr := DBCntr - 1;
    UNTIL (DBCntr < 1) OR (DBString[DBCntr] <> ' ');
    DeBlank := COPY(DBString,1,DBCntr);
  END;
END; { Function DeBlank }
