{ PPCVAR.INC  Pascal Integrated Communications System}
{ Type definations and Variable declarations}
{ 5/31/87 IBM PC Version 5.0 Copyright 1987  by Les Archambault}

type
  record_status  = (deleted, read, private, public,restricted);
  RegisterSet=Record case Integer of
                  1: (AX,BX,CX,DX,BP,DI,SE,DS,ES,Flags: Integer);
                  2: (AL,AH,BL,BH,CL,CH,DL,DH: Byte);
                end;
  Regpack = Record
               AX,BX,CX,DX,BP,SI,DI,DS,ES,FLAGS:Integer;
                end;
  Str3           = string[3];
  Str10          = string[10];
  FileName       = string[12];
  Str14          = string[14];
  StrTAD         = string[27];
  StrPr          = string[50];
  StrStd         = string[80];
  Str100         = string[100];
  StrName        = string[len_name];
  firstname      = string[len_fn];
  lastname       = string[len_ln];
  address        = string[len_ad];
  city           = string[len_cy];
  state          = string[len_st];
  phone          = string[len_ph];
  password       = string[len_pw];
  subject        = string[len_subj];
  message        = string[len_msg];

  tad_array      = array[0..5] of byte;
  name_array     = array[1..11] of byte;
  hour_array     = array[0..23] of integer;
  day_array      = array[0..6] of integer;
  Fname_array    = array[1..20] of filename;
  Record_Array   = array[1..128] of byte;

  buf_ptr        = ^mem_buf;
  mem_buf        = array[1..1024] of byte;

  SysmPtr        = ^SysmRecord;
  SysmRecord     =
    record
      key        : char;                    { Key value }
      loc        : integer;                 { Location of record in file }
      next       : SysmPtr                  { Pointer to next element on list }
    end;

  MesgPtr        = ^MesgRecord;
  MesgRecord     =
    record
      MesgNo,                               { Message number }
      SummLoc    : integer;                 { Summary index }
      TypMsg     : byte;                    { Message type }
      next       : MesgPtr                  { Pointer to next element on list }
    end;

  FilePtr        = ^FileRecord;
  FileRecord     =
    record
      fname      : FileName;                { Name of a matching file }
      index,                                { Libraries only: location of file }
      fsize      : integer;                 { Size of file }
      attrib     : byte;                    { Attributes of file}
      next       : FilePtr                  { Pointer to next element on list }
    end;

  SectPtr        = ^SectRecord;
  SectRecord     =
    record
      SectDrive  : Char;                    { Drive }
      SectUser,                             { User area }
      SectConf,                             { Conference number 1-7}
      SectAccs   : integer;                 { Access level required }
      SectName   : filename;                { Section name }
      SectDesc   : StrPr;                   { Description }
      next       : SectPtr                  { Pointer to next element on list }
    end;

  AreaPtr        = ^AreaRecord;
  AreaRecord     =
    record
      Area,                                 { Area number }
      AreaConf,                             { Conference number 1-7}
      AreaAccs   : integer;                 { Access level required }
      AreaName   : filename;                { Message area name }
      AreaDesc   : StrPr;                   { Description }
      next       : AreaPtr                  { Pointer to next element on list }
    end;

  ArtPtr         =^ArtRecord;
  ArtRecord      =
    record
      Artdrive   : Char;
      ArtUser,
      ArtAccs,
      Artnum     : integer;
      ArtName    : filename;
      ArtDesc    : strpr;
      Next       : ArtPtr;
    end;

  FileBlock      =
    record
      drive      : byte;                    { Byte code }
      fname      : name_array;              { File name }
      extent,                               { Current extent }
      s1, s2, reccount: byte;               { Used to compute file size }
      map        : array[16..31] of byte    { Data map }
    end;

  EntryBlock =
    record
      status     : byte;
      fname      : name_array;
      index,
      fsize,
      CRC,
      CreationDate,
      LastChangeDate,
      CreationTime,
      LastChangeTime: integer;
      PadCount   : byte;
      filler     : array[27..31] of byte
    end;

  user_list      =
    record
      used       : integer;                 {  2 }
{ Personal information }
      fn         : firstname;               { 11 }
      ln         : lastname;                { 16 }
      ad         : address;                 { 21 }
      cy         : city;                    { 21 }
      st         : state;                   {  3 }
      ph         : phone;                   { 13 }
      flags      : byte;                    {  1 }
      pw         : password;                { 11 }
{ User access }
      access     : byte;                    {  1 }
      limit      : byte;                    {  1 }
{ User configuration }
      nulls      : byte;                    {  1 }
      shift_lock : boolean;                 {  1 }
      noisy      : boolean;                 {  1 }
      conf_flags : byte;                    {  1 }
      columns    : byte;                    {  1 }
      lines      : byte;                    {  1 }
{ User stats }
      laston     : tad_array;               {  6 }
      time_today : integer;                 {  2 }
      time_total : integer;                 {  2 }
      lasthi     : integer;                 {  2 }
      upload     : integer;                 {  2 }
      download   : integer                  {  2 }
    end;                             { Total 123 }

  logr_list      =
    record
      date       : tad_array;               {  6 }
      action     : byte;                    {  1 }
      user       : integer;                 {  2 }
      text       : FileName                 { 13 }
    end;                             { Total  22 }

  summ_list      =
    record
      date       : tad_array;               {  6 }
      status     : record_status;           {  1 }
      area       : byte;                    {  1 }
      num,                                  {  2 }
      num_prev,                             {  2 }
      num_next,                             {  2 }
      user_from,                            {  2 }
      user_to    : integer;                 {  2 }
      subject    : subject;                 { 56 }
      st_rec,                               {  2 }
      size       : integer                  {  2 }
    end;                             { Total  80 }

  stat_list      =
    record
      date       : tad_array;               {  6 }
      busy_per_hour : hour_array;           { 48 }
      busy_per_day  : day_array;            { 14 }
    end;                             { Total  68 }

  nwin_list      =
    record
      date       : tad_array;               {  6 }
      status     : record_status;           {  1 }
      name       : FileName;                { 13 }
      user       : integer;                 {  2 }
      sectn      : filename;                { 13 }
      descr      : Strstd;                  { 81 }
      dnloads    : integer;                 {  2 }
      last_dnload: tad_array;               {  6 }
    end;                            { Total  123 }

  sysm_list      = StrStd;           { Total  81 }
  mesg_list      = message;          { Total  73 }

  untype_file    = file;

 {Arc File types}

  long    = record           { used to simulate long (4 byte) integers }
                 l, h : integer
               end;
  fntype  = array [0..12] of char;
  heads   = record
                 name   : fntype;
                 size   : long;
                 date   : integer;
                 time   : integer;
                 crc    : integer;
                 length : long
            end;

var
  debug : boolean;

{ System message global }

  SysmBase       : SysmPtr;                 { Start of linked list }
  Cmd_Queue      : StrStd;                  { for multiple commands}
  Mult_cmds      : boolean;                 { true when mult cmds exist}

{ Section globals }

  SectBase       : SectPtr;                 { Start of linked list }
  SectReq        : filename;                { Section name }

{ Articles globals }

  Artbase        : ArtPtr;                  { start of linked list}

{ Message area globals }

  AreaBase       : AreaPtr;                 { Start of linked list }
  AreaReq        : filename;                { Message area name }
  AreaSet        : integer;                 { Current message area }

{ Directory globals }

  DirBase        : FilePtr;                 { Start of linked list }
  DirEntries,                               { Count of directory entries }
  DirSpace       : integer;                 { Disk space used }

{ Library globals }

  LibBase        : FilePtr;                 { Start of linked list }
  LibEntries,                               { Count of library entries }
  LibSpace       : integer;                 { Space used }
  LibReq         : FileName;                { Library name }

{ Arc globals}
  ArcBase        : FilePtr;
  ArcEntries,
  ArcSpace       : integer;
  ArcReq         : FileName;
  Hdr            : Heads;
  ArcPtr         : integer;
  ArcBuf         : Record_Array;
  HdrVer         : Byte;
  Endfile        : boolean;

{ Message system globals }

  MesgBase, MesgLast, MesgCurr: MesgPtr;    { Pointers }
  temp_hi_lmr,                              { Storage for lmr}
  msg_all,                                  { Public message count }
  msg_ind,                                  { Private message count }
  msg_aut,                                  { Authored message count }
  msg_sys,                                  { Sysop viewable message count }
  msg_hi,msg_lo         : integer;          { High-low message numbers }
  nonstop               : boolean;          { flag for continuous reading}

{ System globals }
  MDM_init_str  : Strpr;                    { Modem initialization string}
  abort,                                    { used to set brk from pause}
  audit_on,                                 { Audit file enabled }
  case_lock,                                { Convert output to upper case }
  clock,                                    { tells whether clock present}
  cold,                                     { Cold start }
  connected,                                { Connection established }
  delay_down,                               { Shutdown between users }
  fini,                                     { Finished with PICS }
  in_library,                               { Library/section switch }
  in_arc,                                   { Arc/section switch}
  in_use,                                   { Successful login }
  local_copy,                               { Console display }
  local_online,                             { Local use allowed }
  new_dir,                                  { New section or library selected }
  noisy,                                    { Prompt bell enable }
  chat_ok,                                  { allow chat function}
  op_chat,                                  { Operator requested chat }
  printer_copy,                             { Printer display }
  remote_copy,                              { Remote display }
  remote_online,                            { Remote use allowed }
  st_switch,                                { Size/time switch }
  up_down_display,                          { Up/download display }
  restrict300,                              { on/off flag}
  auto_macro,                               { on/off flag}
  macro_in_progress,                        { set while macro running}
  macro_file_exists,                        { optional, for auto macro }
  limit_lines,                              { on/off flag}
  restrict_public,                          { public msgs have to by approved}
  extra_time_sw,                            { extra time on sys on/off}
  valid_pw       : boolean;                 { Correct password flag }

  ch             : char;                    { Input character }
  HomDrv,                                   { Default drive }
  RcvDrv,                                   { Upload drive }
  SetDrv,                                   { User selected drive }
  AudDrv        : Str3;                     { Audit file drive}
  HomName,RcvName,
  SetName,AudName  : strpr;                 { Path Names for above}

  user_loc,                                 { Location in data file of user record }
  time_on, time_left, extra_time,           { Timers }
  timeout,sleepy_time,time_count,
  mode,                                     { Current mode of operation }
  free_space,                               { Space remaining on current drive }
  start_restrict300,                        { hour to start restrictions}
  end_restrict300,                          { hour to end restrictions}
  auto_macro_start,                         { hour to start auto macro process}
  macro_done,                               { last day macro operated}
  max_msg_lines,                            { max. number of lines allowed}
  up_down_ratio,                            { numerator of ratio ie. 20:1}
  val_acc,                                  { validated user access level}
  uval_acc,                                 { unvalidated}
  uval_time,                                { same for unvalidated users}
  val_time,                                 { time on sys limit - validated}
  chatstart,                                { hour sysop available}
  chatend,                                  { end of chat available}
  unv_days,                                 { retention of user listing}
  val_days,                                 { retention of val users}
  unr_days,                                 { message retention}
  rea_days,                                 { same for after read}
  max_tries,                                { counter}
  maxfree_uplds,maxfree_logs,               { variables to shut off or limit}
  maxfree_mslimit,maxfree_lines,            {   functions when too little disk}
  maxfree_abs,                              {   space is left}
  extra_time_val,extra_time_start,          { for extra time on system}
  extra_time_stop,
  file_recs,                                { xmodem rcv. record count}
  rate           : integer;                 { Current bps rate }
  hour_count,                               { counts hours for no clock people}
  time_adjust,                              { no clock routines}
  input_time     : real;                    { for input timout routine}
  st,                                       { general use input string}
  macro,                                    { Automatic 'keyboard' input }
  next_inpstr    : StrStd;                  { Input string - used for word wrap }

  global_date,                              { For systems without real time clock }
  login_t        : tad_array;               { Login time }

{ Files }

  user_rec       :         user_list;

  sysm_rec       :         sysm_list;
  sysm_file      : file of sysm_list;

  summ_rec       :         summ_list;
  summ_file      : file of summ_list;

  mesg_rec       :         mesg_list;
  mesg_file      : file of mesg_list;

  logr_rec       :         logr_list;
  logr_file      : file of logr_list;

  stat_rec       :         stat_list;
  stat_file      : file of stat_list;

  nwin_rec       :         nwin_list;
  nwin_file      : file of nwin_list;

  libr_file      : file;
  Arc_file       : file;
  AuditFile      : text;
  Config_file    : text;
  macro_file     : text;

{end of PPCvar.inc}
