{PPCMDM.INC}
{ PICSPC  Pascal Integrated Communications System module}
{ 5/31/87 IBM PC VERS 5.0 Copyright 1987 by Les Archambault}

{  Description: This  driver  is designed to support modems which use the  'AT'
               command set such as the Hayes Smartmodem, the Courier 2400, and
               others.   All operations are open loop, i.e. no command verifi-
               cation is performed.
               Modified for multiple initializations and responses from the
               original SMOPEN routines.

  The following hardware configuration is assumed:

     DCD (pin 8) is supported
     DTR (pin 20) is supported
     RI  (pin 22) is not supported

The following modem default switches are assumed:

     1 = up    DTR supported, do not force to always logic true.
     2 = down  Send result codes as digits.
     3 = down  Send result codes to the host.
     4 = down  Do not echo characters when in command state (off line).
     5 = down  Do not answer the telephone.
     6 = up    DCD supported, do not force to always logic true.
     7 = up    Single line RJ11 telephone connection to modem.
     8 = down  Enables modem command recognition when in command state.
}

const

{ Modem result codes }

  OKAY        = '0';                        { Command executed with no errors }
  CONNECT300  = '1';                        { Carrier detect at 300 bps }
  RING        = '2';                        { Ring signal detected }
  NOCARRIER   = '3';                        { Carrier lost or never heard }
  ERROR       = '4';                        { Error in command execution }
  CONNECT1200 = '5';                        { Carrier detect at 1200 bps }
  CONNECT2400 = '10';                       { Carrier detect at 2400 bps }

function mdresult(secs:integer):str3;
{get result code from mdodem with timeout}

var
    count: real;
    ch: char;
    result: Str3;
  begin
    result := '';
    count:=secs / 0.001;
    repeat
      repeat
      count:=count-1.0;
      delay(1);
      until (ch_inprdy) or (count<=0);
      if count>0 then
        begin
          ch := chr(ch_inp);
          if ch in ['0'..'9'] then result := result + ch;
          if length(result) > 2 then delete(result, 1, 1);
        end;
    until (ch = CR) or (count<=0);
    if count>0 then mdresult := result else mdresult:='';
  end;

procedure mdsend(st: StrStd);
{ Send a command string to the modem  }
  var
    i,n: byte;
  begin
    while ch_inprdy do i:=ch_inp;  {clear buffer}
    for i := 1 to length(st) do
      begin
        delay(75);
        ch_out(ord(st[i]));
        if (ch_inprdy) and (st[i]<>CR) then n:=ch_inp;  {eat echo, if any}
      end;
  end;

procedure mdhangup;
{ Hangup modem }
  var
    i,x: integer;
    bt:byte;
  begin
  debug:=false;
    repeat
      { Break before disconnect not implemented }
      ch_off;                               { Hangup NOW! }
      delay(2000);
      ch_on;
      if ch_carck
        then
          begin
            for i:=1 to 3 do ch_out(ord(ETX));
            delay(2000);
            mdsend('AT H0' + CR);
          end;
    until not ch_carck;
    while ch_inprdy do bt:=ch_inp;   {clear buffer}
  end;

procedure mdbusy;
{ Take modem off hook to present a busy signal to incoming callers }
  begin
    mdsend('AT H1M0' + CR);                    { Take modem off hook }
  end;

function mdring: boolean;
{ Determine if the phone is ringing }
  var  ans:char;
  begin
    ans:=' ';                  {initialize}
    if ch_inprdy then ans:=chr(ch_inp);
    if ans=RING then
      begin
        ans:=chr(ch_inp);      {get CR from modem}
        mdring:=true;
      end
    else
      mdring:=false;
  end;

procedure mdans;
{ Detect and set system to rate at which modem answered phone }
  var
    bt: byte;
    result: Str3;
  begin
    delay(500);
    mdsend('AT A' + CR);                { Let the modem answer }
    delay(500);
    result := mdresult(15);          { first check for OK response }
    if (result=OKAY) or (result='')
         then result:=mdresult(15);  { get actual speed code response}
    if result = CONNECT300
      then ch_set(300)
    else if result = CONNECT1200
      then ch_set(1200)
    else if result = CONNECT2400
      then ch_set(2400)
    else mdhangup;
    delay(500);                             { Make sure carrier is stable }
    clear_inbuf;
  end;

procedure mdinit;
{ Ensure the modem is hung up, initialized, and ready to wait for a ring. }
  var
    bt,i: byte;
    result:str3;
  begin
    bt:=0;
    system_de_init;      {clear communications chanel}
    delay(500);
    ch_init;             { re-initialize it}
    repeat
      delay(1000);
      bt:=succ(bt);
      clear_inbuf;         {clear buffer}
      mdsend(MDM_init_str + CR);
    until (mdresult(5)='0') or (bt>3);
    if bt>3 then
      begin
        putstat('Modem Initialization Problem.. press any key',' ');
        repeat
        until keypressed;
      end;
  end;

{end of PPCMDM.INC}
