{ PPCMCH.INC }
{ PICSPC  Pascal Integrated Communications System module}
{ 5/31/87 IBM PC VERS 5.0 Copyright 1987  by Les Archambault }

Procedure System_Init;  {called once when PICS first Starts}
  begin
    TextMode(BW80);
  end;

procedure putstat(st,st1: StrStd);
{ Display 'st' on status line }

  var row,col:integer;

  begin
    col:=whereX; row:=whereY;
    if row>23 then row:=23;
    GotoXY(1,24);
    ClrEol;
    LowVideo;
    write(st);
    gotoxy(1,25);
    clreol;
    write(st1);
    NormVideo;
    GotoXY(col,row);
  end;

{ Communications Routines}

type
  ComPort      = (Com1,Com2);                     { Asynchronous ports }
  ComSpeed     = (LowSpeed,MedSpeed,HighSpeed);   { 300/1200/2400 baud }
  ComParity    = (NoParity,EvenParity,OddParity); { no/even/odd parity }
  ComInBuffer  = array[0..4095] of byte;          { 4K ring buffer     }
  ComOutBuffer = array[0..99] of byte;            {    ring buffer     }
  ComCtlPtr    = ^ComCtlRec;                      { Ptr, port control  }
  ComCtlRec    = record
                   ComCtlSpeed:      ComSpeed;    { current baud rate  }
                   ComCtlParity:     ComParity;   { current parity     }
                   LastComIdent:     byte;        { interrupt reason   }
                   LastComLineStat:  byte;        { line status        }
                   LastComModemStat: byte;        { modem status       }
                   SavedVector:      ^byte;       { pre-open vector    }
                   InputInIx:        integer;     { ring buffer index  }
                   InputOutIx:       integer;     { ring buffer index  }
                   OutputOutIx:      integer;     { ring buffer index  }
                   OutputInIx:       integer;     { ring buffer index  }
                   InputBuffer:      ComInBuffer; { input ring buffer  }
                   OutputBuffer:     ComOutBuffer;{ output ring buffer }
                 end;

const
  AsyncDS:     integer = -1; { NOTE: contrary to the idea of constants,
                               but to give the interrupt handler access
                               to the ComCtl array, this constant is
                               modified.  See StoreDS. }
  ComInt:      array[Com1..Com2] of byte = ($C,$B);
  ComData      = 0;       { Communications port data xmit/recv      }
  ComEnable    = 1;       { Communications port interrupt enable    }
  ComEnableRD  = 1;       {   data received                         }
  ComEnableTX  = 2;       {   transmit register empty               }
  ComEnableLS  = 4;       {   line status                           }
  ComEnableMS  = 8;       {   modem status                          }
  ComIdent     = 2;       { Communications port interrupt identity  }
  ComIdentNot  = 1;       {   interrupt not pending                 }
  ComIdentMS   = 0;       {   modem status interrupt                }
  ComIdentTX   = 2;       {   transmit register empty               }
  ComIdentRD   = 4;       {   data received                         }
  ComIdentLS   = 6;       {   line status interrupt                 }
  ComLineCtl   = 3;       { Communications port line control        }
  ComLineInit: array[NoParity..OddParity] of byte = ($03,$1A,$0A);
  ComLineBreak = 64;      { Communications Line Send Break          }
  ComLineDLAB  = 128;     { Communications Divisor Latch Access Bit }
  ComModemCtl  = 4;       { Communications port modem control       }
  ComModemDTR  = 1;       {   data terminal ready                   }
  ComModemRTS  = 2;       {   request to send                       }
  ComModemOUT1 = 4;       {   Out 1 signal (enables ring)           }
  ComModemOUT2 = 8;       {   Out 2 signal (enables data receive)   }
  ComLineStat  = 5;       { Communications port line status         }
  ComLineOR    = 2;       {   overrun                               }
  ComLinePE    = 4;       {   parity error                          }
  ComLineFE    = 8;       {   framing error                         }
  ConLineBI    = 16;      {   break interrupt                       }
  ComLineTHRE  = 32;      {   transmit holding register empty       }
  ComModemStat = 6;       { Communications port modem status        }
  ComModemCTS  = 16;      {   clear to send                         }
  ComModemDSR  = 32;      {   data set ready                        }
  ComModemRI   = 64;      {   phone ring                            }
  ComModemCD   = 128;     {   carrier detect                        }
  ComDivLo     = 0;       { Communications port baud-rate divisor 1 }
  ComDivHi     = 1;       { Communications port baud-rate divisor 2 }
  ComBaudDiv:  array[LowSpeed..HighSpeed] of integer = (384,96,48);
  Cmd_8259     = $20;     { 8259 interrupt controller command port  }
  EOI_8259     = $20;     {   "End Of Interrupt" command            }
  RIL_8259     = $0B;     {   "Report Interrupt Level" command      }
  Msk_8259     = $21;     { 8259 interrupt controller mask port     }
  MskVal_8259: array[Com1..Com2] of byte = ($EF,$F7);

var
  ComBase: array[Com1..Com2] of integer absolute $0040:0000;
  ComPtr:  array[Com1..Com2] of ComCtlPtr; { for each comm port }
  Com_Port: Comport;      {picspc port being used}
  Com_Speed: Comspeed;    {picspc current speed}

{ This is called to modify AsyncDS }
procedure StoreDS(var SavedDS: integer);
  begin
    savedDS := DSEG;
  end;

{ This turns the communications interrupts on or off }
procedure Set_8259(ComDev: ComPort; Sw: boolean);
  begin
    inline($FA); {stop interrupts while we do this}
    case Sw of
      true:  port[Msk_8259] :=
                 port[Msk_8259] and MskVal_8259[ComDev];
      false: port[Msk_8259] :=
                 port[Msk_8259] or ($FF xor MskVal_8259[ComDev]);
    end;
    inline($FB); {reenable interrupts}
  end {Set_8259};

{ Communications interrupt handler: do NOT call this! }
procedure AsyncInterrupt;
  var
    pushes: array[1..8] of integer; {allows for inline pushes}
    ComDev: ComPort;
  begin
    inline($83/$C4/$11/           { add  sp,11h (fool turbo) }
           $50/                   { push ax                  }
           $53/                   { push bx                  }
           $51/                   { push cx                  }
           $52/                   { push dx                  }
           $56/                   { push si                  }
           $57/                   { push di                  }
           $1E/                   { push ds                  }
           $06/                   { push es                  }
           $4C/                   { dec  sp     (fool turbo) }
           $2E/$8E/$1E/AsyncDS);  { mov  ds,CS:AsyncDS       }
    with comptr[Com_Port]^ do
      begin
        while (port[combase[com_port]+comident] and comidentnot)=0 do
        begin
        if ((InputInIx+1) mod sizeof(InputBuffer)) <> InputOutIx then
          begin { store input character in ring buffer }
            InputBuffer[InputInIx] := port[ComBase[Com_Port]+ComData];
            InputInIx := (InputInIx+1) mod sizeof(InputBuffer);
          end
        else
          begin
            putstat('Buffer Overrun - correcting -',' ');
            with comptr[Com_Port]^ do  {flush input buffer}
              begin
                InputInix:=0;
                InputOutix:=0;
              end;
          end;
        end; {while}
      end;
    port[Cmd_8259] := EOI_8259;
    inline($44/                   { inc  sp    (unfool turbo) }
           $07/                   { pop  es                   }
           $1F/                   { pop  ds                   }
           $5F/                   { pop  di                   }
           $5E/                   { pop  si                   }
           $5A/                   { pop  dx                   }
           $59/                   { pop  cx                   }
           $5B/                   { pop  bx                   }
           $58/                   { pop  ax                   }
           $8B/$E5/               { mov  sp,bp                }
           $5D/                   { pop  bp                   }
           $CF);                  { iret                      }
  end {AsyncInterrupt};

{ This modifies the communications interrupt vector }
procedure SetInterrupt(ComDev: ComPort; Sw: boolean);
  var
    MsDosRegs: record
                 AX, BX, CX, DX, BP, SI, DI, DS, ES, Flags: integer;
               end;
  begin
    inline($FA); {stop interrupts while we do this}
    with MsDosRegs, ComPtr[ComDev]^ do
    begin
      case Sw of
        true:  begin
                 AX := $3500+ComInt[ComDev]; { get interrupt vector}
                 MsDos(MsDosRegs);
                 SavedVector := Ptr(ES,BX);
                 DS := CSEG;
                 DX := ofs(AsyncInterrupt);
               end;
        false: begin
                 DS := seg(SavedVector^);
                 DX := ofs(SavedVector^);
               end;
      end;
      AX := $2500+ComInt[ComDev]; { set interrupt vector }
      MsDos(MsDosRegs)
    end;
    inline($FB); {reenable interrupts}
  end {SetInterrupt};

{ This sets the communications baud rate }
procedure SetSpeed(ComDev: ComPort; ComRate: ComSpeed);
  begin
    inline($FA); {stop interrupts while we do this}
    with ComPtr[ComDev]^ do ComCtlSpeed  := ComRate;
    port[ComBase[ComDev]+ComLineCtl] :=
      port[ComBase[ComDev]+ComLineCtl] or ComLineDLAB;
    port[ComBase[ComDev]+ComDivLo] := lo(ComBaudDiv[ComRate]);
    port[ComBase[ComDev]+ComDivHi] := hi(ComBaudDiv[ComRate]);
    port[ComBase[ComDev]+ComLineCtl] :=
      port[ComBase[ComDev]+ComLineCtl] and ($FF xor ComLineDLAB);
    inline($FB); {reenable interrupts}
  end {SetSpeed};

{ This modifies the line control register for parity & data bits }
procedure SetFormat(ComDev: ComPort; ComFormat: ComParity);
  begin
    inline($FA); {stop interrupts while we do this}
    with ComPtr[ComDev]^ do ComCtlParity := ComFormat;
    port[ComBase[ComDev]+ComLineCtl] := ComLineInit[ComFormat];
    inline($FB); {reenable interrupts}
  end {SetFormat};

{ This modifies the modem control register for DTR, RTS, etc. }
procedure SetModem(ComDev: ComPort; ModemCtl: byte);
  begin
    inline($FA); {stop interrupts while we do this}
    port[ComBase[ComDev]+ComModemCtl] := ModemCtl;
    inline($FB); {reenable interrupts}
  end {SetModem};

{ This modifies the communications interrupt enable register }
procedure SetEnable(ComDev: ComPort; Enable: byte);
  begin
    inline($FA); {stop interrupts while we do this}
    port[ComBase[ComDev]+ComEnable] := Enable;
    inline($FB); {reenable interrupts}
  end {SetModem};

Procedure Ch_on;  {Turn on the remote channel}
  begin
    SetModem(Com_Port, ComModemDTR+ComModemRTS+ComModemOUT1+ComModemOUT2);
  end;

Procedure Ch_Off; {Turn off the remote chanel}
  begin
    SetModem(Com_Port, ComModemOUT1+ComModemOUT2); {drop dtr & rts}
  end;

Function Ch_Carck:Boolean;  {check for carrier present}
  begin
    if debug then ch_carck:=true
    else
    Ch_Carck:=((CommodemCD and Port[Combase[Com_port]+Commodemstat])<>0);
  end;

Procedure Ch_Set(r:integer);  {set baud rate}
  begin
    rate:=r;
    case r of
      300: begin
            SetSpeed(Com_Port, LowSpeed);
            Com_Speed:=LowSpeed;
           end;
     1200: begin
             SetSpeed(Com_Port,MedSpeed);
             Com_Speed:=MedSpeed;
           end;
     2400: begin
             SetSpeed(Com_Port,HighSpeed);
             Com_Speed:=HighSpeed;
           end;
    end;
  end;  {Ch_set}

{ This procedure MUST be called before doing any I/O. }
Procedure Ch_Init;
  begin
    Set_8259(Com_Port,false);
    StoreDS(AsyncDS);
    new(ComPtr[Com_Port]);
    with ComPtr[Com_Port]^ do
    begin
      LastComIdent := 1;
      InputInIx    := 0;
      InputOutIx   := 0;
      OutputOutIx  := 0;
      OutputInIx   := 0;
    end;
    SetInterrupt(Com_Port,true);
    Set_8259(Com_Port,true);
    SetEnable(Com_Port, ComEnableRD);
    SetModem(Com_Port, ComModemDTR+ComModemRTS+ComModemOUT1+ComModemOUT2);
    SetSpeed(Com_Port, Com_Speed);
    SetFormat(Com_Port, NoParity);
    with ComPtr[Com_Port]^ do
    begin
      LastComLineStat  := port[ComBase[Com_Port]+ComLineStat];
      LastComModemStat := port[ComBase[Com_Port]+ComModemStat];
    end;
  end {CH_init};

{ This procedure shuts-down communications }
procedure System_De_Init;
  begin
    Set_8259(Com_Port,false);
    SetEnable(Com_Port, $00);
    SetInterrupt(Com_Port, false);
    port[ComBase[Com_Port]+ComLineCtl] := $00;
    dispose(ComPtr[Com_Port]);
  end {System_de_Init};

{ This procedure tells you if there's any input }
function Ch_Inprdy: boolean;
  begin
    with ComPtr[Com_Port]^ do Ch_Inprdy := (InputInIx <> InputOutIx);
  end {ch_inprdy};

{ This procedure reads input from the ring buffer - no wait, assumes ready }
function Ch_Inp: byte;
  begin
    with ComPtr[Com_Port]^ do
    begin
      repeat until ch_inprdy;
      Ch_Inp := InputBuffer[InputOutIx];
      InputOutIx := (InputOutIx+1) mod sizeof(InputBuffer);
    end;
  end {ch_inp};

{ This procedure writes output, filling the ring buffer if necessary.}
procedure Ch_Out(Data: byte);
  begin
    with ComPtr[Com_Port]^ do
    begin
      repeat
      until (port[ComBase[Com_Port]+ComLineStat] and ComLineTHRE) <>0;
      port[ComBase[Com_port]+ComData] :=data;
    end;
  end {ch_out};

Procedure Clear_inbuf;
  begin
    with comptr[Com_Port]^ do  {flush input buffer}
      begin
        InputInix:=0;
        InputOutix:=0;
      end;
  end;

{ Clock routines}

procedure GetTAD(var t: tad_array);
{ Return a 6 element integer array of the current system time in
    seconds, minutes, hours, day, month, and year.
}

var
  recpack:          regpack;             {assign record}
  ah,al,cl,dh:   byte;
  year:string[4];
  cx,dx:integer;

begin
  ah := $2c;                             {initialize correct registers}
  with recpack do
    begin
      ax := ah shl 8 + al;
    end;
  intr($21,recpack);                     {call interrupt}
      t[0]:=(recpack.dx shr 8);                    { secs}
      t[1]:=(recpack.cx mod 256);                  { mins}
      t[2]:=(recpack.cx shr 8);                    { hrs }

  with recpack do
    begin
      ax := $2a shl 8;
    end;
  MsDos(recpack);                        { call function }
  with recpack do
    begin
      t[3]:=dx mod 256;                    { day }
      t[4]:=dx shr 8;                      { mon }
      t[5]:=cx -1900;                      { yr  }
    end;
end;

procedure SetTAD(var t: tad_array);
{ Set the system time using a 6 element byte array which contains
    seconds, minutes, hours, day, month, and year.
}
  var regs:RegisterSet;
  begin
   with Regs do
    begin
      ah:=$2D;     { set time call }
      dl:=0;       { hundreths of seconds}
      dh:=t[0];    { seconds }
      cl:=t[1];    { minutes}
      ch:=t[2];    { hours }
      MSdos(regs);

      ah:=$2B;     { set date call }
      dl:=t[3];    { day}
      dh:=t[4];    { month}
      cx:=t[5]+1900;  {year}
      MSdos(regs)
    end;
  end;

{The following two procedures MUST remain here to maintain compatibility
 with systems not using a clock. Please don't remove them.}

Procedure tick_a_min;
  begin
  end;

procedure tick_a_sec;
  begin
  end;

{ end of PPCMCH.INC }
