{PPCKMS.INC}
{ PICSPC  Pascal Integrated Communications System module}
{ 5/31/87 IBM PC VERS 5.0 Copyright 1987 by les archambault }

function test_bit(var num;bit_num:integer):boolean;
    var subject:integer absolute num;
        dummy:integer;
    begin
      dummy:=subject;
      dummy:=dummy shr bit_num;
      if odd(dummy) then test_bit:=true
      else test_bit:=false;
    end;

procedure set_bit(var target; bit_num:integer);
    var  subject:integer absolute target;
         mask:integer;
    begin
      mask:=1 shl bit_num;
      subject:=subject or mask;
    end;

procedure clear_bit(var target;bit_num:integer);
    var subject:integer absolute target;
        mask:integer;
    begin
      mask:=not(1 shl bit_num);
      subject:=subject and mask;
    end;

procedure FindSect(req:FileName; var Drive:Str3; var found: boolean);
{ Find file section from requested name }
  var
    this: SectPtr;
    conf_num:integer;
  begin
    this := SectBase;
    while (req <> this^.SectName) and (this <> nil) do
      this := this^.next;
    conf_num:=this^.sectconf;
    found := ((req = this^.SectName)
             and (cold or (user_rec.access >= this^.SectAccs)
             or test_bit(user_rec.conf_flags,conf_num)));
    if found
      then  Drive:=this^.SectDrive+':\';
  end;

function min(x, y: integer): integer;
{ Return minimum of two integers }
  begin
    if x < y
      then min := x
      else min := y
  end;

function max(x, y: integer): integer;
{ Return greater of two integers }
  begin
    if x > y
      then max := x
      else max := y
  end;

function trim(st: StrStd): StrStd;
{ Remove leading and trailing blanks }
  var
   i, j: integer;
  begin
    i := 1;
    j := length(st);
    while (st[i] = ' ') and (i <= j) do
      i := succ(i);
    while (st[j] = ' ') and (j >= i) do
      j := pred(j);
    trim := copy(st, i, succ(j - i))
  end;

function pad(st: StrStd; i: integer): StrStd;
{ Pad string with spaces to length of i }
  begin
    while length(st) < i do
      st := st + ' ';
    pad := st
  end;

function intstr(n, w: integer): Str10;
{ Return a string value (width 'w')for the input integer ('n') }
  var
    st: Str10;
  begin
    str(n:w, st);
    intstr := st
  end;

function strint(st: Str10): integer;
{ Convert string to integer }
  var
    x, code: integer;
  begin
    if st[1] = '+'
      then delete(st, 1, 1);
    if st = ''
      then code := 1
      else val(st, x, code);
    if code = 0
      then strint := x
      else strint := 0                      { Error, return with 0 }
  end;

function zeller(day, month, year: integer): integer;
{ Compute the day of the week using Zeller's Congruence }
  var
    century: integer;
  begin
    if month > 2
      then month := month - 2
      else
        begin
          month := month + 10;
          year := pred(year)
        end;
    century := year div 100;
    year := year mod 100;
    zeller := (day - 1 + ((13 * month - 1) div 5) + (5 * year div 4) +
              century div 4 - 2 * century + 1) mod 7
  end;

function FormTAD(t: tad_array): StrTAD;
{ Build printable string of current time and date }
  const
    day: array [0..6] of string[6] =
      ('Sun','Mon','Tues','Wednes','Thurs','Fri','Satur');
    month: array [1..12] of string[3] =
      ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
  var
    i: integer;
    line: StrTAD;
  begin
    if (t[1] in [0..59]) and (t[2] in [0..23]) and clock
      then line := intstr(t[2], 2) + ':' + intstr(t[1], 2)
      else line := '';
    for i:= 1 to length(line) do
      if line[i] = ' '
        then line[i]:= '0';
    if (t[3] in [1..31]) and (t[4] in [1..12]) and (t[5] in [0..99])
      then FormTAD :=
        line + '  ' +
        day[zeller(t[3], t[4], 1900 + t[5])] + 'day  ' +
        intstr(t[3], 2) + '-' + month[t[4]] + '-' + intstr(t[5], 2)
      else FormTAD := 'No Date'
  end;

procedure send_time(size: integer; var mm, ss: integer);
{ Compute the file transfer time }
  var
    tr_time: real;
  begin
    tr_time := size * 23.5 / rate;          { Factor is empirically derived  }
    mm := trunc(tr_time);
    ss := round(60.0 * frac(tr_time))
  end;

procedure timer(var time_on, time_left: integer);
{ Compute the time on and the time remaining to the current user }
  var
    t: tad_array;
    give_extra:boolean;
  begin
    GetTAD(t); give_extra:=false;
    time_on := 60 * (t[2] - login_t[2]) + t[1] - login_t[1];
    if time_on < 0
      then time_on := time_on + 1440;
    time_left := user_rec.limit + extra_time - time_on - user_rec.time_today;
    if extra_time_sw then
      begin
        if extra_time_start<extra_time_stop then
          begin
            if (t[2]>extra_time_start) and (t[2]<extra_time_stop)
            then give_extra:=true;
          end
        else
          begin
            if (t[2]>extra_time_start) and (t[2]<extra_time_stop+24)
            then give_extra:=true;
            if (t[2]<extra_time_start) and (t[2]<extra_time_stop)
            then give_extra:=true;
          end;
        if give_extra then time_left:=time_left+extra_time_val;
      end;
  end;

procedure mesg_insert(TypMsg: byte);
{ Insert message into linked list }
  var
    this: MesgPtr;
  begin
    new(this);
    if MesgBase = nil
      then MesgBase := this
      else MesgLast^.next := this;
    MesgLast := this;
    MesgLast^.MesgNo := summ_rec.num;
    MesgLast^.SummLoc := pred(FilePos(summ_file));
    MesgLast^.TypMsg := TypMsg;
    MesgLast^.next := nil
  end;

procedure InsertFile(fname:name_array; index,size:integer; attrib:byte;
                     var entries, total: integer; var first: FilePtr);
{ Insert a new file name into an alphabetic list }
  var
    space: integer;
    f,                                      { File name entry being created }
    this, last: FilePtr;                    { Followers for insertion }
    fn: FileName;
  begin
    fn := '           ';                    { Initialize string }
    move(fname, fn[1], 11);                 { Move name into place }
    insert('.', fn, 9);
    last := nil;
    this := first;
    while (this <> nil) and (this^.fname < fn) do
      begin
        last := this;
        this := this^.next
      end;
    space := size shr 3;
    if (size mod 8) <> 0
      then space := succ(space);
    if this^.fname <> fn
      then
        begin
          entries := succ(entries);
          total := total + space;
          new(f);
          f^.fname := fn;
          f^.index := index;
          f^.fsize := size;
          f^.attrib:=attrib;
          f^.next  := this;
          if last = nil
            then first := f
            else last^.next := f
        end
    else if (this^.fname = fn) and (this^.fsize < size)
      then
        begin
          total := total + space;
          space := this^.fsize shr 3;
          if (this^.fsize mod 8) <> 0
            then space := succ(space);
          total := total - space;
          this^.fsize := size
        end
  end;

Procedure updcrc(var crc: integer; acc: integer);
{ Update CRC with passed value }
    var
      carry: boolean;
      i: integer;
    begin
      for i := 1 to 8 do
        begin
          carry := ((crc and $8000) <> 0);
          crc := crc shl 1;
          if (acc and $0080) <> 0
            then crc := succ(crc);
          acc := acc shl 1;
          if carry
            then crc := crc xor $1021;
        end;
    end;

procedure list(ch: char);
{ List a portion of the system message file }
  var
    line_count: integer;
    this: SysmPtr;
  begin
    this := SysmBase;
    while (this <> nil) and (this^.key <> ch) do
      this := this^.next;
    if this^.key = ch
      then
        begin
          writeln(USR);
          seek(sysm_file, succ(this^.loc));
          read(sysm_file, sysm_rec);
          line_count := 0;
          while (not brk) and (not EOF(sysm_file)) and (sysm_rec[1] <> ':') do
            begin
              writeln(USR, sysm_rec);
              read(sysm_file, sysm_rec);
              if user_rec.lines <> 99
                then
                  begin
                    line_count := succ(line_count);
                    if line_count mod user_rec.lines = 0
                      then pause
                  end
            end
        end
  end;

Procedure Write_status_line;
  var str:strtad;
      date:tad_array;
  begin
    date:=user_rec.laston;
    str := intstr(date[4],2)+'/'+intstr(date[3],2)+'/'+intstr(date[5],2);
    putstat(user_rec.fn + ' ' + user_rec.ln + '  ' + user_rec.cy + ', ' +
     user_rec.st + '   Phone: '+user_rec.ph,
     ' Last on: '+str +'  Access: ' + intstr(user_rec.access, 1)
     + '  On today: ' +
     intstr((time_on+user_rec.time_today), 1)+'  Time Limit: '
     +intstr(user_rec.limit,1)+'  '+intstr(rate,1)+' Baud');
  end;

Function diskfree(drive:str3): integer;
{ Compute amount of disk space free on specified drive, '*' means current
  drive}
  var regs:regpack;
      drv:integer;
    begin
      if drive[1]='*' then drv:=0  {current logged drive}
       else drv:=ord(upcase(drive[1]))-64;   { 1=A, 2=B etc}
      with regs do
        begin
          ax:=$3600;  {get free space}
          dx:=drv;
          msdos(regs);
         if (flags and 1)=1 then diskfree:=0
           else diskfree:=trunc((1.0*ax*bx*cx)/ 1024.0);
        end;
    end;

function unsigned_to_real(u : integer) : real;
{ convert unsigned integer to real }
{ note: INT is a function that returns a REAL!!!}
  begin
    if u >= 0 then unsigned_to_real := Int(u)
    else if u = $8000 then unsigned_to_real := 32768.0
    else unsigned_to_real := 65536.0 + u
  end;

function long_to_real(l : long) : real;
{ convert long integer to a real }
{ note: INT is a function that returns a REAL!!! }
  var r : real;
      s : (POS, NEG);
  const rcon = 65536.0;
  begin
    if l.h >= 0 then begin
      r := Int(l.h) * rcon;
      s := POS
    end else begin
      s := NEG;
      if l.h = $8000 then r := rcon * rcon
      else r := Int(-l.h) * rcon
    end;
    r := r + unsigned_to_real(l.l);
    if s = NEG then long_to_real := -r
    else long_to_real := r
  end;

procedure Read_Arc_Block;
{ read a block from the archive file }
  begin
    if EOF(arc_file) then endfile := TRUE
    else
      begin
        {$I-} BlockRead(arc_file, arcbuf, 1); {$I+}
        endfile:=(ioresult<>0);
      end;
    arcptr := 1
  end;

function Get_Arc_Ch : byte;
{ read 1 character from the archive file }
  begin
    if endfile then Get_Arc_Ch := 0
    else begin
      Get_Arc_Ch := arcbuf[arcptr];
      if arcptr = 128 then Read_Arc_Block
      else arcptr := arcptr + 1
    end
  end;

{ Begining of Overlay file .000 }

overlay procedure hide_release(name: FileName; status: record_status; dirspec:strpr);
{ Hide or release file }
  var
    i: integer;
    regs:regpack;
    ah,al,ch,cl:byte;
    work:string[13];
  begin
    SetSect(dirspec);
    work:=Name+chr(0);
    regs.ax := $4301;                       {set attribute}
    if status=public then regs.cx:=$0000    {make visable}
    else regs.cx:=$0006;                    {set System and Hidden bits}
    regs.ds:=Seg(work);  regs.dx:=Ofs(work[1]);
    MsDos(regs);                        { call function }
    if (user_rec.access>=250) or (not remote_copy) then
      begin
        if regs.ax=2 then writeln(usr,name,' not found.');
        if regs.ax=3 then writeln(usr,'path: ',dirspec,' not found.');
        if regs.ax=5 then writeln(usr,'Access denied by DOS.');
      end;
end;

overlay procedure ArcSeek(offset:real; base:integer);
     { re-position the current pointer in the archive file }
  var b           : real;
      i, ofs, rec : integer;
      c           : byte;
      OK          : boolean;

  begin
    setsect(SetName);
    b := offset + (unsigned_to_real(FilePos(arc_file)) - 1.0) * 128 + arcptr - 1.0;
    if ((b/128.0)>= -32768.0) and ((b/128.0) <=32767) then
      begin
        rec := Trunc(b / 128);
        ofs := Trunc(b - (Int(rec) * 128));  { Int converts to Real }
        {$I-} seek(arc_file, rec); {$I+}
        OK:=(ioresult=0);
        if OK then
          begin
            Read_Arc_Block;
            if not endfile then for i:=1 to ofs do c:=Get_Arc_Ch;
          end;
      end
    else endfile:=true;
  end;

overlay function Read_Arc_Hdr : boolean;
 { read a file header from the archive file }
 { FALSE = eof found; TRUE = header found }
  var name : fntype;
      try  : integer;
      bt : byte;

procedure Fil_Arc_Rec(var buf; reclen : integer);
{ read a record from the archive file }
  var i : integer;
      b : array [1..1024] of byte absolute buf;
  begin
    for i := 1 to reclen do b[i] := Get_Arc_Ch
  end;

  begin {read_arc_hdr}
    setsect(SetName);
    try :=10;
    OK:=true;
    if (not endfile) then
      begin
        bt:=0;
        while (bt<>26) and (not endfile) and OK do
          begin
            bt:=Get_Arc_Ch;
            if try = 0 then OK:=false;
            try := try - 1;
         end;
       hdrver := Get_Arc_Ch;
       if hdrver<0 then OK:=false;
       if hdrver = 0 then   { special end of file marker }
         begin
           Read_Arc_Hdr := FALSE;
           endfile:=true;
         end;
       if hdrver = 1 then
         begin
           Fil_Arc_Rec(hdr, sizeof(heads) - sizeof(long));
           hdrver := 2;
           hdr.length := hdr.size
         end
       else
         Fil_Arc_Rec(hdr, sizeof(heads));
       if OK then Read_Arc_Hdr := TRUE else Read_Arc_Hdr:=false;
      end  {not endfile}
    else Read_Arc_Hdr:=false;
  end;

overlay procedure get_name(var fn: firstname; var ln: lastname;mode:char);
{ Get user name }
  var try,try_name,i:integer;
      tln:lastname;
      tfn:firstname;
      work:strstd;
      ch:char;
      test_names,found:boolean;
      namesfile:text;
  begin
    writeln(USR);  try:=0; try_name:=0; test_names:=true;  found:=false;
    if mode='C' then
      begin
        Assign(namesfile,'BADNAMES.LST');
        {$I-} Reset(namesfile); {$I+}
        if ioresult<>0 then test_names:=false;   {file doesn't exist}
      end
    else
     test_names:=false;
    Repeat
        repeat
          fn := trim(prompt('FIRST name',len_fn, 'ESN'));
          try:=succ(try);
        until (not online) or (fn <> '') or (try>max_tries);
        if try>max_tries then
          begin
            remote_online:=false;
            mdhangup;
          end;
        if fn = 'SYSOP' then ln := ''
          else
           begin
             try:=0;
             repeat
               ln := trim(prompt(' LAST name', len_ln, 'ESN'));
               try:=succ(try);
             until (not online) or (ln <> '') or (try>max_tries);
             if try>max_tries then
               begin
                 remote_online:=false;
                 mdhangup;
               end;
           end;
        if (try<max_tries) and (mode='C') and (online) and (test_names)then
          begin
            reset(namesfile);
            tfn:='';
            for i:=1 to length(fn) do
              if fn[i] in ['A'..'Z'] then tfn:=tfn+fn[i];
            tln:='';
            for i:=1 to length(ln) do
                if ln[i] in ['A'..'Z'] then tln:=tln+ln[i];
            while (not eof(namesfile)) and (online) and (test_names) and (not found) do
              begin
                readln(namesfile,work);
                if (pos(tfn,work)<>0) or (pos(work,tfn)<>0) then found:=true;
                if (ln<>'') and
                  ((pos(tln,work)<>0) or (pos(work,tln)<>0)) then found:=true;
              end;
            if found then
              begin
                Writeln(usr,'That name is reserved...try again');
                try_name:=succ(try_name);
                found:=false;
              end
            else
              test_names:=false;
          end;
        if try_name>max_tries then
          begin
            remote_online:=false;
            mdhangup;
          end;
    until (not online) or (try>max_tries) or (try_name>max_tries) or (not test_names);
    if mode='C' then close(namesfile);
  end;

overlay  procedure change_user_params_A(num:integer; var temp_user_rec:user_list);
    var
      temp,i: integer;
      str: StrStd;

    begin
      with temp_user_rec do
        begin
          Case Num of
          1 : begin
                str:=prompt('Computer ', len_ad, 'EL');
                if str <> '' then ad := str;
              end;
          2 : begin
                str:=prompt('City ', len_cy, 'EL');
                if str <> '' then cy:=str;
              end;
          3 : begin
                str:=prompt('State (2 ltrs.) ', len_st, 'ESL');
                if str <> '' then st:=str;
              end;
          4 : begin
                str:=prompt('Phone number ', len_ph, 'EL');
                if str <> '' then ph:=str;
              end;
          5 : begin
                str:=prompt('Password ', len_pw, 'ESL');
                if str <> '' then pw:=str;
              end;
          6 : begin
                str:=prompt('Access Level ', 3, 'EL');
                if str <> '' then
                   begin
                     temp := strint(str);
                     if (temp <= user_rec.access) or (not remote_copy)
                      then access := temp
                    end;
              end;
          7 : begin
                str:=prompt('Time Limit (min.) ', 3, 'EL');
                if str <> '' then limit := strint(str);
              end;
          8 : begin
                str:=prompt('Nulls ', 1, 'EL');
                if str <> '' then nulls := strint(str);
              end;
          9 : begin
                str:=prompt('Case (U/L) ', 1, 'ESL');
                if str <> '' then shift_lock := (str = 'U');
              end;
          10 : begin
                 str:=prompt('Noisy (Y/N) ', 1, 'ESL');
                 if str <> '' then noisy := (str = 'N');
               end;
          11 : begin
                 str:=prompt('Conferences 1-7 [enter consecutive #s: 0=none] ', 7, 'ESL');
                 if str <> '' then
                   begin
                     clear_bit(conf_flags,0); {don't use this bit}
                     for i:=1 to 7 do
                     if pos(chr(i+48),str)>0 then set_bit(conf_flags,i)
                     else clear_bit(conf_flags,i);
                     if str='0' then conf_flags:=0;
                   end;
               end;
          12 : begin
                 str:=prompt('Width (columns) ', 2, 'ESL');
                 if str <> '' then columns := strint(str);
               end;
          end; {case}
        end;
    end;

overlay  procedure change_user_params_B(num:integer; var temp_user_rec:user_list);
    var
      temp,i: integer;
      str: StrStd;

    begin
      with temp_user_rec do
        begin
          Case Num of
          13 : begin
                 str:=prompt('Lines per screen ', 2, 'ESL');
                 if str <> '' then lines := strint(str);
               end;
          14 : begin
                 str:=prompt('On Today ', 5, 'EL');
                 if str <> '' then time_today := strint(str);
               end;
          15 : begin
                 str:=prompt('On Total ', 5, 'EL');
                 if str <> '' then time_total := strint(str);
               end;
          16 : begin
                 str:=prompt('Last Hi Msg. ', 5, 'EL');
                 if str <> '' then lasthi := strint(str);
               end;
          17 : begin
                 str:=prompt('Uploads ', 5, 'EL');
                 if str <> '' then upload := strint(str);
               end;
          18 : begin
                 str:=prompt('Downloads ', 5, 'EL');
                 if str <> '' then download := strint(str)
               end;
          19 : if test_bit(flags,1) then clear_bit(flags,1)
               else set_bit(flags,1);
          20 : if test_bit(flags,2) then clear_bit(flags,2)
               else set_bit(flags,2);
          21 : if test_bit(flags,3) then clear_bit(flags,3)
               else set_bit(flags,3);
          22 : if test_bit(flags,4) then clear_bit(flags,4)
               else set_bit(flags,4);
          23 : if test_bit(flags,5) then clear_bit(flags,5)
               else set_bit(flags,5);
          end;       {case}
        end;
    end;

Overlay Procedure Write_Config_File;
  var
    ets,co,am,ll,r300,rp:char;
  begin
      SetSect(HomName);
      Assign(Config_file,'CONFIG.BB#');
      Rewrite(config_file);
      if extra_time_sw then ets:='T' else ets:='F';
      if chat_ok then co:='T' else co:='F';
      if auto_macro then am:='T' else am:='F';
      if limit_lines then ll:='T' else ll:='F';
      if restrict300 then r300:='T' else r300:='F';
      if restrict_public then rp:='T' else rp:='F';
      write(config_file,maxfree_uplds,' ',maxfree_logs,' ',maxfree_mslimit,' ',
      maxfree_lines,' ',maxfree_abs,' ',extra_time_start,' ',extra_time_stop,' ',
      extra_time_val,' ',chatstart,' ',chatend,' ',sleepy_time,' ',max_tries,
      ' ',auto_macro_start,' ',max_msg_lines,' ',start_restrict300,' ',
      end_restrict300,' ',up_down_ratio,' ',val_time,' ',uval_time,' ',
      val_acc,' ',uval_acc,' ',val_days,' ',unv_days,' ',unr_days,' ',rea_days,' ');
      write(config_file,ets,co,am,ll,r300,rp,macro:80);
      writeln(usr);
      writeln(usr,'Parameters Recorded.');
      close(config_file);
    end;

procedure endkms;     { forced end of overlay file .000 }
  begin
  end;

{ end of PPCkms.inc}