{PPC2L.INC  Pascal Integrated Communications System Overlays}
{ 6/10/87  IBM PC Version 5.0 Copyright 1987  by Les Archambault}

overlay procedure wrapup;
{ Disconnect, update and close all files}
  var
    i, j, time_on, time_left: integer;
    t: tad_array;
  begin
    setsect(HomName);
    Write(USR, 'Thanks, call again...');
    if valid_pw        { Don't update files if user not initialized }
      then
        begin
          GetTAD(t);
          timer(time_on, time_left);
          if (login_t[3]=t[3]) and (user_rec.access<250)  then
          user_rec.time_today := user_rec.time_today + time_on
          else user_rec.time_today:=0;
          user_rec.time_total := user_rec.time_total + time_on;
          user_rec.laston := t;
          if temp_hi_lmr>user_rec.lasthi then user_rec.lasthi:=temp_hi_lmr;
          PutRec(DatF, user_loc, user_rec);
          log(3, ' ');
          i := login_t[1];
          j := login_t[2];
          while j <> t[2] do
            begin
              stat_rec.busy_per_hour[j] := stat_rec.busy_per_hour[j] + 60 - i;
              i := 0;
              j := succ(j) mod 24
            end;
          stat_rec.busy_per_hour[j] := stat_rec.busy_per_hour[j] + t[1] - i;
          seek(stat_file, 0);
          Write(stat_file, stat_rec)
        end;
    CloseFile(DatF);
    CloseIndex(IdxF);
    Close(logr_file);
    Close(stat_file);
    Close(nwin_file);
    Close(summ_file);
    Close(mesg_file);
    if macro_file_exists then
      begin
        close(macro_file);
        macro_file_exists:=false;
      end;
    if (mode=sysop_mode) and (local_online) and (ch='Q') then halt;
    MdHangup;
  end;

overlay procedure setup;
  var
    i: integer;
    t: tad_array;
    first:boolean;
    test_file:file;

  begin
    valid_pw         :=false;
    first            := false;
    fini             := FALSE;
    connected        := FALSE;
    local_online     := FALSE;
    local_copy       := TRUE;
    printer_copy     := FALSE;
    remote_online    := FALSE;
    remote_copy      := FALSE;
    macro_file_exists:= FALSE;
    AreaReq          :='';
    SectReq          :='';

    mode             := message_mode;       { Start system in message mode }
    nonstop          := FALSE;              { no message scrolling}
    st_switch        := TRUE;               { Default file size display - in 'k' }
    new_dir          := FALSE;              { Reset directory flag }
    up_down_display  := TRUE;               { Show up/downloads for files mode }
    extra_time       := 0;                  { None until upload complete }
    op_chat          := FALSE;              { chat not initiated }

    user_rec.nulls      := 2;               { 2 nulls until recognition }
    user_rec.shift_lock := TRUE;            { Upper case only to start }
    user_rec.noisy      := FALSE;           { Prompt bell initially off }
    user_rec.columns    := def_chars;
    user_rec.lines      := def_lines;

    timeout := 60;                          { Allow one minute for input }

    InitIndex;                              { Get files ready for use }

    assign(test_file,user_data+ext);
    {$I-} Reset(test_file); {$I+}
    if ioresult=0 then if filesize(test_file)>0 then OK:=true
      else OK:=false;
    close(test_file);
    If OK then
      begin
        assign(test_file,user_indx+ext);
        {$I-} Reset(test_file); {$I+}
        if ioresult=0 then if filesize(test_file)>0 then OK:=true
          else OK:=false;
        close(test_file);
      end;
    If OK then
    OpenFile(DatF, user_data + ext, SizeOf(user_rec));
    if OK
      then OpenIndex(IdxF, user_indx + ext, len_ln + len_fn, 0);
    if not OK
      then
        begin
          writeln(BEL,BEL,BEL,'IMPORTANT');
          WRITELN('If your CONFIG.SYS file does not contain a FILES=20 statement');
          Writeln('an I/O error will occur during this initialization !');
          writeln;
          delay(10000);
          Write(BEL, 'User files not found.  Creating ', user_data, ext);
          MakeFile(DatF, user_data + ext, SizeOf(user_rec));
          Write(', ', user_indx, ext);
          MakeIndex(IdxF, user_indx + ext, len_ln + len_fn, 0);
          Writeln;
          first:=true;
        end;

    {$I-} Reset(logr_file) {$I+};
    OK:=(ioresult=0);
    if (not OK) or (OK and (filesize(logr_file)=0))
      then
        begin
          Write(BEL, 'Log file not found.  Creating ', logr_name, ext);
          Rewrite(logr_file);
          logr_rec.user := 0;
          Write(logr_file, logr_rec);
          Writeln;
          first:=true;
        end;

    {$I-} Reset(summ_file) {$I+};
    OK := (IOresult = 0);
    if OK
      then
        begin
          {$I-} Reset(mesg_file) {$I+};
          OK := (IOresult = 0)
        end;
    if (not OK) or (OK and (filesize(summ_file)=0))
      then
        begin
          Write(BEL, 'Message files not found.  Creating ', summ_name, ext);
          Rewrite(summ_file);
          summ_rec.num := 0;
          Write(summ_file, summ_rec);
          Write(', ', mesg_name, ext);
          Rewrite(mesg_file);
          Writeln;
          first:=true;
        end;

    {$I-} Reset(stat_file) {$I+};
    if IOresult = 0 then
        begin
          {$I-} read(stat_file, stat_rec); {$I+}
          i:=IOresult;
        end
      else
        begin
          Write(BEL, 'Statistics file not found.  Creating ', stat_name, ext);
          Rewrite(stat_file);
          GetTAD(stat_rec.date);
          for i := 0 to 23 do
            stat_rec.busy_per_hour[i]  := 0;
          for i := 0 to 6 do
            stat_rec.busy_per_day[i]  := 0;
          Writeln;
          first:=true;
        end;

    {$I-} Reset(nwin_file) {$I+};
    if IOresult <> 0
      then
        begin
          Write(BEL, 'Newin file not found.  Creating ', nwin_name, ext);
          Rewrite(nwin_file);
          Writeln;
          first:=true;
        end;

    if cold
      then
        begin
          log(0, '');
          cold := FALSE;
        end;
    if first then delay(5000);
  end;

overlay procedure wait_for_user;
  var
    ch: char;
    bt: byte;
    min,hr,count_limit,count,counter,
    i,x,delay_count,Rcv_Space,Hom_space: integer;
    t:tad_array;
    timeout:boolean;

  begin
    ClrScr;
    count_limit:=trunc(6000*(Mhz/4.0));
    if delay_down
      then
        begin
          putstat('Waiting for delayed shutdown acknowledgement...',' ');
          mdbusy;
        end
      else
        begin
          putstat(version + ' as of ' + ver_date +
          ' (c) 1986,87 Les Archambault  Foster City, Ca.',' ');
          mdinit;
        end;
    gettad(t);
    Rcv_space:=Diskfree(RcvDrv);
    Hom_space:=Diskfree(HomDrv);
    If macro_in_progress then
      begin
        macro_in_progress:=false;
        if macro_file_exists then
          begin
            close(macro_file);
            macro_file_exists:=false;
          end;
        gettad(t);
        macro_done:=t[3];
        local_online:=false;
      end;
    count := 0;  counter:=0;  delay_count:=0;
    repeat
      If (auto_macro) and (macro_done<>t[3])
      and ((t[2]>=auto_macro_start) or (not clock))
      and (not macro_in_progress) then
        begin
           Assign(macro_file,'MACRO.LST');
           {$I-} Reset(macro_file); {$I+}
           if ioresult=0 then
             begin
               macro_file_exists:=true;
               writeln('Starting auto macro execution.');
               macro_in_progress:=true;
             end
           else close(macro_file);
           if (not macro_file_exists) and (length(macro)>0) then
             begin
               writeln('Starting auto macro execution.');
               macro_in_progress:=true;
               st:=macro;
               repeat
                 i:=pos('^M',st);
                 if i>0 then
                   begin
                     delete(st,i,2);
                     insert(chr(13),st,i);
                   end;
               until i=0;
               cmd_queue:=st;
               mult_cmds:=true;
             end;
        end;

     if (counter>30000) or (counter=0) then
      begin
        if delay_down then
          begin
            clrscr;  writeln;
            gotoxy(5,20);
            writeln('COUNT DOWN TO SYSTEM RE-ACTIVATION... ',75-delay_count);
            writeln;
          end;
        gotoxy(10,15);
        If Rcv_space<maxfree_uplds then
          writeln('UPLOADS OFF DUE TO DISK SPACE LIMITS !');
        If Hom_space<maxfree_logs then
          writeln('NEW LOGINS OFF DUE TO DISK SPACE LIMITS !');
        If Hom_space<maxfree_mslimit then
          writeln('MESSAGES LIMITED DUE TO DISK SPACE LIMITS !');
        If (Hom_space<maxfree_abs) or (Rcv_space<maxfree_abs) then
          begin
            writeln;
            writeln('EXTREME DISK SPACE PROBLEMS !!!!!!!!!');
          end;
        counter:=1;
      end;
      count := succ(count); counter:=succ(counter);
      if counter=10000 then clrscr;
      if count > count_limit
        then
          begin
            if (not clock) then
              begin
                hour_count:=hour_count+(1.0*time_adjust);
                if hour_count>(14400.0*(Mhz/4.0)) then
                  begin
                    global_date[3]:=succ(global_date[3]);
                    if global_date[3]>31 then
                      begin
                        global_date[3]:=1; {day}
                        global_date[4]:=succ(global_date[4]); {month}
                        if global_date[4]>12 then
                          begin
                            global_date[4]:=1;
                            global_date[5]:=succ(global_date[5]); {year}
                          end;
                      end;
                    hour_count:=0.0;
                  end;
              end;
            gettad(t);
            putstat('','');
            GotoXY(succ(Random(79)), succ(Random(23)));
            count := 0;
            if delay_down then delay_count:=succ(delay_count);
          end;
      if delay_down then
        begin
         Write(BEL);
         if delay_count>=75 then
           begin
             delay_down:=false;
             delay_count:=0;
             mdhangup;
           end;
        end;
      ch := GetChar;
      if (ch = LF) or (ch=CR) then
        begin
          gotoxy(1,3);
          writeln(version,'  ',ver_date); writeln;
          {$I-} seek(logr_file,0); {$I+}
          ok:=(ioresult=0);
          if OK then
            begin
              {$I-} read(logr_file,logr_rec); {$I+}
              OK:=(ioresult=0);
              if OK then writeln('Last Caller Number: ',logr_rec.user);
            end;
          If auto_macro then writeln('Automatic Macro:  ENABLED at ',auto_macro_start,':00.')
          else writeln('Automatic Macro:  OFF.');
          if restrict300 then writeln('300 Baud Callers:  RESTRICTED ',
            start_restrict300,':00 - ',end_restrict300,':00 Hours.')
          else writeln('300 Baud Callers:  OK.');
          if chat_ok then writeln('Chat Function:  ENABLED ',chatstart,
            ':00 - ',chatend,':00 Hours.')
          else writeln('Chat Function:  OFF');
          if limit_lines then writeln('Message Length:  LIMITED to ',max_msg_lines,' lines.')
          else writeln('Message Length:  NOT LIMITED.');
          if restrict_public then writeln('Public Messages:  RESTRICTED.')
          else writeln('Public Messages:  NOT RESTRICTED.');
          if extra_time_sw then writeln(extra_time_val,
          ' Minutes of extra time given from ',extra_time_start,
          ':00 to ',extra_time_stop,':00')
          else writeln('Extra time NOT active.');
          if (not clock) then
            begin
              hr:=trunc((hour_count/600.0)*(Mhz/4.0));
              write('time  ',hr,':');
              min:=trunc(frac(hour_count/600)*(Mhz/4.0)*60);
              if min<10 then write('0');
              writeln(min);
            end;
          if ch=CR then
            begin
              writeln;
              writeln('  ^C to exit PICSPC,  ^L for local use.');
            end;
          i:=1; if ch_carck then x:=30 else x:=32000;
          repeat
            bt:=getbyte(1,timeout);
            if bt>0 then i:=x;   {key pressed remotely}
            i:=succ(i);
          until keypressed or (i>=x);
          clrscr;
        end;
      if ch = ETX
        then
          begin
            ClrScr;
            writeln('Busy modem? ');
            read(KBD, ch);
            if UpCase(ch) = 'Y'
              then mdbusy
              else mdhangup;
            writeln;
            writeln('PICSPC completing...');
            log(1, '');
            CloseFile(DatF);
            CloseIndex(IdxF);
            Close(sysm_file);
            Close(summ_file);
            Close(mesg_file);
            Close(logr_file);
            Close(stat_file);
            Close(nwin_file);
            fini := TRUE
          end
      else if (ch=FF) or (macro_in_progress)   {control L}
        then
          begin
            putstat('Local use requested',' ');
            mdbusy;
            case Com_Speed of
              Lowspeed: rate:=300;
              MedSpeed: rate:=1200;
              HighSpeed: rate:=2400;
             end;
            local_online := TRUE
          end
      else if mdring
        then
          begin
            putstat('Ring detected',' ');
            mdans;
            remote_online := ch_carck;
            remote_copy   := remote_online;
            if remote_online
              then putstat('Connect at ' + intstr(rate, 3) + ' bps',' ')
          end
    until fini or local_online or remote_online;
    delay_down := FALSE
  end;

{end of PPC2L.INC}
