{ PPC2K.INC - Pascal Integrated Communications System Overlays}
{ 6/10/87  IBM PC Version 5.0 Copyright 1987  by les archambault}

overlay procedure login;
  var
    continue,abort: boolean;
    key: StrName;

  procedure get_new_user(var continue: boolean);
    var
      i: integer;
    begin
      continue := FALSE;
      Writeln(USR);
      Writeln(USR, 'Name not found.');
      list('A');
      Writeln(USR);
      continue := ask('Are you a new user');
      if continue
        then with user_rec do
          begin
            get_case;
            get_nulls;
            st:=prompt('From what STATE [2 letter abbrev.] are you calling',len_st,'ES');
            cy := prompt('What CITY', len_ad, 'EL');
            ph:=prompt('Your phone number [###-###-####] ',len_ph,'EL');
            ad:=prompt('What computer do you use',len_ad,'EL');
            Writeln(USR);
            Writeln(USR, 'You are ', fn, ' ', ln, ' from ', cy, ', ', st, '.');
            writeln(usr, 'phone number ',ph);
            writeln(usr,ad,' computer.');
            Writeln(USR);
            continue := ask('Is that correct');
            if continue
              then
                begin
                  get_new_password;
                  used := 0;
                  if fn = 'SYSOP'
                    then access := 255
                    else access := uval_acc;
                  limit := uval_time;
                  if fn='SYSOP' then conf_flags:=254 else conf_flags := 0;
                  columns := def_chars;
                  lines := def_lines;
                  for i := 0 to 5 do
                    laston[i] := 0;
                  time_today := 0;
                  flags:=0;
                  time_total := 0;
                  lasthi := 0;
                  upload := 0;
                  download := 0;

                  key := pad(ln, len_ln) + pad(fn, len_fn);
                  AddRec(DatF, user_loc, user_rec);
                  AddKey(IdxF, user_loc, key);
                  log(9, '');
                  list('I');
                  pause
                end
          end
    end;

  procedure init_user;
    var
      str: StrTAD;
    begin
      temp_hi_lmr:=0;
      if local_online
        then log(2, 'Local')
        else log(2, intstr(rate, 3) + ' bps');
      Seek(logr_file, 0);
      Read(logr_file, logr_rec);
      if logr_rec.user<Maxint then logr_rec.user := succ(logr_rec.user)   {caller count}
       else logr_rec.user:=1;  {reset to avoid error}
      Seek(logr_file, 0);
      Write(logr_file, logr_rec);

      GetTAD(login_t);
      if (login_t[3] <> user_rec.laston[3]) or
         (login_t[4] <> user_rec.laston[4]) or
         (login_t[5] <> user_rec.laston[5]) then user_rec.time_today := 0;

      if user_rec.access < 10               { Hang up on twit }
        then remote_online := FALSE
      else
        show_user_stats;
    end;

  begin { login }
    abort:=false;
    GotoXY(1,23);             {position sysop screen}
    Writeln(usr);
    Writeln(USR, version);
    Writeln(USR, ver_date);
    if (not macro_in_progress) then list('W');
    repeat
      if macro_in_progress then
        begin
          user_rec.fn:='SYSOP'; user_rec.ln:='';
        end
      else
        get_name(user_rec.fn, user_rec.ln,'C');
      timeout := sleepy_time;                { increase input timeout }
      key := pad(user_rec.ln, len_ln) + pad(user_rec.fn, len_fn);
      FindKey(IdxF, user_loc, key);
      if OK
        then
          begin
            GetRec(DatF, user_loc, user_rec);
            if macro_in_progress then
              begin
                valid_pw:=true;
                mode:=sysop_mode;
              end
            else
              begin
                Get_old_password('  Password',valid_pw);
                if not valid_pw then list('P');
              end;
            continue := TRUE;
          end
        else
          begin
            if diskfree(HomDrv)>maxfree_logs then
              begin
                get_new_user(continue);
                if continue then valid_pw:=true;
              end
            else
              begin
               valid_pw:=false;
               writeln(usr);
               writeln(usr,'Name not found. Not enough disk space for new callers.');
               writeln(usr,'           Please call back soon.');
               writeln(usr);
               delay(5000);
               continue:=false;
               remote_online:=false;
               mdhangup;
               abort:=true;
              end;
          end;
    until (not online) or continue or abort;
    in_use := valid_pw;
    connected := continue;
    if online and in_use
      then init_user;
  end;

overlay procedure cold_start;
  const
    bufsize = 128;
    bufblocks = 1;
  var
    i ,try,errcnt: integer;
    SysmThis, SysmLast: SysmPtr;
    sysm_text: text;
    t:tad_array;
    work:string[255];

Procedure build_sysm;
  { Build SYSMSG.BB# file }
    var i:integer;
        goof,error:boolean;
        work:string[80];
        dummy:char;
    begin
      goof:=false;
      errcnt:=0;
      {$I-} Close(sysm_file) {$I+};         { Shouldn't erase an open file }
      i := IOresult;                        { Ignore any errors }
      Rewrite(sysm_file);
      Assign(sysm_text, sysm_name + '.TXT');
      {$I-} Reset(sysm_text) {$I+};
      if IOresult = 0
        then
          begin
            Write('  Creating ', sysm_name, ext);
            while (not eof(sysm_text)) and (errcnt<50) do
              begin
                {$I-} readln(sysm_text,work); {$I+}
                error:=(ioresult<>0);
                if length(work)>79 then
                  begin
                    sysm_rec:=copy(work,1,79);
                    writeln;
                    writeln;
                    writeln('Line too long, truncating.');
                    writeln;
                    goof:=true;
                  end
                else sysm_rec:=work;
                if not error then write(sysm_file,sysm_rec);
                if error then
                  begin
                    writeln;
                    writeln;
                    writeln('Error reading text line. No CR,LF ? ');
                    goof:=true;
                    errcnt:=succ(errcnt);
                  end;
              end;             {while not eof text file}
            Close(sysm_text);
            Close(sysm_file);
            Reset(sysm_file);
            if goof or error then
              begin
                writeln;
                writeln(sysm_name,'TXT problem may result in parts of SYSMSG.BB# not being complete.');
                writeln;
                writeln('   Lines in text file should not be longer than 79 characters');
                writeln('   or have high bits set (soft CRs) by the editor you use.');
                writeln;
                delay(10000);
              end;
          end        {ioresult=0}
        else
          begin
            Writeln;
            Write('System message text file  ', sysm_name,'TXT not found.');
          end;
      Writeln;
    end;

  begin     {cold start}
    debug:=false;
    cold                := TRUE;
    for i:=0 to 5 do global_date[i]:=0;            { preset for no clock vers}
    mult_cmds           :=false;                    {no multiple commands}
    cmd_queue           :='';
    chat_ok             := def_chat_ok;
    clock               := true;                   {unless turned off}
    hour_count          :=0.0;
    macro_in_progress   := false;
    gettad(t);
    macro_done          := t[3];
    val_acc             := def_val_acc;
    uval_acc            := def_uval_acc;
    val_time            := def_val_time;
    uval_time           := def_uval_time;
    chatstart           := def_chatstart;
    chatend             := def_chatend;
    unv_days            := def_unv_days;
    val_days            := def_val_days;
    unr_days            := def_unr_days;
    rea_days            := def_rea_days;
    max_tries           := def_max_tries;
    restrict300         := def_restrict300;
    start_restrict300   := def_start_restrict300;
    end_restrict300     := def_end_restrict300;
    auto_macro          := def_auto_macro;
    auto_macro_start    := def_auto_macro_start;
    max_msg_lines       := def_max_msg_lines;
    restrict_public     := def_restrict_public;
    limit_lines         :=def_limit_lines;
    up_down_ratio       :=def_up_down_ratio;
    sleepy_time         :=def_sleepy_time;
    maxfree_uplds       :=def_maxfree_uplds;
    maxfree_logs        :=def_maxfree_logs;
    maxfree_mslimit     :=def_maxfree_mslimit;
    maxfree_lines       :=def_maxfree_lines;
    maxfree_abs         :=def_maxfree_abs;
    extra_time_sw       :=def_extra_time;
    extra_time_start    :=def_extra_time_start;
    extra_time_stop     :=def_extra_time_stop;
    extra_time_val      :=def_extra_time_val;
    time_adjust         :=def_time_adjust;

    macro               := Deflt_macro;

    audit_on    := FALSE;
    delay_down  := FALSE;
    in_library  := FALSE;                   { Start in non-library mode }
    in_arc      := FALSE;

    SysmBase    := nil;                     { Initialize pointers}
    SectBase    := nil;
    AreaBase    := nil;
    MesgBase    := nil;
    DirBase     := nil;
    LibBase     := nil;
    Arcbase     := nil;
    Artbase     := nil;

    UsrOutPtr   := ofs(putchar);           { Initialize output driver }

    { assume system files are here}
    Getdir(0,HomName);                      { get current directory}
    Homdrv:=Copy(Homname,1,3);
    AudName:=HomName;                       { default setting}
    AudDrv:=Copy(AudName,1,3);
    RcvName:=Homname;                       { default setting}
    RcvDrv:=Copy(RcvName,1,3);
    Assign(sysm_file, sysm_name + ext);
    Assign(summ_file, summ_name + ext);
    Assign(mesg_file, mesg_name + ext);
    Assign(logr_file, logr_name + ext);
    Assign(stat_file, stat_name + ext);
    Assign(nwin_file, nwin_name + ext);
    Try:=0;
    {$I-} Reset(sysm_file) {$I+};           { Try to open system message file }
    if IOresult <> 0
      then
        begin
          Write('Cannot open ', sysm_name + ext, '.');
          build_sysm;
          try:=succ(try);
        end;

    {$I-} read(sysm_file, sysm_rec) {$I+};  { Try to read file }
    if IOresult <> 0
      then
        begin
          OK:=false;
          if try=0 then
            begin
              write('Cannot read ',sysm_name +ext,'.');
              build_sysm;
              seek(sysm_file,0);
              {$I-} read(sysm_file,sysm_rec); {$I+}
              OK:=(IOresult=0);
            end;
          if not OK then
            begin
              Writeln;
              Writeln('Cannot create ', sysm_name + ext, '.');
              Writeln('Unable to continue.');
              halt;
            end;
        end;

    i := 0;
    while not EOF(sysm_file) do
      begin
        if sysm_rec[1] = ':'
          then
            begin
              new(SysmThis);
              if SysmBase = nil
                then SysmBase := SysmThis
                else SysmLast^.next := SysmThis;
              SysmLast := SysmThis;
              SysmLast^.key := sysm_rec[2];
              SysmLast^.loc := i;
              SysmLast^.next := nil
            end;
        read(sysm_file, sysm_rec);
        i := succ(i)
      end;
    Read_section_file;         {get setup of sub directories etc}
    if auto_macro and (t[2]<auto_macro_start) then macro_done:=t[3]-1;
  end;

 {end of PPC2K.INC}

