{ PPC2J.INC - Pascal Integrated Communications System }
{ 5/31/87 IBM PC vers. 5.0 Copyright 1987 by Les Archambault}

overlay  procedure delete_file;
  { Delete file from disk }
    var
      DelName: FileName;
      DelFile: file;
    begin
    if ((not in_library) and (not in_arc))
        and ((user_rec.access>=250) or (not remote_copy)) then
     begin
      DelName := correct_fn(prompt('Name of file to delete', 12, 'ES'));
      if (DelName <> '') and (delname<>' ')
        then
          begin
            Assign(DelFile, DelName);
            SetSect(SetName);
            {$I-} Reset(DelFile) {$I+};             { Ensure file exists }
            OK := (IOresult = 0);
            if OK
              then
                begin
                  if ask('Are you sure')
                    then
                      begin
                        Close(DelFile);
                        Erase(DelFile);
                        writeln(USR, DelName, ' deleted.')
                      end
                end
              else
                begin
                  writeln(USR, DelName, ' not found.');
                  close(delfile);
                end;
          end;
      SetSect(HomName);
      readdir(direntries,dirspace,dirbase);
     end
     else
       begin
         if in_library then Writeln(usr,'Can not Delete in Library file.');
         if in_arc then Writeln(usr,'Can not Delete in ARC file.');
       end;
    end;

 overlay procedure copy_file;
  { Copy file from one file area to another }
    var
      Remaining: integer;
      DstDrv:Str3;
      DstSect, SrcName: FileName;
      SrcFile, DstFile: file;
      Dirspec:strpr;

    procedure do_copy;
      const
        BufSize = 4;
        BufBytSize = 512;                     { BufSize * 128 }
      var
        NoOfRecsToRead: Integer;
        Buffer: array[1..BufBytSize] of Byte;
      begin
        while OK and (Remaining > 0) do
          begin
            if BufSize <= Remaining
              then NoOfRecsToRead := BufSize
              else NoOfRecsToRead := Remaining;
            SetSect(SetName);
            {$I-} BlockRead(SrcFile, Buffer, NoOfRecsToRead) {$I+};
            OK := (IOresult = 0);
            if OK
              then
                begin
                  Dirspec:=DstDrv;
                  if (length(HomName)>3) and (Dirspec=HomDrv) then
                    begin
                      Dirspec:=Dirspec+copy(HomName,4,length(HomName));
                      Dirspec:=Dirspec+'\';
                    end;
                  if pos(':',DstSect)=2 then Dirspec:=Dirspec+copy(DstSect,3,length(Dstsect))
                  else Dirspec:=Dirspec+DstSect;
                  SetSect(Dirspec);
                  {$I-} BlockWrite(DstFile, Buffer, NoOfRecsToRead) {$I+};
                  OK := (IOresult = 0);
                  if OK
                    then Remaining := Remaining - NoOfRecsToRead
                    else writeln(USR, 'Write failed.')
                end
              else writeln(USR, 'Read failed.')
          end
      end;

    begin { copy_file }
    if ((not in_library) and (not in_arc))
        and ((user_rec.access>=250) or (not remote_copy)) then
     begin
      SrcName := Correct_fn(prompt('Name of file to copy', 12, 'ES'));
      Assign(SrcFile, SrcName);
      SetSect(SetName);
      {$I-} Reset(SrcFile) {$I+};           { Ensure file exists }
      OK := (IOresult = 0);
      if OK
        then
          begin
            Remaining := FileSize(SrcFile);
            SetSect(HomName);
            Write(usr,'Copy to: ');
            DstSect := get_section_name(' ');
            SetSect(SetName);
            FindSect(DstSect, DstDrv, OK);
            if OK
              then
                begin
                  Assign(DstFile, SrcName);
                  if DstSect='SYSTEM' then Dirspec:=HomName
                  else
                    begin
                      Dirspec:=DstDrv;
                      If (length(HomName)>3) and (dirspec=Homdrv) then
                        begin
                          Dirspec:=Dirspec+copy(HomName,4,length(HomName));
                          Dirspec:=Dirspec+'\';
                        end;
                      if pos(':',DstSect)=2 then
                         Dirspec:=Dirspec+copy(DstSect,3,length(DstSect))
                      else Dirspec:=Dirspec+DstSect;
                    end;
                  SetSect(Dirspec);
                  {$I-} Reset(DstFile) {$I+};    { Ensure file doesn't already exist }
                  OK := (IOresult <> 0);
                  if OK
                    then
                      begin
                        {$I-} Rewrite(DstFile) {$I+};
                        OK := (IOresult = 0);
                          if OK
                            then
                              begin
                                do_copy;
                                SetSect(Dirspec);
                                {$I-} Close(DstFile) {$I+};
                                OK := OK and (IOresult = 0);
                                SetSect(SetName);
                                Close(SrcFile);
                                if OK
                                  then
                                    begin
                                      writeln(USR, SrcName, ' successfully copied.');
                                      if ask('Delete original file')
                                        then
                                          begin
                                            Erase(SrcFile);
                                            writeln(USR, 'Original file deleted.')
                                          end
                                        else writeln(USR, 'Original file retained.')
                                    end
                                  else
                                    begin
                                      setsect(Dirspec);
                                      close(dstfile);
                                      Erase(DstFile);
                                      writeln(USR, 'Copy failed.  Partial file deleted.')
                                    end
                              end
                            else writeln(USR, 'Cannot create file in destination area.')
                      end
                    else writeln(usr,'File already exists in destination area.')
                end
              else writeln(USR, 'Destination section ', DstSect, ' not found.')
          end
        else writeln(USR, 'File ', SrcName, ' not found.');
      {$I-} close(DstFile);  close(SrcFile);  {$I+}
      SetSect(HomName);
      ReadDir(direntries,dirspace,dirbase);
     end
     else
       begin
         if in_library then Writeln(usr,'Copying not allowed in Library file.');
         if in_arc then Writeln(usr,'Copying not allowed in Arc file.');
       end;
    end;

   overlay Procedure Rename_file;
      var
      oldname,newname:filename;
      newfile,oldfile:file;

    Begin
    if ((not in_library) and (not in_arc))
         and ((user_rec.access>=250) or (not remote_copy)) then
     begin
      Writeln(usr);
      oldname:=correct_fn(prompt('Old File Name',12,'ES'));
      If oldname<>' ' then
        Begin
          assign(oldfile,oldname);
          setsect(SetName);
          {$I-} reset(oldfile); {$I+}
          ok:=(ioresult=0);
          setsect(HomName);
          if ok then
            begin
              newname:=correct_fn(prompt('New File Name',12,'ES'));
              If newname<>' ' then
                begin
                  assign(newfile,newname);
                  setsect(SetName);
                  {$I-} Reset(newfile); {$I+}
                  ok:=(ioresult<>0);
                  if ok then
                    begin
                      rename(oldfile,newname);
                      writeln(usr,'File Renamed');
                    end
                  else
                    writeln(usr,newname,' already exists.');
                end
            else
            writeln(usr,oldname,' not found.');
            end;
        end;
      {$I-} close(oldfile); close(newfile); {$I+}
      setsect(HomName);
      readdir(direntries,dirspace,dirbase);
     end
     else
       begin
         if in_library then writeln(usr,'Renaming not allowed in Library file.');
         if in_arc then writeln(usr,'Renaming not allowed in Arc file.');
       end;
    end;

Overlay Procedure File_Status;

  var
    i: integer;
    regs:regpack;
    ah,al,ch,cl:byte;
    fname:filename;
    work:string[13];
    status:record_status;

  begin
   if ((not in_library) and (not in_arc))
       and ((user_rec.access>=250) or (not remote_copy)) then
     begin
       writeln(usr);
       fname:=correct_fn(prompt('Filename',12,'ES'));
       if fname<>'' then
         begin
           setsect(SetName);
           work:=fname+chr(0);
           regs.ax := $4300;                     {get attribute}
           regs.ds:=Seg(work);  regs.dx:=Ofs(work[1]);
           MsDos(regs);                          { call function }
           if (regs.ax<>2) and (regs.ax<>3) and (regs.ax<>5) then
             begin
               i:=lo(regs.cx);
               if test_bit(i,1) then status:=private {hidden}
                else status:=public;
               Write(usr,'File ',fname,' is ');
               if status=public then writeln(usr,'visible.')
                else writeln(usr,'invisible.');
               writeln(usr);
               if ask('Do you want to change status') then
                 begin
                   setsect(homName);
                   if status=private then status:=public
                    else if status=public then status:=private;
                   Hide_Release(fname,status,Setname);
                   setsect(HomName);
                   readdir(direntries,dirspace,dirbase);
                 end;
             end
           else
             begin
               if regs.ax=2 then writeln(usr,fname,' not found.');
               if regs.ax=3 then writeln(usr,'path not found.');
               if regs.ax=5 then writeln(usr,'Access denied by DOS.');
             end;
           Setsect(HomName);
         end;      {fname<>''}
       setsect(HomName);
       readdir(direntries,dirspace,dirbase);
     end            {not in library}
     else
       begin
         if in_library then Writeln(usr,'Status change not allowed in Library file.');
         if in_arc then writeln(usr,'Status change not allowed in Arc file.');
       end;
  end;

overlay procedure config_sys;
  var num:integer;
      menu:char;

  procedure display_settings;
    begin
      writeln(usr);
      writeln(usr,'1...Min. disk space req. to allow uploads..........  ',maxfree_uplds);
      writeln(usr,'2...Min. disk space req. to allow new users........  ',maxfree_logs);
      writeln(usr,'3...Min. disk space req. to NOT limit msg. length..  ',maxfree_mslimit);
      writeln(usr,'4...Msg. lines allowed when limited by disk space..  ',maxfree_lines);
      writeln(usr,'5...Absolute min. disk space for any operations....  ',maxfree_abs);
        write(usr,'6...Extra time added during certain hours..........  ');
      if extra_time_sw then writeln(usr,'ON')
      else writeln(usr,'OFF');
      writeln(usr,'7...Hours extra time on system is added............  ',extra_time_start,'-',extra_time_stop);
      writeln(usr,'8...Minutes of extra time to be added..............  ',extra_time_val);
        write(usr,'9...Allow caller Chat:.............................  ');
      if chat_ok then writeln(usr,'ON')
      else Writeln(usr,'OFF');
      writeln(usr,'10..Hours Chat allowed:                              ',chatstart,'-',chatend);
      writeln(usr,'11..Seconds to wait before input timeout:            ',sleepy_time);
      writeln(usr,'12..Max. tries for names, password befor hangup:     ',max_tries);
        write(usr,'13..Automatic macro operation [requires clock]:....  ');
      if auto_macro then writeln(usr,'ON')
      else writeln(usr,'OFF');
      writeln(usr,'14..Starting hour for auto macro execution:          ',auto_macro_start);
        write(usr,'15..Limiting number of max. message lines:.........  ');
      if limit_lines then writeln(usr,'ON')
      else writeln(usr,'OFF');
      writeln(usr,'16..Maximum number of message lines allowed:         ',max_msg_lines);
        write(usr,'17..Restrict 300 baud callers from using system:...  ');
      if restrict300 then writeln(usr,'ON')
      else writeln(usr,'OFF');
      writeln(usr,'18..Hours to restrict 300 baud use:                  ',start_restrict300,'-',end_restrict300);
      writeln(usr,'19..Downloads allowed / upload [ 0 = Unrestricted]:  ',up_down_ratio);
        write(usr,'20..Restrict public messages until sysop approves:   ');
      if restrict_public then writeln(usr,'ON')
      else writeln(usr,'OFF');
      seek(logr_file,0); read(logr_file,logr_rec);
      writeln(usr,'21..Caller Number..................................  ',
        logr_rec.user);
    end;

  begin  {config sys}
    repeat
      writeln(usr);
      st:=prompt('<S>ystem parameters,  <P>urge parameters,  <Q>uit',10,'ES');
      if (length(st)=1) and (st<>' ') then menu:=st[1]
      else menu:='Q';
      if (menu in ['S','P']) then
        repeat
          writeln(usr);
          if menu='S' then display_settings
          else display_purge_settings;
          writeln(usr);
          num:=strint(prompt('Number to change...<Return> to continue',2,'E'));
          if Menu='S' then change_settings(num)
          else change_purge_settings(num);
        until (num=0) or (not online);
    until (menu='Q') or (not online);
    if online then write_config_file;
  end;

Overlay Procedure Articles;

  var  this:artptr;
       num:integer;
       dirspec:strpr;
  begin
    If ArtBase<>Nil then
      begin
        repeat
          this:=artbase;
          writeln(usr);
          writeln(usr,'ARTICLES AVAILABLE FOR VIEWING');
          writeln(usr);
          while this<>nil do
            begin
              if user_rec.access>=this^.artaccs then
              writeln(usr,this^.artnum,'  ',this^.artdesc);
              this:=this^.next;
            end;
          writeln(usr);
          num:=strint(prompt('Number of Article to read [0 to exit]',3,'E'));
          this:=artbase;
          while (this<>nil) and (this^.artnum<>num) do this:=this^.next;
          if (this^.artnum=num) and (user_rec.access>=this^.artaccs) then
            begin
               Dirspec:=this^.artdrive+':\';
               if (length(HomName)>3) and (dirspec=HomDrv) then
                 begin
                   Dirspec:=Dirspec+copy(HomName,4,length(HomName));
                   Dirspec:=Dirspec+'\';
                 end;
               Dirspec:=Dirspec+'ARTICLES';
               List_file(this^.artname,Dirspec);
               Pause;
            end;
        until (not online) or (num=0);
      end
    else
      begin
        writeln(usr);
        writeln(usr,' Articles are not available at this time.');
        writeln(usr);
      end;
  end;

{ end of PPC2J.inc}
