{PPC2H.INC  Pascal Integrated Communications System Overlays}
{ 6/11/87  IBM PC Version 5.0 Copyright 1987  by Les Archambault}

overlay procedure print_log;
{ Print the log file }
  const
    txt_act: array[0..14] of FileName =
      ('PICS up  ', 'PICS down', 'Login    ', 'Logout   ', 'Recv-Xmdm',
       'Send-Xmdm', 'Type-file', 'Complete ', 'Failed   ', 'New User ',
       'Error    ', 'Purge    ', 'Car. Lost', 'Inp Timeout', 'Canceled');
  var
    t: tad_array;
    str: StrTAD;
    line_count,rec:integer;
    cur_date: real;
    temp_user_rec: user_list;
  begin
    SetSect(HomName);
    writeln(usr,'Log File Listing in reverse order. <CR> for current date.');
    str := prompt('Date to stop listing [mm/dd/yy]', 8, 'E');
    if str=' ' then str:='';
    GetTAD(t);
    if length(str) >= 2
      then t[4] := strint(copy(str, 1, 2));
    if length(str) >= 5
      then t[3] := strint(copy(str, 4, 2));
    if length(str) >= 8
      then t[5] := strint(copy(str, 7, 2));
    cur_date := greg_to_jul(t[3], t[4], t[5]);
    GetTAD(t);
    str := FormTAD(t);
    writeln(USR, 'Log file as of: ', str);
    writeln(USR);
    line_count:=2;
    if audit_on
      then
        begin
          setsect(AudName);
          writeln(AuditFile, 'Log file as of: ', str);
          writeln(AuditFile);
          setsect(HomName);
        end;
      rec:=pred(filesize(logr_file));
      if rec>1 then with logr_rec do
         begin
           seek(logr_file,rec);
           while (not brk) and online and (rec>0) do
             begin
               read(logr_file,logr_rec);
               if greg_to_jul(date[3], date[4], date[5]) >= cur_date then
                 begin
                   if (action > 1) and (logr_rec.user>0)
                   and (logr_rec.user<=(FileLen(DatF))) then
                     begin
                       GetRec(DatF, logr_rec.user, temp_user_rec);
                       if temp_user_rec.used<>0 then
                         begin
                           temp_user_rec.fn:='Deleted';
                           temp_user_rec.ln:='User';
                         end;
                     end
                   else
                     begin
                       if action>1 then temp_user_rec.fn := 'Unknown'
                       else temp_user_rec.fn:='No';
                       temp_user_rec.ln := 'User';
                     end;
                   if (action>14) or (action<0) then action:=10; {error}
                   str := FormTAD(date);
                   writeln(USR, pad(str, 28), txt_act[action], ' ',
                   pad(temp_user_rec.fn + ' ' + temp_user_rec.ln, succ(len_name)), text);
                   if (not printer_copy) and (not audit_on) and (user_rec.lines<>99) then
                     begin
                       line_count:=succ(line_count);
                       if line_count>=user_rec.lines then
                         begin
                           pause;
                           line_count:=1;
                         end;
                     end;
                   if audit_on then
                     begin
                       setsect(AudName);
                       writeln(AuditFile, pad(str, 28), txt_act[action], ' ',
                       pad(temp_user_rec.fn + ' ' + temp_user_rec.ln, succ(len_name)), text);
                       setsect(HomName);
                     end;
                   rec:=pred(rec);
                   seek(logr_file,rec);
                 end  {within date range}
               else
                 begin
                   rec:=pred(rec);
                   seek(logr_file,rec);
                 end;
             end;  {while rec>0}
         end;
      If (not printer_copy) and (not audit_on) and (line_count>1) then pause;
  end;

overlay procedure print_messages;
{ Print the message file }
  var
    i, j, first_line, last_line: integer;
    cur_date: real;
    fr_fn:firstname; fr_ln:lastname;
    t: tad_array;
    str: StrTAD;
    err:boolean;
  begin
    str := prompt('Date to start listing [mm/dd/yy]', 8, 'E');
    if ch<>ETX then
      begin
        GetTAD(t);
        if length(str) >= 2 then t[4] := strint(copy(str, 1, 2)); {month}
        if length(str) >= 5 then t[3] := strint(copy(str, 4, 2)); {day}
        if length(str) >= 8 then t[5] := strint(copy(str, 7, 2)); {year}
        cur_date := greg_to_jul(t[3], t[4], t[5]);
        GetTAD(t);
        str := FormTAD(t);
        writeln(USR, 'Message file as of: ', str);
        if audit_on then
          begin
            setsect(AudName);
            writeln(AuditFile, FF, 'Message file as of: ', str);
            setsect(HomName);
          end;
        i:=1;
        {$I-} seek(summ_file,1); {$I+}
        err:=(ioresult<>0);
        while (not err) and (not brk) and online and (not eof(summ_file)) do
          begin
            {$I-} read(summ_file, summ_rec) {$I+};
            err:=(IOresult<>0);
            if (not err) and (greg_to_jul(summ_rec.date[3],
            summ_rec.date[4], summ_rec.date[5]) >= cur_date) then
              begin
                writeln(USR);
                if audit_on then
                  begin
                    setsect(AudName);
                    writeln(AuditFile);
                    setsect(HomName);
                  end;
                mesg_header_list(i, first_line, last_line,fr_fn,fr_ln);
                {$I-} seek(mesg_file, first_line);  {$I+}
                err:=(ioresult<>0);
                if (not err) then
                  begin
                    for j := 1 to last_line do
                      begin
                        {$I-} read(mesg_file, mesg_rec); {$I+}
                        err:=(ioresult<>0);
                        if (not err) then writeln(USR, mesg_rec);
                        if audit_on and (not err) then
                          begin
                            setsect(AudName);
                            writeln(AuditFile, mesg_rec);
                            setsect(HomName);
                          end;
                      end;
                  end;
              end;
            i:=succ(i);
          end;
      end;
  end;

overlay procedure process_macro;
{ Process sysop macro }
  var
    done,continue: boolean;
    ed_macro: StrStd;
    ch:char;
    i:integer;
  begin
    done := FALSE;
    repeat
      writeln(USR);
      st:=prompt('Macro command <D><E><S><Q><?> ',80, 'ES?');
      if length(st)=1 then ch:=st[1]
      else ch:='?';
      case ch of
        'D': writeln(USR, macro);
        'E': begin
               continue:=true;
               Assign(macro_file,'MACRO.LST');
               {$I-} Reset(macro_file); {$I+}
               if ioresult=0 then
                 begin
                   writeln(usr);
                   write(usr,'The MACRO.LST file exists and must be edited');
                   writeln(usr,' with a text editor.');
                   continue:=ask('do you want to edit the in-memory macro');
                   close(macro_file);
                 end;
               if continue then
                 begin
                   ed_macro := macro;
                   GetStr(ed_macro, ch, 79, 'ES');
                   writeln(USR);
                   macro := ed_macro;
                   setsect(HomName);
                   Write_Config_File;
                 end;
             end;
        'S': begin
               done:=true;
               Assign(macro_file,'MACRO.LST');
               {$I-} Reset(macro_file); {$I+}
               if ioresult=0 then
                 begin
                   if ask('Do you want to execute the MACRO.LST file') then
                     begin
                       macro_file_exists:=true;
                       writeln('Starting macro execution.');
                       macro_in_progress:=true;
                     end
                   else close(macro_file);
                 end
               else close(macro_file);
               if (not macro_file_exists) and (length(macro)>0) then
                 begin
                   writeln('Starting macro execution.');
                   macro_in_progress:=true;
                   st:=macro;
                   repeat
                     i:=pos('^M',st);
                     if i>0 then
                       begin
                         delete(st,i,2);
                         insert(chr(13),st,i);
                       end;
                   until i=0;
                   cmd_queue:=st;
                   mult_cmds:=true;
                 end;
             end;
        'Q': done := TRUE
      else writeln(USR, '<D>isplay, <E>dit, <S>tart, <Q>uit');
      end;
    until (done) or (not online);
  end;

overlay procedure sys_dir;
{ Create system directory file }
  var
    TmpDrv,KepDrv:Str3;
    this: SectPtr;
    this_lbr,this_arc,this_temp: fileptr;
    DestName:filename;
    t: tad_array;
    KepReq: Str10;
    str: StrTAD;
    dir_file: text;
    include_lbr,include_arc:boolean;
    TmpName,KepName:strpr;

  Procedure Header;
  var
    this: SysmPtr;
    rec:integer;
  begin
    this := SysmBase;
    while (this <> nil) and (this^.key <> 'G') do
      this := this^.next;
    if this^.key = 'G' then
      begin
        setsect(HomName);
        rec:=succ(this^.loc);
        repeat
          setsect(HomName);
          seek(sysm_file,rec);
          read(sysm_file,sysm_rec);
          rec:=succ(rec);
          setsect(TmpName);
          if sysm_rec[1]<>':' then writeln(dir_file,sysm_rec);
        until EOF(sysm_file) or (sysm_rec[1]=':');
        setsect(TmpName);
        writeln(dir_file);
      end;
  end;

  procedure center(str: StrStd);
  { Center string on print line }
    begin
      writeln(dir_file, ' ':((user_rec.columns - length(str)) div 2), str);
      writeln(dir_file)
    end;

  procedure write_dir;
  { Write directory to file }
    const
      col_width = 19;
    var
      i, j, k, entries, rows, size, col_limit: integer;
      this: FilePtr;
      nodes: array[1..4] of FilePtr;
      str: Str10;
    begin
      col_limit := max(1, user_rec.columns div col_width);
      writeln(dir_file);
      if in_library then entries:=libentries
      else
      if in_arc then entries:=arcentries
      else
      entries:=direntries;
      if entries <> 0
        then
          begin
            if in_library then this:=libbase
            else
            if in_arc then this:=arcbase
            else
            this:=dirbase;
            if in_library then
            writeln(dir_file,' ** Library: ',libreq,' Files: ',entries,
            '  Space Used  ',libspace,'K')
            else
            if in_arc then
            writeln(dir_file,' ** ArcFile: ',arcreq,' Files: ',entries,
            '  Space Used  ',arcspace,'K')
            else
            writeln(dir_file, '   File area: ', SectReq, '   Files: ', entries,
              '   Space used: ', DirSpace, 'k');
            rows := entries div col_limit;
            if 0 <> entries mod col_limit
              then rows := succ(rows);
            nodes[1] := this;
            for i := 2 to col_limit do
              begin
                for j := 1 to rows do
                  this := this^.next;
                nodes[i] := this
              end;
            i := 1;
            while not (brk or (i > rows)) do
              begin
                for j := 1 to col_limit do
                  begin
                    this := nodes[j];
                    if (i + rows * pred(j)) <= entries
                      then
                        begin
                          size := this^.fsize shr 3;
                          if (this^.fsize mod 8) <> 0
                            then size := succ(size);
                          str := intstr(size, 4) + 'k ';
                          write(dir_file, this^.fname, str);
                          if j < col_limit
                            then write(dir_file, fence, ' ')
                            else writeln(dir_file)
                        end
                      else writeln(dir_file);
                    nodes[j] := nodes[j]^.next   { Go to next on list }
                  end;
                i := succ(i)
              end
          end;
      if j <> col_limit then writeln(dir_file);
    end;

  begin { sys_dir }
    SetSect(HomName);  writeln(usr);
    Write(usr,'Enter File Section name where SYSTEM.DIR will be written: ');
    DestName:=Get_section_name(' ');
    writeln(usr);
    include_lbr:= ask('Include Library breakdown');
    include_arc:= ask('Include Arc breakdown');
    if ch<>ETX then
      begin
        writeln(usr);
        writeln(USR, 'Building system directory...Please wait...');
        KepDrv := SetDrv;
        KepReq := SectReq;
        KepName:= SetName;
        FindSect(DestName, TmpDrv, OK);
        if not OK then
          begin
            TmpDrv:=HomDrv;
            TmpName:=HomName;
          end
        else
          begin
            if DestName='SYSTEM' then TmpName:=HomName
            else
              begin
                TmpName:=TmpDrv;
                if (length(HomName)>3) and (TmpDrv=HomDrv) then
                  begin
                    TmpName:=TmpName+copy(HomName,4,length(HomName));
                    TmpName:=TmpName+'\';
                  end;
                TmpName:=TmpName+DestName;
              end;
          end;
        SetSect(TmpName);
        Assign(dir_file, 'SYSTEM.DIR');
        {$I-} Rewrite(dir_file) {$I+};
        OK := (IOresult = 0);
        if OK then
          begin
            header;
            center('Complete System Directory Listing');
            center('as of');
            GetTAD(t);
            str := FormTAD(t);
            center(str);
            this := SectBase;
            while (this <> nil) and (not brk) and (online) do
              begin
                if this^.SectAccs <= val_acc then
                  begin
                    SectReq := this^.SectName;
                    SetDrv  := this^.SectDrive;
                    SetName := This^.SectDrive+':\';
                    if (length(HomName)>3) and (Setname=HomDrv) then
                      begin
                        SetName:=SetName+copy(HomName,4,length(HomName));
                        SetName:=SetName+'\';
                      end;
                    if pos(':',this^.sectname)=2 then
                       SetName:=SetName+copy(this^.sectname,3,length(this^.sectname))
                    else SetName:=SetName+this^.SectName;
                    SetSect(HomName);
                    ReadDir(DirEntries, DirSpace, DirBase);
                    SetSect(TmpName);
                    write_dir;
                    if include_lbr then
                      begin
                        this_lbr:=dirbase;
                        while this_lbr<>Nil do
                          begin
                            if copy(this_lbr^.fname,10,3)='LBR' then
                              begin
                                libreq:=this_lbr^.fname;
                                while pos(' ',libreq)>0 do
                                 delete(libreq,pos(' ',libreq),1);
                                setsect(HomName);
                                libreaddir(libentries,libspace,libbase);
                                setsect(TmpName);
                                write_dir;
                                if in_library then
                                  begin
                                     in_library:=false;
                                     setsect(SetName);
                                     close(libr_file);
                                     setsect(TmpName);
                                   end;
                              end;
                            this_lbr:=this_lbr^.next;
                          end;
                      end; {include lbr}
                    if include_arc then
                      begin
                        this_arc:=dirbase;
                        while this_arc<>Nil do
                          begin
                            if copy(this_arc^.fname,10,3)='ARC' then
                              begin
                                arcreq:=this_arc^.fname;
                                while pos(' ',arcreq)>0 do
                                 delete(arcreq,pos(' ',arcreq),1);
                                setsect(HomName);
                                arcreaddir(arcentries,arcspace,arcbase);
                                setsect(TmpName);
                                write_dir;
                                if in_arc then
                                  begin
                                     in_arc:=false;
                                     setsect(SetName);
                                     close(arc_file);
                                     setsect(TmpName);
                                   end;
                              end;
                            this_arc:=this_arc^.next;
                          end;
                      end; {include arc}
                  end;     {section<access}
                  this := this^.next
              end; {this<>nil}
            Close(dir_file);
            SetSect(HomName);
            SectReq := KepReq;
            SetDrv := KepDrv;
            SetName:= KepName;
            ReadDir(DirEntries, DirSpace, DirBase)
          end;   {file opened ok}
        writeln(USR);
      end;
  end;

{end of PPC2H.INC}
