{PPC2F.INC}
{ PICSPC  Pascal Integrated Communications System module}
{ 6/20/87 IBM PC VERS 5.0 Copyright 1987 by Les Archambault}

overlay procedure validate_user;
{ Change user access time and level to 'validated' status }
  var
    temp_user_loc: integer;
    ed_fn: firstname;
    ed_ln: lastname;
    key: StrName;
    temp_user_rec: user_list;
  begin
    OK:=true;
    SetSect(HomName);
    ed_fn:=trim(prompt('First Name',len_fn,'ESN'));
    if ed_fn<>'' then ed_ln:=trim(prompt('Last Name',len_ln,'ESN'));
    if (ed_fn='') or (ed_ln='') then OK:=false;
    if ok then
      begin
        key := pad(ed_ln, len_ln) + pad(ed_fn, len_fn);
        FindKey(IdxF, temp_user_loc, key);
      end;
    if OK then GetRec(DatF, temp_user_loc, temp_user_rec)
    else writeln(USR, 'Name not found.');
    if OK then
      begin
        if (temp_user_rec.access < user_rec.access) and
           (ask('Validate '+temp_user_rec.fn+' '+temp_user_rec.ln)) then
             begin
               temp_user_rec.access := val_acc;
               temp_user_rec.limit  := val_time;
               PutRec(DatF, temp_user_loc, temp_user_rec);
               writeln(USR, temp_user_rec.fn, ' ', temp_user_rec.ln, ' validated.')
             end;
      end;
  end;

overlay procedure delete_user;
{ Delete user from file }
  var
    i,x,temp_user_loc: integer;
    del_fn: firstname;
    del_ln: lastname;
    key: StrName;
    temp_user_rec: user_list;
    this:MesgPtr;
    err:boolean;
  begin
    err:=false; OK:=true; SetSect(HomName);
    del_fn:=trim(prompt('First Name',len_fn,'ESN'));
    if del_fn<>'' then del_ln:=trim(prompt('Last Name',len_ln,'ESN'));
    if (del_fn='') or (del_ln='') then OK:=false;
    if ok then
      begin
        writeln(usr);
        key := pad(del_ln, len_ln) + pad(del_fn, len_fn);
        SearchKey(IdxF, temp_user_loc, key);
      end
    else temp_user_loc:=0;
    if OK and (temp_user_loc<=filelen(DatF)) then
      begin
        GetRec(DatF, temp_user_loc, temp_user_rec);
        Writeln(usr,'Found User: ',temp_user_rec.fn,' ',temp_user_rec.ln);
        writeln(usr);
        if temp_user_rec.access < user_rec.access
          then if ask('Delete') then
            begin
              DeleteKey(IdxF, temp_user_loc, key);
              if OK then
                begin
                  DeleteRec(DatF, temp_user_loc);
                  writeln(usr);
                  writeln(USR, 'Revising message summary file.');
                  for i := 1 to pred(FileSize(summ_file)) do
                    begin        { Delete messages pertaining to user }
                      {$I-} seek(summ_file, i);  {$I+}
                      err:=(ioresult<>0);
                      {$I-} read(summ_file, summ_rec); {$I+}
                      err:=(ioresult<>0);
                      if (((summ_rec.user_to = temp_user_loc)
                        or (summ_rec.user_from = temp_user_loc)))
                        and (not err) then
                           begin
                             if summ_rec.user_to=temp_user_loc then
                             summ_rec.user_to:=-1;
                             if summ_rec.user_from=temp_user_loc then
                               summ_rec.user_from:=-1;
                             this:=MesgBase;
                             while (this<>nil) and (this^.mesgno<>summ_rec.num) do
                              this:=this^.next;
                             if this^.mesgno=summ_rec.num then
                               begin
                                 MesgCurr:=this;
                                 mesg_delete;
                               end;
                           end;
                    end;
                  if err then
                    begin
                      log(10,'Del User'); log(10,'Msg File');
                    end;
                  {now clear newin file references}
                  Writeln(usr,'Revising Newin file.');
                  {$I-} seek(nwin_file,0); {$I+}
                  err:=(ioresult<>0);
                  while (not eof(nwin_file)) and (not err) do
                    begin
                      {$I-} read(nwin_file,nwin_rec); {$I+}
                      err:=(ioresult<>0);
                      If (not err) then
                        begin
                          if nwin_rec.user=temp_user_loc then
                            begin
                              nwin_rec.user:=0;
                              write(nwin_file,nwin_rec);
                            end;
                        end;
                    end;
                  if err then
                    begin
                      log(10,'Del User'); log(10,'Newin File');
                    end;
                  {now finally, the log file}
                  if filesize(logr_file)>1 then
                    begin
                      writeln(usr,'Revising the Log file.');
                      {$I-} seek(logr_file,1); {$I+}
                      err:=(ioresult<>0);
                      while (not eof(logr_file)) and (not err) do
                        begin
                          {$I-} read(logr_file,logr_rec); {$I+}
                          err:=(ioresult<>0);
                          If (not err) then
                            begin
                              if logr_rec.user=temp_user_loc then
                                begin
                                  logr_rec.user:=0;
                                  write(logr_file,logr_rec);
                                end;
                            end;
                        end;
                    end;  {revising log file}
                  if err then
                    begin
                      log(10,'Del User'); log(10,'Log File');
                    end;
                  if (not err) and OK then writeln(USR, key, ' deleted.');
                  writeln(usr);
                end; {OK  - revising files}
            end;  { wants to delete}
      end   {key found}
    else
      if temp_user_loc>filelen(DatF) then
        begin
          writeln(usr,'Bad User Number - can not use.');
          log(10,'delete user'); log(10,'User Number');
        end;
  end;       {delete user}

overlay procedure rebuild_index;
{ Rebuild the user index file from the data file.  In addition, this routine
  will recover the data file from certain types of damage. }
  var
    i, previous_rec, count_used, count_unused: integer;
    key: StrName;
    temp_user_rec: user_list;
    temp: file;
  begin
    SetSect(HomName);
    writeln(USR, 'Rebuilding user index file.');
    writeln(USR, 'User data file in record order:');
    CloseIndex(IdxF);
    Assign(temp, user_indx + ext);
    Erase(temp);
    InitIndex;
    MakeIndex(IdxF, user_indx + ext, len_ln + len_fn, 0);
    previous_rec := -1;
    count_used := 0;
    count_unused := 0;
    with temp_user_rec do
      begin
        for i := 1 to pred(FileLen(DatF)) do
          begin
            GetRec(DatF, i, temp_user_rec);
            if used = 0
              then
                begin
                  key := pad(ln, len_ln) + pad(fn, len_fn);
                  AddKey(IdxF, i, key);
                  if OK
                    then
                      begin
                        count_used := succ(count_used);
                        writeln(USR, i:4, '  ', used:4, '  ', fn, ' ', ln)
                      end
                    else
                      begin
                        used := previous_rec;    { Can't use DeleteRec since }
                        previous_rec := i;       {   we're playing with pointers }
                        PutRec(DatF, i, temp_user_rec);
                        count_unused := succ(count_unused);
                        writeln(USR, i:4, '  ', used:4, '  Duplicate record deleted')
                      end
                end
              else
                begin
                  used := previous_rec;
                  previous_rec := i;
                  PutRec(DatF, i, temp_user_rec);
                  count_unused := succ(count_unused);
                  writeln(USR, i:4, '  ', used:4, '  Free record')
                end
          end
      end;
    GetRec(DatF, 0, temp_user_rec);
    DatF.FirstFree := previous_rec;
    DatF.NumberFree := count_unused;
    PutRec(DatF, 0, temp_user_rec);

{ Normally PICS only closes files between sessions to improve operational
  speed, but since essential data files have just been modified, they will
  be closed and reopened to ensure file integrity. }

    CloseFile(DatF);
    CloseIndex(IdxF);
    OpenFile(DatF, user_data + ext, SizeOf(user_rec));
    OpenIndex(IdxF, user_indx + ext, len_ln + len_fn, 0);
    InitIndex;
    writeln(USR);
    writeln(USR, FileLen(DatF), ' records, ', UsedRecs(DatF), ' users in file.')
  end;

Overlay Procedure Make_Message;
 {makes a message entry from a disk file}
  var
    msg_status: record_status;
    abort:boolean;
    ch: char;
    start,last_line, to_loc,from_loc,x,to_area: integer;
    to_fn,from_fn: firstname;
    to_ln,from_ln: lastname;
    subj: subject;
    key: StrName;
    temp_user_rec: user_list;
    msg_line:message;
    mfile:text;
    mname:filename;
    t:tad_array;
    this:areaptr;
    area:str10;

  begin
    writeln(usr);  ok:=true;
    SetSect(HomName);
    mname:=prompt('Name of file in SYSTEM area to put into message',12,'ES');
    if mname<>' ' then
      begin
        Abort:=false;
        Assign(mfile,mname);
        {$I-} Reset(mfile); {$I+}
        if ioresult<>0 then
          begin
            Writeln(usr);
            writeln(usr,'Can Not find file ',mname);
            writeln(usr);
            ok:=false;
          end;
        if ok then
          begin
            Writeln(USR);
            Write(USR, 'From: ', user_rec.fn, ' ', user_rec.ln);
            if (not ask(' OK')) then
              begin
                repeat
                  from_fn:=prompt('From FIRST Name ',len_fn,'ESN');
                  if from_fn='QUIT' then abort:=true
                  else
                  from_ln:=prompt('From LAST Name  ',len_ln,'ESN');
                  if from_ln='QUIT' then abort:=true;
                  if (not abort) then
                    begin
                      key := pad(from_ln, len_ln) + pad(from_fn, len_fn);
                      FindKey(IdxF, from_loc, key);
                      if not OK then
                        begin
                          Writeln(USR, from_fn, ' ', from_ln, ' not known on system.');
                          writeln(usr,'type QUIT to exit .');
                        end;
                    end;
                until ok or abort or (not online);
              end     {get new FROM name}
            else
            from_loc:=user_loc;
            OK:=false;
            if (not abort) then
              begin
                repeat
                  to_fn := prompt('To FIRST name [CR for ALL]', len_fn, 'ESN');
                  if to_fn='QUIT' then abort:=true
                  else
                  if to_fn=' ' then
                    begin
                      to_loc:=0;
                      msg_status:=public;
                      ok:=true;
                    end
                  else
                  if to_fn = 'SYSOP' then to_ln := ''
                  else
                  to_ln := prompt('LAST name', len_ln, 'ESN');
                  if to_ln='QUIT' then abort:=true;
                  if (not OK) and (not abort) then
                    begin
                      key := pad(to_ln, len_ln) + pad(to_fn, len_fn);
                      FindKey(IdxF, to_loc, key);
                      if not OK then
                        begin
                          Writeln(USR, to_fn, ' ', to_ln, ' not known on system.');
                          writeln(usr,'type QUIT to exit .');
                        end;
                    end;
                until (not online) or OK or abort;
                if abort or (not online) then OK:=false;
                if OK then
                  begin
                    subj := prompt('Subject', len_subj, 'EL');
                    if subj='' then subj:='NONE';
                    If to_fn<>' ' then
                      begin
                        if Ask('Make Message PUBLIC') then msg_status:=public
                        else msg_status:=private;
                      end;
                    repeat
                      this:=areabase;
                      area:=prompt('Message Area',12,'ES?M');
                      if (area=' ') or (area='?') then
                        begin
                          Writeln(usr,'Available message Areas:');
                          writeln(usr);
                          while this<>nil do
                            begin
                              writeln(usr,this^.areaname);
                              this:=this^.next;
                            end;
                        end
                      else
                        begin
                          this:=areabase;
                          while (this<>nil) and (area<>this^.areaname) do
                          this:=this^.next;
                        end;
                    until (area=this^.areaname) or (not online);
                    to_area:=this^.area;

                    start:=filesize(mesg_file);    {record msg lines}
                    seek(mesg_file,start);
                    last_line:=0;
                    while (not EOF(mfile)) do
                      begin
                        Readln(mfile,msg_line);
                        write(mesg_file,msg_line);
                        last_line:=succ(last_line);
                      end;
                    close(mfile);

                    GetTAD(t);                 {make summary file record}
                    seek(summ_file, 0);
                    read(summ_file, summ_rec);
                    with summ_rec do
                      begin
                        date      := t;
                        status    := msg_status;
                        area      := to_area;
                        num       := succ(num);
                        num_prev  := 0;
                        num_next  := 0;
                        user_from := from_loc;
                        user_to   := to_loc;
                        subject   := subj;
                        st_rec    := start;
                        size      := last_line;
                      end;
                    seek(summ_file, 0);
                    Write(summ_file, summ_rec);
                    seek(summ_file, filesize(summ_file));  {add new record to end}
                    Write(summ_file, summ_rec);
                    mesg_insert(0);
                    writeln(usr);
                    writeln(usr,'Message built.');
                  end;                {OK second time}
              end;                    {not abort}
          end;                        {OK}
      end;                            {Name<>' '}
  end;                                {make message}

{ end of PPC2F.inc}
