{PPC2E.INC}
{ PICSPC  Pascal Integrated Communications System module}
{ 5/31/87 IBM PC VERS 5.0 Copyright 1987 by Les Archambault}

overlay procedure display_users;
{ Display user file }
  const
    col_width = 19;
  var
    i, colbeg, colend, len,count: integer;
    ch, disp_case, disp_nois: char;
    t: tad_array;
    key: StrName;
    temp_user_rec: user_list;
    str:strtad;
    caller:boolean;

  begin   {display users}
   SetSect(HomName);
   if (user_rec.access >= 250) or (not remote_copy) then caller:=false
   else caller:=true;
    repeat
    if (not caller) then
      begin
        writeln(usr);
        st := prompt('Type of list <A><B><E><Q><U><?> ',80, 'ES?');
        if length(st)=1 then ch:=st[1]
        else ch:=' ';
        if not(ch in ['A','E','Q','U'])
          then Writeln(USR, '<A>ll, <B>rief, <E>xceptional, <U>n-validated, <Q>uit');
      end
    else
      If user_rec.access>=val_acc then ch:='B'
      else ch:='Q';
    if ch in ['A','B','E','U'] then
    Begin
    Writeln(USR);
    Writeln(USR, 'The user list will be alphabetic by last name,');
    Writeln(USR, 'starting with a character or string you specify.');
    Writeln(USR);
    key := prompt('Start [ <CR> for all names]', len_name, 'ES');
    if key = ' '
      then
        begin
          ClearKey(IdxF);
          NextKey(IdxF, i, key)
        end
      else
        begin
          SearchKey(IdxF, i, key);
          if not OK
            then
              begin
                ClearKey(IdxF);
                NextKey(IdxF, i, key)
              end
        end;
    GetTAD(t); Count:=0;
    str := FormTAD(t);
    if ch = 'E'
      then Writeln(USR, 'Exceptional - access, time, exempt from purge.')
    else if ch = 'U'
      then Write(USR, 'Unvalidated ');
    Writeln(USR, 'Users As Of: ', str);
    Writeln(USR);
    if (user_rec.lines<>99) and (not printer_copy) then count:=count+2;
    if (user_rec.access >= 250) or (not remote_copy) then
      begin
        Writeln(USR, FileLen(DatF), ' records, ');
        if (user_rec.lines<>99) and (not printer_copy) then count:=succ(count);
      end;
    if ch<>'B' then Writeln(USR, UsedRecs(DatF), ' users in file.');
    if (user_rec.lines<>99) and (not printer_copy) then count:=succ(count);
    colend := 999;
    while (not brk) and OK do
      with temp_user_rec do
        begin
          GetRec(DatF, i, temp_user_rec);
          if (ch = 'B') and (fn <> 'SYSOP') and (access >= val_acc)
            then
              begin
                Writeln(usr,pad(ln,succ(len_ln)),' ',pad(fn,succ(len_fn)),
                 '    ',pad(cy,succ(len_cy)),'  ',st);
                writeln(usr,'Computer: ',pad(ad,succ(len_ad)),' Last on: ',laston[4],
                  '/',laston[3],'/',laston[5]);
                writeln(usr);
                if (user_rec.lines <>99) and (not printer_copy) then
                  begin
                    count:=count+3;
                    if count>=user_rec.lines then
                      begin
                        pause; count:=0;
                      end;
                  end;
              end
          else if (ch = 'A')
               or ((ch = 'U') and (access < val_acc))
               or ((ch = 'E') and ((access > val_acc) or (limit > val_time)
               or test_bit(flags,5)))
            then if fn<>'SYSOP' then
              begin
                Writeln(usr);
                Writeln(USR,                 {first line}
                  ln,' ',fn,'   ',cy,',',st,'   ',
                  pad(ph, succ(len_ph)),'  ',
                  pad(ad, succ(len_ad)));

                Writeln(usr,                 {second line}
                  'Access:',access:4,
                  '    Time Limit:',limit:4);

                if shift_lock
                  then disp_case := 'U'
                  else disp_case := 'L';
                if noisy
                  then disp_nois := 'N'
                  else disp_nois := 'Q';

                Write(USR,                   {third line}
                  'Nulls:',nulls:2,
                  '    Case:',disp_case:2,
                  '    Noisy:',disp_nois:2,
                  '    Conferences:');
                  if conf_flags>0 then
                    begin
                      for i:=1 to 7 do
                       if test_bit(conf_flags,i) then write(usr,' ',chr(i+48));
                      writeln(usr);
                    end
                  else writeln(usr,' None');

                Writeln(usr,                 {fourth line}
                  'Cols:',columns:3,
                  '   Lines:',lines:3,
                  '   Last on: ',laston[4],'/',laston[3],'/',laston[5],' ',
                  '   Last msg read:',lasthi:5);

                Write(usr,                   {fourth line}
                  'Uplds:',upload:3,
                  '    Downlds:',download:4,
                  '   Password: ',pw,
                  '   Flags set:');
                  if flags>0 then
                    begin
                      for i:=0 to 7 do
                        if test_bit(flags,i) then write(usr,' ',chr(i+48));
                      writeln(usr);
                    end
                  else writeln(usr,' None');

                 if (user_rec.lines<>99) and (not printer_copy) then
                   begin
                     count:=count+6;
                     if count>=user_rec.lines then
                     begin
                       pause; count:=0;
                     end;
                   end;
              end;
          NextKey(IdxF, i, key)
        end;
   end;  {valid command}
   until (ch='Q') or (not online) or caller;
  end;

overlay function chat: boolean;
{ Chat with sysop }
  var
    regs:registerset;
    ch: char;
    i,x,n,count: integer;
    t: tad_array;
    str: StrStd;
  begin
    OK := op_chat;
    if op_chat
      then Writeln(USR, 'Chat requested by Sysop...', BEL, BEL)
      else
        begin
          GetTAD(t);
          if (not chat_ok) then
            writeln(usr,'Sorry, the Chat function is not active at this time.')
          else
          if (t[2] < ChatStart) or (t[2] > pred(ChatEnd))
            then Writeln(USR, 'Sorry, the hours to chat are ', ChatStart, ':00 to ', ChatEnd, ':00.')
            else
              begin
                Writeln(USR);
                Writeln(USR, 'Please standby ', user_rec.fn, ' ', user_rec.ln, '.');
                Writeln(USR, 'Will ring for 30 seconds.  Type ^C to cancel.');
                Writeln(USR);
                Write(USR, '|-------------------------------|', CR, '|');
                i := 15;
                repeat
                  Write(BEL, BEL);           { BEL is not normally sent to console }
                  Write(USR, '-+', BEL);
                  time_count:=0;  count:=0;
                  repeat
                    ch:=GetChar;
                    regs.ah:=0;
                    intr($1a,regs);
                    n:=regs.dx;
                    if n<>time_count then
                      begin
                        time_count:=n;
                        count:=succ(count);
                      end;
                  until (not online) or (count >36) or (ch in [ETX, ESC]);
                  i := pred(i)
                until (not online) or (i <= 0) or (ch in [ETX, ESC]);
                Writeln(USR);
                if ch = ETX
                  then Writeln(USR, 'Cancelled.')
                  else if ch = ESC
                    then
                      begin
                        Writeln(USR, 'Sysop is available.  Type ^C to exit CHAT...');
                        OK := TRUE
                      end
                    else Writeln(USR, 'Sorry, the sysop is not available.')
              end
        end;
    if OK
      then
        begin
          Writeln(USR);
          next_inpstr := '';
          repeat
            str := next_inpstr;
            GetStr(str, ch, len_msg, 'AEW');
            Writeln(USR)
          until (not online) or (ch = ETX);
          chat := FALSE
        end
      else chat := ask('Would you care to leave a message')
  end;

overlay procedure display_time;
{ Display current system time and date }
  var
    t,tem: tad_array;
    str: StrTAD;
    min,hr,err:integer;
    temp:real;
  begin
    GetTAD(t);
    str := FormTAD(t);
    Writeln(USR, str);
    if (not clock) then
      begin
       writeln(usr);
       hr:=trunc((hour_count/600.0)*(Mhz/4.0));
       write(usr,'System thinks time is ',hr,':');
       min:=trunc(frac(hour_count/600)*(Mhz/4.0)*60);
       if min<10 then write(usr,'0');
       writeln(usr,min);
       if (user_rec.access>=250) and (ask('Change time adjustment multiplier')) then
         begin
           writeln(usr,'less than 1.0 slows timer,  greater than 1.0 speeds timer');
           writeln(usr,'Present setting is ',time_adjust:2:2);
           st:=prompt('New value',4,'E');
           val(st,temp,err);
           if err=0 then time_adjust:=temp;
         end;
      end;
    if (user_rec.access >= 250) or (not remote_copy)
      then if ask('Do you want to reset the time')
             then
               begin
                 Writeln(USR);              { Change login time so system doesn't hang up on us }
                 tem[5] := strint(prompt('Year  ', 2, 'E'));
                 tem[4] := strint(prompt('Month ', 2, 'E'));
                 tem[3] := strint(prompt('Day   ', 2, 'E'));
                 tem[2] := strint(prompt('Hour  ', 2, 'E'));
                 tem[1] := strint(prompt('Minute', 2, 'E'));
                 tem[0] := strint(prompt('Second', 2, 'E'));
                 SetTAD(tem);
                 GetTAD(login_t);
                 str := FormTAD(login_t);
                 Writeln(USR, str);
               end;
  end;

overlay procedure display_stats;
  var
    i, days, max: integer;
    t: tad_array;
    day_array: array[0..23] of integer;

  procedure show_graph(title: StrPr);
    var
      i, j: integer;
      factor, scale: real;
      line: StrStd;
    begin
      Writeln(USR, ' ':8, title, ' for the Last ', days, ' Days');
      Writeln(USR);
      factor := max / 15.0;
      for j := 15 downto 1 do
        begin
          line := '                                                                       ';
          scale := factor * j;
          for i := 0 to 23 do
            if day_array[i] > scale
              then
                begin
                  line[1 + 3 * i] := '*';
                  line[2 + 3 * i] := '*'
                end;
          Write(USR, scale:3:0);
          i := length(line);
          while line[i] = ' ' do
            i := pred(i);
          Writeln(USR, ' ', copy(line, 1, i))
        end;
      Writeln(USR, '    12  1  2  3  4  5  6  7  8  9 10 11 12  1  2  3  4  5  6  7  8  9 10 11');
      Writeln(USR, '    |------------- A. M. ---------------|------------- P. M. -------------|')
    end;

  begin { show_stats }
    GetTAD(t);
    days := round(greg_to_jul(t[3], t[4], t[5]) - greg_to_jul(stat_rec.date[3],
      stat_rec.date[4], stat_rec.date[5]));
    if days = 0
      then days := 1;
    max := 0;
    for i := 0 to 23 do
      begin
        day_array[i] := round((100.0 * stat_rec.busy_per_hour[i]) / (60.0 * days));
        if max < day_array[i]
          then max := day_array[i]
      end;
    show_graph('Percent of Average System Usage by Hour')
  end;

overlay procedure alter_user_params;
{ Get new user parameters }
  var
    valid, continue: boolean;
    ch: char;
    i: integer;
    temp: string[2];
  begin
    repeat
      continue := false;
      st:=prompt('Parameter <B><L><N><P><Q><S><?> ',80, 'ES?');
      if length(st)=1 then ch:=st[1]
      else ch:='?';
      case ch of
        'B': begin
               user_rec.noisy := not user_rec.noisy;
               if user_rec.noisy
                 then Writeln(USR, 'Prompt bell on.')
                 else Writeln(USR, 'Prompt bell off.')
             end;
        'L': begin
               Writeln(USR, 'Current lines-per-page setting is ', user_rec.lines, '.');
               temp := prompt('New setting [10-48 or 99 to inhibit pause]', 2, 'ES');
               i := strint(temp);
               if (temp = ' ') or (not (i in [10..48, 99]))
                 then Writeln(USR, 'Lines-per-page unchanged.')
                 else user_rec.lines := i
             end;
        'N': begin
               Writeln(USR, 'Currently using ', user_rec.nulls, ' nulls.');
               get_nulls
             end;
        'P': begin
               get_old_password('Please enter current password', valid);
               if valid
                 then get_new_password
                 else Writeln(USR, 'Password unchanged.')
             end;
        'Q': continue:=true;
        'S': get_case
       else
             begin
               list('C');
               continue := FALSE;
             end;
      end;
    until (continue) or (not online);
    if online then putrec(datf,user_loc,user_rec);
  end;

{end of PPC2E.inc}

