{PPC2D.INC}
{ PICSPC  Pascal Integrated Communications System module}
{ 5/31/87 IBMPC VERS 5.0 Copyright 1987 by Les Archambault}

overlay procedure RecvXmodem(mode:char);
{ Receive a file using Xmodem protocol }

  var
    filecount,i,recs,mm,ss,free,size: integer;
    XfrName: FileName;
    abort_batch,in_conference,timeup:boolean;
    bt:byte;
    Fnames:fname_array;
    TemDrv:str3;
    TemName:strpr;
    this:sectptr;

Procedure Get_File(var xfrname:filename; var abort_batch:boolean;mode:char);

  var
    i, block, mm, ss: integer;
    XfrFile: untype_file;
    this:SectPtr;
    DirSpec:StrPr;
    file_exists:boolean;
  Begin
    if XfrName <> '' then
      begin
        block:=1; file_exists:=false;
        while (length(XfrName) - pos('.', XfrName)) < 2 do
          XfrName := XfrName + '-';
        setsect(HomName);
        log(4, XfrName);
        this:=SectBase;
        OK:=true;
        while (this<>nil) and OK do
          begin    { Ensure file doesn't already exist }
            if (this^.sectname='SYSTEM') or (this^.SectAccs>=250)
              then this:=this^.next;
            if this<>nil then
              begin
                dirspec:=this^.sectdrive+':\';
                if (length(Homname)>3) and (dirspec=Homdrv) then
                  begin
                    dirspec:=dirspec+copy(HomName,4,length(HomName));
                    dirspec:=dirspec+'\';
                  end;
                if pos(':',this^.sectname)=2 then
                  dirspec:=dirspec+copy(this^.sectname,3,length(this^.sectname))
                else dirspec:=dirspec+this^.sectname;
                setsect(dirspec);
                Assign(XfrFile, XfrName);
                {$I-} Reset(XfrFile) {$I+};
                OK:=(ioresult<>0);  { OK true if file not found }
                close(XfrFile);
                this:=this^.next;
              end;
          end;
        if (not OK) then file_exists:=true;
        SetSect(RcvName);
        if OK then
          begin
            {$I-} Rewrite(XfrFile) {$I+};    { Try to open file }
            OK := (IOresult = 0);
            if OK then
              begin
                setsect(HomName);
                free:=diskfree(rcvdrv);
                if mode<>'B' then
                  begin
                    if in_conference then
                    writeln(usr, Xfrname, ' will be received in the conference area.')
                    else
                    writeln(USR, XfrName, ' will be received in a private area.');
                    writeln(USR, free, 'k disk space available.  Please cancel if file is too large.');
                    writeln(USR, 'To cancel, type CTL-X.');
                    writeln(USR, 'Ready to receive...');
                  end;
                RecvFile(xfrname,xfrfile,block,mode,abort_batch);
                if OK then OK := (FileSize(XfrFile) > 0);
                if OK then
                  begin
                    send_time(filesize(xfrFile), mm, ss);
                    extra_time := extra_time + mm;
                  end;
                close(XfrFile);
                if OK then
                  begin
                    if not in_conference then
                      begin
                        SetSect(HomName); {set up for loading overlay}
                        hide_release(XfrName, private,RcvName);
                      end;
                  end
                else
                  begin
                    Erase(XfrFile);
                    Writeln(usr);
                    writeln(USR, 'Transfer cancelled.  Incomplete file deleted.');
                    if mode='B' then abort_batch:=true;
                  end;
              end
            else
              begin
                writeln(USR, 'Cannot create ', XfrName, '.');
                if mode='B' then abort_batch:=true;
              end;
          end
        else
          begin
            Close(XfrFile);
            writeln(USR,'Thanks, but there is already a copy of ', XfrName, ' in the System.');
            if mode='B' then abort_batch:=true;
          end;
        SetSect(HomName);
        if OK then
          begin
            log(7, '');
            if (not clock) then for i:=1 to mm do
              begin
                tick_a_min;
                hour_count:=hour_count+10.0;
              end;
            user_rec.upload := succ(user_rec.upload);
          end
        else
          begin
            if file_exists then log(8, 'File Exists') else log(8,'');
            if mode='B' then abort_batch:=true;
          end;
      end;
  end;

begin { RecvXmodem }
 if (diskfree(RcvDrv)>maxfree_uplds) and (maxavail>64) then
  begin
    filecount:=0;  abort_batch:=false; xfrname:=' '; {set up}
    in_conference:=false;
    this:=sectbase;
    while (this<>nil) and (this^.sectname<>sectreq) do this:=this^.next;
    if this^.sectname=sectreq then
      begin
        i:=this^.sectconf;  {conference number}
        in_conference:= test_bit(user_rec.conf_flags,i)
      end;
    if in_conference then
      begin
        TemDrv:=RcvDrv;
        TemName:=RcvName;
        RcvDrv:=setDrv;
        RcvName:=SetName;
      end;
    if mode='B' then
      begin
        log(4,'BATCH');
        free:=diskfree(RcvDrv);
        for i:=1 to 20 do fnames[i]:='';  {empty array}
        writeln(usr,'Batch Mode Enabled -  ',free,'K space available');
        writeln(usr,'Max. of 20 files may be transfered.');
        writeln(usr,'Please cancel with CTRL X if space too small');
        write(usr,'Files will be received in a ');
        if in_conference then writeln(usr,'conference area.')
         else writeln(usr,'private area.');
        writeln(usr,'Descriptions will be requested at end of transfers');
        writeln(usr,'Ready to Receive...');
        while (not abort_batch) and (xfrname<>'') do
            begin
              free:=diskfree(RcvDrv);
              get_filename(xfrname,fnames,filecount,recs,size,abort_batch);
              if free<maxfree_uplds then
                begin
                  abort_batch:=true;
                  writeln(usr,'Insufficient disk space.');
                end
              else
              if abort_batch then writeln(usr,'Bad Filename');
              file_recs:=recs;
              if (xfrname<>'') and (not abort_batch) then
                  get_file(xfrname,abort_batch,mode);
              if (filecount>20) and (not abort_batch) then
                begin
                  writeln(usr,'20 file limit...');
                  repeat bt:=getbyte(2,timeup);
                  until timeup;
                  PutByte(Ord(CAN));
                  Putbyte(Ord(CAN));
                  abort_batch:=true;
                end;
            end;
        If Abort_batch then
          begin
            Writeln(usr,'Aborting Batch Transfer.');
            PutByte(ord(CAN));
            PutByte(ord(CAN));
            log(8,'BATCH');
            clear_inbuf;
          end
        else
          log(7,'BATCH');
        writeln(usr); gotoxy(1,23); writeln(usr);
        filecount:=pred(filecount);  {last empty filename record}
        setsect(HomName);
        While (filecount>=1) and online do
            begin
              if fnames[filecount]<>'' then
                begin
                  writeln(usr,'File: ',Fnames[filecount]);
                  Get_description(Fnames[filecount]);
                  filecount:=pred(filecount);
                end;
            end;
        if ok and (not abort_batch) then writeln(usr,'Thanks, ',user_rec.fn);
        if (setdrv=rcvdrv) and (SetName=RcvName) then
            begin
              ReadDir(DirEntries,DirSpace,DirBase);
              New_Dir:=false;
            end;
        setsect(HomName);

      end           {END OF BATCH}
    else
      begin
        XfrName := prompt('File name', 12, 'ES');
        if xfrname<>' ' then xfrname:=correct_fn(xfrname)
        else xfrname:='';
        if xfrname<>'' then get_file(xfrname,abort_batch,mode);
        if ok and (xfrname<>'')then
          begin
            writeln(usr);
            Writeln(usr,'Transfer Complete.');
            setsect(HomName);
            Get_description(xfrname);
            if (setdrv=rcvdrv) and (SetName=RcvName) then
              begin
                ReadDir(direntries,dirspace,dirbase);
                new_dir:=false;
              end;
            Writeln(usr,'Thanks, ',user_rec.fn);
          end
        else clear_inbuf;
      end;
    if in_conference then
      begin
        RcvDrv:=TemDrv;
        RcvName:=TemName;
        in_conference:=false;
      end;
    SetSect(HomName);
  end         {got enough disk space}
  else
    begin
      writeln(usr);
      if maxavail<64 then
        begin
          Writeln(usr,'Not enough memory for uploads.');
          setsect(HomName);
          log(4,'Heap Size');
        end
      else
      Writeln(usr,'Not enough disk space for uploads.');
      writeln(usr);
    end;
  repeat bt:=getbyte(2,timeup);
  until timeup;
end;

{end of PPC2d.inc}
