{PPC2C.INC}
{ PICSPC  Pascal Integrated Communications System module}
{ 5/31/87 IBM PC VERS 5.0 Copyright 1987 by Les Archambault}

overlay procedure SendXmodem(sendmode:char);
{ Send a file using Xmodem protocol }
  var
    OK,Ok_to_send,connected,timeup: boolean;
    bt:byte;
    this: FilePtr;
    XfrName: FileName;
    XfrFile: untype_file;
    i,x,mm,ss,size,fnum,tot_size:integer;
    fnames:fname_array;
    fsize:array[1..20] of integer;
    name_buf:record_array;
    tot_send_time,ch_size:real;

procedure Send_a_File;
   var arc_recs:integer;
  begin
      if in_library
      then this := LibBase
      else if in_arc then this:=ArcBase
      else this := DirBase;
    while (this <> nil) and (XfrName <> compress_fn(this^.fname)) do
      this := this^.next;
    if this <> nil
      then
        begin
          setsect(HomName);
          log(5, XfrName);
          setsect(SetName);
          if in_library
            then
              begin
                seek(libr_file, this^.index);
                setsect(HomName);
                SendFile(xfrname,libr_file, this^.fsize,sendmode,ok_to_send);
              end
            else
            if in_arc then
              begin
                setsect(HomName);
                Position_Arcfile(xfrname,ok_to_send);
                arc_recs:=trunc((Long_to_Real(hdr.size)+31.0)/128.0);
                if frac((long_to_real(hdr.size)+31.0)/128.0)>0 then
                   arc_recs:=succ(arc_recs);
                if ok_to_send then
                  begin
                    setsect(HomName);
                    SendFile(XfrName,Arc_file,arc_recs,sendmode,ok_to_send);
                  end;
              end
            else
              begin
                Assign(XfrFile, XfrName);
                Reset(XfrFile);
                setsect(HomName);
                SendFile(xfrname,XfrFile, FileSize(XfrFile),sendmode,ok_to_send);
                Close(XfrFile)
              end;
          SetSect(HomName);
          if OK_to_send then
            begin
              log(7, '');
              user_rec.download := succ(user_rec.download);
            end
          else log(8, '');
        end
      else
        begin
          writeln(USR, XfrName, ' not found.');
          ok_to_send:=false;
          SetSect(HomName);
          Log(8,'Not Found');
        end;
  end;

begin { SendXmodem }
 if (not test_bit(user_rec.flags,1)) then
  begin
    Ok_to_send:=true;
    if (sendmode='B') and ((in_library) or (in_arc)) then
      begin
        writeln(usr,'No batch mode within Library or Arc files.');
        ok_to_send:=false;
        writeln(usr);
      end;
    If (sendmode='B') and (not in_library) and (not in_arc) and (ok_to_send) then
      begin
       fnum:=0;  {total number of files to send}
       Writeln(usr);
       Writeln(usr,'Batch Mode enabled.');
       log(5,'BATCH');
       repeat
        ok_to_send:=Online;
        if ok_to_send then xfrname:=prompt('Filenames (wildcards ok)',80,'ES');
        If (xfrname<>' ') and (ok_to_send) then
          begin
            This:=dirbase;
            xfrname:=expand_filename(xfrname);
            while (this<>nil) and (ok_to_send) do
              begin
                if fnum>20 then ok_to_send:=false;
                if (equal_names(xfrname,this^.fname)) and ok_to_send then
                  begin
                    fnum:=succ(fnum);
                    fnames[fnum]:=compress_fn(this^.fname);
                    fsize[fnum]:=this^.fsize;
                  end;
                this:=this^.next;
              end;
          end;     {xfrname<>' ' and ok to send}
       until (xfrname=' ') or (not mult_cmds) or (not ok_to_send);
       if (fnum>0) and (fnum<21) and (ok_to_send) then
          begin
            tot_size:=0;  tot_send_time:=0;
            for i:=1 to fnum do
              begin
                size:=fsize[i] shr 3;  {divide by 8 recs / K}
                if fsize[i] mod 8<>0 then size:=succ(size);
                if odd(size) then size:=succ(size);
                tot_size:=tot_size+size;
                tot_send_time:=tot_send_time+(fsize[i] * 23.0 / rate);
              end;
            mm:= trunc(tot_send_time);
            ss:=round(60.0 * frac(tot_send_time));
            Writeln(usr);
            Writeln(usr,'Total xfer time ',mm,' minutes ',ss,' secs. at ',rate,' baud.');
            Writeln(usr,fnum,' File(s) require ',tot_size,'K (2K blocks).');
            Writeln(usr,'Abort with Ctrl X if space not available.');
            Writeln(usr,'Ready to Send...');
            Writeln(usr);
            Timer(time_on,time_left);
            If time_left<mm then
              begin
                Writeln(usr,'Not enough time for transfer.');
                ok_to_send:=false;
              end;
          end       {fnum>0 and fnum<26}
       else         {no filenames or too many files}
          begin
            ok_to_send:=false;
            if fnum>20 then Writeln(usr,'Max. of 20 Files.')
            else writeln(usr,'No files found...Aborting.');
          end;
       setsect(HomName);
       If ok_to_send then test_download_ratio(ok_to_send,sendmode,fnum);
       While (ok_to_send) and (fnum>0) and (fnames[fnum]<>'') do  {build name record}
         begin
           ok_to_send:=online;
           xfrname:=fnames[fnum];
           for i:=1 to length(xfrname) do name_buf[i]:=ord(xfrname[i]);
           i:=succ(i);
           name_buf[i]:=0;                     {end of filename}
           ch_size:=fsize[fnum] * 128.0;
           str(ch_size:8:0,st);
           i:=succ(i);
           for x:=1 to length(st) do
             begin
               if st[x]<>' ' then
                 begin
                   name_buf[i]:=ord(st[x]);
                   i:=succ(i);
                 end;
             end;
           name_buf[i]:=ord(' ');  {terminate record size string }
           for x:=i+1 to 128 do name_buf[x]:=0;   {fill out record}
           name_buf[127]:=lo(fsize[fnum]);        {record count}
           name_buf[128]:=hi(fsize[fnum]);
           if (fnum>0) and (ok_to_send) then
             begin
               send_name(name_buf,ok_to_send);
               if ok_to_send then send_a_file;
               if ok_to_send then update_newin(xfrname);
             end;
           fnum:=pred(fnum);
           if (fnum=0) and (ok_to_send) then
             begin
               fillchar(name_buf,sizeof(name_buf),chr(0));
               send_name(name_buf,ok_to_send);
               if (ok_to_send) and (not clock) then
                for i:=1 to trunc(tot_send_time) do
                  begin
                    tick_a_min;
                    hour_count:=hour_count+10.0;
                  end;
             end;
         end; {ok to send, fnum>0 and fnames<>''}
         setsect(HomName);
         writeln(usr);
         if ok_to_send then
           begin
             log(7,'BATCH');
             writeln(usr,'Batch Transfer Complete.');
           end
         else
           begin
             log(8,'BATCH');
             writeln(usr,'Aborting Batch Transfer.');
           end;
      end     {sendmode=B and not in library and ok to send}
    else
    if (Ok_to_send) and (sendmode<>'B') then
      begin
        setsect(HomName);
        test_download_ratio(ok_to_send,sendmode,fnum);
        if ok_to_send then
          begin
            XfrName := prompt('File name', 12, 'ES');
            if xfrname<>' ' then xfrname:=correct_fn(xfrname)
            else xfrname:='';
            if XfrName <> '' then Send_a_file;
            SetSect(HomName);
            if (ok_to_send) and (xfrname<>'') then update_newin(xfrname);
          end;
      end;
  end   {not restricted}
 else
   begin
     writeln(usr);
     if maxavail<64 then
       begin
         write(usr,'Memory problem ');
         setsect(HomName);
         log(5,'Heap Size');
       end;
     Writeln(usr,'Unable to send files.');
     writeln(usr);
   end;
 repeat bt:=getbyte(2,timeup);  {eat garbage on phone lines}
 until timeup;
end;    {Send Xmodem}

overlay procedure SendText;
  const
    bufsize = 128;
    bufblocks =1;
  var
    this: FilePtr;
    XfrName: FileName;
    XfrFile: untype_file;
    buffer:array[1..bufsize] of byte;

  procedure SendFile(var XfrFile: untype_file; remaining: integer);
  { Send a squeezed or ASCII file }
    const
      recognize = $FF76;
      DLE       = $90;
    var
      EndOfFile, squeezed,page,connected: boolean;
      i, x, BufferPtr, bpos, curin, repct, lastc, NoOfRecs, line_count: integer;
      FileType: String[3];
      ErrMsg: StrPr;
      dnode: array [0..255, 0..1] of integer;

    function getc: integer;
    { Get an 8 bit value from the input buffer - read block if necessary }
      begin
        if BufferPtr > BufSize
          then
            begin
              NoOfRecs := min(BufBlocks, remaining);
              EndOfFile := (NoOfRecs = 0);
              if not EndOfFile
                then
                  begin
                    {$I-} BlockRead(XfrFile, Buffer, NoOfRecs) {$I+};
                    EndOfFile := (IOresult <> 0)
                  end;
              remaining := remaining - NoOfRecs;
              BufferPtr := 1
            end;
        getc := Buffer[BufferPtr];
        BufferPtr := succ(BufferPtr)
      end;

    function getw: integer;
    { Get a 16 bit value from the input buffer }
      begin
        getw := getc + Swap(getc)
      end;

    procedure BuildTree;
    { Build decode tree }
      var
        i, CheckSum, numnodes: integer;
      begin
        ErrMsg := '';
        if recognize = getw                 { Is it really a squeezed file? }
          then
            begin
              CheckSum := getw;             { Get checksum }
              XfrName := '';
              i := getc;                    { Build original file name }
              while i <> 0 do
                begin
                  XfrName := XfrName + UpCase(chr(i));
                  i := getc
                end;
              numnodes := getw;             { Get the number of nodes in tree }
              if (0 < numnodes) and (numnodes <= 256)
                then for i := 0 to pred(numnodes) do
                  begin
                    dnode[i, 0] := getw;
                    dnode[i, 1] := getw;
                  end
                else
                  begin
                    ErrMsg := 'Invalid decode tree size.';
                    squeezed := FALSE
                  end
            end
          else squeezed := FALSE
      end;

    function gethuff: integer;
    { Get character coding }
      var
        i: integer;
      begin
        i := 0;
        repeat
          bpos := succ(bpos);
          if bpos > 7
            then
              begin
                curin := getc;
                bpos := 0
              end
            else curin := curin shr 1;
          i := dnode[i, curin and $0001]
        until i < 0;
        i := -succ(i);
        if i = 0
          then gethuff := 26
          else gethuff := i
      end;

    function getcr: integer;
      var
        c: integer;
      begin
        if repct > 0
          then
            begin
              repct := pred(repct);
              getcr := lastc
            end
          else
            begin
              c := gethuff;
              if c = DLE
                then
                  begin
                    repct := gethuff;
                    if repct = 0
                      then getcr := DLE
                      else
                        begin
                          repct := repct - 2;
                          getcr := lastc
                        end
                  end
                else
                  begin
                    getcr := c;
                    lastc := c
                  end
            end
      end;

    begin { SendFile }
      connected:=online;
      if (not connected) then setsect(SetName)
      else
        begin
          i := pos('.', XfrName);
          if i = 0
            then FileType := ''
            else FileType := copy(XfrName, succ(i), length(XfrName));
          squeezed := ('Q' = FileType[2]);
          repct := 0;
          bpos := 8;
          ErrMsg := '';
          BufferPtr := MaxInt;                  { Force a read the first time }
          EndOfFile := FALSE;
          if remaining > 0
            then
              begin
                if squeezed
                  then BuildTree;
                i := pos('.', XfrName);
                if 0 = i
                  then FileType := ''
                  else FileType := copy(XfrName, succ(i), length(XfrName));
                if (FileType = 'COM') or (FileType = 'OBJ') or (FileType[2]='Z') or
                   (FileType = 'EXE') or (FileType = 'LBR') or (FileType='ARC')
                  then ErrMsg := 'Xmodem protocol required for ".' + FileType + '" files.';
                if ErrMsg = ''
                  then
                    begin
                      page:=ask('Do you want page breaks');
                      line_count := 0;
                      if squeezed
                        then
                          begin
                            writeln(USR, '      ---> ', XfrName);
                            x := getcr
                          end
                        else x := getc;
                      while (not brk) and (not EndOfFile) and (x <> 26) do
                        begin
                          write(USR, chr(x));
                          if (user_rec.lines <> 99) and (chr(x) = LF) and (page)
                            then
                              begin
                                line_count := succ(line_count);
                                if line_count mod user_rec.lines = 0
                                  then pause
                              end;
                          if squeezed
                            then x := getcr
                            else x := getc
                        end
                    end
              end
            else ErrMsg := 'Missing or empty input file.';
          if ErrMsg <> ''
            then writeln(USR, ErrMsg)
        end;
    end;

  begin { SendText }
    if in_arc then writeln(usr,'Unable to Type Arc file members.')
    else
    begin
    XfrName := correct_fn(prompt('File name', 12, 'ES'));
    if XfrName <> ''
      then
        begin
          if in_library
            then this := LibBase
            else this := DirBase;
          while (this <> nil) and (XfrName <> compress_fn(this^.fname)) do
            this := this^.next;
          if this <> nil
            then
              begin
                setsect(HomName);
                log(6, XfrName);
                SetSect(SetName);
                if in_library
                  then
                    begin
                      {$I-} seek(libr_file, this^.index) {$I+};
                      if IOresult = 0
                        then SendFile(libr_file, this^.fsize)
                    end
                  else
                    begin
                      Assign(XfrFile, XfrName);
                      Reset(XfrFile);
                      SendFile(XfrFile, FileSize(XfrFile));
                      Close(XfrFile)
                    end;
                SetSect(HomName);
                log(7, '')
              end
            else writeln(USR, XfrName, ' not found.')
        end;
    end;
  end;

{end of PPC2C.inc}
