{PPC2B.INC}
{ PICSPC  Pascal Integrated Communications System module}
{ 5/31/87 IBM PC VERS 5.0 Copyright 1987 by les archambault}

overlay procedure toggle_st_switch;
{ Toggle file size display }
  begin
    writeln(USR);
    st_switch := not st_switch;
    write(USR, 'File sizes will be shown in ');
    if st_switch
      then writeln(USR, 'bytes, where "k" is 1024.')
      else writeln(USR, 'minutes and seconds of transfer time.')
  end;

overlay procedure newin_list;
{ List new uploads }
  var
    i, line_count,conf_num: integer;
    str: StrTAD;
    temp_user_rec: user_list;
    this:sectptr;
    pages,none_found:boolean;
    Fname,work:filename;

  begin
    fname:='';  none_found:=true;
    if ask('Search for file(s)') then
      begin
        fname:=prompt('Filename (wildcards ok) ',12,'ES');
        if fname<>' ' then fname:=expand_filename(fname)
        else fname:='';
      end;
    pages:=ask('Do you want page breaks');
    line_count := 0;
    i := pred(FileSize(nwin_file));
    while (not brk) and (i >= 0) do
      begin
        seek(nwin_file, i);
        read(nwin_file, nwin_rec);
        this:=sectbase;
        with nwin_rec do
          begin
            if status = public
              then
                begin
                  while (this<>nil) and (this^.sectname<>sectn) do
                    this:=this^.next;
                  conf_num:=this^.sectconf;
                  if ((user_rec.access>=this^.sectaccs) or (test_bit(user_rec.conf_flags,conf_num))) and
                  ((sectn=sectreq) or (sectreq='NEWIN') or (sectreq='SYSTEM')) then
                    begin
                      work:=expand_filename(name);
                      if (fname='') or (equal_names(fname,work)) then
                        begin
                          none_found:=false;
                          str := intstr(date[4],2)+'/'+intstr(date[3],2)+'/'+intstr(date[5],2);
                          if (user>0) and (user<=FileLen(DatF)) then
                            begin
                              GetRec(DatF, user, temp_user_rec);
                              if temp_user_rec.used<>0 then
                                begin
                                  temp_user_rec.fn:='';
                                  temp_user_rec.ln:='';
                                end;
                            end
                          else
                            begin
                              temp_user_rec.fn:='Unknown';
                              temp_user_rec.ln:='Sender';
                            end;

                          writeln(USR);
                          write(USR, pad(name, 15),sectn,' Section ', str,'  ');
                          writeln(usr,temp_user_rec.fn, ' ', temp_user_rec.ln);
                          str := intstr(last_dnload[4],2)+'/'+intstr(last_dnload[3],2)+'/'+intstr(last_dnload[5],2);
                          writeln(usr,'Downloads ',dnloads,'  Last download ',str);
                          writeln(usr,'    ',descr);
                          if (user_rec.lines <> 99) and pages
                            then
                              begin
                                line_count := succ(line_count);
                                if line_count mod (user_rec.lines div 4) = 0
                                then pause;
                              end;
                        end; {fname='' or equal names}
                    end;   {print out}
                end;
          end;
        i := pred(i);
      end;
    if (none_found) and (filesize(nwin_file)>0) then
      begin
        writeln(usr);
        write(usr,'No File(s) found in Newin list');
        if (sectreq<>'NEWIN') and (sectreq<>'SYSTEM') then
          begin
            writeln(usr,' for this file area.');
            writeln(usr,'NEWIN file area lists ALL available files.');
          end
        else writeln(usr,'.');
        writeln(usr);
      end;
    if filesize(nwin_file)=0 then
      begin
        writeln(usr);
        writeln(usr,'Newin List is empty.');
        writeln(usr);
      end;
  end;

overlay procedure file_area_change(req: filename);
{ View and set up file area for use }
  const
    col_width = 14;
  var
    col_count, col_limit, conf_num,line_count: integer;
    Drive:Str3;
    this: SectPtr;
    pr: StrPr;
    DirName:FileName;
    SameSect:boolean;

  begin   {file area change}
    SameSect:=False;
    col_limit := max(1, user_rec.columns div col_width);
    if req = ''
      then
        begin
          pr := 'File area';
          req := prompt(pr, 12, 'ES?M');
          if req=' ' then
            begin
              req:=SectReq;  {default to current setting}
              SameSect:=true;
            end
          else
            SameSect:=false;
        end;
    while (not new_dir) and (online) and (not SameSect) do
      begin
        this := SectBase;
        if req = '?' then
            begin
              writeln(USR, 'Available file areas:');
              writeln(USR);
              line_count:=2;
              while (not brk) and (this <> nil) do
                begin
                  conf_num:=this^.SectConf;
                  if (user_rec.access >= this^.SectAccs)
                  or (test_bit(user_rec.conf_flags,conf_num))
                    then writeln(USR, pad(this^.SectName, 14), this^.SectDesc);
                  this := this^.next;
                  if user_rec.lines <> 99 then
                    begin
                      line_count := succ(line_count);
                      if line_count mod user_rec.lines = 0 then pause;
                    end;
                end;
              writeln(USR);
              req := prompt(pr, 12, 'ES?');
              if req=' ' then req:=SectReq;
            end
        else if req <> ''
          then
            begin
              FindSect(req, Drive, OK);
              if OK
                then
                  begin
                    SectReq := req;
                    SetDrv  := Drive;
                    if (req='SYSTEM') and (HomName[1]=Drive[1]) then SetName:=HomName
                     else
                       begin
                         SetName:=Drive;
                         if (length(HomName)>3) and (Drive=HomDrv) then
                           begin
                             SetName:=SetName+copy(HomName,4,length(HomName));
                             SetName:=SetName+'\';
                           end;
                         if pos(':',req)=2 then SetName:=Setname+copy(req,3,length(req))
                         else SetName:=SetName+req;
                       end;
                    ReadDir(DirEntries, DirSpace, DirBase);
                  end
                else
                  begin
                    writeln(USR, '"', req, '" not found.  Available file areas:');
                    writeln(USR);
                    col_count := 0;
                    this := SectBase;
                    while (not brk) and (this <> nil) do
                      begin
                        conf_num:=this^.SectConf;
                        if (user_rec.access >= this^.SectAccs)
                        or (test_bit(user_rec.conf_flags,conf_num))
                          then
                            begin
                              write(USR, pad(this^.SectName, col_width));
                              col_count := succ(col_count);
                              if 0 = col_count mod col_limit
                                then writeln(USR)
                            end;
                        this := this^.next
                      end;
                    if 0 <> col_count mod col_limit
                      then writeln(USR);
                    writeln(USR);
                    req := prompt(pr, 12, 'ES?');
                    if req=' ' then req:=SectReq;
                  end
            end
      end
  end;

overlay procedure library;
{ Open and close a library }
  var
    i: integer;
    this: FilePtr;
  begin { library }
    if in_library
      then
        begin
          SetSect(SetName);          { Close file }
          Close(libr_file);
          SetSect(HomName);
          while LibBase <> nil do           { Clean out old list }
            begin
              this := LibBase;
              LibBase := LibBase^.Next;     { Go to next on chain }
              dispose(this)                 { Reclaim space }
            end;
          in_library := FALSE;
          writeln(USR, 'Library ', LibReq, ' closed.')
        end
      else
        begin
          LibReq := prompt('Library', 12, 'ES');
          delete(LibReq, 1, pos(':', LibReq));
          if LibReq <> ''
            then
              begin
                if pos('.', LibReq) = 0
                  then LibReq := LibReq + '.LBR';
                if copy(LibReq, succ(pos('.', LibReq)), 3) = 'LBR'
                  then LibReadDir(LibEntries, LibSpace, LibBase);
                if not in_library
                  then writeln(USR, 'Cannot open ', LibReq, '.')
              end
        end
  end;

overlay procedure Arc;
{ Open and close an Arc File }
  var
    i: integer;
    this: FilePtr;
  begin { Arc }
    if in_arc
      then
        begin
          SetSect(SetName);          { Close file }
          Close(Arc_file);
          SetSect(HomName);
          while ArcBase <> nil do           { Clean out old list }
            begin
              this := ArcBase;
              ArcBase := ArcBase^.Next;     { Go to next on chain }
              dispose(this)                 { Reclaim space }
            end;
          in_arc := FALSE;
          writeln(USR, 'Arc File ', ArcReq, ' closed.')
        end
      else
        begin
          ArcReq := prompt('Arc File', 12, 'ES');
          delete(ArcReq, 1, pos(':', ArcReq));
          if ArcReq <> ''
            then
              begin
                if pos('.', ArcReq) = 0
                  then ArcReq := ArcReq + '.ARC';
                if copy(ArcReq, succ(pos('.', ArcReq)), 3) = 'ARC'
                  then ArcReadDir(ArcEntries, ArcSpace, ArcBase);
                if not in_Arc
                  then writeln(USR, 'Cannot open ', ArcReq, '.')
              end
        end
  end;

overlay procedure directory;
{ Display file area or library directory }
  const
    col_width = 19;
  var
    i, j, k, entries, rows, mm, ss, size, col_count, col_limit, line_count: integer;
    this: FilePtr;
    nodes: array[1..4] of FilePtr;
    st: Str10;
    fn: FileName;
  begin
    col_limit := max(1, user_rec.columns div col_width);
    writeln(USR);
    new_dir := FALSE;
    if in_library
      then
        begin
          this := LibBase;
          entries := LibEntries;
          if entries = 0
            then writeln(USR, '   Library: ', LibReq, ' is empty.')
            else writeln(USR, '   Library: ', LibReq, '   Files: ', entries,
                 '   Space used: ', LibSpace, 'k')
        end
      else
        if in_arc then
          begin
            this:=ArcBase;
            entries:=ArcEntries;
            if entries=0 then
              writeln(USR, '   Arc File: ', ArcReq, ' is empty.')
            else writeln(USR, '   Arc File: ', ArcReq, '   Files: ', entries,
                 '   Space used: ', ArcSpace, 'k')
          end
      else
        begin
          this := DirBase;
          entries := DirEntries;
          if entries = 0
            then writeln(USR, '   File area: ', SectReq, ' is empty.')
            else write(USR, '   File area: ', SectReq, '   Files: ', entries,
                 '   Space used: ', DirSpace, 'k');
          if user_rec.access >= 250
            then writeln(USR, '   Free: ', free_space, 'k')
            else writeln(USR)
        end;
    line_count := 2;
    if entries > 0
      then
        begin
          rows := entries div col_limit;
          if 0 <> entries mod col_limit
            then rows := succ(rows);
          nodes[1] := this;
          for i := 2 to col_limit do
            begin
              for j := 1 to rows do
                this := this^.next;
              nodes[i] := this
            end;
          i := 1;
          while (not brk) and (i <= rows) do
            begin
              for j := 1 to col_limit do
                begin
                  this := nodes[j];
                  if (i + rows * pred(j)) <= entries
                    then
                      begin
                        if st_switch
                          then
                            begin
                              size := this^.fsize shr 3;
                              if (this^.fsize mod 8) <> 0
                                then size := succ(size);
                              st := intstr(size, 4) + 'k '
                            end
                          else
                            begin
                              send_time(this^.fsize, mm, ss);
                              st := intstr(mm, 3) + ':' + intstr(ss, 2);
                              for k := 3 to length(st) do
                                if st[k] = ' '
                                  then st[k] := '0'
                            end;
                        fn := this^.fname;
                        if test_bit(this^.attrib,1) then
                           fn[9] := '*'; { Indicate $SYS file }
                        write(USR, fn, st);
                        if j < col_limit
                          then write(USR, fence, ' ')
                          else writeln(USR)
                      end
                    else writeln(USR);
                  nodes[j] := nodes[j]^.next   { Go to next on list }
                end;
              if user_rec.lines <> 99
                then
                  begin
                    line_count := succ(line_count);
                    if line_count mod user_rec.lines = 0
                      then pause
                  end;
              i := succ(i)
            end
        end;
    if j <> col_limit
      then writeln(USR)
  end;

Overlay Procedure Find_Files;
{ searches all sections for a file and expands wildcards}
  type
    dtarecord = record
        filler:array[0..21] of byte;
        fileattrib:byte;
        time1,time2:byte;
        date1,date2:byte;
        size1,size2:integer;
        end;

var  this:sectptr;
     i,j,off,line_count:integer;
     filname:filename;
     abort:boolean;
     dirspec:strpr;
     dta:string[44];
     dtarec:dtarecord absolute dta;
     regs:regpack;
     mask:strpr;

begin  {findfiles}
  this:=sectbase; line_count:=0;
  writeln(usr); abort:=false;
  Mask:=prompt('Filename (wildcards ok) ',12,'ES');
  if mask<>'' then
    begin
      while pos(':',mask)>0 do delete(mask,pos(':',mask),1);
      while pos('\',mask)>0 do delete(mask,pos('\',mask),1);
    end;
  if Mask<>'' then
    begin
      mask:=mask+chr(0);
      while (this<>nil) and (not abort) do
        begin
          if (this^.sectaccs<=user_rec.access) or (not remote_copy) then
            begin
              if this^.sectname='SYSTEM' then Dirspec:=Homname
              else
                begin
                  dirspec:=this^.sectdrive+':\';
                  if (length(Homname)>3) and (dirspec=Homdrv) then
                    begin
                      dirspec:=dirspec+copy(HomName,4,length(HomName));
                      dirspec:=dirspec+'\';
                    end;
                  if pos(':',this^.sectname)=2 then
                     dirspec:=dirspec+copy(this^.sectname,3,length(this^.sectname))
                  else dirspec:=dirspec+this^.sectname;
                end;
              setsect(dirspec);
              filname:='';
              fillchar(dta[1],44,#32); dta[0]:=#44;
              with regs do
                begin
                  ax:=$1a00;    {set up disk transfer area}
                  ds:=seg(dta); dx:=ofs(dta)+1;
                  msdos(regs);
                  ax:=$4e00;    {read first}
                  ds:=seg(mask); dx:=ofs(mask)+1;
                  if (user_rec.access>=250) or (not remote_copy) then
                    cx:=39
                    else cx:=33;
                  msdos(regs);
                  if (flags and 1)=0 then
                    begin
                      filname:=copy(dta,31,12);
                      if pos(chr(0),filname)>0 then delete(filname,pos(chr(0),filname),1);
                      if ((filname[1]<>'.') and (filname[1]<>' ')
                      and (not test_bit(dtarec.fileattrib,1))) or (not remote_copy)
                      or (user_rec.access>=250) then
                        begin
                          write(usr,pad(filname,15),'Location:  ',this^.sectname);
                          if (user_rec.access>=250) and (test_bit(dtarec.fileattrib,1))
                            then writeln(usr,'...Hidden.')
                            else writeln(usr);
                          line_count:=2;
                        end;
                      repeat
                        if brk then abort:=true;
                        fillchar(dta[31],14,' ');
                        ax:=$4f00;  {search next}
                        msdos(regs);
                        if (ax<>18) and (ax<>2) then
                          begin
                            filname:=copy(dta,31,12);
                            if pos(chr(0),filname)>0 then delete(filname,pos(chr(0),filname),1);
                            if ((filname[1]<>'.') and (filname[1]<>' ')
                            and (not test_bit(dtarec.fileattrib,1))) or (not remote_copy)
                            or (user_rec.access>=250) then
                              begin
                                write(usr,pad(filname,15),'Location:  ',this^.sectname);
                                if (user_rec.access>=250) and (test_bit(dtarec.fileattrib,1))
                                  then writeln(usr,'...Hidden.')
                                  else writeln(usr);
                                if user_rec.lines <> 99 then
                                  begin
                                    line_count := succ(line_count);
                                    if line_count mod user_rec.lines = 0 then pause;
                                  end;
                              end;
                          end;
                      until (flags and 1)<>0;
                    end;
                end;
            end;   {access allowed}
          this:=this^.next; {point to next section}
        end;  {searching sections}
      if line_count<1 then writeln(usr,'File(s) Not Found.');
      setsect(HomName);
      writeln(usr);
    end;  {mask<>''}
end;


{end of PPC2B.INC}
