{PPC0F.INC  Pascal Integrated Communications System Overlays}
{ 5/31/87 IBM PC Version 5.0 Copyright 1987 by Les Archambault}

overlay procedure Send_name(name_buf:Record_array;var ok_to_send:boolean);
    const
      maxerr = 10;
    var
      timeout: boolean;
      bt,row,col: byte;
      ch: char;
      i, vv, block, errcnt: integer;
    begin
      errcnt := 0;
      block := 0;
      col:=wherex;
      row:=wherey;
      window(1,1,80,10);
      gotoxy(1,1);
      for i:=1 to 10 do
        begin
          gotoxy(1,i);
          clreol;
        end;
      for i:=1 to 75 do write('-');
      gotoxy(1,1);
      writeln; writeln('        Sending Batch Filename'); writeln;
      repeat
        bt := GetByte(10, timeout);
        if timeout then errcnt:=succ(errcnt);
        if bt=ord(CAN) then errcnt:=maxerr;
        if (not online) then errcnt:=maxerr;
      until (errcnt>=maxerr) or (bt=ord('C'));
      if errcnt<maxerr then
        begin
          errcnt:=0;
          repeat
            vv := 0;
            for i := 1 to 128 do updcrc(vv, name_buf[i]);
            updcrc(vv, 0);
            updcrc(vv, 0);
            PutByte(ord(SOH));
            PutByte(lo(block));
            PutByte(not lo(block));
            for i := 1 to 128 do PutByte(name_buf[i]);
            PutByte(hi(vv));
            PutByte(lo(vv));
            repeat
              bt := GetByte(12, timeout);
              if bt=ord(ACK) then errcnt:=0;
              if (timeout) or (bt=ord(NAK)) then
                begin
                  errcnt:=succ(errcnt);
                  clear_inbuf;
                end;
              if timeout then Writeln(' ++ Timeout - Error ',errcnt,' ++');
              if bt=ord(NAK) then Writeln(' ++ NAK received - Error ',errcnt,' ++');
              if bt=ord(CAN) then errcnt:=maxerr;
              if (not online) then errcnt:=maxerr;
            until (bt in [ord(NAK),ord(ACK),ord(CAN)]) or timeout;
          until (errcnt=0) or (errcnt>=maxerr);
          if errcnt>=maxerr then ok_to_send:=false;
        end
      else
        begin
          ok_to_send:=false;
          Writeln(' ++ Timeout receiving header ACK... Aborting.');
        end;
      window(1,1,80,25);
      gotoxy(col,row);
    end;

Overlay Procedure Get_description(XfrName:filename);
  var  work:strstd;
       i:integer;

Function get_section(mode:char):filename;
   var
     this:sectptr;
     line_count,conf_num:integer;
     work:filename;

     begin
       repeat
       this:=sectbase; writeln(usr);
       work:=prompt('Section name ',12,'ES?M');
       if work=' ' then
         begin
           work:='NEWIN';  {DEFAULT VALUE}
           writeln(usr,'Defaulting to: NEWIN');
           Writeln(usr);
         end;
       if work='?' then
         begin
           line_count:=2;
           writeln(usr,'Available File Area Sections:');
           writeln(usr);
           while (not brk) and (this<>nil) do
             begin
               conf_num:=this^.sectconf;
               if (user_rec.access>=this^.sectaccs)
               or (test_bit(user_rec.conf_flags,conf_num)) then
                 begin
                   write(usr,pad(this^.sectname,14));
                   if mode='D' then writeln(usr,this^.sectdesc)
                    else writeln(usr);
                 end;
               this:=this^.next;
               if user_rec.lines <> 99 then
                  begin
                    line_count := succ(line_count);
                    if line_count mod user_rec.lines = 0 then pause;
                  end;
             end;
           writeln(usr);
         end;
       this:=sectbase;
       while (this<>nil) and (this^.sectname<>work) do
       this:=this^.next;
       until (work=this^.sectname) or (brk) or (not online);
       if work=this^.sectname then get_section:=work
       else get_section:='NEWIN';
     end;

  begin {get_description}
   repeat
    writeln(USR, 'Please enter a one line description of your file:');
    writeln(USR);
    writeln(USR, '  |-------------------------------------------------------------------------|');
    work:=prompt('',75,'EL');
    writeln(usr);
   until ((work<>'') and (Ask('Is your description correct'))) or (not online);
   Writeln(usr,' Enter Section Name where the file should be located.');
    with nwin_rec do
      begin
        status := private;
        name := XfrName;
        GetTAD(date);
        user := user_loc;
        descr := work;
        sectn:=get_section('D');
        dnloads:=0;
        for i:=0 to 5 do last_dnload[i]:=0;
      end;
    seek(nwin_file, FileSize(nwin_file));
    write(nwin_file, nwin_rec);
  end;

Overlay Procedure List_file(Fname:filename;dirspec:strpr);
   var work:strstd;
       Tfile:text;
       ln_count:integer;
   begin
     setsect(dirspec);
     Assign(Tfile,Fname);
     {$I-} Reset(Tfile); {$I+}
     if ioresult=0 then
       begin
         ln_count:=1;
         while (not eof(Tfile)) and (online) and (not brk) do
           begin
             readln(Tfile,work);
             Writeln(usr,work);
             if (user_rec.lines<>99) and (not nonstop) then
               begin
                 ln_count:=succ(ln_count);
                 if ln_count mod user_rec.lines=0 then pause;
               end;
           end;
       end
       else writeln(usr,'File not available.');
     close(Tfile);
     setsect(homname);
   end;

{end of PPC0F.INC}
