  { PPC0E.INC Pascal Integrated Communications System Overlays }
  { 5/31/87 IBM PC Version 5.0 Copyright 1987 by Les Archambault}

  Overlay procedure RecvFile(var xfrname:filename;var xfrfile:untype_file;
                     var block:integer;mode:char;var Abort_batch:boolean);
    const
      maxerr=10;
      start_err=25;

    var
      CRCmode,timeout,EndOfFile,write_err,KMDmode,firstime: boolean;
      row,col,cancel,bt,blocknum,blockcpl: byte;
      ch: char;
      errcnt,recs,i,mv,vv,mm,ss: integer;
      file_buf:buf_ptr;

    Begin
      New(file_buf);
      SetSect(RcvName);
      OK := FALSE; firstime:=true;
      EndOfFile := FALSE;
      CRCmode := TRUE;
      KMDmode:=false;
      cancel:=0;
      errcnt := 0;
      recs:=1;
      col:=wherex;
      row:=wherey;
      gotoxy(1,11);
      for i:=1 to 79 do write('-');
      window(1,1,80,10);
      gotoxy(1,1);
      for i:=1 to 10 do
        begin
          gotoxy(1,i);
          clreol;
        end;
      gotoxy(1,1);
      writeln;
      if mode='B' then writeln('              Receiving Batch Transfer')
      else
      writeln('              Receiving Xmodem File');
      writeln;
      if mode='B' then
        begin
          writeln('File: ',xfrname);
          if file_recs>0 then
            begin
              send_time(file_recs,mm,ss);
              st:=intstr(mm,3)+':'+intstr(ss,2);
              writeln('Contains ',file_recs,' records / ',file_recs div 8,' 1k blocks.');
              writeln('Total Receive time ',mm,' minutes ',ss,' secs. at ',rate,' baud');
            end;
        end;
      writeln;
      if (mode='K') or (mode='B') then KMDmode:=true;
      clear_inbuf;
      repeat
        bt := (GetByte(4,timeout) and $7F);
        if timeout then
            begin
              errcnt := succ(errcnt);
              if (errcnt > 5) and (mode<>'B') then
                begin
                  CRCmode := not CRCmode;
                  if errcnt=5 then Writeln('Switching to Checksum');
                end;
              if CRCmode then
                begin
                  PutByte(ord('C'));
                  if not KMDmode then PutByte(ord('K'));
                end
              else PutByte(ord(NAK));
            end
        else
          begin
            if bt=ord(CAN) then cancel:=succ(cancel)
            else if cancel>0 then cancel:=0;
            if cancel>=2 then errcnt:=start_err;
          end;
        if (not ch_carck) then
          begin
            setsect(HomName);
            log(12,'Rcv xmdm');
            setsect(RcvName);  {reset to proper directory}
            errcnt:=start_err;
            mdhangup;
            remote_online:=false;
          end;
      { SOH and EOT must be solicited to be valid, but CAN may be sent anytime }
      until ((errcnt>0) and (bt in [ord(SOH), ord(EOT),ord(STX)])) or (errcnt >= start_err);
      cancel:=0;
      if errcnt >= start_err then errcnt:=maxerr else errcnt := 0;
      while (not EndOfFile) and (errcnt<maxerr) do
        begin
          case chr(bt) of
            SOH: begin
                   blocknum := GetByte(5, timeout);
                   blockcpl := not GetByte(2, timeout);
                   for i := 1 to 128 do
                     file_buf^[i] := GetByte(2, timeout);
                   mv := GetByte(2, timeout);
                   if CRCmode
                     then mv := swap(mv) or GetByte(2, timeout);
                   OK := (blocknum = blockcpl);
                   if cancel>0 then cancel:=0;
                   if OK then
                     begin
                       OK := (blocknum = lo(block));
                       if OK then
                         begin
                           vv := 0;
                           if CRCmode then
                              begin
                                for i := 1 to 128 do
                                updcrc(vv, file_buf^[i]);
                                updcrc(vv, 0);
                                updcrc(vv, 0)
                              end
                           else
                             begin
                               for i := 1 to 128 do
                                 vv := vv + file_buf^[i];
                               vv := lo(vv)
                             end;
                           OK := (mv = vv);
                           write_err:=false;
                           if OK then
                             begin
                               {$I-} blockwrite(XfrFile, file_buf^, 1) {$I+};
                               write_err:=(IOresult<>0);
                               if write_err then
                                 begin
                                   ok:=false;
                                   write('  ++ Disk or directory full');
                                 end;
                             end
                           else if CRCmode then write('  ++ CRC ')
                           else write('  ++ Checksum ')
                         end
                       else
                         begin
                           OK := (blocknum = lo(pred(block)));
                           if not OK then
                             write('  ++ Block number');
                         end
                     end
                   else write('  ++ Block complement mismatch');
                   ch := GetChar;           { Monitor local console }
                   if OK
                     then
                       begin
                         if (block = 1) and firstime then
                           begin
                             firstime:=false;
                             if CRCmode then writeln('CRC mode selected.')
                               else writeln('Checksum mode selected.');
                           end;
                         write(CR); clrEol;
                         write('Received Record: ', recs);
                         recs:=succ(recs);
                         block:=succ(block) mod 256;
                         errcnt := 0;
                         putbyte(ord(ACK));
                       end
                     else
                       begin
                         if cancel>0 then cancel:=pred(cancel);
                         errcnt := succ(errcnt);
                         writeln(' - error ', errcnt, ' ++');
                         if write_err
                           then
                             begin
                               errcnt := maxerr;
                               repeat bt:=getbyte(1,timeout) until timeout;
                               putbyte(ord(CAN));
                               putbyte(ord(CAN));
                             end
                           else
                             begin
                               clear_inbuf;
                               repeat bt:=GetByte(1,timeout) until timeout;
                               putbyte(ord(NAK));
                             end;
                       end;
                 end;
            STX: begin
                   blocknum := GetByte(5, timeout);
                   blockcpl := not GetByte(2, timeout);
                   for i := 1 to 1024 do
                      file_buf^[i] := GetByte(2, timeout);
                   mv := GetByte(2, timeout);
                   if CRCmode
                     then mv := swap(mv) or GetByte(2, timeout);
                   if cancel>0 then cancel:=0;
                   OK := (blocknum = blockcpl);
                   if OK then
                     begin
                       OK := (blocknum = lo(block));
                       if OK then
                         begin
                           vv := 0;
                           if CRCmode then
                              begin
                                for i := 1 to 1024 do
                                updcrc(vv, file_buf^[i]);
                                updcrc(vv, 0);
                                updcrc(vv, 0);
                              end
                           else
                             begin
                               for i := 1 to 1024 do
                                 vv := vv + file_buf^[i];
                               vv := lo(vv)
                             end;
                           OK := (mv = vv);
                           write_err:=false;
                           if OK then
                             begin
                               {$I-} blockwrite(XfrFile, file_buf^, 8) {$I+};
                               write_err := (IOresult<>0);
                               if write_err then
                                 begin
                                   OK:=false;
                                   write('  ++ Disk or directory full');
                                 end;
                             end
                           else if CRCmode then write('  ++ CRC ')
                           else write('  ++ Checksum ')
                         end
                       else
                         begin
                           OK := (blocknum = lo(pred(block)));
                           if not OK then
                             write('  ++ Block number');
                         end
                     end
                   else write('  ++ Block complement mismatch');
                   ch := GetChar;           { Monitor local console }
                   if OK
                     then
                       begin
                         if (block = 1) and firstime then
                           begin
                             firstime:=false;
                             if CRCmode then writeln('CRC mode selected.')
                               else writeln('Checksum mode selected.');
                           end;
                         write(CR); clrEol;
                         write('Received 1K Block: ',recs);
                         recs:=succ(recs);
                         block:=succ(block) mod 256;
                         errcnt := 0;
                         putbyte(ord(ACK));
                       end
                     else
                       begin
                         errcnt := succ(errcnt);
                         writeln(' - error ', errcnt, ' ++');
                         if write_err
                           then
                             begin
                               errcnt := maxerr;
                               repeat bt:=getbyte(1,timeout) until timeout;
                               putbyte(ord(CAN));
                               putbyte(ord(CAN));
                             end
                           else
                             begin
                               clear_inbuf;
                               repeat bt:=Getbyte(1,timeout) until timeout;
                               putbyte(ord(NAK));
                             end;
                       end;
                 end;

            EOT: begin
                   EndOfFile := TRUE;
                   clear_inbuf;
                   putbyte(ord(ACK));
                 end;
            CAN: begin
                   cancel:=succ(cancel);
                   if cancel>=2 then
                     begin
                       OK := FALSE;
                       errcnt := maxerr;
                       writeln;
                       writeln('Sender Cancelled');
                       setsect(HomName);
                       log(14,'by Sender');
                       setsect(RcvName);
                       clear_inbuf;
                     end;
                 end;
            else begin
                   OK := FALSE;
                   if timeout then write('  ++ Timeout')
                     else  write('  ++ Received ', bt, ', not SOH');
                   errcnt := succ(errcnt);
                   writeln(' - error ', errcnt, ' ++');
                   if cancel>0 then cancel:=0;
                   if not timeout then clear_inbuf;
                   repeat bt:=Getbyte(1,timeout) until timeout;
                   putbyte(ord(NAK));
                 end;
          end;  {case}
        if (not ch_carck) then
            begin
              errcnt:=maxerr;
              setsect(homname);
              log(12,'Rcv xmdm');
              setsect(RcvName);
              mdhangup;
              remote_online:=false;
            end;
        if (not endoffile) and (errcnt<maxerr) then
          bt:=(getbyte(10,timeout) and $7F);  {get next SOH etc}
      end;   {while}
    window(1,1,80,25);
    gotoxy(col,row);
    if (mode='B') and (errcnt>=maxerr) then abort_batch:=true;
    if (errcnt>=maxerr) and (not ok) then
      begin
        repeat bt:=getbyte(1,timeout) until timeout;
        putbyte(ord(CAN)); putbyte(ord(CAN));
      end;
    dispose(file_buf);
    if errcnt>=maxerr then
      begin
        clear_inbuf;
        repeat bt:=getbyte(1,timeout); until timeout;
      end;
  end;

  Overlay procedure Get_Filename(var xfrname:filename;var Fnames:Fname_array;
      var filecount:integer;var recs,size:integer;var Abort_batch:boolean);

    const
      maxerr=10;
      start_err=25;
    var
      timeout: boolean;
      row,col,bt,blocknum,blockcpl,cancel: byte;
      ch: char;
      errcnt,i,mv,vv,block: integer;
      buffer:record_array;
      temp:filename;
      char_count:real;

    begin
      OK := FALSE;
      cancel:=0;
      xfrname:='';
      errcnt := 0;
      col:=wherex;
      row:=wherey;
      gotoxy(1,11);
      for i:=1 to 79 do write('-');
      window(1,1,80,10);
      gotoxy(1,1);
      for i:=1 to 10 do
        begin
          gotoxy(1,i);
          clreol;
        end;
      gotoxy(1,1);
      writeln; writeln('            Getting Xmodem Batch Filename'); writeln;
      clear_inbuf;
      repeat
        bt := (GetByte(4, timeout) and $7F);
        if bt=ord(CAN) then cancel:=succ(cancel)
        else if cancel>0 then cancel:=0;
        if cancel>=2 then errcnt:=start_err;
        if timeout then
          begin
            errcnt:=succ(errcnt);
            PutByte(ord('C'));
          end;
        if (not ch_carck) then
          begin
            log(12,'Rcv xmdm');
            errcnt:=start_err;
            mdhangup;
            remote_online:=false;
          end;
      until(errcnt>0) and ((bt=ord(SOH)) or (errcnt >= start_err));
      if (errcnt >= start_err) or (not ch_carck) then errcnt := maxerr
        else errcnt := 0;
      cancel:=0;
      while (errcnt < maxerr) and (not OK) do
        begin
          case chr(bt) of
            SOH: begin
                   block:=0;
                   blocknum := GetByte(4, timeout);
                   blockcpl := not GetByte(1, timeout);
                   for i := 1 to 128 do
                     Buffer[i] := GetByte(1, timeout);
                   mv := GetByte(1, timeout);
                   mv := swap(mv) or GetByte(1, timeout);
                   if cancel>0 then cancel:=0;
                   OK := (blocknum = blockcpl);
                   if OK then
                      begin
                        OK := (blocknum = lo(block));
                        if OK then
                          begin
                            vv := 0;
                            for i := 1 to 128 do
                               updcrc(vv, Buffer[i]);
                            updcrc(vv, 0);
                            updcrc(vv, 0);
                            OK := (mv = vv);
                            if not OK then write('  ++ CRC ')
                          end
                        else
                          begin
                            OK := (blocknum = lo(pred(block)));
                            if not OK then
                              write('  ++ Block number');
                          end
                      end
                   else write('  ++ Block complement ');
                   ch := GetChar;
                   if OK
                     then
                       begin
                         filecount:=succ(filecount);
                         char_count:=0;
                         temp:=''; i:=0; st:=''; size:=0; recs:=0;
                         repeat            {get filename}
                           i:=succ(i);
                           if buffer[i]<>0 then temp:=temp+upcase(chr(buffer[i]));
                         until (buffer[i]=0) or (i=13);
                         if temp<>'' then
                           repeat           {get char count}
                             i:=succ(i);
                             if buffer[i]<>32 then st:=st+chr(buffer[i]);
                           until (buffer[i]=0) or (buffer[i]=32);
                         if st<>'' then for i:=1 to length(st) do
                         if (not (st[i] in ['0'..'9'])) then delete(st,i,1);
                         val(st,char_count,i);
                         if i<>0 then char_count:=0;
                         if (char_count=0) and ((buffer[127]>0) or (buffer[128]>0)) then
                           begin
                             recs:=(buffer[128] *256) + buffer[127];
                             size:=recs div 8;
                           end;
                         if char_count>0 then
                           begin
                             size:=trunc(char_count/1024);
                             if frac(char_count/1024)>0 then size:=succ(size);
                             recs:=trunc(char_count/128);
                             if frac(char_count/128)>0 then recs:=succ(recs);
                           end;
                         for i:=1 to length(temp) do
                           temp[i]:=chr(ord(temp[i]) and $7F);
                         xfrname:=temp;
                         fnames[filecount]:=xfrname;
                         putbyte(ord(ACK));
                       end
                     else
                       begin
                         errcnt := succ(errcnt);
                         writeln(' - error ', errcnt, ' ++');
                         clear_inbuf;
                         repeat bt:=getbyte(1,timeout) until timeout;
                         PutByte(ord(NAK));
                         bt:=(getbyte(10,timeout) and $7F);
                       end;
                 end;
            CAN: begin
                   cancel:=succ(cancel);
                   if cancel>=2 then
                     begin
                       OK := FALSE;
                       errcnt := maxerr;
                       writeln;
                       writeln('Canceled by Sender');
                     end;
                 end;
            else begin
                   OK := FALSE;
                   if timeout then write('  ++ Timeout')
                     else write('  ++ Received ', bt, ', not SOH');
                   errcnt := succ(errcnt);
                   writeln(' - error ', errcnt, ' ++');
                   if cancel>0 then cancel:=pred(cancel);
                   clear_inbuf;
                   if errcnt < maxerr then
                     begin
                       repeat bt:=getbyte(1,timeout) until timeout;
                       PutByte(ord(NAK));
                       bt:=(getbyte(10,timeout) and $7F);
                     end;
                 end;
          end;    {case}
          if (not ch_carck) then
            begin
              errcnt:=maxerr;
              log(12,'Rcv xmdm');
              mdhangup;
              remote_online:=false;
            end;
        end;  { while errcnt<maxerr  and not OK}
      if errcnt>=maxerr then
        begin
          abort_batch:=true;
          putbyte(ord(CAN));
          putbyte(ord(CAN));
          clear_inbuf;
        end;
      window(1,1,80,25);
      gotoxy(col,row);
    end;

{end of PPC0E.inc}
