{PPC0D.INC   Pascal Integrated Communications System Overlays}
{ 5/31/87 IBM PC Version 5.0 Copyright 1987 by Les Archambault}

overlay procedure SendFile(var xfrname:filename; var XfrFile:untype_file
                 ;remaining:integer;sendmode:char;var ok_to_send:boolean);
    const
      maxerr = 10;
    var
      CRCmode,KMDmode,timeout,firstime: boolean;
      bt,row,col,cancel: byte;
      ch: char;
      mm, ss, time_on, time_left, i, vv,recs,tot_errcnt,recs128,
      krecs,xrecs,block, errcnt,bufsize,bufblocks,result,kblocks: integer;
      arc_size:real;
      file_buf:buf_ptr;
      hdr_array:array[1..27] of byte absolute hdr;

    begin
      new(file_buf);
      cancel:=0;
      OK:=true; KMDmode:=false; firstime:=true;
      setsect(SetName);
      if sendmode<>'B' then
        begin
          timer(time_on, time_left);
          send_time(remaining, mm, ss);
          if mm > time_left then
            begin
              writeln(USR, 'Insufficient time remaining.');
              OK := FALSE
            end;
        end;
      if OK then
          begin
            errcnt := 0; tot_errcnt:=0; recs:=1;
            block := 1; xrecs:=0; krecs:=0;
            if sendmode<>'B' then
              begin
                writeln(USR, XfrName, ' contains ', remaining, ' records.');
                kblocks:=remaining div 8;
                if remaining mod 8 <>0 then kblocks:=succ(kblocks);
                for i:=1 to length(xfrname) do write(usr,' ');
                writeln(usr,'          ',kblocks,' 1K blocks.');
                writeln(USR, 'Send time: ', mm, ' minutes ',ss, ' seconds at ', rate, ' bps.');
                writeln(USR, 'To cancel, type several CTL-X.');
                if in_arc then
                  begin
                    writeln(usr);
                    writeln(usr,'Arc file members are sent compressed.');
                    writeln(usr,'Remember to name your file with .ARC suffix.');
                  end;
                writeln(USR, 'Ready to send...');
              end;
            col:=wherex;
            row:=wherey;
            gotoxy(1,11);
            for i:=1 to 79 do write('-');
            window(1,1,80,10);
            gotoxy(1,1);
            for i:=1 to 10 do
              begin
                gotoxy(1,i);
                clreol;
              end;
            gotoxy(1,1);
            writeln; writeln('               Xmodem Send'); writeln;
            if sendmode='B' then writeln('Sending; ',xfrname);
            writeln;
            if (sendmode='K') or (sendmode='B') then KMDmode:=true;
            repeat
              bt := (GetByte(10, timeout) and $7F);
              CRCmode := ((bt = ord('C')) or (bt=ord('c')));
              if CRCmode
                then
                  begin
                    if cancel>0 then cancel:=0;
                    bt:=(getbyte(1,timeout) and $7F);
                    if (sendmode<>'K') and (sendmode<>'B') then
                      KMDmode:=((bt=ord('K')) or (bt=ord('k')));
                    if KMDmode and (remaining>=8) then
                      begin
                        writeln('1K protocol');
                        bufblocks:=8;
                        bufsize:=1024;
                        krecs:=remaining div 8;
                        xrecs:=remaining mod 8;
                      end
                    else
                      begin
                        KMDmode:=false;
                        bufblocks:=1;
                        bufsize:=128;
                      end;
                    writeln('CRC mode.');
                    errcnt := 0
                  end
              else if bt = ord(NAK)
                then
                  begin
                    if cancel>0 then cancel:=0;
                    writeln('Checksum mode.');
                    errcnt := 0;
                    bufsize:=128;
                    bufblocks:=1;
                  end
              else if bt = ord(CAN) then
                begin
                  errcnt:=succ(errcnt);
                  cancel:=succ(cancel);
                  if cancel>=2 then errcnt := maxerr;
                  writeln;
                  writeln('Receiver Canceled.');
                  setsect(HomName);
                  log(14,'Receiver');
                  setsect(SetName);
                end
              else
                begin
                  if cancel>0 then cancel:=0;
                  errcnt := succ(errcnt);
                  clear_inbuf;
                end;
              if (not ch_carck) then
                begin
                  errcnt:=maxerr;
                  setsect(homname);
                  log(12,'sending xmdm');
                  setsect(SetName);
                  MdHangup;
                  remote_online:=false;
                end;
            until (errcnt = 0) or (errcnt >= maxerr);
            if KMDmode then remaining:=krecs;
            if in_arc then arc_size:=long_to_real(hdr.size)+29.0;
            while (remaining > 0) and (errcnt < maxerr) do
              begin
                if (not in_arc) then
                  blockread(XfrFile, file_buf^, bufblocks,result)
                else
                  begin
                    if (block=1) and firstime then
                      begin
                        firstime:=false;
                        file_buf^[1]:=26; {archive id byte}
                        file_buf^[2]:=hdrver;
                        for i:=1 to sizeof(heads) do file_buf^[i+2]:=hdr_array[i];
                        if arc_size>=bufsize-29 then
                          begin
                            for i:=30 to bufsize do file_buf^[i]:=get_arc_ch;
                            arc_size:=arc_size-bufsize;
                          end
                        else
                          begin
                            for i:=1 to trunc(arc_size) do file_buf^[i]:=get_arc_ch;
                            file_buf^[trunc(arc_size)+1]:=26;
                            file_buf^[trunc(arc_size)+2]:=0;
                          end;
                      end
                    else
                      begin
                        if arc_size>=bufsize then
                          begin
                            for i:=1 to bufsize do file_buf^[i]:=get_arc_ch;
                            arc_size:=arc_size-bufsize;
                          end
                        else
                          begin
                            for i:=1 to trunc(arc_size) do file_buf^[i]:=get_arc_ch;
                            file_buf^[trunc(arc_size)+1]:=26;
                            file_buf^[trunc(arc_size)+2]:=0;
                          end;
                      end;
                  end;
                remaining := pred(remaining);
                repeat
                  vv := 0;
                  if CRCmode
                    then
                      begin
                        for i := 1 to bufsize do
                          updcrc(vv, file_buf^[i]);
                        updcrc(vv, 0);
                        updcrc(vv, 0);
                      end
                    else for i := 1 to bufsize do
                           vv := vv + file_buf^[i];
                  if (KMDmode) and (bufsize>128) then
                  PutByte(ord(STX))
                  else
                  PutByte(ord(SOH));
                  PutByte(lo(block));
                  PutByte(not lo(block));
                  for i := 1 to bufsize do
                   PutByte(file_buf^[i]);
                  if CRCmode
                    then PutByte(hi(vv));
                  PutByte(lo(vv));
                  repeat
                    bt := (GetByte(10, timeout) and $7F);
                    if bt = ord(ACK)
                      then
                        begin
                          if cancel>0 then cancel:=0;
                          if (KMDmode) and (bufsize>128) then
                            begin
                              write(CR, 'Sent 1K block: ',recs);
                              recs:=succ(recs);
                            end
                          else
                            begin
                              if KMDmode then
                                begin
                                  write(cr);
                                  ClrEol;
                                end;
                              write(CR, 'Sent Record: ', recs);  { Local display of what is happening }
                              recs:=succ(recs);
                            end;
                          block := succ(block);
                          errcnt := 0;
                        end
                    else if (bt = ord(NAK)) or timeout
                      then
                        begin
                          if cancel>0 then cancel:=0;
                          if bt = ord(NAK)
                            then write('  ++ NAK received')
                          else if timeout
                            then write('  ++ Timeout');
                          errcnt := succ(errcnt);
                          tot_errcnt:=succ(tot_errcnt);
                          writeln(' - error ', errcnt, ' ++');
                          clear_inbuf;
                        end
                    else if bt = ord(CAN) then
                      begin
                        errcnt:=succ(errcnt);
                        cancel:=succ(cancel);
                        if cancel>=2 then errcnt := maxerr;
                        writeln;
                        writeln('Receiver Canceled');
                      end;
                    ch := GetChar;           { Monitor local console }
                    if (not ch_carck) then
                      begin
                        errcnt:=maxerr;
                        setsect(homName);
                        log(12,'sending xmdm');
                        setsect(SetName);
                        MdHangup;
                        remote_online:=false;
                      end;
                  until (bt in [ord(ACK), ord(NAK)]) or timeout
                    or (errcnt>=maxerr) or (not ch_carck);
                until (errcnt = 0) or (errcnt >= maxerr);
                If (KMDmode) and (bufsize>128) and (tot_errcnt<255)
                and (tot_errcnt>4) then
                  begin
                    recs128:=recs*8;
                    recs128:=recs128 div tot_errcnt;  {get ratio}
                    if ((rate=2400) and (recs128<43)) or
                       ((rate<=1200) and (recs128<71)) then
                      begin
                        xrecs:=(remaining * 8)+xrecs;
                        remaining:=0; {set up to change back to 128 bytes}
                        tot_errcnt:=255;  {prevent second use of this routine}
                      end;
                  end;
                if (KMDmode) and (remaining=0) and (xrecs>0) then
                  begin
                    bufblocks:=1;  {switch back to 128 block size}
                    bufsize:=128;
                    remaining:=xrecs;
                    xrecs:=0;
                  end;
              end;
            writeln;
            OK := (errcnt = 0);
            window(1,1,80,25);
            gotoxy(col,row);
            if OK
              then
                begin
                  repeat
                    PutByte(ord(EOT));
                    if ord(ACK) = (GetByte(10, timeout) and $7F)
                      then errcnt := 0
                    else errcnt := succ(errcnt)
                  until (errcnt = 0) or (errcnt >= maxerr);
                  bt := GetByte(2, timeout);
                  OK := (errcnt = 0);
                  if sendmode<>'B' then
                    begin
                      if OK then
                        begin
                           writeln(usr);
                           writeln(USR, 'Transfer complete.');
                           if (not clock) then for i:=1 to mm do
                             begin
                               tick_a_min;
                               hour_count:=hour_count+10.0;
                             end;
                         end
                      else
                        begin
                          writeln(usr);
                          writeln(USR, 'End of file not acknowledged.');
                        end;
                    end;
                end
              else
                begin
                  if sendmode<>'B' then writeln(USR, 'Transfer cancelled.');
                  putbyte(ord(CAN));
                  putbyte(ord(CAN));
                end;
          end;
        if (not ok) then ok_to_send:=false;
        dispose(file_buf);
        clear_inbuf;
    end;

Overlay procedure Test_Download_Ratio(var ok_to_send:boolean
                    ;sendmode:char;fnum:integer);
  var
    i,x:integer;
  begin
    if (up_down_ratio>0) and (ok_to_send) then
      begin
        x:=user_rec.download;
        if sendmode='B' then x:=x+Fnum;
        if x=0 then x:=1;
        i:=user_rec.upload+1;
        if ((i*up_down_ratio) div x)<2 then
          begin
            writeln(usr);
            writeln(usr,'System allows ',up_down_ratio,' downloads/upload.');
            writeln(usr,'You are close to that limit with ',user_rec.download,
            ' Downloads and ',user_rec.upload,' Uploads.');
            if sendmode='B' then
              Writeln(usr,'Batch transfer will add ',fnum,' to your downloads.');
            writeln(usr);
          end;
        if ((i*up_down_ratio) div x)<1 then
          begin
            ok_to_send:=false;
            writeln(usr);
            writeln(usr,'Unable to send files until some uploads are received.');
            writeln(usr);
          end;
      end;
  end;

{end of PPC0D.INC}
