{ PPC0B.INC  Pascal Integrated Communications System Overlays}
{ 5/31/87 IBM PC Version 5.0 Copyright 1987 by Les Archambault}

overlay procedure ReadDir(var entries, space_used: integer; var first: FilePtr);
{ Create an alphabetized list of files in the current file area }
  type
    dtarecord = record
                 filler:array[0..21] of byte;
                 fileattrib:byte;
                 time1,time2:byte;
                 date1,date2:byte;
                 size1,size2:integer;
                 end;
  var
    i, j, off: integer;
    this: FilePtr;
    dta:string[44];
    name:name_array;
    dtarec:dtarecord absolute dta;
    regs:regpack;
    mask:strpr;
    size:real;

Procedure fillrec;
 var i,x:integer;
     work:string[12];
  begin
    work:=copy(dta,31,12);
    fillchar(name,11,' ');
    x:=1; i:=1;
    while (work[i]<>chr(0)) and (i<=length(work)) do
      begin
        if work[i]='.' then
          begin
            x:=9; i:=succ(i);
          end
        else
          begin
            name[x]:=ord(work[i]);
            x:=succ(x); i:=succ(i);
          end;
      end;
    with dtarec do
      begin
        size:=size2*65536.0+size1;
        if size1<0 then size:=size+65536.0;
        if (size>0.0) and (size<128.0) then size:=128.0;
        if chr(name[1])<>' ' then
        Insertfile(name,0,trunc(size/128.0),fileattrib,entries,space_used,first);
      end;
  end;

  begin  {ReadDir}
    new_dir := TRUE;
    space_used := 0;
    while first <> nil do                 { Clean out any old directory list }
      begin
        this := first;
        first := first^.Next;             { Go to next on chain }
        dispose(this)                     { Reclaim space }
      end;
    DirEntries := 0;
    mask:='????????.???'+chr(0);
    SetSect(SetName);
    fillchar(dta[1],44,#32); dta[0]:=#44;
    with regs do
      begin
        ax:=$1a00;    {set up disk transfer area}
        ds:=seg(dta); dx:=ofs(dta)+1;
        msdos(regs);
        ax:=$4e00;    {read first}
        ds:=seg(mask); dx:=ofs(mask)+1;
        if ((user_rec.access>=250) and (mode<>Sysop_mode)) or
        ((not remote_copy) and (mode<>Sysop_mode)) then cx:=39  { read-only and hidden files}
        else cx:=33;
        msdos(regs);
        if (flags and 1)=0 then
          begin
            fillrec;  {enter data into linked list}
            repeat
              fillchar(dta[31],14,' ');
              ax:=$4f00;  {search next}
              msdos(regs);
              if (ax<>18) and (ax<>2) then fillrec;
            until (flags and 1)<>0;
          end;
      end;
    free_space := diskfree('*');    {current directory}
    SetSect(HomName)
  end;

overlay procedure LibReadDir(var entries, space_used: integer; var first: FilePtr);
{ Read library directory }
  var
    i, off: integer;
    this:fileptr;
    LibBlock: array[0..num_drives] of EntryBlock;
  begin
    SetSect(SetName);
    Assign(libr_file, LibReq);
    {$I-} Reset(libr_file) {$I+};
    if (IOresult=0) and (filesize(libr_file)>0) then
        begin
          while first <> nil do                 { Clean out any old directory list }
            begin
             this := first;
             first := first^.Next;             { Go to next on chain }
             dispose(this)                     { Reclaim space }
            end;
          {$I-} blockread(libr_file, LibBlock, 1) {$I+};
          in_library := (IOresult = 0);
          i := 1;
          while in_library and (i < 11) do
            if LibBlock[0].fname[i] = $20
              then i := succ(i)
              else in_library := FALSE;
          in_library := in_library and (LibBlock[0].status = 0);
          if in_library
            then
              begin
                new_dir := TRUE;
                space_used := 0;
                LibEntries := 0;
                for i := 1 to pred(LibBlock[0].fsize shl 2) do
                  begin
                    off := i mod 4;
                    if off = 0
                      then blockread(libr_file, LibBlock, 1);
                    with LibBlock[off] do
                      if status < $FE
                        then InsertFile(fname, index, fsize, 0, entries, space_used, first)
                  end
              end
        end;
    SetSect(HomName)
  end;

overlay procedure ArcReadDir(var entries, space_used: integer;
       var first: FilePtr);

var
    size     : real;
    c,i,x    : integer;
    extname :  name_array;
    this:fileptr;

  begin   {ArcReadDir}
    SetSect(SetName);
    Assign(Arc_File,ArcReq);
    {$I-} Reset(arc_file) {$I+};
    if (IOresult=0) and (filesize(Arc_File)>0) then
        begin
          while first <> nil do                 { Clean out any old directory list }
            begin
             this := first;
             first := first^.Next;             { Go to next on chain }
             dispose(this)                     { Reclaim space }
            end;
          new_dir := TRUE;  OK:=True;
          Arcspace := 0;
          ArcEntries := 0;
          {$I-} blockread(arc_file,arcbuf,1); {$I+}
          Endfile:=(ioresult<>0);
          arcptr:=1;
          setsect(HomName);
            while (Read_Arc_Hdr) and OK do
              begin
                in_arc:=true;
                fillchar(extname,11,' ');
                i := 1; x:=1;
                while hdr.name[i-1] <> #0 do
                  begin
                    if hdr.name[i-1]='.' then x:=9
                    else
                      begin
                        extname[x]:=ord(hdr.name[i-1]);
                        x:=succ(x);
                      end;
                    i:=succ(i);
                  end;
                size := long_to_real(hdr.size);
                if (size>0.0) and (size<128.0) then size:=128.0;
                if (not endfile) then
                  begin
                    InsertFile(extname, 0, trunc(size/128.0), 0, entries, space_used, first);
                    setsect(HomName);
                    ArcSeek(long_to_real(hdr.size), 1);
                  end;
                setsect(HomName);
              end;    {reading arc file header}
          setsect(SetName);
          if (not OK) then
            begin
              writeln(usr,'Warning! Error reading Arc file ',arcreq,'.');
              close(arc_file);
            end;
        end
        else
          begin
            writeln(usr,'Error opening Arc File ',arcreq,'.');
            new_dir:=false;
            close(arc_file);
          end;
    setsect(HomName);
  end; {ArcReadDir}

Overlay Procedure Position_Arcfile(arcname:filename; var ok_to_send:boolean);

var
    name_found  : boolean;
    c,i,x    : integer;
    work_name: filename;

  begin
    name_found:=false;
    setsect(SetName);
    {$I-} Reset(arc_file) {$I+};
    if IOresult = 0
      then
        begin
          {$I-} blockread(arc_file,arcbuf,1); {$I+}
          endfile:=(ioresult<>0);
          arcptr:=1;
          repeat
            setsect(HomName);
            OK:= Read_Arc_Hdr;
            if ok and (not endfile) then
              begin
                work_name:='';
                i := 1;
                while hdr.name[i-1] <> #0 do
                  begin
                    work_name:=work_name+hdr.name[i-1];
                    i:=succ(i);
                  end;
                if arcname=work_name then name_found:=true;
              end;    {reading arc file header}
            if (not endfile) and (not name_found) then
              begin
                setsect(HomName);
                ArcSeek(long_to_real(hdr.size), 1);
              end;
          until endfile or (not OK) or name_found;
          if name_found then ok_to_send:=true;
        end
        else
          ok_to_send:=false;
    setsect(HomName);
  end;

overlay function greg_to_jul(day, mon, yr: integer): real;
{ Convert from Gregorian date to Julian }
  var
    i: integer;
  begin
    i := (mon - 14) div 12;
    greg_to_jul := day - 32075 + 367 * (mon - 2 - 12 * i) div 12 -
                   3 * (yr + 6800 + i) div 400 + 365.25 * (yr + 6700 + i)
  end;

overlay Function get_section_name(mode:char):filename;
{ for file area sections}
   var
     this:sectptr;
     line_count,conf_num:integer;
     work:filename;

     begin
       repeat
       this:=sectbase; writeln(usr);
       work:=prompt('Section name ',12,'ES?M');
       if (work=' ') and (mode<>'L') then
         begin
           work:=Sectreq;  { default to current value }
           writeln(usr,'Defaulting to: ',SectReq);
         end;
       if work='?' then
         begin
           line_count:=2;
           writeln(usr,'Available file areas:');
           writeln(usr);
           while (not brk) and (this<>nil) do
             begin
               conf_num:=this^.sectconf;
               if (user_rec.access>=this^.sectaccs)
               or (test_bit(user_rec.conf_flags,conf_num)) then
                 begin
                   write(usr,pad(this^.sectname,14));
                   if (mode='D') or (mode='L') then writeln(usr,this^.sectdesc)
                    else writeln(usr);
                 end;
               this:=this^.next;
               if user_rec.lines <> 99 then
                 begin
                   line_count := succ(line_count);
                   if line_count mod user_rec.lines = 0 then pause;
                 end;
             end;
           writeln(usr);
         end;
       this:=sectbase;
       while (this<>nil) and (this^.sectname<>work) do
       this:=this^.next;
       until (work=this^.sectname) or (brk) or (not online);
       if work=this^.sectname then get_section_name:=work
       else get_section_name:='';
     end;

Overlay Function Expand_Filename(tfname:filename):filename;
{ Expands filename to 12 characters and expands wildcards}

Var work_name:filename;
    n,x,k: integer;

Begin
  work_name:='            ';
  work_name[9]:='.';
  x:=1;  k:=1;
  while (x<=length(tfname)) and (k<13) do
    begin
      if tfname[x]='.' then
        begin
          k:=10; x:=succ(x);
        end;
      if tfname[x]='*' then
        begin
          if k<9 then
            begin
              for n:=k to 8 do work_name[n]:='?';
              k:=10;
            end
          else
            begin
              if k>9 then for n:=k to 12 do work_name[n]:='?';
              k:=13;
            end;
        end
      else
      work_name[k]:=tfname[x];
      x:=succ(x);
      k:=succ(k);
    end;
  Expand_filename:=work_name;
end;

Overlay Function Equal_names(Test,Target:filename):boolean;
{ tests equality of two filenames including wildcards expanded
  with the Expand_filename function}

Var x:integer;
    match:boolean;

begin
  match:=true;
  for x:=1 to length(test) do test[x]:=chr($7F and ord(test[x])); {strip hi bit}
  for x:=1 to length(target) do target[x]:=chr($7F and ord(target[x])); {strip hi bit}
  x:=1;
  repeat
    if (test[x]<>'?') and (test[x]<>target[x]) then match:=false;
    x:=succ(x);
  until (match=false) or (x>length(test));
  equal_names:=match;
end;

{end of PPC0B.INC}
