/* t4write.c  (c)Copyright Sequiter Software Inc., 1990-1993. All rights reserved. */

#include "d4all.h"
#ifdef __TURBOC__
   #pragma hdrstop
#endif


#include "t4test.h"

CODE4   cb;
DATA4  *data;
FIELD4 *field ;
TAG4   *tag ;

static FIELD4INFO fields[] =
{
   { "TEST", 'N', 15, 0 },
   { 0,0,0,0},
} ;

static TAG4INFO tags[] =
{
   { "TAG", "TEST", "", 0, 0 },
   { 0,0,0, 0, 0 },
} ;


static int test_write( D4DISPLAY *display, long num_recs, int do_open )
{
   long i_rec ;
   double d   =  60000000.0 ;
   double neg = -5.0 ;

   cb.safety =  0 ;

   if (do_open)
   {
      data = d4open( &cb, "T4WRITE" ) ;
      if ( d4zap( data, 1L, d4reccount( data ) ) != 0 )
         e4severe( e4result, "t4write.c - d4zap()" ) ;
   }
   else
      data = d4create( &cb, "T4WRITE", fields, tags ) ;

   if ( data == 0 )
      e4severe( e4result, "t4write.c" ) ;

   d4opt_start( &cb ) ;

   field =  d4field( data, "TEST" ) ;
   if ( field == 0 )
      e4severe( e4result, "t4write:  d4field()" ) ;

   f4assign_double( field, d ) ;

   d4display_str( display,  "        Writing Record:  ", 1 ) ;

   for ( i_rec = 1L; i_rec <= num_recs; i_rec++ )  
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( i_rec % 50 == 0 || i_rec == num_recs )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Writing Record:  ", 0 ) ;
         d4display_num( display, i_rec, 0 ) ;
      }

      if ( d4append_start( data, 0 ) != 0 )
         e4severe( e4result, "t4write:  d4append_start()" ) ;
      if ( d4append( data ) != 0 )
         e4severe( e4result, "t4write:  d4append()" ) ;
   }

   tag = d4tag( data, "TAG" ) ;
   if ( tag == 0 )
      e4severe( e4result, "t4write:  d4tag()" ) ;
   d4tag_select( data, tag ) ;
   if (d4check( data ) < 0 )
      e4severe( e4result, "t4write - d4check()" ) ;

   d -=  100000.0 ;

   d4display_str( display,  "        Replacing Record:  ", 1 ) ;

   for ( i_rec = 1; i_rec <= num_recs; i_rec++ )
   {
      if ( d4display_quit( display ) )
         return 1 ;

      if ( i_rec % 50 == 0 || i_rec == num_recs )
      {
         display->x = (int) 0 ;
         d4display_str( display,  "        Replacing Record:  ", 0 ) ;
         if ( d4recno( data ) != num_recs - i_rec + 1 )
            d4display_num( display, i_rec, 0 ) ;
      }

      if ( d4seek_double( data, d ) != r4after )
         e4severe( e4result, "t4write, d4seek_double()" ) ;

      #ifdef S4MDX
         if ( d4recno( data ) != num_recs - i_rec + 1 )
      #else
         if ( d4recno( data ) != i_rec )
      #endif
         e4severe( e4result, "t4write, d4seek_double()" ) ;

      f4assign_double( field, neg ) ;
   }

   if (d4check( data ) < 0 )
      e4severe( e4result, "t4write - d4check()" ) ;

   if ( d4close_all( &cb ) != 0 )
      e4severe( e4result, "t4write - d4close_all()" ) ;

   return 0 ;
}


static int  test_with_mem_check( D4DISPLAY *display, long num_recs )
{
   d4init( &cb ) ;

   cb.hWnd = display->hWnd ;
   #ifdef S4DLL
      cb.hInst = display->hInst ;
   #endif

   if ( test_write( display, num_recs, 0 ) )
      return 1 ;
   if ( test_write( display, num_recs, 1 ) )
      return 1 ;

   #ifdef S4DEBUG
      mem4check_memory() ;
      d4init_undo(&cb) ;

      #ifndef S4DLL
         mem4reset() ;
         if ( mem4free_check(100) != 0 )
            e4severe( e4result, "t4write.c:  Memory items not freed" ) ;
      #endif
   #else
      d4init_undo( &cb ) ;
   #endif

   return 0 ;
}

int  S4FUNCTION t4test( D4DISPLAY *display )
{
   long num_recs = 0 ;

   num_recs = atol( d4parsestring_nparm( &display->parse_str ) ) ;
   if ( num_recs <= 0 )
      num_recs = 1000L ;

   d4display_str( display,  "T4WRITE Test  ", 1 ) ;
   d4display_str( display,  " ", 1 ) ;
   d4display_str( display,  "Number of Recs:   ", 1 ) ;
   d4display_num( display,  (long) num_recs, 0 ) ;
   d4display_str( display,  "", 1 ) ;

   if ( test_with_mem_check( display, num_recs ) )
      e4exit(&cb) ;

   display->y += 2 ;
   d4display_str( display, "T4WRITE:   SUCCESS", 1) ;
   d4display_str( display, "", 1) ;
   return 1 ;
}
