/* t4test.h   (c)Copyright Sequiter Software Inc., 1990-1993.  All rights reserved. */ 
/* Display routine definitions for CodeBase 4.5 testing */

#ifdef S4WINDOWS
#include <windows.h>
#else
#define HWND unsigned
#define HANDLE unsigned
#endif

#ifdef S4UNIX
   #include "p4port.h"
#endif

typedef struct
{
   #ifdef S4WINDOWS
      #ifdef S4MEDIUM
         char *ptr ;
      #else
         LPSTR  ptr ;
      #endif
   #else
      int          n_parms ;
      int          i_parm ;
      char       **parms ;
   #endif
} D4PARSE_STR;

typedef struct
{
   HWND      hWnd ;
   HANDLE    hInst ;
   D4PARSE_STR  parse_str ;
   int          x,y ;

   #ifdef S4WINDOWS
      TEXTMETRIC   tm ;
      LPMSG        lpmsg ;
      MSG          msg ;  /* Last Message */
      int          did_close ;
      int          did_quit ;
      HCURSOR      hSaveCursor ;
   #endif
} D4DISPLAY;

#ifdef S4TEMP
   extern D4DISPLAY display ;
#endif

#ifdef DLL
   extern HANDLE test_hInst ;
#endif

#ifdef S4WINDOWS
extern MSG msg ;
extern TEXTMETRIC tm ;
#endif

#ifdef __cplusplus
   extern "C" {
#endif

void  S4FUNCTION d4display_start( void ) ;
int   S4FUNCTION d4display_getch( D4DISPLAY * ) ;
void  S4FUNCTION d4display_init( D4DISPLAY *, HWND ) ;
void  S4FUNCTION d4display_str( D4DISPLAY *, char *, int ) ;
void  S4FUNCTION d4display_num( D4DISPLAY *, long, int ) ;
int   S4FUNCTION d4display_quit( D4DISPLAY * ) ;
void  S4FUNCTION d4display_wait( D4DISPLAY * ) ;

#ifdef S4WINDOWS
   void S4FUNCTION d4parsestring_init( D4PARSE_STR *, LPSTR ) ;
#else
   void S4FUNCTION d4parsestring_init( D4PARSE_STR *, int , char ** ) ;
#endif

char *S4FUNCTION d4parsestring_nparm( D4PARSE_STR * ) ;
int   S4FUNCTION t4test( D4DISPLAY * ) ;

#ifdef __cplusplus
   }
#endif
